/*
 * Decompiled with CFR 0.152.
 */
package io.scaleplan.templating;

import io.scaleplan.templating.InvalidTemplateException;
import io.scaleplan.templating.MissingValueException;
import io.scaleplan.templating.TemplateFragment;
import io.scaleplan.templating.TemplateOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Template
implements Iterable<TemplateFragment> {
    private static final TemplateOptions DEFAULT_OPTIONS = TemplateOptions.builder().build();
    private final List<TemplateFragment> fragments;
    private final String materializedText;
    private final TemplateOptions options;

    private Template(@NotNull List<TemplateFragment> fragments) {
        this(fragments, DEFAULT_OPTIONS);
    }

    private Template(@NotNull List<TemplateFragment> fragments, @NotNull TemplateOptions options) {
        List<TemplateFragment> optimizedFrags = Template.optimize(Objects.requireNonNull(fragments));
        this.materializedText = optimizedFrags.isEmpty() ? "" : (optimizedFrags.size() == 1 && optimizedFrags.get(0).isText() ? optimizedFrags.get(0).getValue() : null);
        this.fragments = optimizedFrags;
        this.options = options;
    }

    public static Template fromFragments(@Nullable List<TemplateFragment> fragments) {
        if (fragments == null) {
            return new Template(Collections.emptyList());
        }
        return new Template(Collections.unmodifiableList(fragments));
    }

    public static Template compile(@NotNull String text) {
        return Template.compile(text, null);
    }

    public static Template compile(@NotNull String text, @Nullable Map<String, Object> context) {
        return Template.compile(text, context, DEFAULT_OPTIONS);
    }

    public static Template compile(@NotNull String text, @Nullable Map<String, Object> context, @NotNull TemplateOptions options) {
        return Template.compile(text, options.getPattern().matcher(text), options.getRestKey(), context);
    }

    private static Template compile(@NotNull String text, @NotNull Matcher matcher, @NotNull String restKey, @Nullable Map<String, Object> context) {
        Objects.requireNonNull(text, "text is required for Template#compile");
        Objects.requireNonNull(matcher, "matcher is required for Template#compile");
        ArrayList<TemplateFragment> fragments = new ArrayList<TemplateFragment>();
        int prevEnd = 0;
        int placeholderCounter = 0;
        while (matcher.find()) {
            int start = matcher.start();
            boolean isEscape = false;
            if (start > 0 && text.charAt(start - 1) == '\\') {
                isEscape = true;
                --start;
            }
            if (start != prevEnd) {
                fragments.add(TemplateFragment.create(text.subSequence(prevEnd, start).toString()));
            }
            if (isEscape) {
                fragments.add(TemplateFragment.create(matcher.group(1)));
            } else {
                ++placeholderCounter;
                String key = matcher.group(2);
                if (key.equals(restKey)) {
                    if (matcher.end() != text.length()) {
                        throw new InvalidTemplateException("Rest placeholder can only appear at the end of a template.");
                    }
                    fragments.add(TemplateFragment.create(matcher.group(3), restKey));
                } else {
                    if (key.isEmpty()) {
                        key = Integer.toString(placeholderCounter);
                    }
                    if (context != null && context.containsKey(key)) {
                        fragments.add(TemplateFragment.create((String)context.get(key)));
                    } else {
                        fragments.add(TemplateFragment.create(matcher.group(3), key));
                    }
                }
            }
            prevEnd = matcher.end();
        }
        if (prevEnd < text.length()) {
            fragments.add(TemplateFragment.create(text.subSequence(prevEnd, text.length()).toString()));
        }
        return new Template(fragments);
    }

    @Override
    @NotNull
    public Iterator<TemplateFragment> iterator() {
        return this.fragments.iterator();
    }

    @Override
    public Spliterator<TemplateFragment> spliterator() {
        return this.fragments.spliterator();
    }

    public int size() {
        return this.fragments.size();
    }

    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    public boolean isMaterialized() {
        return this.materializedText != null;
    }

    public String getMaterializedText() {
        return this.materializedText;
    }

    public TemplateOptions getOptions() {
        return this.options;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.fragments.size());
        for (TemplateFragment frag : this.fragments) {
            builder.append(frag.toString());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        return this.fragments.equals(template.fragments) && this.options.equals(template.options);
    }

    public int hashCode() {
        return Objects.hash(this.fragments, this.options);
    }

    public String render(@NotNull Function<String, String> keyToValue, boolean strict) {
        StringBuilder builder = new StringBuilder();
        for (TemplateFragment frag : this.fragments) {
            String value;
            String key = frag.getKey();
            if (key == null) {
                value = frag.getValue();
            } else {
                value = keyToValue.apply(key);
                if (value == null) {
                    if (frag.hasDefault()) {
                        value = frag.getValue();
                    } else {
                        if (strict) {
                            throw new MissingValueException(key);
                        }
                        value = "";
                    }
                }
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public Map<String, String> extract(@NotNull String text) {
        Objects.requireNonNull(text);
        if (this.isMaterialized()) {
            String mt = this.materializedText;
            if (mt.regionMatches(0, text, 0, mt.length())) {
                return Collections.emptyMap();
            }
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(this.size() / 2 + 1);
        int currentOffset = 0;
        int lastFragmentIndex = this.fragments.size() - 1;
        String restKey = this.options.getRestKey();
        for (int i = 0; i < this.fragments.size(); ++i) {
            TemplateFragment frag = this.fragments.get(i);
            if (frag.isText()) {
                int regionLength;
                String fragValue = frag.getValue();
                if (!text.regionMatches(currentOffset, fragValue, 0, regionLength = fragValue.length())) {
                    return null;
                }
                currentOffset += regionLength;
                continue;
            }
            if (frag.getKey().equals(restKey)) {
                result.put(frag.getKey(), text.substring(currentOffset));
                return result;
            }
            int nextTextPos = 0;
            if (i == lastFragmentIndex) {
                nextTextPos = text.indexOf(this.options.getLastDelimiter(), currentOffset);
                if (nextTextPos > 0) {
                    return null;
                }
                nextTextPos = text.length();
            } else {
                TemplateFragment nextFragment = this.fragments.get(i + 1);
                if (nextFragment.isText()) {
                    nextTextPos = text.indexOf(nextFragment.getValue().charAt(0), currentOffset);
                } else if (frag.hasDefault()) {
                    result.put(frag.getKey(), frag.getValue());
                } else {
                    return null;
                }
            }
            if (nextTextPos < 0) {
                return null;
            }
            if (currentOffset == nextTextPos) {
                if (!frag.hasDefault()) {
                    return null;
                }
                result.put(frag.getKey(), frag.getValue());
                continue;
            }
            String subText = text.substring(currentOffset, nextTextPos);
            result.put(frag.getKey(), subText);
            currentOffset = nextTextPos;
        }
        if (currentOffset < text.length()) {
            return null;
        }
        return result;
    }

    public String toRegexString() {
        if (this.isMaterialized()) {
            return String.format("^%s$", Pattern.quote(this.materializedText));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        int lastFragmentIndex = this.fragments.size() - 1;
        String restKey = this.options.getRestKey();
        for (int i = 0; i < this.fragments.size(); ++i) {
            TemplateFragment frag = this.fragments.get(i);
            if (frag.isText()) {
                sb.append(Pattern.quote(frag.getValue()));
                continue;
            }
            if (frag.getKey().equals(restKey)) {
                sb.append(String.format("(?<%s>.*)", restKey));
                break;
            }
            sb.append("(?<");
            sb.append(frag.getKey());
            sb.append('>');
            if (i == lastFragmentIndex) {
                if (this.options.getLastDelimiter() == ']') {
                    sb.append("[^\\]]+");
                } else {
                    sb.append(String.format("[^%c]+", Character.valueOf(this.options.getLastDelimiter())));
                }
            } else {
                TemplateFragment nextFragment = this.fragments.get(i + 1);
                if (nextFragment.isText()) {
                    char nextChar = nextFragment.getValue().charAt(0);
                    sb.append("[^");
                    if (nextChar == ']') {
                        sb.append("\\]");
                    } else {
                        sb.append(nextChar);
                    }
                    sb.append("]+");
                } else {
                    sb.append("()");
                }
            }
            sb.append(frag.hasDefault() ? ")?" : Character.valueOf(')'));
        }
        sb.append("$");
        return sb.toString();
    }

    static List<TemplateFragment> optimize(List<TemplateFragment> fragments) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<TemplateFragment> newFragments = new ArrayList<TemplateFragment>(fragments.size());
        for (TemplateFragment frag : fragments) {
            if (frag.isText()) {
                stringBuilder.append(frag.getValue());
                continue;
            }
            if (stringBuilder.length() > 0) {
                newFragments.add(TemplateFragment.create(stringBuilder.toString()));
                stringBuilder.setLength(0);
            }
            newFragments.add(frag);
        }
        if (stringBuilder.length() > 0) {
            newFragments.add(TemplateFragment.create(stringBuilder.toString()));
        }
        return newFragments;
    }
}

