/*
 * Decompiled with CFR 0.152.
 */
package io.scaleplan.templating;

import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class RendererSpec {
    private final String prefix;
    private final Function<String, String> renderer;

    public static RendererSpec create(@NotNull String prefix, @NotNull Function<String, String> renderer) {
        return new RendererSpec(prefix, renderer);
    }

    private RendererSpec(@NotNull String prefix, @NotNull Function<String, String> renderer) {
        this.prefix = Objects.requireNonNull(prefix, "prefix is required");
        this.renderer = Objects.requireNonNull(renderer, "renderer is required");
    }

    public boolean matches(@NotNull String prefix) {
        return prefix.startsWith(this.prefix);
    }

    public String render(@NotNull String key) {
        return this.renderer.apply(key.substring(this.prefix.length()));
    }
}

