package io.scaleplan.templating;

import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class TemplateFragment {
    private final String value;
    private final String key;
    private final boolean hasDefault;

    public static TemplateFragment create() {
        return TemplateFragment.create(null, null);
    }

    public static TemplateFragment create(@Nullable final String value) {
        return create(value, null);
    }

    public static TemplateFragment create(
            @Nullable final String value,
            @Nullable final String key
    ) {
        return new TemplateFragment(value, key);
    }

    private TemplateFragment(final String value, final String key) {
        this.hasDefault = value != null;
        this.value = (value != null) ? value : "";
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public String getKey() {
        return key;
    }

    public boolean hasDefault() {
        return hasDefault;
    }

    public boolean isText() {
        return key == null;
    }

    public boolean isPlaceholder() {
        return key != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TemplateFragment)) return false;
        TemplateFragment other = (TemplateFragment) obj;
        return Objects.equals(this.key, other.key)
                && Objects.equals(this.value, other.value);
    }

    @Override
    public String toString() {
        if (key == null) {
            return value;
        } else {
            if (hasDefault) return String.format("{%s|%s}", key, value);
            else return String.format("{%s}", key);
        }
    }
}
