package io.scaleplan.templating;

import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import java.util.function.Function;

public class RendererSpec {
    private final String prefix;
    private final Function<String, String> renderer;

    public static RendererSpec create(
            @NotNull final String prefix,
            @NotNull final Function<String, String> renderer
    ) {
        return new RendererSpec(prefix, renderer);
    }

    private RendererSpec(
            @NotNull final String prefix,
            @NotNull final Function<String, String> renderer
    ) {
        this.prefix = Objects.requireNonNull(prefix, "prefix is required");
        this.renderer = Objects.requireNonNull(renderer, "renderer is required");
    }

    public boolean matches(@NotNull final String prefix) {
        return prefix.startsWith(this.prefix);
    }

    public String render(@NotNull final String key) {
        return renderer.apply(key.substring(prefix.length()));
    }
}
