package io.scaleplan.templating;

import org.jetbrains.annotations.NotNull;

public class MissingValueException extends RuntimeException {
    private final String placeholder;

    public MissingValueException(@NotNull final String placeholder) {
        super(String.format("Value for placeholder `%s` not found.", placeholder));
        this.placeholder = placeholder;
    }

    public MissingValueException(@NotNull final String placeholder, final Throwable t) {
        super(String.format("Value for placeholder `%s` not found.", placeholder), t);
        this.placeholder = placeholder;
    }
}
