/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.maven;

import io.saagie.maven.AbstractSaagieMojo;
import io.saagie.maven.ManagerRestClient;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="update", requiresDependencyResolution=ResolutionScope.COMPILE)
public class UpdateJobMojo
extends AbstractSaagieMojo {
    public void execute() {
        this.loadProperties();
        try {
            this.loadCredentials(this.managerProperties);
            ManagerRestClient managerRestClient = new ManagerRestClient(this.getLog(), this.managerProperties);
            managerRestClient.checkManagerConnection();
            ManagerRestClient.Job job = managerRestClient.checkJobExists();
            String directory = this.project.getBuild().getDirectory();
            String filename = managerRestClient.uploadFile(directory, this.managerProperties.getJarName());
            job.getCurrent().setFile(filename);
            job.getCurrent().setTemplate(this.generateJobTemplate(this.managerProperties.getArguments()));
            job.getCurrent().getOptions().setLanguage_version(this.managerProperties.getLanguageVersion());
            job.getCurrent().setCpu(this.managerProperties.getCpu());
            job.getCurrent().setMemory(this.managerProperties.getMem());
            job.getCurrent().setDisk(this.managerProperties.getDisk());
            job.getCurrent().setReleaseNote(this.managerProperties.getReleaseNote());
            this.getLog().debug((CharSequence)("  >> Updating job " + job.getId() + " with: " + job.toString()));
            managerRestClient.updateJob(job);
            this.getLog().info((CharSequence)("Job updated : " + this.generateJobURL(job.getId()) + "/versions"));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

