/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.maven;

import com.google.gson.Gson;
import io.saagie.maven.ManagerProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class ManagerRestClient {
    private final Log log;
    private final ManagerProperties managerProperties;
    Gson gson = new Gson();
    private RestTemplate restTemplate = this.restTemplate();

    public ManagerRestClient(Log log, ManagerProperties managerProperties) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        this.log = log;
        this.managerProperties = managerProperties;
    }

    private RestTemplate restTemplate() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        CloseableHttpClient httpclient = HttpClients.custom().setMaxConnPerRoute(10).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        requestFactory.setHttpClient((HttpClient)httpclient);
        requestFactory.setConnectTimeout(3000);
        requestFactory.setReadTimeout(60000);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    public void checkManagerConnection() throws MojoExecutionException {
        this.log.debug((CharSequence)"Check Manager Connection ... ");
        ResponseEntity response = this.restTemplate.exchange(URI.create(this.getBaseApiUrl() + "/platform/" + this.managerProperties.getPlatformId()), HttpMethod.GET, new HttpEntity((MultiValueMap)this.createHeaders()), String.class);
        if (!response.getStatusCode().is2xxSuccessful()) {
            this.log.error((CharSequence)("Error during check Manager Connection (ErrorCode : " + response.getStatusCode() + " )"));
            throw new MojoExecutionException("Error during check SaagieManager connection");
        }
        this.log.info((CharSequence)"Connection to Manager : OK");
    }

    public String uploadFile(String directory, String path) throws URISyntaxException, IOException, MojoExecutionException {
        this.log.info((CharSequence)"  >> Upload File ... ");
        LinkedMultiValueMap multipartMap = new LinkedMultiValueMap();
        multipartMap.add((Object)"file", (Object)new UrlResource(Paths.get(directory, path).toUri()));
        HttpHeaders headers = this.createHeaders();
        headers.setContentType(new MediaType("multipart", "form-data"));
        HttpEntity request = new HttpEntity((Object)multipartMap, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.getBaseApiUrl() + "/platform/" + this.managerProperties.getPlatformId() + "/job/upload", HttpMethod.POST, request, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            this.log.error((CharSequence)("Error during upload file (ErrorCode : " + response.getStatusCode() + " )"));
            throw new MojoExecutionException("Error during jar upload");
        }
        FileName fielName = (FileName)this.gson.fromJson((String)response.getBody(), FileName.class);
        this.log.info((CharSequence)"  >> Upload File OK");
        return fielName.getFileName();
    }

    public Integer createJob(String body) throws MojoExecutionException {
        this.log.info((CharSequence)"  >> Create Job ... ");
        ResponseEntity response = this.restTemplate.exchange(URI.create(this.getBaseApiUrl() + "/platform/" + this.managerProperties.getPlatformId() + "/job"), HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.createHeaders()), String.class);
        if (!response.getStatusCode().is2xxSuccessful()) {
            this.log.error((CharSequence)("Error during create job(ErrorCode : " + response.getStatusCode() + " )"));
            throw new MojoExecutionException("Error during the job creation");
        }
        Job job = (Job)this.gson.fromJson((String)response.getBody(), Job.class);
        return job.getId();
    }

    public Job checkJobExists() throws MojoExecutionException {
        this.log.debug((CharSequence)("Check Job {" + this.managerProperties.getJobId() + "} Exists ... "));
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(URI.create(this.getBaseApiUrl() + "/platform/" + this.managerProperties.getPlatformId() + "/job/" + this.managerProperties.getJobId()), HttpMethod.GET, new HttpEntity((MultiValueMap)this.createHeaders()), String.class);
        }
        catch (HttpClientErrorException e) {
            this.log.error((CharSequence)("Error during check Job Exists {id:" + this.managerProperties.getJobId() + "}"));
            throw new MojoExecutionException("Error during existing job validation");
        }
        Job job = (Job)this.gson.fromJson((String)response.getBody(), Job.class);
        if (job == null || !this.managerProperties.getJobName().equals(job.getName()) || !this.managerProperties.getJobCategory().equals(job.getCategory())) {
            this.log.error((CharSequence)("Error, the job don't correspond : Requested : {id:" + this.managerProperties.getJobId() + ", name:" + this.managerProperties.getJobName() + ", category:" + this.managerProperties.getJobCategory() + "} - In platform : {id:" + job.getId() + ", name:" + job.getName() + ", category:" + job.getCategory() + "}"));
            throw new MojoExecutionException("Error during existing job validation");
        }
        this.log.info((CharSequence)("Job {id:" + this.managerProperties.getJobId() + ", name:" + this.managerProperties.getJobName() + ", category:" + this.managerProperties.getJobCategory() + "} exists"));
        return job;
    }

    public void updateJob(Job job) throws MojoExecutionException {
        this.log.debug((CharSequence)"  >> Update Job ... ");
        String body = this.gson.toJson((Object)job);
        ResponseEntity response = this.restTemplate.exchange(URI.create(this.getBaseApiUrl() + "/platform/" + this.managerProperties.getPlatformId() + "/job/" + this.managerProperties.getJobId() + "/version"), HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.createHeaders()), String.class);
        if (!response.getStatusCode().is2xxSuccessful()) {
            this.log.error((CharSequence)("Error during update job(ErrorCode : " + response.getStatusCode() + " )"));
            throw new MojoExecutionException("Error during the job update");
        }
    }

    private String getBaseApiUrl() {
        return this.managerProperties.getUrlApi().replaceFirst("\\$\\{realm}", this.managerProperties.getRealm());
    }

    private HttpHeaders createHeaders() {
        return new HttpHeaders(){
            {
                String auth = ManagerRestClient.this.managerProperties.getLogin() + ":" + ManagerRestClient.this.managerProperties.getPassword();
                String encodedAuth = DatatypeConverter.printBase64Binary((byte[])auth.getBytes(Charset.forName("UTF-8")));
                String authHeader = "Basic " + new String(encodedAuth);
                this.set("Authorization", authHeader);
            }
        };
    }

    class Job {
        private Integer id;
        private String name;
        private String category;
        private Current current;

        public Integer getId() {
            return this.id;
        }

        public Job setId(Integer id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Job setName(String name) {
            this.name = name;
            return this;
        }

        public String getCategory() {
            return this.category;
        }

        public Job setCategory(String category) {
            this.category = category;
            return this;
        }

        public Current getCurrent() {
            return this.current;
        }

        public Job setCurrent(Current current) {
            this.current = current;
            return this;
        }

        public String toString() {
            return "Job{id=" + this.id + ", name='" + this.name + '\'' + ", category='" + this.category + '\'' + ", current=" + this.current + '}';
        }

        class Current {
            private Integer id;
            private Integer job_id;
            private Integer number;
            private String template;
            private String file;
            private String creation_date;
            private Options options;
            private String cpu;
            private String memory;
            private String disk;
            private String releaseNote;

            public Integer getId() {
                return this.id;
            }

            public Current setId(Integer id) {
                this.id = id;
                return this;
            }

            public Integer getJob_id() {
                return this.job_id;
            }

            public Current setJob_id(Integer job_id) {
                this.job_id = job_id;
                return this;
            }

            public Integer getNumber() {
                return this.number;
            }

            public Current setNumber(Integer number) {
                this.number = number;
                return this;
            }

            public String getTemplate() {
                return this.template;
            }

            public Current setTemplate(String template) {
                this.template = template;
                return this;
            }

            public String getFile() {
                return this.file;
            }

            public Current setFile(String file) {
                this.file = file;
                return this;
            }

            public String getCreation_date() {
                return this.creation_date;
            }

            public Current setCreation_date(String creation_date) {
                this.creation_date = creation_date;
                return this;
            }

            public Options getOptions() {
                return this.options;
            }

            public Current setOptions(Options options) {
                this.options = options;
                return this;
            }

            public String getCpu() {
                return this.cpu;
            }

            public Current setCpu(String cpu) {
                this.cpu = cpu;
                return this;
            }

            public String getMemory() {
                return this.memory;
            }

            public Current setMemory(String memory) {
                this.memory = memory;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Current setDisk(String disk) {
                this.disk = disk;
                return this;
            }

            public String getReleaseNote() {
                return this.releaseNote;
            }

            public Current setReleaseNote(String releaseNote) {
                this.releaseNote = releaseNote;
                return this;
            }

            public String toString() {
                return "Current{id=" + this.id + ", job_id=" + this.job_id + ", number=" + this.number + ", template='" + this.template + '\'' + ", file='" + this.file + '\'' + ", creation_date='" + this.creation_date + '\'' + ", options=" + this.options + ", cpu='" + this.cpu + '\'' + ", memory='" + this.memory + '\'' + ", disk='" + this.disk + '\'' + ", releaseNote='" + this.releaseNote + '\'' + '}';
            }
        }

        class Options {
            private String language_version;

            public String getLanguage_version() {
                return this.language_version;
            }

            public Options setLanguage_version(String language_version) {
                this.language_version = language_version;
                return this;
            }

            public String toString() {
                return "Options{language_version='" + this.language_version + '\'' + '}';
            }
        }
    }

    class FileName {
        private String fileName;

        public String getFileName() {
            return this.fileName;
        }

        public FileName setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }
    }
}

