/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.maven;

import io.saagie.maven.AbstractSaagieMojo;
import io.saagie.maven.ManagerRestClient;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.COMPILE)
public class CreateJobMojo
extends AbstractSaagieMojo {
    public void execute() {
        this.loadProperties();
        try {
            this.loadCredentials(this.managerProperties);
            ManagerRestClient managerRestClient = new ManagerRestClient(this.getLog(), this.managerProperties);
            managerRestClient.checkManagerConnection();
            String directory = this.project.getBuild().getDirectory();
            String filename = managerRestClient.uploadFile(directory, this.managerProperties.getJarName());
            String body = this.requestBodyBuilder(this.managerProperties.getPlatformId(), this.managerProperties.getJobType(), this.managerProperties.getJobCategory(), this.managerProperties.getCpu(), this.managerProperties.getDisk(), this.managerProperties.getMem(), filename, this.generateJobTemplate(this.managerProperties.getArguments()), this.managerProperties.getLanguageVersion(), this.managerProperties.getReleaseNote(), this.managerProperties.getDescription(), this.managerProperties.getJobName());
            this.getLog().debug((CharSequence)("  >> Job creation request body: " + body));
            Integer jobId = managerRestClient.createJob(body);
            this.getLog().info((CharSequence)("  >> Job created : " + this.generateJobURL(jobId)));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    @NotNull
    private String requestBodyBuilder(String platformId, String objectType, String jobCategory, String cpu, String disk, String memory, String filename, String args, String languageVersion, String releaseNote, String description, String jobName) {
        return "{\"platform_id\": \"" + platformId + "\", \"always_email\": false, \"capsule_code\": \"" + objectType + "\", \"category\": \"" + jobCategory + "\", \"current\": {   \"cpu\": " + cpu + ",    \"disk\": " + disk + ",    \"memory\": " + memory + ",    \"file\": \"" + filename + "\",    \"template\": \"" + args + "\",    \"options\": {       \"language_version\": \"" + languageVersion + "\"   },   \"releaseNote\": \"" + releaseNote + "\"},\"description\": \"" + description + "\", \"manual\": true, \"name\": \"" + jobName + "\", \"retry\": \"\", \"schedule\": \"R0/2016-07-06T15:47:52.051Z/P0Y0M1DT0H0M0S\"}";
    }
}

