/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.maven;

import io.saagie.maven.ManagerProperties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

abstract class AbstractSaagieMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(property="urlApi", readonly=true, defaultValue="https://${realm}-manager.prod.saagie.io/api/v1")
    String urlApi;
    @Parameter(property="login", readonly=true)
    String login;
    @Parameter(property="password", readonly=true)
    String password;
    @Parameter(property="realm", readonly=true, required=true)
    String realm;
    @Parameter(property="platformId", readonly=true, required=true)
    String platformId;
    @Parameter(property="jobName", readonly=true, required=true)
    String jobName;
    @Parameter(property="jobCategory", readonly=true, required=true)
    String jobCategory;
    @Parameter(property="jobType", readonly=true, required=true, defaultValue="java-scala")
    String jobType;
    @Parameter(property="jobId", readonly=true, required=false)
    String jobId;
    @Parameter(property="jarName", readonly=true, required=true, defaultValue="${project.build.finalName}-jar-with-dependencies.jar")
    String jarName;
    @Parameter(property="languageVersion", readonly=true, required=true, defaultValue="8.131")
    String languageVersion;
    @Parameter(property="cpu", readonly=true, required=true, defaultValue="0.5")
    String cpu;
    @Parameter(property="disk", readonly=true, required=true, defaultValue="1024")
    String disk;
    @Parameter(property="mem", readonly=true, required=true, defaultValue="512")
    String mem;
    @Parameter(property="arguments", readonly=true, defaultValue=" ")
    String arguments;
    @Parameter(property="releaseNote", readonly=true, defaultValue=" ")
    String releaseNote;
    @Parameter(property="description", readonly=true, defaultValue=" ")
    String description;
    ManagerProperties managerProperties = new ManagerProperties();
    @Component
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;
    @Parameter(property="serverId", readonly=true, required=true, defaultValue="saagie-manager")
    private String serverId;

    AbstractSaagieMojo() {
    }

    protected void loadProperties() {
        this.getLog().info((CharSequence)"Start Saagie Maven Plugin");
        this.managerProperties.setUrlApi(this.urlApi).setLogin(this.login).setPassword(this.password).setRealm(this.realm).setPlatformId(this.platformId).setJobName(this.jobName).setJobCategory(this.jobCategory).setJobType(this.jobType).setJobId(this.jobId).setJarName(this.jarName).setCpu(this.cpu).setMem(this.mem).setDisk(this.disk).setArguments(this.arguments).setLanguageVersion(this.languageVersion).setDescription(this.description).setReleaseNote(this.releaseNote);
        this.getLog().debug((CharSequence)("ManagerProperties : " + this.managerProperties));
    }

    protected void loadCredentials(ManagerProperties managerProperties) throws MojoExecutionException, MojoFailureException {
        Server server;
        if (this.settings != null && (server = this.settings.getServer(this.serverId)) != null) {
            String username = server.getUsername();
            String password = server.getPassword();
            if (null != password && password.startsWith("{") && password.endsWith("}")) {
                DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
                SettingsDecryptionResult result = this.decrypter.decrypt((SettingsDecryptionRequest)request);
                password = result.getServer().getPassword();
            }
            managerProperties.setLogin(username);
            managerProperties.setPassword(password);
        }
    }

    protected String generateJobURL(Integer jobId) {
        return this.managerProperties.getUrlApi().replaceFirst("\\$\\{realm}", this.managerProperties.getRealm()).replaceFirst("/api/v1", "/#/manager/" + this.managerProperties.getPlatformId() + "/job/" + jobId);
    }

    protected String generateJobTemplate(String arguments) {
        return "java -jar {file} " + arguments;
    }
}

