/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.maven;

import io.saagie.maven.AbstractSaagieMojo;
import io.saagie.maven.ManagerRestClient;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="update", requiresDependencyResolution=ResolutionScope.COMPILE)
public class UpdateJobMojo
extends AbstractSaagieMojo {
    public void execute() {
        this.loadProperties();
        try {
            this.loadCredentials(this.managerProperties);
            ManagerRestClient managerRestClient = new ManagerRestClient(this.getLog(), this.managerProperties);
            managerRestClient.checkManagerConnection();
            ManagerRestClient.Job job = managerRestClient.checkJobExists();
            String directory = this.project.getBuild().getDirectory();
            String filename = managerRestClient.uploadFile(directory, this.managerProperties.getJarName());
            job.getCurrent().setFile(filename);
            managerRestClient.updateJob(job);
            this.getLog().info((CharSequence)("Job updated : " + this.generateURLJob(job.getId()) + "/versions"));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

