/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.maven;

import io.saagie.maven.AbstractSaagieMojo;
import io.saagie.maven.ManagerRestClient;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.COMPILE)
public class CreateJobMojo
extends AbstractSaagieMojo {
    public void execute() {
        this.loadProperties();
        try {
            this.loadCredentials(this.managerProperties);
            ManagerRestClient managerRestClient = new ManagerRestClient(this.getLog(), this.managerProperties);
            managerRestClient.checkManagerConnection();
            String directory = this.project.getBuild().getDirectory();
            String filename = managerRestClient.uploadFile(directory, this.managerProperties.getJarName());
            String body = "{\"platform_id\":\"" + this.managerProperties.getPlatformId() + "\",\"capsule_code\":\"" + this.managerProperties.getJobType() + "\",\"category\":\"" + this.managerProperties.getJobCategory() + "\",\"current\":{\"template\":\"java -jar {file}\",\"file\":\"" + filename + "\"},\"options\":{\"language_version\":\"" + this.managerProperties.getLanguageVersion() + "\"},\"cpu\":" + this.managerProperties.getCpu() + ",\"memory\":" + this.managerProperties.getMem() + ",\"disk\":" + this.managerProperties.getDisk() + ",\"manual\":true,\"name\":\"" + this.managerProperties.getJobName() + "\",\"retry\":\"\",\"schedule\":\"R0/2016-07-06T15:47:52.051Z/P0Y0M1DT0H0M0S\"}";
            Integer jobId = managerRestClient.createJob(body);
            this.getLog().info((CharSequence)("Job created : " + this.generateURLJob(jobId)));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

