/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.plugin.dataops.utils;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.saagie.plugin.dataops.DataOpsExtension;
import io.saagie.plugin.dataops.models.Job;
import io.saagie.plugin.dataops.models.JobInstance;
import io.saagie.plugin.dataops.models.JobMapper;
import io.saagie.plugin.dataops.models.JobVersion;
import io.saagie.plugin.dataops.models.Pipeline;
import io.saagie.plugin.dataops.models.PipelineInstance;
import io.saagie.plugin.dataops.models.PipelineVersion;
import io.saagie.plugin.dataops.models.Project;
import io.saagie.plugin.dataops.models.Server;
import io.saagie.plugin.dataops.tasks.projects.enums.UnitTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.tika.Tika;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.threeten.extra.PeriodDuration;

public class SaagieUtils
implements GroovyObject {
    private static final Logger logger;
    private static final MediaType JSON;
    private DataOpsExtension configuration;
    private static Object handleErrorClosure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SaagieUtils(DataOpsExtension configuration) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DataOpsExtension dataOpsExtension = configuration;
        this.configuration = (DataOpsExtension)ScriptBytecodeAdapter.castToType((Object)dataOpsExtension, DataOpsExtension.class);
    }

    public static String gq(String request, String vars, String operationName) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[0].call((Object)logger, (Object)"GraphQL Query:");
        callSiteArray[1].call((Object)logger, (Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)vars)) {
            callSiteArray[2].call((Object)logger, (Object)"GraphQL Variables:");
            callSiteArray[3].call((Object)logger, (Object)vars);
        }
        Object inlinedRequest = callSiteArray[4].call((Object)request, (Object)"\\n", (Object)"");
        Object query = new GStringImpl(new Object[]{inlinedRequest}, new String[]{"{\"query\":\"", "\""});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vars, null)) {
            query = callSiteArray[5].call(query, (Object)new GStringImpl(new Object[]{vars}, new String[]{",\"variables\":", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)operationName)) {
            query = callSiteArray[6].call(query, (Object)new GStringImpl(new Object[]{operationName}, new String[]{",\"operationName\":\"", "\""}));
        }
        query = callSiteArray[7].call(query, (Object)"}");
        callSiteArray[8].call((Object)logger, (Object)"Generated graphql query:\n{}", query);
        return ShortTypeHandling.castToString((Object)query);
    }

    public Request getProjectsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[9].call((Object)logger, (Object)"Generating getProjectsRequest");
        Object listProjectsRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listProjectsRequest = object = callSiteArray[10].callStatic(SaagieUtils.class, (Object)"\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
            listProjectsRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, listProjectsRequest), Request.class);
    }

    public Request getGlobalEnvironmentVariables() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[12].call((Object)logger, (Object)"Generating globalEnvironmentVariablesQuery");
        Object getAllGlobalVariablesQuery = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            getAllGlobalVariablesQuery = object = callSiteArray[13].callStatic(SaagieUtils.class, (Object)" query globalEnvironmentVariablesQuery { globalEnvironmentVariables { id name scope value description isPassword } } ");
        } else {
            String string = SaagieUtils.gq(" query globalEnvironmentVariablesQuery { globalEnvironmentVariables { id name scope value description isPassword } } ");
            getAllGlobalVariablesQuery = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callCurrent((GroovyObject)this, getAllGlobalVariablesQuery), Request.class);
    }

    public Request getProjectEnvironmentVariables(String projectId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[15].call((Object)logger, (Object)"Generating getProjectEnvironmentVariables [projectId={}]", (Object)projectId);
        Object jsonGenerator = callSiteArray[16].call(callSiteArray[17].callConstructor(JsonGenerator.Options.class));
        Object gqVariables = callSiteArray[18].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", projectId}));
        Object getAllProjectVariablesQuery = callSiteArray[19].callStatic(SaagieUtils.class, (Object)"\n            query environmentVariablesQuery($projectId: UUID!) {  projectEnvironmentVariables(projectId: $projectId) {    id    scope    name    value    description    isPassword    overriddenValues {      id      scope      value      description      isPassword     }   }}\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callCurrent((GroovyObject)this, getAllProjectVariablesQuery), Request.class);
    }

    public Request getProjectJobsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ");
    }

    public Request getProjectJobsGetNameAndIdRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ");
    }

    public Request getProjectPipelinesRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[24].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[25].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[29].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[30].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[31].callStatic(SaagieUtils.class, (Object)"\n            query pipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public static boolean isCollectionOrArray(Object object) {
        Reference object2 = new Reference(object);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _isCollectionOrArray_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference object;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isCollectionOrArray_closure1(Object _outerInstance, Object _thisObject, Reference object) {
                Reference reference;
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.object = reference = object;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it, callSiteArray[1].call(this.object.get()));
            }

            public Object getObject() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.object.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isCollectionOrArray_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isAssignableFrom";
                stringArray[1] = "getClass";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _isCollectionOrArray_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isCollectionOrArray_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isCollectionOrArray_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{Collection.class, Object[].class}), (Object)new _isCollectionOrArray_closure1(SaagieUtils.class, SaagieUtils.class, object2)));
    }

    public Request getListTechnologyVersionsRequest(String technologyId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[34].call((Object)logger, (Object)"Generating getListTechnologyVersionsRequest [technology={}]", (Object)technologyId);
        Object jsonGenerator = callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[38].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"technologyId", technologyId}));
        Object listTechnologyVersions = callSiteArray[39].callStatic(SaagieUtils.class, (Object)"\n            query TechnologiesVersions($technologyId: UUID!) {\n            technologiesVersions(technologyId: $technologyId) {\n              versionLabel\n              technologyLabel\n              secondaryTechnologies {\n                   label     isAvailable      versions\n              }\n            }\n          }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callCurrent((GroovyObject)this, listTechnologyVersions), Request.class);
    }

    public Request getProjectJobsRequestBuild(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[42].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[43].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[47].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[48].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[49].callStatic(SaagieUtils.class, (Object)query, gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request archiveProjectRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[52].call((Object)logger, (Object)"Generating archiveProjectRequest [ProjectId={}]", callSiteArray[53].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[57].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[58].callGroovyObjectGetProperty((Object)project)}));
        Object getProjectInstanceStatus = callSiteArray[59].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveProjectMutation($projectId: UUID!) {\n                archiveProject(projectId: $projectId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request saveProjectEnvironmentVariable(Object environmentVariable) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[62].call((Object)logger, (Object)"Generating saveEnvironmentVariable [ProjectId={}]", callSiteArray[63].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[67].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"entityId", callSiteArray[68].callGroovyObjectGetProperty((Object)project), "envVar", environmentVariable}));
        Object getProjectInstanceStatus = callSiteArray[69].callStatic(SaagieUtils.class, (Object)"\n            mutation saveGlobalEnvVarMutation($entityId: UUID, $envVar: EnvironmentVariableInput!) {  saveEnvironmentVariable(entityId: $entityId, environmentVariable: $envVar) {    id   name   __typename  }}\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request saveGlobalEnvironmentVariable(Object environmentVariable) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[72].call((Object)logger, (Object)"Generating saveEnvironmentVariable [ProjectId={}]", callSiteArray[73].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[77].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"envVar", environmentVariable}));
        Object getProjectInstanceStatus = callSiteArray[78].callStatic(SaagieUtils.class, (Object)"\n            mutation saveGlobalEnvVarMutation($envVar: EnvironmentVariableInput!) { saveEnvironmentVariable(environmentVariable: $envVar) {    id name  __typename  }}\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request getGlobalVariableByNameAndIdAndScope() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[80].call((Object)logger, (Object)"Generating getGlobalVariableByNameAndId");
        Object jsonGenerator = callSiteArray[81].call(callSiteArray[82].call(callSiteArray[83].callConstructor(JsonGenerator.Options.class)));
        Object getGlobalVariablesByNamesAndId = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            getGlobalVariablesByNamesAndId = object = callSiteArray[84].callStatic(SaagieUtils.class, (Object)" query globalEnvironmentVariablesQuery { globalEnvironmentVariables { id    name  scope } } ");
        } else {
            String string = SaagieUtils.gq(" query globalEnvironmentVariablesQuery { globalEnvironmentVariables { id    name  scope } } ");
            getGlobalVariablesByNamesAndId = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].callCurrent((GroovyObject)this, getGlobalVariablesByNamesAndId), Request.class);
    }

    public Request getProjectVariableByNameAndIdAndScope() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[87].call((Object)logger, (Object)"Generating getProjectVariableByNameAndId [ProjectId={}]", callSiteArray[88].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = null;
        jsonGenerator = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[89].callStatic(SaagieUtils.class)) : (object = SaagieUtils.getJsonGenerator());
        Object gqVariables = callSiteArray[90].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[91].callGroovyObjectGetProperty((Object)project)}));
        Object getGlobalVariablesByNamesAndId = callSiteArray[92].callStatic(SaagieUtils.class, (Object)" query environmentVariablesQuery($projectId: UUID!) { projectEnvironmentVariables(projectId: $projectId) { id  name scope } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callCurrent((GroovyObject)this, getGlobalVariablesByNamesAndId), Request.class);
    }

    public static Object getJsonGenerator() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].callConstructor(JsonGenerator.Options.class)));
    }

    public Request getProjectTechnologiesRequest() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[98].call((Object)logger, (Object)"generating getProjectTechnologiesRequest [projectId={}]", callSiteArray[99].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = null;
        jsonGenerator = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[100].callStatic(SaagieUtils.class)) : (object = SaagieUtils.getJsonGenerator());
        Object gqVariables = callSiteArray[101].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[102].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectTechnologies = callSiteArray[103].callStatic(SaagieUtils.class, (Object)"\n            query technologiesQuery($projectId: UUID!) {\n                technologies(projectId: $projectId) {\n                    id\n                    label\n                    isAvailable\n                    icon\n                    features {\n                        field\n                        label\n                        isMandatory\n                        comment\n                        defaultValue\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].callCurrent((GroovyObject)this, listProjectTechnologies), Request.class);
    }

    public Request getPipelineRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[106].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[111].callGroovyObjectGetProperty((Object)server), callSiteArray[112].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[113].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static ArrayList getDifferenceOfTwoArrays(ArrayList collection1, ArrayList collection2) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[114].call(callSiteArray[115].call((Object)collection1, (Object)collection2), callSiteArray[116].call((Object)collection2, (Object)collection1)), ArrayList.class);
    }

    public Request getPipelineInstancesRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[118].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        HttpUrl.Builder httpBuilder = (HttpUrl.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].call(callSiteArray[120].call(HttpUrl.class, (Object)new GStringImpl(new Object[]{callSiteArray[121].callGroovyObjectGetProperty((Object)server), callSiteArray[122].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", "/instance"}))), HttpUrl.Builder.class);
        callSiteArray[123].call((Object)httpBuilder, (Object)"page", (Object)"1");
        callSiteArray[124].call((Object)httpBuilder, (Object)"size", (Object)"10");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].callConstructor(Request.Builder.class), callSiteArray[128].call((Object)httpBuilder))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[129].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineInstanceDetailRequestFromParamV1(String pipelineId, String instanceId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[131].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[132].call(callSiteArray[133].call(callSiteArray[134].call(callSiteArray[135].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[136].callGroovyObjectGetProperty((Object)server), callSiteArray[137].callGroovyObjectGetProperty((Object)server), pipelineId, instanceId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", "/instance/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[138].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineRequestFromParam(Object pipelineId) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[140].call((Object)logger, (Object)"generating getPipelineRequest [projectId={}]", callSiteArray[141].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = null;
        jsonGenerator = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[142].callStatic(SaagieUtils.class)) : (object = SaagieUtils.getJsonGenerator());
        Object gqVariables = callSiteArray[143].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", pipelineId}));
        Object pipelineResult = callSiteArray[144].callStatic(SaagieUtils.class, (Object)"\n            query pipeline ($pipelineId: UUID!) {\n                pipeline(id: $pipelineId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callCurrent((GroovyObject)this, pipelineResult), Request.class);
    }

    @Deprecated
    public Request getProjectCreateJobRequest(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[147].callGetProperty(callSiteArray[148].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[149].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object jsonGenerator = callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call(callSiteArray[153].callConstructor(JsonGenerator.Options.class)), (Object)"usePreviousArtifact"));
        Object gqVariables = callSiteArray[154].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[155].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[156].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object createProjectJob = callSiteArray[157].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!) {\n                createJob(job: $job, jobVersion: $jobVersion) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectCreateJobRequestWithGraphQL(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[160].callGetProperty(callSiteArray[161].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[162].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Reference file = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[163].callConstructor(File.class, callSiteArray[164].callGetProperty(callSiteArray[165].callGroovyObjectGetProperty((Object)jobVersion))), File.class)));
        callSiteArray[166].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[167].callGetProperty((Object)((File)file.get())));
        public final class _getProjectCreateJobRequestWithGraphQL_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getProjectCreateJobRequestWithGraphQL_closure2(Object _outerInstance, Object _thisObject, Reference file) {
                Reference reference;
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.file = reference = file;
            }

            public Object doCall(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(this.file.get());
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)value), (String)"name");
                return value;
            }

            public Object call(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value);
            }

            public File getFile() {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProjectCreateJobRequestWithGraphQL_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "packageInfo";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProjectCreateJobRequestWithGraphQL_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jsonGenerator = callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call(callSiteArray[171].callConstructor(JsonGenerator.Options.class)), JobVersion.class, (Object)new _getProjectCreateJobRequestWithGraphQL_closure2(this, this, file)));
        Object gqVariables = callSiteArray[172].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[173].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[174].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object object = callSiteArray[175].callGetProperty((Object)((File)file.get()));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[176].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[177].call(callSiteArray[178].call(callSiteArray[179].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object createProjectJob = callSiteArray[180].callStatic(SaagieUtils.class, (Object)" mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!, $file: Upload) { createJob(job: $job, jobVersion: $jobVersion, file: $file) { id name } } ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].callCurrent((GroovyObject)this, createProjectJob, (Object)job, (Object)jobVersion), Request.class);
    }

    public Request getProjectUpdateJobRequest() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[182].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].call(JobMapper.class, (Object)job, callSiteArray[184].callGetProperty(callSiteArray[185].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[186].call((Object)logger, (Object)"Generating getProjectUpdateJobRequest [job={}]", (Object)mappedJob);
        Object jsonGenerator = null;
        jsonGenerator = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[187].callStatic(SaagieUtils.class)) : (object = SaagieUtils.getJsonGenerator());
        Object gqVariables = callSiteArray[188].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", mappedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[189].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[190].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].call(JobMapper.class, (Object)job, callSiteArray[192].callGetProperty(callSiteArray[193].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[194].callCurrent((GroovyObject)this, callSiteArray[195].callGetProperty((Object)mappedJob)), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequestFromParams(Object job) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[196].call(callSiteArray[197].call(callSiteArray[198].callConstructor(JsonGenerator.Options.class)));
        Map formattedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[199].callStatic(SaagieUtils.class, job), Map.class);
        Object gqVariables = callSiteArray[200].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", formattedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[201].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobRequestFormat(String gqVariables) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object updateProjectJob = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            updateProjectJob = object = callSiteArray[202].callStatic(SaagieUtils.class, (Object)" mutation editJobMutation($job: JobEditionInput!) { editJob(job: $job) { id } } ", (Object)gqVariables);
        } else {
            String string = SaagieUtils.gq(" mutation editJobMutation($job: JobEditionInput!) { editJob(job: $job) { id } } ", gqVariables);
            updateProjectJob = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getAddJobVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[204].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[205].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[206].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[207].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[208].call(callSiteArray[209].call(callSiteArray[210].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[211].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[212].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[213].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[214].callStatic(SaagieUtils.class, (Object)" mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) { addJobVersion(jobId: $jobId, jobVersion: $jobVersion) { number } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[215].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public static Map getFormatForUpdateJob(Map data) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set set = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[216].callConstructor(HashSet.class), Set.class);
        callSiteArray[217].call((Object)set, (Object)"projectId");
        callSiteArray[218].call((Object)set, (Object)"category");
        callSiteArray[219].call((Object)set, (Object)"technology");
        callSiteArray[220].call(callSiteArray[221].call((Object)data), (Object)set);
        return data;
    }

    public Request getAddJobVersionRequestWithGraphQL(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[222].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[223].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object file = callSiteArray[224].callConstructor(File.class, callSiteArray[225].callGetProperty(callSiteArray[226].callGroovyObjectGetProperty((Object)jobVersion)));
        callSiteArray[227].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[228].callGetProperty(file));
        Object jsonGenerator = callSiteArray[229].call(callSiteArray[230].call(callSiteArray[231].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[232].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[233].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[234].call((Object)jobVersion)}));
        Object object = callSiteArray[235].callGetProperty(file);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[236].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[237].call(callSiteArray[238].call(callSiteArray[239].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object updateProjectJob = callSiteArray[240].callStatic(SaagieUtils.class, (Object)" mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!, $file: Upload) { addJobVersion(jobId: $jobId, jobVersion: $jobVersion, file: $file) { number } } ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[241].callCurrent((GroovyObject)this, updateProjectJob, (Object)job, (Object)jobVersion), Request.class);
    }

    public Request getAddJobVersionRequestWithoutFile(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[242].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[243].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGeneratorParams = callSiteArray[244].call(callSiteArray[245].call(callSiteArray[246].callConstructor(JsonGenerator.Options.class)), (Object)"packageInfo");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[247].callGetPropertySafe(callSiteArray[248].callGroovyObjectGetProperty((Object)jobVersion)))) {
            Object object;
            jsonGeneratorParams = object = callSiteArray[249].call(jsonGeneratorParams, (Object)"usePreviousArtifact");
        }
        Object jsonGenerator = callSiteArray[250].call(jsonGeneratorParams);
        Object gqVariables = callSiteArray[251].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[252].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[253].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[254].callStatic(SaagieUtils.class, (Object)" mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) { addJobVersion(jobId: $jobId, jobVersion: $jobVersion) { number } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[255].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getUploadFileToJobRequest(String jobId, String jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[256].call((Object)logger, (Object)"Generating getUploadFileToJobRequest [jobId={}, jobVersion={}]", (Object)jobId, (Object)jobVersion);
        Object file = callSiteArray[257].callConstructor(File.class, callSiteArray[258].callGetProperty(callSiteArray[259].callGetProperty(callSiteArray[260].callGroovyObjectGetProperty((Object)this.configuration))));
        Tika tika = (Tika)ScriptBytecodeAdapter.castToType((Object)callSiteArray[261].callConstructor(Tika.class), Tika.class);
        String fileMimeType = ShortTypeHandling.castToString((Object)callSiteArray[262].call((Object)tika, file));
        callSiteArray[263].call((Object)logger, (Object)"Detected file mime type: ", (Object)fileMimeType);
        Object fileType = callSiteArray[264].call(MediaType.class, (Object)fileMimeType);
        callSiteArray[265].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[266].callGetProperty(file));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[267].call(callSiteArray[268].call(callSiteArray[269].call(callSiteArray[270].callConstructor(MultipartBody.Builder.class), callSiteArray[271].callGetProperty(MultipartBody.class)), (Object)"files", callSiteArray[272].callGetProperty(file), callSiteArray[273].call(RequestBody.class, file, fileType))), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[274].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[275].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[276].call((Object)logger, (Object)"Building upload file request with jwt auth...");
            Object realm = callSiteArray[277].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[278].callGroovyObjectGetProperty((Object)server);
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].call(callSiteArray[280].call(callSiteArray[281].call(callSiteArray[282].call(callSiteArray[283].call(callSiteArray[284].call(callSiteArray[285].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[286].callGetProperty(callSiteArray[287].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[288].callGetProperty(callSiteArray[289].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[290].callGetProperty(callSiteArray[291].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/projects/api/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        callSiteArray[292].call((Object)logger, (Object)"Building upload file request with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[293].call(callSiteArray[294].call(callSiteArray[295].call(callSiteArray[296].call(callSiteArray[297].call(callSiteArray[298].call(callSiteArray[299].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[300].callGetProperty(callSiteArray[301].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[302].callGetProperty(callSiteArray[303].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[304].callGetProperty(callSiteArray[305].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", callSiteArray[306].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[307].call(callSiteArray[308].call(callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].call(callSiteArray[312].call(callSiteArray[313].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[314].callGetProperty(callSiteArray[315].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[316].callGetProperty(callSiteArray[317].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[318].callGetProperty(callSiteArray[319].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
    }

    public Request getRunProjectJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[320].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[321].call((Object)logger, (Object)"Generating getRunProjectJobRequest for job [id={}]", callSiteArray[322].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[323].call(callSiteArray[324].call(callSiteArray[325].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[326].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[327].callGroovyObjectGetProperty((Object)job)}));
        Object runProjectJobRequest = callSiteArray[328].callStatic(SaagieUtils.class, (Object)" mutation editJobMutation($jobId: UUID!) { runJob(jobId: $jobId) { id status } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[329].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public static Object cleanDirectory(File temp, Logger logger) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object object = callSiteArray[330].call((Object)temp);
        try {
            return object;
        }
        catch (Exception exception) {
            callSiteArray[331].call((Object)logger, (Object)"The directory couldn't be cleaned");
            Object object2 = callSiteArray[332].call((Object)logger, callSiteArray[333].callGetProperty((Object)exception));
            return object2;
        }
    }

    public Request getCreatePipelineRequest(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[334].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[335].call((Object)logger, (Object)"Generating getCreatePipelineRequest for project [projectId={}, pipeline={}, pipelineVersion={}]", callSiteArray[336].callGroovyObjectGetProperty((Object)project), (Object)pipeline, (Object)pipelineVersion);
        Object jsonGenerator = callSiteArray[337].call(callSiteArray[338].call(callSiteArray[339].callConstructor(JsonGenerator.Options.class)));
        Map graphqlPipelineVar = ScriptBytecodeAdapter.createMap((Object[])new Object[]{ScriptBytecodeAdapter.spreadMap((Object)callSiteArray[340].call((Object)pipeline)), callSiteArray[341].call((Object)pipeline), "projectId", callSiteArray[342].callGroovyObjectGetProperty((Object)project), "jobsId", callSiteArray[343].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[344].callGroovyObjectGetProperty((Object)pipelineVersion)});
        Object gqVariables = callSiteArray[345].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", graphqlPipelineVar}));
        Object runProjectJobRequest = callSiteArray[346].callStatic(SaagieUtils.class, (Object)" mutation createPipelineMutation($pipeline: PipelineInput!) { createPipeline(pipeline: $pipeline) { id } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[347].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getProjectJobInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[348].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[349].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[350].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[351].call(callSiteArray[352].call(callSiteArray[353].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[354].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[355].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object getJobInstanceStatus = callSiteArray[356].callStatic(SaagieUtils.class, (Object)" query getJobInstanceStatus($jobId: UUID!) { jobInstance(id: $jobId) { status } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[357].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[358].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[359].call((Object)logger, (Object)"Generating getProjectPipelineInstanceStatusRequest [pipelineInstanceId={}]", callSiteArray[360].callGroovyObjectGetProperty((Object)pipelineinstance));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[361].callCurrent((GroovyObject)this, callSiteArray[362].callGroovyObjectGetProperty((Object)pipelineinstance)), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequestWithparam(String id) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[363].call(callSiteArray[364].call(callSiteArray[365].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[366].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", id}));
        Object getPipelineInstanceStatus = callSiteArray[367].callStatic(SaagieUtils.class, (Object)" query getPipelineInstanceStatus($id: UUID!) { pipelineInstance(id: $id) { status } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[368].callCurrent((GroovyObject)this, getPipelineInstanceStatus), Request.class);
    }

    public Request getProjectUpdatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[369].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[370].call((Object)logger, (Object)"Generating getProjectUpdatePipelineRequest [pipelineId={}]", callSiteArray[371].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[372].call(callSiteArray[373].call(callSiteArray[374].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[375].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", callSiteArray[376].call((Object)pipeline)}));
        Object editPipeline = callSiteArray[377].callStatic(SaagieUtils.class, (Object)" mutation editPipelineMutation($pipeline: PipelineEditionInput!) { editPipeline(pipeline: $pipeline) { id } } ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[378].callCurrent((GroovyObject)this, editPipeline), Request.class);
    }

    public Request getAddPipelineVersionRequest(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[379].callCurrent((GroovyObject)this, (Object)pipeline, (Object)pipelineVersion), Request.class);
    }

    public Request getAddPipelineVersionRequestFromParams(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[380].call((Object)logger, (Object)"Generating getAddPipelineVersionRequest [pipelineId={}]", callSiteArray[381].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[382].call(callSiteArray[383].call(callSiteArray[384].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[385].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[386].callGroovyObjectGetProperty((Object)pipeline), "jobsId", callSiteArray[387].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[388].callGroovyObjectGetProperty((Object)pipelineVersion)}));
        Object addPipelineVersionRequest = callSiteArray[389].callStatic(SaagieUtils.class, (Object)"\n            mutation addPipelineVersionMutation(\n                $pipelineId: UUID!,\n                $jobsId: [UUID!]!,\n                $releaseNote: String,\n            ) {\n                addPipelineVersion(\n                    pipelineId: $pipelineId,\n                    jobsId: $jobsId,\n                    releaseNote: $releaseNote\n                ) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[390].callCurrent((GroovyObject)this, addPipelineVersionRequest), Request.class);
    }

    public Request getProjectRunPipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[391].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[392].call((Object)logger, (Object)"Generating getProjectRunPipelineRequest [pipelineId={}]", callSiteArray[393].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[394].call(callSiteArray[395].call(callSiteArray[396].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[397].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[398].callGroovyObjectGetProperty((Object)pipeline)}));
        Object runPipeline = callSiteArray[399].callStatic(SaagieUtils.class, (Object)"\n            mutation runPipelineMutation($pipelineId: UUID!) {\n                runPipeline(pipelineId: $pipelineId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[400].callCurrent((GroovyObject)this, runPipeline), Request.class);
    }

    public Request getProjectDeletePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[401].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[402].call((Object)logger, (Object)"Generating getProjectDeletePipelineRequest [pipelineId={}]", callSiteArray[403].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[404].call(callSiteArray[405].call(callSiteArray[406].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[407].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[408].callGroovyObjectGetProperty((Object)pipeline)}));
        Object deletePipeline = callSiteArray[409].callStatic(SaagieUtils.class, (Object)"\n            mutation deletePipelineMutation($id: UUID!) {\n                deletePipeline(id: $id)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[410].callCurrent((GroovyObject)this, deletePipeline), Request.class);
    }

    public Request getProjectArchiveJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[411].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[412].call((Object)logger, (Object)"Generating getProjectDeleteJobRequest [jobId={}]", callSiteArray[413].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[414].call(callSiteArray[415].call(callSiteArray[416].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[417].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[418].callGroovyObjectGetProperty((Object)job)}));
        Object getJobInstanceStatus = callSiteArray[419].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveJobMutation($jobId: UUID!) {\n                archiveJob(jobId: $jobId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[420].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectStopPipelineInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[421].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[422].call((Object)logger, (Object)"Generating getProjectStopPipelineInstanceRequest [pipelineinstanceId={}]", callSiteArray[423].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[424].call(callSiteArray[425].call(callSiteArray[426].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[427].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineInstanceId", callSiteArray[428].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getJobInstanceStatus = callSiteArray[429].callStatic(SaagieUtils.class, (Object)"\n            mutation stopPipelineInstanceMutation($pipelineInstanceId: UUID!) {\n                stopPipelineInstance(pipelineInstanceId: $pipelineInstanceId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[430].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getJwtTokenRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[431].call((Object)logger, (Object)"Requesting JWT...");
        Request newRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[432].call(callSiteArray[433].call(callSiteArray[434].call(callSiteArray[435].call(callSiteArray[436].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[437].callGetProperty(callSiteArray[438].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", callSiteArray[439].callCurrent((GroovyObject)this))));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[440].call(callSiteArray[441].call(callSiteArray[442].call(callSiteArray[443].call(callSiteArray[444].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[445].callGetProperty(callSiteArray[446].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", (Object)this.getCredentials())));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[447].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getStopJobInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[448].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[449].call((Object)logger, (Object)"Generating getStopJobInstanceRequest for job instance [id={}]", callSiteArray[450].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[451].call(callSiteArray[452].call(callSiteArray[453].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[454].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobInstanceId", callSiteArray[455].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object runProjectJobRequest = callSiteArray[456].callStatic(SaagieUtils.class, (Object)"\n            mutation stopJobMutation($jobInstanceId: UUID!) {\n                stopJobInstance(jobInstanceId: $jobInstanceId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[457].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    private boolean checkIfStringIsJson(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[458].call(JsonOutput.class, (Object)query);
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
            boolean bl2 = false;
            return bl2;
        }
    }

    private Request buildMultipartRequestFromQuery(String query, Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[459].call((Object)logger, (Object)"Generating multipart request from query=\"{}\"", (Object)query);
        Object file = callSiteArray[460].callConstructor(File.class, callSiteArray[461].callGetProperty(callSiteArray[462].callGroovyObjectGetProperty((Object)jobVersion)));
        Object fileName = callSiteArray[463].callGetProperty(file);
        callSiteArray[464].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[465].callGetProperty(file));
        Object jsonGenerator = callSiteArray[466].call(callSiteArray[467].call(callSiteArray[468].callConstructor(JsonGenerator.Options.class)));
        Object map = callSiteArray[469].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"0", ScriptBytecodeAdapter.createList((Object[])new Object[]{"variables.file"})}));
        Object fileBody = callSiteArray[470].call(RequestBody.class, file, callSiteArray[471].call(MediaType.class, (Object)"application/octet-stream"));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[472].call(callSiteArray[473].call(callSiteArray[474].call(callSiteArray[475].call(callSiteArray[476].call(callSiteArray[477].callConstructor(MultipartBody.Builder.class, (Object)"--graphql-multipart-upload-boundary-85763456--"), callSiteArray[478].callGetProperty(MultipartBody.class)), (Object)"operations", null, callSiteArray[479].call(RequestBody.class, (Object)query, (Object)JSON)), (Object)"map", null, callSiteArray[480].call(RequestBody.class, map, (Object)JSON)), (Object)"0", fileName, fileBody)), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[481].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[482].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[483].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[484].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[485].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[486].call(callSiteArray[487].call(callSiteArray[488].call(callSiteArray[489].call(callSiteArray[490].call(callSiteArray[491].call(callSiteArray[492].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[493].callGetProperty(callSiteArray[494].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[495].callGetProperty(callSiteArray[496].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[497].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[498].call(callSiteArray[499].call(callSiteArray[500].call(callSiteArray[501].call(callSiteArray[502].call(callSiteArray[503].call(callSiteArray[504].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[505].callGetProperty(callSiteArray[506].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[507].callGetProperty(callSiteArray[508].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[509].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[510].call(callSiteArray[511].call(callSiteArray[512].call(callSiteArray[513].call(callSiteArray[514].call(callSiteArray[515].call(callSiteArray[516].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[517].callGetProperty(callSiteArray[518].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[519].callGetProperty(callSiteArray[520].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[521].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPlatformListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[522].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[523].call((Object)logger, (Object)"Generating request in order to get access rights by platforms");
        String realm = ShortTypeHandling.castToString((Object)callSiteArray[524].callGroovyObjectGetProperty((Object)server));
        String jwtToken = ShortTypeHandling.castToString((Object)callSiteArray[525].callGroovyObjectGetProperty((Object)server));
        callSiteArray[526].call((Object)logger, (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"Using realm=", " and jwt=", ""}));
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[527].call(callSiteArray[528].call(callSiteArray[529].call(callSiteArray[530].call(callSiteArray[531].call(callSiteArray[532].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[533].callGetProperty(callSiteArray[534].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[535].callGetProperty(callSiteArray[536].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/security/api/groups/authorizations/", "/permissions/projects"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{callSiteArray[537].call((Object)realm), jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Saagie-Realm", callSiteArray[538].call((Object)realm)))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[539].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getListAllPipelinesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[540].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[541].call((Object)logger, (Object)"Generating getListAllPipelinesRequest for project [id={}]", callSiteArray[542].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[543].call(callSiteArray[544].call(callSiteArray[545].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[546].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[547].callGroovyObjectGetProperty((Object)project)}));
        Object listAllPipelineRequest = callSiteArray[548].callStatic(SaagieUtils.class, (Object)"\n            query getAllPipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[549].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getListAllTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[550].call((Object)logger, (Object)"Generating getListAllTechnologiesRequest ... ");
        Object listAllPipelineRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listAllPipelineRequest = object = callSiteArray[551].callStatic(SaagieUtils.class, (Object)"\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
            listAllPipelineRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[552].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getGroupListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[553].callCurrent((GroovyObject)this), Request.class);
        }
        return this.getPlatformListRequest();
    }

    public Request getProjectsCreateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[554].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[555].call((Object)logger, (Object)"Generating getProjectsCreateRequest for creating a new project [name={}]", callSiteArray[556].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[557].call(callSiteArray[558].call(callSiteArray[559].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[560].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[561].call((Object)project)}));
        Object createProjectRequest = callSiteArray[562].callStatic(SaagieUtils.class, (Object)"\n            mutation createProjectMutation($project: ProjectInput!) {\n                createProject(project: $project) {\n                    id\n                    name\n                    description\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[563].callCurrent((GroovyObject)this, createProjectRequest), Request.class);
    }

    public Request getJobDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[564].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[565].callCurrent((GroovyObject)this, callSiteArray[566].callGroovyObjectGetProperty((Object)job)), Request.class);
    }

    public Request getJobDetailRequestFromParam(Object jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[567].call((Object)logger, (Object)"Generating getJobDetailRequest for getting job detail [id={}]", jobId);
        Object jsonGenerator = callSiteArray[568].call(callSiteArray[569].call(callSiteArray[570].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[571].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object getJobDetailRequest = callSiteArray[572].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        runtimeVersion\n                        packageInfo {\n                            downloadUrl\n                        }\n                        dockerInfo {\n                            image\n                            dockerCredentialsId\n                        }\n                        commandLine\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[573].callCurrent((GroovyObject)this, getJobDetailRequest), Request.class);
    }

    public Request getJobDetailRequestFromParamV1(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[574].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[575].call((Object)logger, (Object)"Generating request in order to get job detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[576].call(callSiteArray[577].call(callSiteArray[578].call(callSiteArray[579].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[580].callGroovyObjectGetProperty((Object)server), callSiteArray[581].callGroovyObjectGetProperty((Object)server), jobId}, new String[]{"", "/manager/api/v1/platform/", "/job/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[582].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getAllVariablesFromV1() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[583].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[584].call((Object)logger, (Object)"Generating request in order to get all environment variables from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[585].call(callSiteArray[586].call(callSiteArray[587].call(callSiteArray[588].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[589].callGroovyObjectGetProperty((Object)server), callSiteArray[590].callGroovyObjectGetProperty((Object)server)}, new String[]{"", "/manager/api/v1/platform/", "/envvars"})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[591].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getJobVersionDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[592].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[593].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[594].call((Object)logger, (Object)"Getting jobVersion for job  [id={}] with project Id [id={}]", callSiteArray[595].callGroovyObjectGetProperty((Object)project), callSiteArray[596].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[597].call(callSiteArray[598].call(callSiteArray[599].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[600].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[601].callGroovyObjectGetProperty((Object)job), "number", 1}));
        Object getJobVersionRequest = callSiteArray[602].callStatic(SaagieUtils.class, (Object)"\n            query jobVersion($jobId: UUID!, $number: Int!) {\n                jobVersion(jobId: $jobId, number: $number) {\n                    commandLine\n                    dockerInfo {\n                        image\n                        dockerCredentialsId\n                    }\n                    releaseNote\n                    runtimeVersion\n                    packageInfo {\n                        name\n                        downloadUrl\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[603].callCurrent((GroovyObject)this, getJobVersionRequest), Request.class);
    }

    public Request getProjectsUpdateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[604].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[605].call((Object)logger, (Object)"Generating getProjectsUpdateRequest for updating a new project [id={}]", callSiteArray[606].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[607].call(callSiteArray[608].call(callSiteArray[609].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[610].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[611].call((Object)project)}));
        Object updateProjectRequest = callSiteArray[612].callStatic(SaagieUtils.class, (Object)"\n            mutation editProjectMutation($project: ProjectEditionInput!) {\n                editProject(project: $project) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[613].callCurrent((GroovyObject)this, updateProjectRequest), Request.class);
    }

    public Request getListVersionForJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[614].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[615].call((Object)logger, (Object)"Generating getListVersionForJobRequest for getting list a new job [id={}]", (Object)jobId);
        Object jsonGenerator = callSiteArray[616].call(callSiteArray[617].call(callSiteArray[618].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[619].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object listVersionForAJobRequest = callSiteArray[620].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    versions {\n                        number\n                        isCurrent\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[621].callCurrent((GroovyObject)this, listVersionForAJobRequest), Request.class);
    }

    private Request buildRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[622].call((Object)logger, (Object)"Generating request from query=\"{}\"", (Object)query);
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[623].call(RequestBody.class, (Object)query, (Object)JSON), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[624].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[625].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[626].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[627].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[628].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[629].call(callSiteArray[630].call(callSiteArray[631].call(callSiteArray[632].call(callSiteArray[633].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[634].callGetProperty(callSiteArray[635].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[636].callGetProperty(callSiteArray[637].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[638].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[639].call(callSiteArray[640].call(callSiteArray[641].call(callSiteArray[642].call(callSiteArray[643].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[644].callGetProperty(callSiteArray[645].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[646].callGetProperty(callSiteArray[647].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[648].callCurrent((GroovyObject)this)), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[649].call(callSiteArray[650].call(callSiteArray[651].call(callSiteArray[652].call(callSiteArray[653].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[654].callGetProperty(callSiteArray[655].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[656].callGetProperty(callSiteArray[657].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[658].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public void downloadFromHTTPSServer(String urlFrom, String to, OkHttpClient client, Object name) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            callSiteArray[659].call((Object)logger, (Object)"Downloading artifiacts ....");
            Request request = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[660].callCurrent((GroovyObject)this, (Object)urlFrom);
                request = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Request request2;
                request = request2 = this.buildRequestForFile(urlFrom);
            }
            Object response = callSiteArray[661].call(callSiteArray[662].call((Object)client, (Object)request));
            Object object = callSiteArray[663].call(callSiteArray[664].call(response));
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
            Object object2 = callSiteArray[665].callConstructor(FileOutputStream.class, callSiteArray[666].callConstructor(File.class, callSiteArray[667].call(callSiteArray[668].call((Object)to, (Object)"/"), name)));
            outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)object2, OutputStream.class);
            byte[] buffer = new byte[2048];
            int length = 0;
            int downloaded = 0;
            while (true) {
                Object object3 = callSiteArray[669].call((Object)inputStream, (Object)buffer);
                length = DefaultTypeTransformation.intUnbox((Object)object3);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)object3, (Object)-1)) {
                    callSiteArray[670].call((Object)outputStream, (Object)buffer, (Object)0, (Object)length);
                    downloaded = DefaultTypeTransformation.intUnbox((Object)callSiteArray[671].call((Object)downloaded, (Object)length));
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw (Throwable)callSiteArray[672].callConstructor(GradleException.class, callSiteArray[673].callGetProperty((Object)ex));
        }
        callSiteArray[674].call((Object)logger, (Object)"Artifacts downloaded.");
        callSiteArray[675].call((Object)outputStream);
        callSiteArray[676].call((Object)inputStream);
    }

    public Request buildRequestForFile(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[677].call((Object)logger, (Object)"Generating request for url=\"{}\"", (Object)url);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[678].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        callSiteArray[679].call((Object)logger, (Object)"Fetching file with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[680].call(callSiteArray[681].call(callSiteArray[682].call(callSiteArray[683].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", callSiteArray[684].callCurrent((GroovyObject)this)));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[685].call(callSiteArray[686].call(callSiteArray[687].call(callSiteArray[688].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", (Object)this.getCredentials()));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[689].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static String getFileNameFromUrl(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)url) ? callSiteArray[690].call((Object)url, callSiteArray[691].call(callSiteArray[692].call((Object)url, (Object)"/"), (Object)1), callSiteArray[693].call((Object)url)) : null);
    }

    public static Object removeLastSlash(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[694].call((Object)url, (Object)"/"))) {
            Object object = callSiteArray[695].call((Object)url, (Object)0, callSiteArray[696].call(callSiteArray[697].call((Object)url), (Object)1));
            url = ShortTypeHandling.castToString((Object)object);
        }
        return url;
    }

    private String getCredentials() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[698].call(Credentials.class, callSiteArray[699].callGetProperty(callSiteArray[700].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[701].callGetProperty(callSiteArray[702].callGroovyObjectGetProperty((Object)this.configuration))));
    }

    public static Map extractProperties(Object obj) {
        Reference obj2 = new Reference(obj);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _extractProperties_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "synthetic";
                return new CallSiteArray(_extractProperties_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _extractProperties_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference obj;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure4(Object _outerInstance, Object _thisObject, Reference obj) {
                Reference reference;
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.obj = reference = obj;
            }

            public Object doCall(Object field) {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(field), callSiteArray[1].call(this.obj.get(), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(field)}, new String[]{"", ""}))});
            }

            public Object getObj() {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return this.obj.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getAt";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _extractProperties_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractProperties_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[703].call(callSiteArray[704].call(callSiteArray[705].callGetProperty(callSiteArray[706].call(obj2.get())), (Object)new _extractProperties_closure3(SaagieUtils.class, SaagieUtils.class)), (Object)new _extractProperties_closure4(SaagieUtils.class, SaagieUtils.class, obj2)), Map.class);
    }

    public static boolean distinctValues(int ... arr) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set foundNumbers = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[707].callConstructor(HashSet.class), Set.class);
        String num = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[708].call((Object)arr), Iterator.class);
        while (iterator.hasNext()) {
            num = ShortTypeHandling.castToString(iterator.next());
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[709].call((Object)foundNumbers, (Object)num))) {
                return false;
            }
            callSiteArray[710].call((Object)foundNumbers, (Object)num);
        }
        return true;
    }

    public static Object debugRequest(Request request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[711].call((Object)logger, (Object)"====== Request ======");
        callSiteArray[712].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[713].callGetProperty((Object)((Request)request2.get())), callSiteArray[714].callGetProperty(callSiteArray[715].call(callSiteArray[716].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"", " ", ""}));
        callSiteArray[717].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[718].callGetProperty(callSiteArray[719].call(callSiteArray[720].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"Host: ", ""}));
        public final class _debugRequest_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugRequest_closure5(Object _outerInstance, Object _thisObject, Reference request) {
                Reference reference;
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference = request;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.request.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Request getRequest() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return (Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), Request.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugRequest_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugRequest_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugRequest_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugRequest_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[721].call(callSiteArray[722].call(callSiteArray[723].call((Object)((Request)request2.get()))), (Object)new _debugRequest_closure5(SaagieUtils.class, SaagieUtils.class, request2));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[724].call((Object)((Request)request2.get())))) {
            callSiteArray[725].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[726].call(callSiteArray[727].call((Object)((Request)request2.get())))}, new String[]{"Content-Length: ", ""}));
            Buffer buffer = (Buffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[728].callConstructor(Buffer.class), Buffer.class);
            callSiteArray[729].call(callSiteArray[730].call((Object)((Request)request2.get())), (Object)buffer);
            return callSiteArray[731].call((Object)logger, callSiteArray[732].call((Object)buffer));
        }
        return null;
    }

    public static Object debugResponse(Response response) {
        Reference response2 = new Reference((Object)response);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[733].call((Object)logger, (Object)"====== Response ======");
        callSiteArray[734].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[735].call(callSiteArray[736].call((Object)((Response)response2.get()))), callSiteArray[737].callGetProperty((Object)((Response)response2.get())), callSiteArray[738].callGetProperty((Object)((Response)response2.get()))}, new String[]{"", " ", " ", ""}));
        public final class _debugResponse_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugResponse_closure6(Object _outerInstance, Object _thisObject, Reference response) {
                Reference reference;
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.response.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Response getResponse() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return (Response)ScriptBytecodeAdapter.castToType((Object)this.response.get(), Response.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugResponse_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugResponse_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugResponse_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugResponse_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[739].call(callSiteArray[740].call(callSiteArray[741].call((Object)((Response)response2.get()))), (Object)new _debugResponse_closure6(SaagieUtils.class, SaagieUtils.class, response2));
    }

    public static Object throwAndLogError(Object l, Object message) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[742].call(l, message);
        throw (Throwable)callSiteArray[743].callConstructor(GradleException.class, message);
    }

    public static String convertScheduleV1ToCron(String cronString) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)cronString)) {
            return ShortTypeHandling.castToString(null);
        }
        int startPeriod = DefaultTypeTransformation.intUnbox((Object)callSiteArray[744].call((Object)cronString, (Object)"/", callSiteArray[745].call(callSiteArray[746].call((Object)cronString, (Object)"/"), (Object)1)));
        if (!(startPeriod != 0)) {
            callSiteArray[747].callStatic(SaagieUtils.class, (Object)"Can't parse cronString, couldn t find '/'");
        }
        String startDate = ShortTypeHandling.castToString((Object)callSiteArray[748].call((Object)cronString, callSiteArray[749].call(callSiteArray[750].call((Object)cronString, (Object)"/"), (Object)1), (Object)startPeriod));
        String cronPeriod = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[751].call((Object)cronString, callSiteArray[752].call((Object)startPeriod, (Object)1), callSiteArray[753].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[754].call((Object)cronString, (Object)(startPeriod + 1), callSiteArray[755].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        }
        Date cronDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[756].call(Date.class, callSiteArray[757].call(callSiteArray[758].call(ZonedDateTime.class, (Object)startDate, callSiteArray[759].call(callSiteArray[760].callGetProperty(DateTimeFormatter.class), callSiteArray[761].callGetProperty(ZoneOffset.class))))), Date.class);
        PeriodDuration period = (PeriodDuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[762].call(PeriodDuration.class, (Object)cronPeriod), PeriodDuration.class);
        Object minutes = null;
        Object hours = null;
        Object dayOfMonths = null;
        Object months = null;
        Object time = callSiteArray[763].callGetProperty(callSiteArray[764].callGetProperty(UnitTime.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[765].callGetProperty(callSiteArray[766].call((Object)period)))) {
            Object object;
            Object object2;
            time = object2 = callSiteArray[767].callGetProperty(callSiteArray[768].callGetProperty(UnitTime.class));
            months = object = callSiteArray[769].call((Object)"*/", callSiteArray[770].callGetProperty(callSiteArray[771].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[772].callGetProperty(callSiteArray[773].callGetProperty(UnitTime.class)))) {
            Object object;
            months = object = callSiteArray[774].call(callSiteArray[775].callGetProperty((Object)cronDate));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[776].callGetProperty(callSiteArray[777].call((Object)period)))) {
            Object object;
            Object object3;
            time = object3 = callSiteArray[778].callGetProperty(callSiteArray[779].callGetProperty(UnitTime.class));
            dayOfMonths = object = callSiteArray[780].call((Object)"*/", callSiteArray[781].callGetProperty(callSiteArray[782].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[783].callGetProperty(callSiteArray[784].callGetProperty(UnitTime.class)))) {
            Object object;
            dayOfMonths = object = callSiteArray[785].call(callSiteArray[786].callGetProperty((Object)cronDate));
        }
        Object hoursTest = callSiteArray[787].call(callSiteArray[788].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[789].call(callSiteArray[790].call((Object)period)))) {
            Object object;
            Object object4;
            time = object4 = callSiteArray[791].callGetProperty(callSiteArray[792].callGetProperty(UnitTime.class));
            hours = object = callSiteArray[793].call((Object)"*/", hoursTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[794].callGetProperty(callSiteArray[795].callGetProperty(UnitTime.class)))) {
            Object object;
            hours = object = callSiteArray[796].call(callSiteArray[797].callGetProperty((Object)cronDate));
        }
        Object minutesTest = callSiteArray[798].call(callSiteArray[799].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[800].call(callSiteArray[801].call((Object)period))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[802].call(callSiteArray[803].call((Object)period)))) {
            Object object;
            Object object5;
            time = object5 = callSiteArray[804].callGetProperty(callSiteArray[805].callGetProperty(UnitTime.class));
            minutes = object = callSiteArray[806].call((Object)"* / ", minutesTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[807].callGetProperty(callSiteArray[808].callGetProperty(UnitTime.class)))) {
            Object object;
            minutes = object = callSiteArray[809].call(callSiteArray[810].callGetProperty((Object)cronDate));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[811].callStatic(SaagieUtils.class, minutes, hours, dayOfMonths, months));
    }

    public static String generateCronExpression(String minutes, String hours, String dayOfMonth, String month) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[812].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)callSiteArray[813].callStatic(SaagieUtils.class, (Object)minutes), (Object)callSiteArray[814].callStatic(SaagieUtils.class, (Object)hours), (Object)callSiteArray[815].callStatic(SaagieUtils.class, (Object)dayOfMonth), (Object)callSiteArray[816].callStatic(SaagieUtils.class, (Object)month), (Object)"*")));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[817].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)SaagieUtils.getValueOrStar(minutes), (Object)SaagieUtils.getValueOrStar(hours), (Object)SaagieUtils.getValueOrStar(dayOfMonth), (Object)SaagieUtils.getValueOrStar(month), (Object)"*")));
    }

    private static Object getValueOrStar(String value) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? value : "*";
    }

    @Generated
    public static String gq(String request, String vars) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, vars, null);
        }
        return SaagieUtils.gq(request, vars, null);
    }

    @Generated
    public static String gq(String request) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, null, null);
        }
        return SaagieUtils.gq(request, null, null);
    }

    @Deprecated
    @Generated
    public Request getUploadFileToJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getUploadFileToJobRequest(jobId, "1");
        }
        return this.getUploadFileToJobRequest(jobId, "1");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaagieUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SaagieUtils.$getCallSiteArray()[818].call(Logging.class, SaagieUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = SaagieUtils.$getCallSiteArray()[819].call(MediaType.class, (Object)"application/json; charset=utf-8");
        JSON = (MediaType)ScriptBytecodeAdapter.castToType((Object)object2, MediaType.class);
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                callSiteArray[0].call((Object)l, (Object)"Checking server response");
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(response))) {
                    callSiteArray[2].call((Object)l, (Object)"No error in server response.");
                    return null;
                }
                String body = ShortTypeHandling.castToString((Object)callSiteArray[3].call(callSiteArray[4].call(response)));
                callSiteArray[5].callStatic(SaagieUtils.class, response);
                String status = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[6].call(response)}, new String[]{"", ""}));
                GStringImpl message = new GStringImpl(new Object[]{status, body}, new String[]{"Error ", " when requesting \n", ""});
                callSiteArray[7].call((Object)l, (Object)message);
                throw (Throwable)callSiteArray[8].callConstructor(GradleException.class, (Object)message);
            }

            public Object call(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                return callSiteArray[9].callCurrent((GroovyObject)this, (Object)l, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "successful";
                stringArray[2] = "debug";
                stringArray[3] = "string";
                stringArray[4] = "body";
                stringArray[5] = "debugResponse";
                stringArray[6] = "code";
                stringArray[7] = "error";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                __clinit__closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure7 __clinit__closure72 = new __clinit__closure7(SaagieUtils.class, SaagieUtils.class);
        handleErrorClosure = __clinit__closure72;
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static MediaType getJSON() {
        return JSON;
    }

    @Generated
    public DataOpsExtension getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(DataOpsExtension dataOpsExtension) {
        this.configuration = dataOpsExtension;
    }

    @Generated
    public static Object getHandleErrorClosure() {
        return handleErrorClosure;
    }

    @Generated
    public static void setHandleErrorClosure(Object object) {
        handleErrorClosure = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "debug";
        stringArray[1] = "debug";
        stringArray[2] = "debug";
        stringArray[3] = "debug";
        stringArray[4] = "replaceAll";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "debug";
        stringArray[9] = "debug";
        stringArray[10] = "gq";
        stringArray[11] = "buildRequestFromQuery";
        stringArray[12] = "debug";
        stringArray[13] = "gq";
        stringArray[14] = "buildRequestFromQuery";
        stringArray[15] = "debug";
        stringArray[16] = "build";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "toJson";
        stringArray[19] = "gq";
        stringArray[20] = "buildRequestFromQuery";
        stringArray[21] = "getProjectJobsRequestBuild";
        stringArray[22] = "getProjectJobsRequestBuild";
        stringArray[23] = "project";
        stringArray[24] = "debug";
        stringArray[25] = "id";
        stringArray[26] = "build";
        stringArray[27] = "excludeNulls";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "toJson";
        stringArray[30] = "id";
        stringArray[31] = "gq";
        stringArray[32] = "buildRequestFromQuery";
        stringArray[33] = "any";
        stringArray[34] = "debug";
        stringArray[35] = "build";
        stringArray[36] = "excludeNulls";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "toJson";
        stringArray[39] = "gq";
        stringArray[40] = "buildRequestFromQuery";
        stringArray[41] = "project";
        stringArray[42] = "debug";
        stringArray[43] = "id";
        stringArray[44] = "build";
        stringArray[45] = "excludeNulls";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "toJson";
        stringArray[48] = "id";
        stringArray[49] = "gq";
        stringArray[50] = "buildRequestFromQuery";
        stringArray[51] = "project";
        stringArray[52] = "debug";
        stringArray[53] = "id";
        stringArray[54] = "build";
        stringArray[55] = "excludeNulls";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "toJson";
        stringArray[58] = "id";
        stringArray[59] = "gq";
        stringArray[60] = "buildRequestFromQuery";
        stringArray[61] = "project";
        stringArray[62] = "debug";
        stringArray[63] = "id";
        stringArray[64] = "build";
        stringArray[65] = "excludeNulls";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "toJson";
        stringArray[68] = "id";
        stringArray[69] = "gq";
        stringArray[70] = "buildRequestFromQuery";
        stringArray[71] = "project";
        stringArray[72] = "debug";
        stringArray[73] = "id";
        stringArray[74] = "build";
        stringArray[75] = "excludeNulls";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "toJson";
        stringArray[78] = "gq";
        stringArray[79] = "buildRequestFromQuery";
        stringArray[80] = "debug";
        stringArray[81] = "build";
        stringArray[82] = "excludeNulls";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "gq";
        stringArray[85] = "buildRequestFromQuery";
        stringArray[86] = "project";
        stringArray[87] = "debug";
        stringArray[88] = "id";
        stringArray[89] = "getJsonGenerator";
        stringArray[90] = "toJson";
        stringArray[91] = "id";
        stringArray[92] = "gq";
        stringArray[93] = "buildRequestFromQuery";
        stringArray[94] = "build";
        stringArray[95] = "excludeNulls";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "project";
        stringArray[98] = "debug";
        stringArray[99] = "id";
        stringArray[100] = "getJsonGenerator";
        stringArray[101] = "toJson";
        stringArray[102] = "id";
        stringArray[103] = "gq";
        stringArray[104] = "buildRequestFromQuery";
        stringArray[105] = "server";
        stringArray[106] = "debug";
        stringArray[107] = "build";
        stringArray[108] = "get";
        stringArray[109] = "url";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "url";
        stringArray[112] = "environment";
        stringArray[113] = "debugRequest";
        stringArray[114] = "plus";
        stringArray[115] = "minus";
        stringArray[116] = "minus";
        stringArray[117] = "server";
        stringArray[118] = "debug";
        stringArray[119] = "newBuilder";
        stringArray[120] = "parse";
        stringArray[121] = "url";
        stringArray[122] = "environment";
        stringArray[123] = "addQueryParameter";
        stringArray[124] = "addQueryParameter";
        stringArray[125] = "build";
        stringArray[126] = "url";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "build";
        stringArray[129] = "debugRequest";
        stringArray[130] = "server";
        stringArray[131] = "debug";
        stringArray[132] = "build";
        stringArray[133] = "get";
        stringArray[134] = "url";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "url";
        stringArray[137] = "environment";
        stringArray[138] = "debugRequest";
        stringArray[139] = "project";
        stringArray[140] = "debug";
        stringArray[141] = "id";
        stringArray[142] = "getJsonGenerator";
        stringArray[143] = "toJson";
        stringArray[144] = "gq";
        stringArray[145] = "buildRequestFromQuery";
        stringArray[146] = "mapJobAndJobVersionWithoutMail";
        stringArray[147] = "id";
        stringArray[148] = "project";
        stringArray[149] = "debug";
        stringArray[150] = "build";
        stringArray[151] = "excludeFieldsByName";
        stringArray[152] = "excludeNulls";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "toJson";
        stringArray[155] = "job";
        stringArray[156] = "jobVersion";
        stringArray[157] = "gq";
        stringArray[158] = "buildRequestFromQuery";
        stringArray[159] = "mapJobAndJobVersionWithoutMail";
        stringArray[160] = "id";
        stringArray[161] = "project";
        stringArray[162] = "debug";
        stringArray[163] = "<$constructor$>";
        stringArray[164] = "name";
        stringArray[165] = "packageInfo";
        stringArray[166] = "debug";
        stringArray[167] = "absolutePath";
        stringArray[168] = "build";
        stringArray[169] = "addConverter";
        stringArray[170] = "excludeNulls";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "toJson";
        stringArray[173] = "job";
        stringArray[174] = "jobVersion";
        stringArray[175] = "absolutePath";
        stringArray[176] = "packageInfo";
        stringArray[177] = "reverse";
        stringArray[178] = "drop";
        stringArray[179] = "reverse";
        stringArray[180] = "gq";
        stringArray[181] = "buildMultipartRequestFromQuery";
        stringArray[182] = "job";
        stringArray[183] = "mapJobWithoutMail";
        stringArray[184] = "id";
        stringArray[185] = "project";
        stringArray[186] = "debug";
        stringArray[187] = "getJsonGenerator";
        stringArray[188] = "toJson";
        stringArray[189] = "getProjectUpdateJobRequestFormat";
        stringArray[190] = "job";
        stringArray[191] = "mapJobWithoutMail";
        stringArray[192] = "id";
        stringArray[193] = "project";
        stringArray[194] = "getProjectUpdateJobFromDataRequestFromParams";
        stringArray[195] = "job";
        stringArray[196] = "build";
        stringArray[197] = "excludeNulls";
        stringArray[198] = "<$constructor$>";
        stringArray[199] = "getFormatForUpdateJob";
        stringArray[200] = "toJson";
        stringArray[201] = "getProjectUpdateJobRequestFormat";
        stringArray[202] = "gq";
        stringArray[203] = "buildRequestFromQuery";
        stringArray[204] = "job";
        stringArray[205] = "jobVersion";
        stringArray[206] = "debug";
        stringArray[207] = "id";
        stringArray[208] = "build";
        stringArray[209] = "excludeNulls";
        stringArray[210] = "<$constructor$>";
        stringArray[211] = "toJson";
        stringArray[212] = "id";
        stringArray[213] = "toMap";
        stringArray[214] = "gq";
        stringArray[215] = "buildRequestFromQuery";
        stringArray[216] = "<$constructor$>";
        stringArray[217] = "add";
        stringArray[218] = "add";
        stringArray[219] = "add";
        stringArray[220] = "removeAll";
        stringArray[221] = "keySet";
        stringArray[222] = "debug";
        stringArray[223] = "id";
        stringArray[224] = "<$constructor$>";
        stringArray[225] = "name";
        stringArray[226] = "packageInfo";
        stringArray[227] = "debug";
        stringArray[228] = "absolutePath";
        stringArray[229] = "build";
        stringArray[230] = "excludeNulls";
        stringArray[231] = "<$constructor$>";
        stringArray[232] = "toJson";
        stringArray[233] = "id";
        stringArray[234] = "toMap";
        stringArray[235] = "absolutePath";
        stringArray[236] = "packageInfo";
        stringArray[237] = "reverse";
        stringArray[238] = "drop";
        stringArray[239] = "reverse";
        stringArray[240] = "gq";
        stringArray[241] = "buildMultipartRequestFromQuery";
        stringArray[242] = "debug";
        stringArray[243] = "id";
        stringArray[244] = "excludeFieldsByName";
        stringArray[245] = "excludeNulls";
        stringArray[246] = "<$constructor$>";
        stringArray[247] = "downloadUrl";
        stringArray[248] = "packageInfo";
        stringArray[249] = "excludeFieldsByName";
        stringArray[250] = "build";
        stringArray[251] = "toJson";
        stringArray[252] = "id";
        stringArray[253] = "toMap";
        stringArray[254] = "gq";
        stringArray[255] = "buildRequestFromQuery";
        stringArray[256] = "debug";
        stringArray[257] = "<$constructor$>";
        stringArray[258] = "name";
        stringArray[259] = "packageInfo";
        stringArray[260] = "jobVersion";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "detect";
        stringArray[263] = "debug";
        stringArray[264] = "parse";
        stringArray[265] = "debug";
        stringArray[266] = "absolutePath";
        stringArray[267] = "build";
        stringArray[268] = "addFormDataPart";
        stringArray[269] = "setType";
        stringArray[270] = "<$constructor$>";
        stringArray[271] = "FORM";
        stringArray[272] = "name";
        stringArray[273] = "create";
        stringArray[274] = "server";
        stringArray[275] = "jwt";
        stringArray[276] = "debug";
        stringArray[277] = "realm";
        stringArray[278] = "token";
        stringArray[279] = "build";
        stringArray[280] = "post";
        stringArray[281] = "addHeader";
        stringArray[282] = "addHeader";
        stringArray[283] = "addHeader";
        stringArray[284] = "url";
        stringArray[285] = "<$constructor$>";
        stringArray[286] = "url";
        stringArray[287] = "server";
        stringArray[288] = "environment";
        stringArray[289] = "server";
        stringArray[290] = "id";
        stringArray[291] = "project";
        stringArray[292] = "debug";
        stringArray[293] = "build";
        stringArray[294] = "post";
        stringArray[295] = "addHeader";
        stringArray[296] = "addHeader";
        stringArray[297] = "addHeader";
        stringArray[298] = "url";
        stringArray[299] = "<$constructor$>";
        stringArray[300] = "url";
        stringArray[301] = "server";
        stringArray[302] = "environment";
        stringArray[303] = "server";
        stringArray[304] = "id";
        stringArray[305] = "project";
        stringArray[306] = "getCredentials";
        stringArray[307] = "build";
        stringArray[308] = "post";
        stringArray[309] = "addHeader";
        stringArray[310] = "addHeader";
        stringArray[311] = "addHeader";
        stringArray[312] = "url";
        stringArray[313] = "<$constructor$>";
        stringArray[314] = "url";
        stringArray[315] = "server";
        stringArray[316] = "environment";
        stringArray[317] = "server";
        stringArray[318] = "id";
        stringArray[319] = "project";
        stringArray[320] = "job";
        stringArray[321] = "debug";
        stringArray[322] = "id";
        stringArray[323] = "build";
        stringArray[324] = "excludeNulls";
        stringArray[325] = "<$constructor$>";
        stringArray[326] = "toJson";
        stringArray[327] = "id";
        stringArray[328] = "gq";
        stringArray[329] = "buildRequestFromQuery";
        stringArray[330] = "deleteDir";
        stringArray[331] = "warn";
        stringArray[332] = "warn";
        stringArray[333] = "message";
        stringArray[334] = "project";
        stringArray[335] = "debug";
        stringArray[336] = "id";
        stringArray[337] = "build";
        stringArray[338] = "excludeNulls";
        stringArray[339] = "<$constructor$>";
        stringArray[340] = "toMap";
        stringArray[341] = "toMap";
        stringArray[342] = "id";
        stringArray[343] = "jobs";
        stringArray[344] = "releaseNote";
        stringArray[345] = "toJson";
        stringArray[346] = "gq";
        stringArray[347] = "buildRequestFromQuery";
        stringArray[348] = "jobinstance";
        stringArray[349] = "debug";
        stringArray[350] = "id";
        stringArray[351] = "build";
        stringArray[352] = "excludeNulls";
        stringArray[353] = "<$constructor$>";
        stringArray[354] = "toJson";
        stringArray[355] = "id";
        stringArray[356] = "gq";
        stringArray[357] = "buildRequestFromQuery";
        stringArray[358] = "pipelineinstance";
        stringArray[359] = "debug";
        stringArray[360] = "id";
        stringArray[361] = "getProjectPipelineInstanceStatusRequestWithparam";
        stringArray[362] = "id";
        stringArray[363] = "build";
        stringArray[364] = "excludeNulls";
        stringArray[365] = "<$constructor$>";
        stringArray[366] = "toJson";
        stringArray[367] = "gq";
        stringArray[368] = "buildRequestFromQuery";
        stringArray[369] = "pipeline";
        stringArray[370] = "debug";
        stringArray[371] = "id";
        stringArray[372] = "build";
        stringArray[373] = "excludeNulls";
        stringArray[374] = "<$constructor$>";
        stringArray[375] = "toJson";
        stringArray[376] = "toMap";
        stringArray[377] = "gq";
        stringArray[378] = "buildRequestFromQuery";
        stringArray[379] = "getAddPipelineVersionRequestFromParams";
        stringArray[380] = "debug";
        stringArray[381] = "id";
        stringArray[382] = "build";
        stringArray[383] = "excludeNulls";
        stringArray[384] = "<$constructor$>";
        stringArray[385] = "toJson";
        stringArray[386] = "id";
        stringArray[387] = "jobs";
        stringArray[388] = "releaseNote";
        stringArray[389] = "gq";
        stringArray[390] = "buildRequestFromQuery";
        stringArray[391] = "pipeline";
        stringArray[392] = "debug";
        stringArray[393] = "id";
        stringArray[394] = "build";
        stringArray[395] = "excludeNulls";
        stringArray[396] = "<$constructor$>";
        stringArray[397] = "toJson";
        stringArray[398] = "id";
        stringArray[399] = "gq";
        stringArray[400] = "buildRequestFromQuery";
        stringArray[401] = "pipeline";
        stringArray[402] = "debug";
        stringArray[403] = "id";
        stringArray[404] = "build";
        stringArray[405] = "excludeNulls";
        stringArray[406] = "<$constructor$>";
        stringArray[407] = "toJson";
        stringArray[408] = "id";
        stringArray[409] = "gq";
        stringArray[410] = "buildRequestFromQuery";
        stringArray[411] = "job";
        stringArray[412] = "debug";
        stringArray[413] = "id";
        stringArray[414] = "build";
        stringArray[415] = "excludeNulls";
        stringArray[416] = "<$constructor$>";
        stringArray[417] = "toJson";
        stringArray[418] = "id";
        stringArray[419] = "gq";
        stringArray[420] = "buildRequestFromQuery";
        stringArray[421] = "pipelineinstance";
        stringArray[422] = "debug";
        stringArray[423] = "id";
        stringArray[424] = "build";
        stringArray[425] = "excludeNulls";
        stringArray[426] = "<$constructor$>";
        stringArray[427] = "toJson";
        stringArray[428] = "id";
        stringArray[429] = "gq";
        stringArray[430] = "buildRequestFromQuery";
        stringArray[431] = "debug";
        stringArray[432] = "build";
        stringArray[433] = "get";
        stringArray[434] = "addHeader";
        stringArray[435] = "url";
        stringArray[436] = "<$constructor$>";
        stringArray[437] = "url";
        stringArray[438] = "server";
        stringArray[439] = "getCredentials";
        stringArray[440] = "build";
        stringArray[441] = "get";
        stringArray[442] = "addHeader";
        stringArray[443] = "url";
        stringArray[444] = "<$constructor$>";
        stringArray[445] = "url";
        stringArray[446] = "server";
        stringArray[447] = "debugRequest";
        stringArray[448] = "jobinstance";
        stringArray[449] = "debug";
        stringArray[450] = "id";
        stringArray[451] = "build";
        stringArray[452] = "excludeNulls";
        stringArray[453] = "<$constructor$>";
        stringArray[454] = "toJson";
        stringArray[455] = "id";
        stringArray[456] = "gq";
        stringArray[457] = "buildRequestFromQuery";
        stringArray[458] = "prettyPrint";
        stringArray[459] = "debug";
        stringArray[460] = "<$constructor$>";
        stringArray[461] = "name";
        stringArray[462] = "packageInfo";
        stringArray[463] = "name";
        stringArray[464] = "debug";
        stringArray[465] = "absolutePath";
        stringArray[466] = "build";
        stringArray[467] = "excludeNulls";
        stringArray[468] = "<$constructor$>";
        stringArray[469] = "toJson";
        stringArray[470] = "create";
        stringArray[471] = "parse";
        stringArray[472] = "build";
        stringArray[473] = "addFormDataPart";
        stringArray[474] = "addFormDataPart";
        stringArray[475] = "addFormDataPart";
        stringArray[476] = "setType";
        stringArray[477] = "<$constructor$>";
        stringArray[478] = "FORM";
        stringArray[479] = "create";
        stringArray[480] = "create";
        stringArray[481] = "server";
        stringArray[482] = "jwt";
        stringArray[483] = "debug";
        stringArray[484] = "realm";
        stringArray[485] = "token";
        stringArray[486] = "build";
        stringArray[487] = "post";
        stringArray[488] = "addHeader";
        stringArray[489] = "addHeader";
        stringArray[490] = "addHeader";
        stringArray[491] = "url";
        stringArray[492] = "<$constructor$>";
        stringArray[493] = "url";
        stringArray[494] = "server";
        stringArray[495] = "environment";
        stringArray[496] = "server";
        stringArray[497] = "debug";
        stringArray[498] = "build";
        stringArray[499] = "post";
        stringArray[500] = "addHeader";
        stringArray[501] = "addHeader";
        stringArray[502] = "addHeader";
        stringArray[503] = "url";
        stringArray[504] = "<$constructor$>";
        stringArray[505] = "url";
        stringArray[506] = "server";
        stringArray[507] = "environment";
        stringArray[508] = "server";
        stringArray[509] = "getCredentials";
        stringArray[510] = "build";
        stringArray[511] = "post";
        stringArray[512] = "addHeader";
        stringArray[513] = "addHeader";
        stringArray[514] = "addHeader";
        stringArray[515] = "url";
        stringArray[516] = "<$constructor$>";
        stringArray[517] = "url";
        stringArray[518] = "server";
        stringArray[519] = "environment";
        stringArray[520] = "server";
        stringArray[521] = "debugRequest";
        stringArray[522] = "server";
        stringArray[523] = "debug";
        stringArray[524] = "realm";
        stringArray[525] = "token";
        stringArray[526] = "debug";
        stringArray[527] = "build";
        stringArray[528] = "get";
        stringArray[529] = "addHeader";
        stringArray[530] = "addHeader";
        stringArray[531] = "url";
        stringArray[532] = "<$constructor$>";
        stringArray[533] = "url";
        stringArray[534] = "server";
        stringArray[535] = "environment";
        stringArray[536] = "server";
        stringArray[537] = "toUpperCase";
        stringArray[538] = "toLowerCase";
        stringArray[539] = "debugRequest";
        stringArray[540] = "project";
        stringArray[541] = "debug";
        stringArray[542] = "id";
        stringArray[543] = "build";
        stringArray[544] = "excludeNulls";
        stringArray[545] = "<$constructor$>";
        stringArray[546] = "toJson";
        stringArray[547] = "id";
        stringArray[548] = "gq";
        stringArray[549] = "buildRequestFromQuery";
        stringArray[550] = "debug";
        stringArray[551] = "gq";
        stringArray[552] = "buildRequestFromQuery";
        stringArray[553] = "getPlatformListRequest";
        stringArray[554] = "project";
        stringArray[555] = "debug";
        stringArray[556] = "name";
        stringArray[557] = "build";
        stringArray[558] = "excludeNulls";
        stringArray[559] = "<$constructor$>";
        stringArray[560] = "toJson";
        stringArray[561] = "toMap";
        stringArray[562] = "gq";
        stringArray[563] = "buildRequestFromQuery";
        stringArray[564] = "job";
        stringArray[565] = "getJobDetailRequestFromParam";
        stringArray[566] = "id";
        stringArray[567] = "debug";
        stringArray[568] = "build";
        stringArray[569] = "excludeNulls";
        stringArray[570] = "<$constructor$>";
        stringArray[571] = "toJson";
        stringArray[572] = "gq";
        stringArray[573] = "buildRequestFromQuery";
        stringArray[574] = "server";
        stringArray[575] = "debug";
        stringArray[576] = "build";
        stringArray[577] = "get";
        stringArray[578] = "url";
        stringArray[579] = "<$constructor$>";
        stringArray[580] = "url";
        stringArray[581] = "environment";
        stringArray[582] = "debugRequest";
        stringArray[583] = "server";
        stringArray[584] = "debug";
        stringArray[585] = "build";
        stringArray[586] = "get";
        stringArray[587] = "url";
        stringArray[588] = "<$constructor$>";
        stringArray[589] = "url";
        stringArray[590] = "environment";
        stringArray[591] = "debugRequest";
        stringArray[592] = "project";
        stringArray[593] = "job";
        stringArray[594] = "debug";
        stringArray[595] = "id";
        stringArray[596] = "id";
        stringArray[597] = "build";
        stringArray[598] = "excludeNulls";
        stringArray[599] = "<$constructor$>";
        stringArray[600] = "toJson";
        stringArray[601] = "id";
        stringArray[602] = "gq";
        stringArray[603] = "buildRequestFromQuery";
        stringArray[604] = "project";
        stringArray[605] = "debug";
        stringArray[606] = "id";
        stringArray[607] = "build";
        stringArray[608] = "excludeNulls";
        stringArray[609] = "<$constructor$>";
        stringArray[610] = "toJson";
        stringArray[611] = "toMap";
        stringArray[612] = "gq";
        stringArray[613] = "buildRequestFromQuery";
        stringArray[614] = "project";
        stringArray[615] = "debug";
        stringArray[616] = "build";
        stringArray[617] = "excludeNulls";
        stringArray[618] = "<$constructor$>";
        stringArray[619] = "toJson";
        stringArray[620] = "gq";
        stringArray[621] = "buildRequestFromQuery";
        stringArray[622] = "debug";
        stringArray[623] = "create";
        stringArray[624] = "server";
        stringArray[625] = "jwt";
        stringArray[626] = "debug";
        stringArray[627] = "realm";
        stringArray[628] = "token";
        stringArray[629] = "build";
        stringArray[630] = "post";
        stringArray[631] = "addHeader";
        stringArray[632] = "url";
        stringArray[633] = "<$constructor$>";
        stringArray[634] = "url";
        stringArray[635] = "server";
        stringArray[636] = "environment";
        stringArray[637] = "server";
        stringArray[638] = "debug";
        stringArray[639] = "build";
        stringArray[640] = "post";
        stringArray[641] = "addHeader";
        stringArray[642] = "url";
        stringArray[643] = "<$constructor$>";
        stringArray[644] = "url";
        stringArray[645] = "server";
        stringArray[646] = "environment";
        stringArray[647] = "server";
        stringArray[648] = "getCredentials";
        stringArray[649] = "build";
        stringArray[650] = "post";
        stringArray[651] = "addHeader";
        stringArray[652] = "url";
        stringArray[653] = "<$constructor$>";
        stringArray[654] = "url";
        stringArray[655] = "server";
        stringArray[656] = "environment";
        stringArray[657] = "server";
        stringArray[658] = "debugRequest";
        stringArray[659] = "debug";
        stringArray[660] = "buildRequestForFile";
        stringArray[661] = "execute";
        stringArray[662] = "newCall";
        stringArray[663] = "byteStream";
        stringArray[664] = "body";
        stringArray[665] = "<$constructor$>";
        stringArray[666] = "<$constructor$>";
        stringArray[667] = "plus";
        stringArray[668] = "plus";
        stringArray[669] = "read";
        stringArray[670] = "write";
        stringArray[671] = "plus";
        stringArray[672] = "<$constructor$>";
        stringArray[673] = "message";
        stringArray[674] = "debug";
        stringArray[675] = "close";
        stringArray[676] = "close";
        stringArray[677] = "debug";
        stringArray[678] = "server";
        stringArray[679] = "debug";
        stringArray[680] = "build";
        stringArray[681] = "addHeader";
        stringArray[682] = "url";
        stringArray[683] = "<$constructor$>";
        stringArray[684] = "getCredentials";
        stringArray[685] = "build";
        stringArray[686] = "addHeader";
        stringArray[687] = "url";
        stringArray[688] = "<$constructor$>";
        stringArray[689] = "debugRequest";
        stringArray[690] = "substring";
        stringArray[691] = "plus";
        stringArray[692] = "lastIndexOf";
        stringArray[693] = "length";
        stringArray[694] = "endsWith";
        stringArray[695] = "substring";
        stringArray[696] = "minus";
        stringArray[697] = "length";
        stringArray[698] = "basic";
        stringArray[699] = "login";
        stringArray[700] = "server";
        stringArray[701] = "password";
        stringArray[702] = "server";
        stringArray[703] = "collectEntries";
        stringArray[704] = "findAll";
        stringArray[705] = "declaredFields";
        stringArray[706] = "getClass";
        stringArray[707] = "<$constructor$>";
        stringArray[708] = "iterator";
        stringArray[709] = "contains";
        stringArray[710] = "add";
        stringArray[711] = "debug";
        stringArray[712] = "debug";
        stringArray[713] = "method";
        stringArray[714] = "path";
        stringArray[715] = "url";
        stringArray[716] = "url";
        stringArray[717] = "debug";
        stringArray[718] = "host";
        stringArray[719] = "url";
        stringArray[720] = "url";
        stringArray[721] = "forEach";
        stringArray[722] = "names";
        stringArray[723] = "headers";
        stringArray[724] = "body";
        stringArray[725] = "debug";
        stringArray[726] = "contentLength";
        stringArray[727] = "body";
        stringArray[728] = "<$constructor$>";
        stringArray[729] = "writeTo";
        stringArray[730] = "body";
        stringArray[731] = "debug";
        stringArray[732] = "readUtf8";
        stringArray[733] = "debug";
        stringArray[734] = "debug";
        stringArray[735] = "toString";
        stringArray[736] = "protocol";
        stringArray[737] = "code";
        stringArray[738] = "message";
        stringArray[739] = "each";
        stringArray[740] = "names";
        stringArray[741] = "headers";
        stringArray[742] = "error";
        stringArray[743] = "<$constructor$>";
        stringArray[744] = "indexOf";
        stringArray[745] = "plus";
        stringArray[746] = "indexOf";
        stringArray[747] = "throwAndLogError";
        stringArray[748] = "substring";
        stringArray[749] = "plus";
        stringArray[750] = "indexOf";
        stringArray[751] = "substring";
        stringArray[752] = "plus";
        stringArray[753] = "length";
        stringArray[754] = "substring";
        stringArray[755] = "length";
        stringArray[756] = "from";
        stringArray[757] = "toInstant";
        stringArray[758] = "parse";
        stringArray[759] = "withZone";
        stringArray[760] = "ISO_ZONED_DATE_TIME";
        stringArray[761] = "UTC";
        stringArray[762] = "parse";
        stringArray[763] = "value";
        stringArray[764] = "SECOND";
        stringArray[765] = "months";
        stringArray[766] = "getPeriod";
        stringArray[767] = "value";
        stringArray[768] = "MONTH";
        stringArray[769] = "plus";
        stringArray[770] = "months";
        stringArray[771] = "getPeriod";
        stringArray[772] = "value";
        stringArray[773] = "MONTH";
        stringArray[774] = "toString";
        stringArray[775] = "month";
        stringArray[776] = "days";
        stringArray[777] = "getPeriod";
        stringArray[778] = "value";
        stringArray[779] = "DAYOFMONTH";
        stringArray[780] = "plus";
        stringArray[781] = "days";
        stringArray[782] = "getPeriod";
        stringArray[783] = "value";
        stringArray[784] = "DAYOFMONTH";
        stringArray[785] = "toString";
        stringArray[786] = "day";
        stringArray[787] = "toHours";
        stringArray[788] = "getDuration";
        stringArray[789] = "toHours";
        stringArray[790] = "getDuration";
        stringArray[791] = "value";
        stringArray[792] = "HOUR";
        stringArray[793] = "plus";
        stringArray[794] = "value";
        stringArray[795] = "HOUR";
        stringArray[796] = "toString";
        stringArray[797] = "hours";
        stringArray[798] = "toHours";
        stringArray[799] = "getDuration";
        stringArray[800] = "toMinutes";
        stringArray[801] = "getDuration";
        stringArray[802] = "toHours";
        stringArray[803] = "getDuration";
        stringArray[804] = "value";
        stringArray[805] = "MINUTE";
        stringArray[806] = "plus";
        stringArray[807] = "value";
        stringArray[808] = "MINUTE";
        stringArray[809] = "toString";
        stringArray[810] = "minutes";
        stringArray[811] = "generateCronExpression";
        stringArray[812] = "format";
        stringArray[813] = "getValueOrStar";
        stringArray[814] = "getValueOrStar";
        stringArray[815] = "getValueOrStar";
        stringArray[816] = "getValueOrStar";
        stringArray[817] = "format";
        stringArray[818] = "getLogger";
        stringArray[819] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[820];
        SaagieUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SaagieUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SaagieUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

