/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.plugin.dataops.utils;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.saagie.plugin.dataops.DataOpsExtension;
import io.saagie.plugin.dataops.models.Job;
import io.saagie.plugin.dataops.models.JobInstance;
import io.saagie.plugin.dataops.models.JobMapper;
import io.saagie.plugin.dataops.models.JobVersion;
import io.saagie.plugin.dataops.models.Pipeline;
import io.saagie.plugin.dataops.models.PipelineInstance;
import io.saagie.plugin.dataops.models.PipelineVersion;
import io.saagie.plugin.dataops.models.Project;
import io.saagie.plugin.dataops.models.Server;
import io.saagie.plugin.dataops.tasks.projects.enums.UnitTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.tika.Tika;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.threeten.extra.PeriodDuration;

public class SaagieUtils
implements GroovyObject {
    private static final Logger logger;
    private static final MediaType JSON;
    private DataOpsExtension configuration;
    private static Object handleErrorClosure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SaagieUtils(DataOpsExtension configuration) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DataOpsExtension dataOpsExtension = configuration;
        this.configuration = (DataOpsExtension)ScriptBytecodeAdapter.castToType((Object)dataOpsExtension, DataOpsExtension.class);
    }

    public static String gq(String request, String vars, String operationName) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[0].call((Object)logger, (Object)"GraphQL Query:");
        callSiteArray[1].call((Object)logger, (Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)vars)) {
            callSiteArray[2].call((Object)logger, (Object)"GraphQL Variables:");
            callSiteArray[3].call((Object)logger, (Object)vars);
        }
        Object inlinedRequest = callSiteArray[4].call((Object)request, (Object)"\\n", (Object)"");
        Object query = new GStringImpl(new Object[]{inlinedRequest}, new String[]{"{\"query\":\"", "\""});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vars, null)) {
            query = callSiteArray[5].call(query, (Object)new GStringImpl(new Object[]{vars}, new String[]{",\"variables\":", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)operationName)) {
            query = callSiteArray[6].call(query, (Object)new GStringImpl(new Object[]{operationName}, new String[]{",\"operationName\":\"", "\""}));
        }
        query = callSiteArray[7].call(query, (Object)"}");
        callSiteArray[8].call((Object)logger, (Object)"Generated graphql query:\n{}", query);
        return ShortTypeHandling.castToString((Object)query);
    }

    public Request getProjectsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[9].call((Object)logger, (Object)"Generating getProjectsRequest");
        Object listProjectsRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listProjectsRequest = object = callSiteArray[10].callStatic(SaagieUtils.class, (Object)"\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
            listProjectsRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, listProjectsRequest), Request.class);
    }

    public Request getProjectJobsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ");
    }

    public Request getProjectJobsRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ");
    }

    public Request getProjectPipelinesRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[15].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[16].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[20].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[21].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[22].callStatic(SaagieUtils.class, (Object)"\n            query pipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request getListTechnologyVersionsRequest(String technologyId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[24].call((Object)logger, (Object)"Generating getListTechnologyVersionsRequest [technology={}]", (Object)technologyId);
        Object jsonGenerator = callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[28].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"technologyId", technologyId}));
        Object listTechnologyVersions = callSiteArray[29].callStatic(SaagieUtils.class, (Object)"\n            query TechnologiesVersions($technologyId: UUID!) {\n            technologiesVersions(technologyId: $technologyId) {\n              versionLabel\n              technologyLabel\n            }\n          }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callCurrent((GroovyObject)this, listTechnologyVersions), Request.class);
    }

    public Request getProjectJobsRequestBuild(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[32].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[33].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[37].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[38].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[39].callStatic(SaagieUtils.class, (Object)query, gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request archiveProjectRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[42].call((Object)logger, (Object)"Generating archiveProjectRequest [ProjectId={}]", callSiteArray[43].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[47].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[48].callGroovyObjectGetProperty((Object)project)}));
        Object getProjectInstanceStatus = callSiteArray[49].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveProjectMutation($projectId: UUID!) {\n                archiveProject(projectId: $projectId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request getProjectTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[52].call((Object)logger, (Object)"generating getProjectTechnologiesRequest [projectId={}]", callSiteArray[53].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[57].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[58].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectTechnologies = callSiteArray[59].callStatic(SaagieUtils.class, (Object)"\n            query technologiesQuery($projectId: UUID!) {\n                technologies(projectId: $projectId) {\n                    id\n                    label\n                    isAvailable\n                    icon\n                    features {\n                        field\n                        label\n                        isMandatory\n                        comment\n                        defaultValue\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callCurrent((GroovyObject)this, listProjectTechnologies), Request.class);
    }

    public Request getPipelineRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[62].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[67].callGroovyObjectGetProperty((Object)server), callSiteArray[68].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[69].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineRequestFromParam(Object pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[71].call((Object)logger, (Object)"generating getPipelineRequest [projectId={}]", callSiteArray[72].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[73].call(callSiteArray[74].call(callSiteArray[75].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[76].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", pipelineId}));
        Object pipelineResult = callSiteArray[77].callStatic(SaagieUtils.class, (Object)"\n            query pipeline ($pipelineId: UUID!) {\n                pipeline(id: $pipelineId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callCurrent((GroovyObject)this, pipelineResult), Request.class);
    }

    @Deprecated
    public Request getProjectCreateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[82].callGetProperty(callSiteArray[83].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[84].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object jsonGenerator = callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].callConstructor(JsonGenerator.Options.class)), (Object)"usePreviousArtifact"));
        Object gqVariables = callSiteArray[89].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[90].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[91].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object createProjectJob = callSiteArray[92].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!) {\n                createJob(job: $job, jobVersion: $jobVersion) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectCreateJobRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[97].callGetProperty(callSiteArray[98].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[99].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Reference file = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].callConstructor(File.class, callSiteArray[101].callGetProperty(callSiteArray[102].callGroovyObjectGetProperty((Object)jobVersion))), File.class)));
        callSiteArray[103].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[104].callGetProperty((Object)((File)file.get())));
        public final class _getProjectCreateJobRequestWithGraphQL_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getProjectCreateJobRequestWithGraphQL_closure1(Object _outerInstance, Object _thisObject, Reference file) {
                Reference reference;
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.file = reference = file;
            }

            public Object doCall(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(this.file.get());
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)value), (String)"name");
                return value;
            }

            public Object call(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value);
            }

            public File getFile() {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProjectCreateJobRequestWithGraphQL_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "packageInfo";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProjectCreateJobRequestWithGraphQL_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProjectCreateJobRequestWithGraphQL_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jsonGenerator = callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].callConstructor(JsonGenerator.Options.class)), JobVersion.class, (Object)new _getProjectCreateJobRequestWithGraphQL_closure1(this, this, file)));
        Object gqVariables = callSiteArray[109].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[110].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[111].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object object = callSiteArray[112].callGetProperty((Object)((File)file.get()));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[113].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object createProjectJob = callSiteArray[117].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!, $file: Upload) {\n                createJob(job: $job, jobVersion: $jobVersion, file: $file) {\n                    id\n                    name\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectUpdateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call(JobMapper.class, (Object)job, callSiteArray[121].callGetProperty(callSiteArray[122].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[123].call((Object)logger, (Object)"Generating getProjectUpdateJobRequest [job={}]", (Object)mappedJob);
        Object jsonGenerator = callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[127].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", mappedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].call(JobMapper.class, (Object)job, callSiteArray[131].callGetProperty(callSiteArray[132].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callCurrent((GroovyObject)this, callSiteArray[134].callGetProperty((Object)mappedJob)), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequestFromParams(Object job) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[135].call(callSiteArray[136].call(callSiteArray[137].callConstructor(JsonGenerator.Options.class)));
        Map formattedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].callStatic(SaagieUtils.class, job), Map.class);
        Object gqVariables = callSiteArray[139].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", formattedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobRequestFormat(String gqVariables) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object updateProjectJob = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            updateProjectJob = object = callSiteArray[141].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", (Object)gqVariables);
        } else {
            String string = SaagieUtils.gq("\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", gqVariables);
            updateProjectJob = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getAddJobVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[145].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[146].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[150].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[151].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[152].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[153].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public static Map getFormatForUpdateJob(Map data) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set set = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callConstructor(HashSet.class), Set.class);
        callSiteArray[156].call((Object)set, (Object)"projectId");
        callSiteArray[157].call((Object)set, (Object)"category");
        callSiteArray[158].call((Object)set, (Object)"technology");
        callSiteArray[159].call(callSiteArray[160].call((Object)data), (Object)set);
        return data;
    }

    public Request getAddJobVersionRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[163].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[164].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object file = callSiteArray[165].callConstructor(File.class, callSiteArray[166].callGetProperty(callSiteArray[167].callGroovyObjectGetProperty((Object)jobVersion)));
        callSiteArray[168].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[169].callGetProperty(file));
        Object jsonGenerator = callSiteArray[170].call(callSiteArray[171].call(callSiteArray[172].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[173].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[174].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[175].call((Object)jobVersion)}));
        Object object = callSiteArray[176].callGetProperty(file);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[177].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[178].call(callSiteArray[179].call(callSiteArray[180].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object updateProjectJob = callSiteArray[181].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!, $file: Upload) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion, file: $file) {\n                    number\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[182].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public Request getAddJobVersionRequestWithoutFile() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[185].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[186].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGeneratorParams = callSiteArray[187].call(callSiteArray[188].call(callSiteArray[189].callConstructor(JsonGenerator.Options.class)), (Object)"packageInfo");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[190].callGetPropertySafe(callSiteArray[191].callGetProperty(callSiteArray[192].callGroovyObjectGetProperty((Object)this.configuration))))) {
            Object object;
            jsonGeneratorParams = object = callSiteArray[193].call(jsonGeneratorParams, (Object)"usePreviousArtifact");
        }
        Object jsonGenerator = callSiteArray[194].call(jsonGeneratorParams);
        Object gqVariables = callSiteArray[195].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[196].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[197].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[198].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[199].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getUploadFileToJobRequest(String jobId, String jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[200].call((Object)logger, (Object)"Generating getUploadFileToJobRequest [jobId={}, jobVersion={}]", (Object)jobId, (Object)jobVersion);
        Object file = callSiteArray[201].callConstructor(File.class, callSiteArray[202].callGetProperty(callSiteArray[203].callGetProperty(callSiteArray[204].callGroovyObjectGetProperty((Object)this.configuration))));
        Tika tika = (Tika)ScriptBytecodeAdapter.castToType((Object)callSiteArray[205].callConstructor(Tika.class), Tika.class);
        String fileMimeType = ShortTypeHandling.castToString((Object)callSiteArray[206].call((Object)tika, file));
        callSiteArray[207].call((Object)logger, (Object)"Detected file mime type: ", (Object)fileMimeType);
        Object fileType = callSiteArray[208].call(MediaType.class, (Object)fileMimeType);
        callSiteArray[209].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[210].callGetProperty(file));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call(callSiteArray[212].call(callSiteArray[213].call(callSiteArray[214].callConstructor(MultipartBody.Builder.class), callSiteArray[215].callGetProperty(MultipartBody.class)), (Object)"files", callSiteArray[216].callGetProperty(file), callSiteArray[217].call(RequestBody.class, file, fileType))), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[218].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[219].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[220].call((Object)logger, (Object)"Building upload file request with jwt auth...");
            Object realm = callSiteArray[221].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[222].callGroovyObjectGetProperty((Object)server);
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[223].call(callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].call(callSiteArray[227].call(callSiteArray[228].call(callSiteArray[229].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[230].callGetProperty(callSiteArray[231].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[232].callGetProperty(callSiteArray[233].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[234].callGetProperty(callSiteArray[235].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/projects/api/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        callSiteArray[236].call((Object)logger, (Object)"Building upload file request with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[237].call(callSiteArray[238].call(callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call(callSiteArray[242].call(callSiteArray[243].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[244].callGetProperty(callSiteArray[245].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[246].callGetProperty(callSiteArray[247].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[248].callGetProperty(callSiteArray[249].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", callSiteArray[250].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[251].call(callSiteArray[252].call(callSiteArray[253].call(callSiteArray[254].call(callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[258].callGetProperty(callSiteArray[259].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[260].callGetProperty(callSiteArray[261].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[262].callGetProperty(callSiteArray[263].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
    }

    public Request getRunProjectJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[264].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[265].call((Object)logger, (Object)"Generating getRunProjectJobRequest for job [id={}]", callSiteArray[266].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[267].call(callSiteArray[268].call(callSiteArray[269].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[270].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[271].callGroovyObjectGetProperty((Object)job)}));
        Object runProjectJobRequest = callSiteArray[272].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($jobId: UUID!) {\n                runJob(jobId: $jobId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[273].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public static Object cleanDirectory(File temp, Logger logger) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object object = callSiteArray[274].call((Object)temp);
        try {
            return object;
        }
        catch (Exception exception) {
            callSiteArray[275].call((Object)logger, (Object)"The directory couldn't be cleaned");
            Object object2 = callSiteArray[276].call((Object)logger, callSiteArray[277].callGetProperty((Object)exception));
            return object2;
        }
    }

    public Request getCreatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[278].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[280].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        callSiteArray[281].call((Object)logger, (Object)"Generating getCreatePipelineRequest for project [projectId={}, pipeline={}, pipelineVersion={}]", callSiteArray[282].callGroovyObjectGetProperty((Object)project), (Object)pipeline, (Object)pipelineVersion);
        Object jsonGenerator = callSiteArray[283].call(callSiteArray[284].call(callSiteArray[285].callConstructor(JsonGenerator.Options.class)));
        Map graphqlPipelineVar = ScriptBytecodeAdapter.createMap((Object[])new Object[]{ScriptBytecodeAdapter.spreadMap((Object)callSiteArray[286].call((Object)pipeline)), callSiteArray[287].call((Object)pipeline), "projectId", callSiteArray[288].callGroovyObjectGetProperty((Object)project), "jobsId", callSiteArray[289].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[290].callGroovyObjectGetProperty((Object)pipelineVersion)});
        Object gqVariables = callSiteArray[291].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", graphqlPipelineVar}));
        Object runProjectJobRequest = callSiteArray[292].callStatic(SaagieUtils.class, (Object)"\n            mutation createPipelineMutation($pipeline: PipelineInput!) {\n                createPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[293].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getProjectJobInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[294].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[295].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[296].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[297].call(callSiteArray[298].call(callSiteArray[299].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[300].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[301].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object getJobInstanceStatus = callSiteArray[302].callStatic(SaagieUtils.class, (Object)"\n            query getJobInstanceStatus($jobId: UUID!) {\n                jobInstance(id: $jobId) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[303].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[304].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[305].call((Object)logger, (Object)"Generating getProjectPipelineInstanceStatusRequest [pipelineInstanceId={}]", callSiteArray[306].callGroovyObjectGetProperty((Object)pipelineinstance));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[307].callCurrent((GroovyObject)this, callSiteArray[308].callGroovyObjectGetProperty((Object)pipelineinstance)), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequestWithparam(String id) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[312].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", id}));
        Object getPipelineInstanceStatus = callSiteArray[313].callStatic(SaagieUtils.class, (Object)"\n            query getPipelineInstanceStatus($id: UUID!) {\n                pipelineInstance(id: $id) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[314].callCurrent((GroovyObject)this, getPipelineInstanceStatus), Request.class);
    }

    public Request getProjectUpdatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[315].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[316].call((Object)logger, (Object)"Generating getProjectUpdatePipelineRequest [pipelineId={}]", callSiteArray[317].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[318].call(callSiteArray[319].call(callSiteArray[320].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[321].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", callSiteArray[322].call((Object)pipeline)}));
        Object editPipeline = callSiteArray[323].callStatic(SaagieUtils.class, (Object)"\n            mutation editPipelineMutation($pipeline: PipelineEditionInput!) {\n                editPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[324].callCurrent((GroovyObject)this, editPipeline), Request.class);
    }

    public Request getAddPipelineVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[325].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[326].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[327].callCurrent((GroovyObject)this, (Object)pipeline, (Object)pipelineVersion), Request.class);
    }

    public Request getAddPipelineVersionRequestFromParams(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[328].call((Object)logger, (Object)"Generating getAddPipelineVersionRequest [pipelineId={}]", callSiteArray[329].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[330].call(callSiteArray[331].call(callSiteArray[332].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[333].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[334].callGroovyObjectGetProperty((Object)pipeline), "jobsId", callSiteArray[335].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[336].callGroovyObjectGetProperty((Object)pipelineVersion)}));
        Object addPipelineVersionRequest = callSiteArray[337].callStatic(SaagieUtils.class, (Object)"\n            mutation addPipelineVersionMutation(\n                $pipelineId: UUID!,\n                $jobsId: [UUID!]!,\n                $releaseNote: String,\n            ) {\n                addPipelineVersion(\n                    pipelineId: $pipelineId,\n                    jobsId: $jobsId,\n                    releaseNote: $releaseNote\n                ) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[338].callCurrent((GroovyObject)this, addPipelineVersionRequest), Request.class);
    }

    public Request getProjectRunPipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[339].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[340].call((Object)logger, (Object)"Generating getProjectRunPipelineRequest [pipelineId={}]", callSiteArray[341].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[342].call(callSiteArray[343].call(callSiteArray[344].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[345].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[346].callGroovyObjectGetProperty((Object)pipeline)}));
        Object runPipeline = callSiteArray[347].callStatic(SaagieUtils.class, (Object)"\n            mutation runPipelineMutation($pipelineId: UUID!) {\n                runPipeline(pipelineId: $pipelineId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[348].callCurrent((GroovyObject)this, runPipeline), Request.class);
    }

    public Request getProjectDeletePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[349].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[350].call((Object)logger, (Object)"Generating getProjectDeletePipelineRequest [pipelineId={}]", callSiteArray[351].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[352].call(callSiteArray[353].call(callSiteArray[354].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[355].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[356].callGroovyObjectGetProperty((Object)pipeline)}));
        Object deletePipeline = callSiteArray[357].callStatic(SaagieUtils.class, (Object)"\n            mutation deletePipelineMutation($id: UUID!) {\n                deletePipeline(id: $id)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[358].callCurrent((GroovyObject)this, deletePipeline), Request.class);
    }

    public Request getProjectArchiveJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[359].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[360].call((Object)logger, (Object)"Generating getProjectDeleteJobRequest [jobId={}]", callSiteArray[361].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[362].call(callSiteArray[363].call(callSiteArray[364].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[365].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[366].callGroovyObjectGetProperty((Object)job)}));
        Object getJobInstanceStatus = callSiteArray[367].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveJobMutation($jobId: UUID!) {\n                archiveJob(jobId: $jobId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[368].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectStopPipelineInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[369].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[370].call((Object)logger, (Object)"Generating getProjectStopPipelineInstanceRequest [pipelineinstanceId={}]", callSiteArray[371].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[372].call(callSiteArray[373].call(callSiteArray[374].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[375].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineInstanceId", callSiteArray[376].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getJobInstanceStatus = callSiteArray[377].callStatic(SaagieUtils.class, (Object)"\n            mutation stopPipelineInstanceMutation($pipelineInstanceId: UUID!) {\n                stopPipelineInstance(pipelineInstanceId: $pipelineInstanceId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[378].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getJwtTokenRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[379].call((Object)logger, (Object)"Requesting JWT...");
        Request newRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[380].call(callSiteArray[381].call(callSiteArray[382].call(callSiteArray[383].call(callSiteArray[384].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[385].callGetProperty(callSiteArray[386].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", callSiteArray[387].callCurrent((GroovyObject)this))));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[388].call(callSiteArray[389].call(callSiteArray[390].call(callSiteArray[391].call(callSiteArray[392].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[393].callGetProperty(callSiteArray[394].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", (Object)this.getCredentials())));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[395].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getStopJobInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[396].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[397].call((Object)logger, (Object)"Generating getStopJobInstanceRequest for job instance [id={}]", callSiteArray[398].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[399].call(callSiteArray[400].call(callSiteArray[401].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[402].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobInstanceId", callSiteArray[403].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object runProjectJobRequest = callSiteArray[404].callStatic(SaagieUtils.class, (Object)"\n            mutation stopJobMutation($jobInstanceId: UUID!) {\n                stopJobInstance(jobInstanceId: $jobInstanceId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[405].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    private boolean checkIfStringIsJson(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[406].call(JsonOutput.class, (Object)query);
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
            boolean bl2 = false;
            return bl2;
        }
    }

    private Request buildMultipartRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[407].call((Object)logger, (Object)"Generating multipart request from query=\"{}\"", (Object)query);
        Object file = callSiteArray[408].callConstructor(File.class, callSiteArray[409].callGetProperty(callSiteArray[410].callGetProperty(callSiteArray[411].callGroovyObjectGetProperty((Object)this.configuration))));
        Object fileName = callSiteArray[412].callGetProperty(file);
        callSiteArray[413].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[414].callGetProperty(file));
        Object jsonGenerator = callSiteArray[415].call(callSiteArray[416].call(callSiteArray[417].callConstructor(JsonGenerator.Options.class)));
        Object map = callSiteArray[418].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"0", ScriptBytecodeAdapter.createList((Object[])new Object[]{"variables.file"})}));
        Object fileBody = callSiteArray[419].call(RequestBody.class, file, callSiteArray[420].call(MediaType.class, (Object)"application/octet-stream"));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[421].call(callSiteArray[422].call(callSiteArray[423].call(callSiteArray[424].call(callSiteArray[425].call(callSiteArray[426].callConstructor(MultipartBody.Builder.class, (Object)"--graphql-multipart-upload-boundary-85763456--"), callSiteArray[427].callGetProperty(MultipartBody.class)), (Object)"operations", null, callSiteArray[428].call(RequestBody.class, (Object)query, (Object)JSON)), (Object)"map", null, callSiteArray[429].call(RequestBody.class, map, (Object)JSON)), (Object)"0", fileName, fileBody)), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[430].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[431].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[432].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[433].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[434].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[435].call(callSiteArray[436].call(callSiteArray[437].call(callSiteArray[438].call(callSiteArray[439].call(callSiteArray[440].call(callSiteArray[441].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[442].callGetProperty(callSiteArray[443].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[444].callGetProperty(callSiteArray[445].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[446].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[447].call(callSiteArray[448].call(callSiteArray[449].call(callSiteArray[450].call(callSiteArray[451].call(callSiteArray[452].call(callSiteArray[453].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[454].callGetProperty(callSiteArray[455].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[456].callGetProperty(callSiteArray[457].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[458].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[459].call(callSiteArray[460].call(callSiteArray[461].call(callSiteArray[462].call(callSiteArray[463].call(callSiteArray[464].call(callSiteArray[465].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[466].callGetProperty(callSiteArray[467].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[468].callGetProperty(callSiteArray[469].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[470].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPlatformListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[471].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[472].call((Object)logger, (Object)"Generating request in order to get access rights by platforms");
        String realm = ShortTypeHandling.castToString((Object)callSiteArray[473].callGroovyObjectGetProperty((Object)server));
        String jwtToken = ShortTypeHandling.castToString((Object)callSiteArray[474].callGroovyObjectGetProperty((Object)server));
        callSiteArray[475].call((Object)logger, (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"Using realm=", " and jwt=", ""}));
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[476].call(callSiteArray[477].call(callSiteArray[478].call(callSiteArray[479].call(callSiteArray[480].call(callSiteArray[481].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[482].callGetProperty(callSiteArray[483].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[484].callGetProperty(callSiteArray[485].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/security/api/groups/authorizations/", "/permissions/projects"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{callSiteArray[486].call((Object)realm), jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Saagie-Realm", callSiteArray[487].call((Object)realm)))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[488].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getListAllPipelinesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[489].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[490].call((Object)logger, (Object)"Generating getListAllPipelinesRequest for project [id={}]", callSiteArray[491].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[492].call(callSiteArray[493].call(callSiteArray[494].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[495].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[496].callGroovyObjectGetProperty((Object)project)}));
        Object listAllPipelineRequest = callSiteArray[497].callStatic(SaagieUtils.class, (Object)"\n            query getAllPipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[498].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getListAllTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[499].call((Object)logger, (Object)"Generating getListAllTechnologiesRequest");
        Object listAllPipelineRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listAllPipelineRequest = object = callSiteArray[500].callStatic(SaagieUtils.class, (Object)"\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
            listAllPipelineRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[501].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getGroupListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[502].callCurrent((GroovyObject)this), Request.class);
        }
        return this.getPlatformListRequest();
    }

    public Request getProjectsCreateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[503].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[504].call((Object)logger, (Object)"Generating getProjectsCreateRequest for creating a new project [name={}]", callSiteArray[505].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[506].call(callSiteArray[507].call(callSiteArray[508].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[509].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[510].call((Object)project)}));
        Object createProjectRequest = callSiteArray[511].callStatic(SaagieUtils.class, (Object)"\n            mutation createProjectMutation($project: ProjectInput!) {\n                createProject(project: $project) {\n                    id\n                    name\n                    description\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[512].callCurrent((GroovyObject)this, createProjectRequest), Request.class);
    }

    public Request getJobDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[514].callCurrent((GroovyObject)this, callSiteArray[515].callGroovyObjectGetProperty((Object)job)), Request.class);
    }

    public Request getJobDetailRequestFromParam(Object jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[516].call((Object)logger, (Object)"Generating getJobDetailRequest for getting job detail [id={}]", jobId);
        Object jsonGenerator = callSiteArray[517].call(callSiteArray[518].call(callSiteArray[519].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[520].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object getJobDetailRequest = callSiteArray[521].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        runtimeVersion\n                        packageInfo {\n                            downloadUrl\n                        }\n                        dockerInfo {\n                            image\n                            dockerCredentialsId\n                        }\n                        commandLine\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[522].callCurrent((GroovyObject)this, getJobDetailRequest), Request.class);
    }

    public Request getJobDetailRequestFromParamV1(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[523].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[524].call((Object)logger, (Object)"Generating request in order to get job detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[525].call(callSiteArray[526].call(callSiteArray[527].call(callSiteArray[528].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[529].callGroovyObjectGetProperty((Object)server), callSiteArray[530].callGroovyObjectGetProperty((Object)server), jobId}, new String[]{"", "/manager/api/v1/platform/", "/job/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[531].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getJobVersionDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[532].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[533].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[534].call((Object)logger, (Object)"Getting jobVersion for job  [id={}] with project Id [id={}]", callSiteArray[535].callGroovyObjectGetProperty((Object)project), callSiteArray[536].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[537].call(callSiteArray[538].call(callSiteArray[539].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[540].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[541].callGroovyObjectGetProperty((Object)job), "number", 1}));
        Object getJobVersionRequest = callSiteArray[542].callStatic(SaagieUtils.class, (Object)"\n            query jobVersion($jobId: UUID!, $number: Int!) {\n                jobVersion(jobId: $jobId, number: $number) {\n                    commandLine\n                    dockerInfo {\n                        image\n                        dockerCredentialsId\n                    }\n                    releaseNote\n                    runtimeVersion\n                    packageInfo {\n                        name\n                        downloadUrl\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[543].callCurrent((GroovyObject)this, getJobVersionRequest), Request.class);
    }

    public Request getProjectsUpdateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[544].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[545].call((Object)logger, (Object)"Generating getProjectsUpdateRequest for updating a new project [id={}]", callSiteArray[546].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[547].call(callSiteArray[548].call(callSiteArray[549].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[550].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[551].call((Object)project)}));
        Object updateProjectRequest = callSiteArray[552].callStatic(SaagieUtils.class, (Object)"\n            mutation editProjectMutation($project: ProjectEditionInput!) {\n                editProject(project: $project) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[553].callCurrent((GroovyObject)this, updateProjectRequest), Request.class);
    }

    public Request getListVersionForJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[554].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[555].call((Object)logger, (Object)"Generating getListVersionForJobRequest for getting list a new job [id={}]", (Object)jobId);
        Object jsonGenerator = callSiteArray[556].call(callSiteArray[557].call(callSiteArray[558].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[559].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object listVersionForAJobRequest = callSiteArray[560].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    versions {\n                        number\n                        isCurrent\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[561].callCurrent((GroovyObject)this, listVersionForAJobRequest), Request.class);
    }

    private Request buildRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[562].call((Object)logger, (Object)"Generating request from query=\"{}\"", (Object)query);
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[563].call(RequestBody.class, (Object)query, (Object)JSON), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[564].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[565].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[566].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[567].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[568].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[569].call(callSiteArray[570].call(callSiteArray[571].call(callSiteArray[572].call(callSiteArray[573].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[574].callGetProperty(callSiteArray[575].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[576].callGetProperty(callSiteArray[577].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[578].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[579].call(callSiteArray[580].call(callSiteArray[581].call(callSiteArray[582].call(callSiteArray[583].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[584].callGetProperty(callSiteArray[585].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[586].callGetProperty(callSiteArray[587].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[588].callCurrent((GroovyObject)this)), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[589].call(callSiteArray[590].call(callSiteArray[591].call(callSiteArray[592].call(callSiteArray[593].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[594].callGetProperty(callSiteArray[595].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[596].callGetProperty(callSiteArray[597].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[598].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public void downloadFromHTTPSServer(String urlFrom, String to, OkHttpClient client, Object name) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            callSiteArray[599].call((Object)logger, (Object)"Downloading artifiacts ....");
            Request request = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[600].callCurrent((GroovyObject)this, (Object)urlFrom);
                request = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Request request2;
                request = request2 = this.buildRequestForFile(urlFrom);
            }
            Object response = callSiteArray[601].call(callSiteArray[602].call((Object)client, (Object)request));
            Object object = callSiteArray[603].call(callSiteArray[604].call(response));
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
            Object object2 = callSiteArray[605].callConstructor(FileOutputStream.class, callSiteArray[606].callConstructor(File.class, callSiteArray[607].call(callSiteArray[608].call((Object)to, (Object)"/"), name)));
            outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)object2, OutputStream.class);
            byte[] buffer = new byte[2048];
            int length = 0;
            int downloaded = 0;
            while (true) {
                Object object3 = callSiteArray[609].call((Object)inputStream, (Object)buffer);
                length = DefaultTypeTransformation.intUnbox((Object)object3);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)object3, (Object)-1)) {
                    callSiteArray[610].call((Object)outputStream, (Object)buffer, (Object)0, (Object)length);
                    downloaded = DefaultTypeTransformation.intUnbox((Object)callSiteArray[611].call((Object)downloaded, (Object)length));
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw (Throwable)callSiteArray[612].callConstructor(GradleException.class, callSiteArray[613].callGetProperty((Object)ex));
        }
        callSiteArray[614].call((Object)logger, (Object)"Artifacts downloaded.");
        callSiteArray[615].call((Object)outputStream);
        callSiteArray[616].call((Object)inputStream);
    }

    public Request buildRequestForFile(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[617].call((Object)logger, (Object)"Generating request for url=\"{}\"", (Object)url);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[618].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        callSiteArray[619].call((Object)logger, (Object)"Fetching file with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[620].call(callSiteArray[621].call(callSiteArray[622].call(callSiteArray[623].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", callSiteArray[624].callCurrent((GroovyObject)this)));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[625].call(callSiteArray[626].call(callSiteArray[627].call(callSiteArray[628].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", (Object)this.getCredentials()));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[629].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static String getFileNameFromUrl(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[630].call((Object)url, callSiteArray[631].call(callSiteArray[632].call((Object)url, (Object)"/"), (Object)1), callSiteArray[633].call((Object)url)));
    }

    public static Object removeLastSlash(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[634].call((Object)url, (Object)"/"))) {
            Object object = callSiteArray[635].call((Object)url, (Object)0, callSiteArray[636].call(callSiteArray[637].call((Object)url), (Object)1));
            url = ShortTypeHandling.castToString((Object)object);
        }
        return url;
    }

    private String getCredentials() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[638].call(Credentials.class, callSiteArray[639].callGetProperty(callSiteArray[640].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[641].callGetProperty(callSiteArray[642].callGroovyObjectGetProperty((Object)this.configuration))));
    }

    public static Map extractProperties(Object obj) {
        Reference obj2 = new Reference(obj);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _extractProperties_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _extractProperties_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _extractProperties_closure2.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _extractProperties_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "synthetic";
                return new CallSiteArray(_extractProperties_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _extractProperties_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference obj;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure3(Object _outerInstance, Object _thisObject, Reference obj) {
                Reference reference;
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.obj = reference = obj;
            }

            public Object doCall(Object field) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(field), callSiteArray[1].call(this.obj.get(), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(field)}, new String[]{"", ""}))});
            }

            public Object getObj() {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return this.obj.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getAt";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _extractProperties_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractProperties_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[643].call(callSiteArray[644].call(callSiteArray[645].callGetProperty(callSiteArray[646].call(obj2.get())), (Object)new _extractProperties_closure2(SaagieUtils.class, SaagieUtils.class)), (Object)new _extractProperties_closure3(SaagieUtils.class, SaagieUtils.class, obj2)), Map.class);
    }

    public static boolean distinctValues(int ... arr) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set foundNumbers = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[647].callConstructor(HashSet.class), Set.class);
        String num = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[648].call((Object)arr), Iterator.class);
        while (iterator.hasNext()) {
            num = ShortTypeHandling.castToString(iterator.next());
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[649].call((Object)foundNumbers, (Object)num))) {
                return false;
            }
            callSiteArray[650].call((Object)foundNumbers, (Object)num);
        }
        return true;
    }

    public static Object debugRequest(Request request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[651].call((Object)logger, (Object)"====== Request ======");
        callSiteArray[652].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[653].callGetProperty((Object)((Request)request2.get())), callSiteArray[654].callGetProperty(callSiteArray[655].call(callSiteArray[656].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"", " ", ""}));
        callSiteArray[657].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[658].callGetProperty(callSiteArray[659].call(callSiteArray[660].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"Host: ", ""}));
        public final class _debugRequest_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugRequest_closure4(Object _outerInstance, Object _thisObject, Reference request) {
                Reference reference;
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference = request;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.request.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Request getRequest() {
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                return (Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), Request.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugRequest_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugRequest_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugRequest_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugRequest_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[661].call(callSiteArray[662].call(callSiteArray[663].call((Object)((Request)request2.get()))), (Object)new _debugRequest_closure4(SaagieUtils.class, SaagieUtils.class, request2));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[664].call((Object)((Request)request2.get())))) {
            callSiteArray[665].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[666].call(callSiteArray[667].call((Object)((Request)request2.get())))}, new String[]{"Content-Length: ", ""}));
            Buffer buffer = (Buffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[668].callConstructor(Buffer.class), Buffer.class);
            callSiteArray[669].call(callSiteArray[670].call((Object)((Request)request2.get())), (Object)buffer);
            return callSiteArray[671].call((Object)logger, callSiteArray[672].call((Object)buffer));
        }
        return null;
    }

    public static Object debugResponse(Response response) {
        Reference response2 = new Reference((Object)response);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[673].call((Object)logger, (Object)"====== Response ======");
        callSiteArray[674].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[675].call(callSiteArray[676].call((Object)((Response)response2.get()))), callSiteArray[677].callGetProperty((Object)((Response)response2.get())), callSiteArray[678].callGetProperty((Object)((Response)response2.get()))}, new String[]{"", " ", " ", ""}));
        public final class _debugResponse_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugResponse_closure5(Object _outerInstance, Object _thisObject, Reference response) {
                Reference reference;
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.response.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Response getResponse() {
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                return (Response)ScriptBytecodeAdapter.castToType((Object)this.response.get(), Response.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugResponse_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugResponse_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugResponse_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugResponse_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[679].call(callSiteArray[680].call(callSiteArray[681].call((Object)((Response)response2.get()))), (Object)new _debugResponse_closure5(SaagieUtils.class, SaagieUtils.class, response2));
    }

    public static Object throwAndLogError(Object l, Object message) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[682].call(l, message);
        throw (Throwable)callSiteArray[683].callConstructor(GradleException.class, message);
    }

    public static String convertScheduleV1ToCron(String cronString) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)cronString)) {
            return ShortTypeHandling.castToString(null);
        }
        int startPeriod = DefaultTypeTransformation.intUnbox((Object)callSiteArray[684].call((Object)cronString, (Object)"/", callSiteArray[685].call(callSiteArray[686].call((Object)cronString, (Object)"/"), (Object)1)));
        if (!(startPeriod != 0)) {
            callSiteArray[687].callStatic(SaagieUtils.class, (Object)"Can't parse cronString, couldn t find '/'");
        }
        String startDate = ShortTypeHandling.castToString((Object)callSiteArray[688].call((Object)cronString, callSiteArray[689].call(callSiteArray[690].call((Object)cronString, (Object)"/"), (Object)1), (Object)startPeriod));
        String cronPeriod = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[691].call((Object)cronString, callSiteArray[692].call((Object)startPeriod, (Object)1), callSiteArray[693].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[694].call((Object)cronString, (Object)(startPeriod + 1), callSiteArray[695].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        }
        Date cronDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[696].call(Date.class, callSiteArray[697].call(callSiteArray[698].call(ZonedDateTime.class, (Object)startDate))), Date.class);
        PeriodDuration period = (PeriodDuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[699].call(PeriodDuration.class, (Object)cronPeriod), PeriodDuration.class);
        Object minutes = null;
        Object hours = null;
        Object dayOfMonths = null;
        Object months = null;
        Object time = callSiteArray[700].callGetProperty(callSiteArray[701].callGetProperty(UnitTime.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[702].callGetProperty(callSiteArray[703].call((Object)period)))) {
            Object object;
            Object object2;
            time = object2 = callSiteArray[704].callGetProperty(callSiteArray[705].callGetProperty(UnitTime.class));
            months = object = callSiteArray[706].call((Object)"*/", callSiteArray[707].callGetProperty(callSiteArray[708].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[709].callGetProperty(callSiteArray[710].callGetProperty(UnitTime.class)))) {
            Object object;
            months = object = callSiteArray[711].call(callSiteArray[712].callGetProperty((Object)cronDate));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[713].callGetProperty(callSiteArray[714].call((Object)period)))) {
            Object object;
            Object object3;
            time = object3 = callSiteArray[715].callGetProperty(callSiteArray[716].callGetProperty(UnitTime.class));
            dayOfMonths = object = callSiteArray[717].call((Object)"*/", callSiteArray[718].callGetProperty(callSiteArray[719].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[720].callGetProperty(callSiteArray[721].callGetProperty(UnitTime.class)))) {
            Object object;
            dayOfMonths = object = callSiteArray[722].call(callSiteArray[723].callGetProperty((Object)cronDate));
        }
        Object hoursTest = callSiteArray[724].call(callSiteArray[725].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[726].call(callSiteArray[727].call((Object)period)))) {
            Object object;
            Object object4;
            time = object4 = callSiteArray[728].callGetProperty(callSiteArray[729].callGetProperty(UnitTime.class));
            hours = object = callSiteArray[730].call((Object)"*/", hoursTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[731].callGetProperty(callSiteArray[732].callGetProperty(UnitTime.class)))) {
            Object object;
            hours = object = callSiteArray[733].call(callSiteArray[734].callGetProperty((Object)cronDate));
        }
        Object minutesTest = callSiteArray[735].call(callSiteArray[736].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[737].call(callSiteArray[738].call((Object)period))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[739].call(callSiteArray[740].call((Object)period)))) {
            Object object;
            Object object5;
            time = object5 = callSiteArray[741].callGetProperty(callSiteArray[742].callGetProperty(UnitTime.class));
            minutes = object = callSiteArray[743].call((Object)"* / ", minutesTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[744].callGetProperty(callSiteArray[745].callGetProperty(UnitTime.class)))) {
            Object object;
            minutes = object = callSiteArray[746].call(callSiteArray[747].callGetProperty((Object)cronDate));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[748].callStatic(SaagieUtils.class, minutes, hours, dayOfMonths, months));
    }

    public static String generateCronExpression(String minutes, String hours, String dayOfMonth, String month) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[749].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)callSiteArray[750].callStatic(SaagieUtils.class, (Object)minutes), (Object)callSiteArray[751].callStatic(SaagieUtils.class, (Object)hours), (Object)callSiteArray[752].callStatic(SaagieUtils.class, (Object)dayOfMonth), (Object)callSiteArray[753].callStatic(SaagieUtils.class, (Object)month), (Object)"*")));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[754].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)SaagieUtils.getValueOrStar(minutes), (Object)SaagieUtils.getValueOrStar(hours), (Object)SaagieUtils.getValueOrStar(dayOfMonth), (Object)SaagieUtils.getValueOrStar(month), (Object)"*")));
    }

    private static Object getValueOrStar(String value) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? value : "*";
    }

    @Generated
    public static String gq(String request, String vars) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, vars, null);
        }
        return SaagieUtils.gq(request, vars, null);
    }

    @Generated
    public static String gq(String request) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, null, null);
        }
        return SaagieUtils.gq(request, null, null);
    }

    @Deprecated
    @Generated
    public Request getUploadFileToJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getUploadFileToJobRequest(jobId, "1");
        }
        return this.getUploadFileToJobRequest(jobId, "1");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaagieUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SaagieUtils.$getCallSiteArray()[755].call(Logging.class, SaagieUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = SaagieUtils.$getCallSiteArray()[756].call(MediaType.class, (Object)"application/json; charset=utf-8");
        JSON = (MediaType)ScriptBytecodeAdapter.castToType((Object)object2, MediaType.class);
        public final class __clinit__closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure6.$getCallSiteArray();
                callSiteArray[0].call((Object)l, (Object)"Checking server response");
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(response))) {
                    callSiteArray[2].call((Object)l, (Object)"No error in server response.");
                    return null;
                }
                String body = ShortTypeHandling.castToString((Object)callSiteArray[3].call(callSiteArray[4].call(response)));
                callSiteArray[5].callStatic(SaagieUtils.class, response);
                String status = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[6].call(response)}, new String[]{"", ""}));
                GStringImpl message = new GStringImpl(new Object[]{status, body}, new String[]{"Error ", " when requesting \n", ""});
                callSiteArray[7].call((Object)l, (Object)message);
                throw (Throwable)callSiteArray[8].callConstructor(GradleException.class, (Object)message);
            }

            public Object call(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure6.$getCallSiteArray();
                return callSiteArray[9].callCurrent((GroovyObject)this, (Object)l, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "successful";
                stringArray[2] = "debug";
                stringArray[3] = "string";
                stringArray[4] = "body";
                stringArray[5] = "debugResponse";
                stringArray[6] = "code";
                stringArray[7] = "error";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                __clinit__closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure6 __clinit__closure62 = new __clinit__closure6(SaagieUtils.class, SaagieUtils.class);
        handleErrorClosure = __clinit__closure62;
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static MediaType getJSON() {
        return JSON;
    }

    @Generated
    public DataOpsExtension getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(DataOpsExtension dataOpsExtension) {
        this.configuration = dataOpsExtension;
    }

    @Generated
    public static Object getHandleErrorClosure() {
        return handleErrorClosure;
    }

    @Generated
    public static void setHandleErrorClosure(Object object) {
        handleErrorClosure = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "debug";
        stringArray[1] = "debug";
        stringArray[2] = "debug";
        stringArray[3] = "debug";
        stringArray[4] = "replaceAll";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "debug";
        stringArray[9] = "debug";
        stringArray[10] = "gq";
        stringArray[11] = "buildRequestFromQuery";
        stringArray[12] = "getProjectJobsRequestBuild";
        stringArray[13] = "getProjectJobsRequestBuild";
        stringArray[14] = "project";
        stringArray[15] = "debug";
        stringArray[16] = "id";
        stringArray[17] = "build";
        stringArray[18] = "excludeNulls";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "toJson";
        stringArray[21] = "id";
        stringArray[22] = "gq";
        stringArray[23] = "buildRequestFromQuery";
        stringArray[24] = "debug";
        stringArray[25] = "build";
        stringArray[26] = "excludeNulls";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "toJson";
        stringArray[29] = "gq";
        stringArray[30] = "buildRequestFromQuery";
        stringArray[31] = "project";
        stringArray[32] = "debug";
        stringArray[33] = "id";
        stringArray[34] = "build";
        stringArray[35] = "excludeNulls";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "toJson";
        stringArray[38] = "id";
        stringArray[39] = "gq";
        stringArray[40] = "buildRequestFromQuery";
        stringArray[41] = "project";
        stringArray[42] = "debug";
        stringArray[43] = "id";
        stringArray[44] = "build";
        stringArray[45] = "excludeNulls";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "toJson";
        stringArray[48] = "id";
        stringArray[49] = "gq";
        stringArray[50] = "buildRequestFromQuery";
        stringArray[51] = "project";
        stringArray[52] = "debug";
        stringArray[53] = "id";
        stringArray[54] = "build";
        stringArray[55] = "excludeNulls";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "toJson";
        stringArray[58] = "id";
        stringArray[59] = "gq";
        stringArray[60] = "buildRequestFromQuery";
        stringArray[61] = "server";
        stringArray[62] = "debug";
        stringArray[63] = "build";
        stringArray[64] = "get";
        stringArray[65] = "url";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "url";
        stringArray[68] = "environment";
        stringArray[69] = "debugRequest";
        stringArray[70] = "project";
        stringArray[71] = "debug";
        stringArray[72] = "id";
        stringArray[73] = "build";
        stringArray[74] = "excludeNulls";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "toJson";
        stringArray[77] = "gq";
        stringArray[78] = "buildRequestFromQuery";
        stringArray[79] = "job";
        stringArray[80] = "jobVersion";
        stringArray[81] = "mapJobAndJobVersionWithoutMail";
        stringArray[82] = "id";
        stringArray[83] = "project";
        stringArray[84] = "debug";
        stringArray[85] = "build";
        stringArray[86] = "excludeFieldsByName";
        stringArray[87] = "excludeNulls";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "toJson";
        stringArray[90] = "job";
        stringArray[91] = "jobVersion";
        stringArray[92] = "gq";
        stringArray[93] = "buildRequestFromQuery";
        stringArray[94] = "job";
        stringArray[95] = "jobVersion";
        stringArray[96] = "mapJobAndJobVersionWithoutMail";
        stringArray[97] = "id";
        stringArray[98] = "project";
        stringArray[99] = "debug";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "name";
        stringArray[102] = "packageInfo";
        stringArray[103] = "debug";
        stringArray[104] = "absolutePath";
        stringArray[105] = "build";
        stringArray[106] = "addConverter";
        stringArray[107] = "excludeNulls";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "toJson";
        stringArray[110] = "job";
        stringArray[111] = "jobVersion";
        stringArray[112] = "absolutePath";
        stringArray[113] = "packageInfo";
        stringArray[114] = "reverse";
        stringArray[115] = "drop";
        stringArray[116] = "reverse";
        stringArray[117] = "gq";
        stringArray[118] = "buildMultipartRequestFromQuery";
        stringArray[119] = "job";
        stringArray[120] = "mapJobWithoutMail";
        stringArray[121] = "id";
        stringArray[122] = "project";
        stringArray[123] = "debug";
        stringArray[124] = "build";
        stringArray[125] = "excludeNulls";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "toJson";
        stringArray[128] = "getProjectUpdateJobRequestFormat";
        stringArray[129] = "job";
        stringArray[130] = "mapJobWithoutMail";
        stringArray[131] = "id";
        stringArray[132] = "project";
        stringArray[133] = "getProjectUpdateJobFromDataRequestFromParams";
        stringArray[134] = "job";
        stringArray[135] = "build";
        stringArray[136] = "excludeNulls";
        stringArray[137] = "<$constructor$>";
        stringArray[138] = "getFormatForUpdateJob";
        stringArray[139] = "toJson";
        stringArray[140] = "getProjectUpdateJobRequestFormat";
        stringArray[141] = "gq";
        stringArray[142] = "buildRequestFromQuery";
        stringArray[143] = "job";
        stringArray[144] = "jobVersion";
        stringArray[145] = "debug";
        stringArray[146] = "id";
        stringArray[147] = "build";
        stringArray[148] = "excludeNulls";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "toJson";
        stringArray[151] = "id";
        stringArray[152] = "toMap";
        stringArray[153] = "gq";
        stringArray[154] = "buildRequestFromQuery";
        stringArray[155] = "<$constructor$>";
        stringArray[156] = "add";
        stringArray[157] = "add";
        stringArray[158] = "add";
        stringArray[159] = "removeAll";
        stringArray[160] = "keySet";
        stringArray[161] = "job";
        stringArray[162] = "jobVersion";
        stringArray[163] = "debug";
        stringArray[164] = "id";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "name";
        stringArray[167] = "packageInfo";
        stringArray[168] = "debug";
        stringArray[169] = "absolutePath";
        stringArray[170] = "build";
        stringArray[171] = "excludeNulls";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "toJson";
        stringArray[174] = "id";
        stringArray[175] = "toMap";
        stringArray[176] = "absolutePath";
        stringArray[177] = "packageInfo";
        stringArray[178] = "reverse";
        stringArray[179] = "drop";
        stringArray[180] = "reverse";
        stringArray[181] = "gq";
        stringArray[182] = "buildMultipartRequestFromQuery";
        stringArray[183] = "job";
        stringArray[184] = "jobVersion";
        stringArray[185] = "debug";
        stringArray[186] = "id";
        stringArray[187] = "excludeFieldsByName";
        stringArray[188] = "excludeNulls";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "downloadUrl";
        stringArray[191] = "packageInfo";
        stringArray[192] = "jobVersion";
        stringArray[193] = "excludeFieldsByName";
        stringArray[194] = "build";
        stringArray[195] = "toJson";
        stringArray[196] = "id";
        stringArray[197] = "toMap";
        stringArray[198] = "gq";
        stringArray[199] = "buildRequestFromQuery";
        stringArray[200] = "debug";
        stringArray[201] = "<$constructor$>";
        stringArray[202] = "name";
        stringArray[203] = "packageInfo";
        stringArray[204] = "jobVersion";
        stringArray[205] = "<$constructor$>";
        stringArray[206] = "detect";
        stringArray[207] = "debug";
        stringArray[208] = "parse";
        stringArray[209] = "debug";
        stringArray[210] = "absolutePath";
        stringArray[211] = "build";
        stringArray[212] = "addFormDataPart";
        stringArray[213] = "setType";
        stringArray[214] = "<$constructor$>";
        stringArray[215] = "FORM";
        stringArray[216] = "name";
        stringArray[217] = "create";
        stringArray[218] = "server";
        stringArray[219] = "jwt";
        stringArray[220] = "debug";
        stringArray[221] = "realm";
        stringArray[222] = "token";
        stringArray[223] = "build";
        stringArray[224] = "post";
        stringArray[225] = "addHeader";
        stringArray[226] = "addHeader";
        stringArray[227] = "addHeader";
        stringArray[228] = "url";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "url";
        stringArray[231] = "server";
        stringArray[232] = "environment";
        stringArray[233] = "server";
        stringArray[234] = "id";
        stringArray[235] = "project";
        stringArray[236] = "debug";
        stringArray[237] = "build";
        stringArray[238] = "post";
        stringArray[239] = "addHeader";
        stringArray[240] = "addHeader";
        stringArray[241] = "addHeader";
        stringArray[242] = "url";
        stringArray[243] = "<$constructor$>";
        stringArray[244] = "url";
        stringArray[245] = "server";
        stringArray[246] = "environment";
        stringArray[247] = "server";
        stringArray[248] = "id";
        stringArray[249] = "project";
        stringArray[250] = "getCredentials";
        stringArray[251] = "build";
        stringArray[252] = "post";
        stringArray[253] = "addHeader";
        stringArray[254] = "addHeader";
        stringArray[255] = "addHeader";
        stringArray[256] = "url";
        stringArray[257] = "<$constructor$>";
        stringArray[258] = "url";
        stringArray[259] = "server";
        stringArray[260] = "environment";
        stringArray[261] = "server";
        stringArray[262] = "id";
        stringArray[263] = "project";
        stringArray[264] = "job";
        stringArray[265] = "debug";
        stringArray[266] = "id";
        stringArray[267] = "build";
        stringArray[268] = "excludeNulls";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "toJson";
        stringArray[271] = "id";
        stringArray[272] = "gq";
        stringArray[273] = "buildRequestFromQuery";
        stringArray[274] = "deleteDir";
        stringArray[275] = "warn";
        stringArray[276] = "warn";
        stringArray[277] = "message";
        stringArray[278] = "project";
        stringArray[279] = "pipeline";
        stringArray[280] = "pipelineVersion";
        stringArray[281] = "debug";
        stringArray[282] = "id";
        stringArray[283] = "build";
        stringArray[284] = "excludeNulls";
        stringArray[285] = "<$constructor$>";
        stringArray[286] = "toMap";
        stringArray[287] = "toMap";
        stringArray[288] = "id";
        stringArray[289] = "jobs";
        stringArray[290] = "releaseNote";
        stringArray[291] = "toJson";
        stringArray[292] = "gq";
        stringArray[293] = "buildRequestFromQuery";
        stringArray[294] = "jobinstance";
        stringArray[295] = "debug";
        stringArray[296] = "id";
        stringArray[297] = "build";
        stringArray[298] = "excludeNulls";
        stringArray[299] = "<$constructor$>";
        stringArray[300] = "toJson";
        stringArray[301] = "id";
        stringArray[302] = "gq";
        stringArray[303] = "buildRequestFromQuery";
        stringArray[304] = "pipelineinstance";
        stringArray[305] = "debug";
        stringArray[306] = "id";
        stringArray[307] = "getProjectPipelineInstanceStatusRequestWithparam";
        stringArray[308] = "id";
        stringArray[309] = "build";
        stringArray[310] = "excludeNulls";
        stringArray[311] = "<$constructor$>";
        stringArray[312] = "toJson";
        stringArray[313] = "gq";
        stringArray[314] = "buildRequestFromQuery";
        stringArray[315] = "pipeline";
        stringArray[316] = "debug";
        stringArray[317] = "id";
        stringArray[318] = "build";
        stringArray[319] = "excludeNulls";
        stringArray[320] = "<$constructor$>";
        stringArray[321] = "toJson";
        stringArray[322] = "toMap";
        stringArray[323] = "gq";
        stringArray[324] = "buildRequestFromQuery";
        stringArray[325] = "pipeline";
        stringArray[326] = "pipelineVersion";
        stringArray[327] = "getAddPipelineVersionRequestFromParams";
        stringArray[328] = "debug";
        stringArray[329] = "id";
        stringArray[330] = "build";
        stringArray[331] = "excludeNulls";
        stringArray[332] = "<$constructor$>";
        stringArray[333] = "toJson";
        stringArray[334] = "id";
        stringArray[335] = "jobs";
        stringArray[336] = "releaseNote";
        stringArray[337] = "gq";
        stringArray[338] = "buildRequestFromQuery";
        stringArray[339] = "pipeline";
        stringArray[340] = "debug";
        stringArray[341] = "id";
        stringArray[342] = "build";
        stringArray[343] = "excludeNulls";
        stringArray[344] = "<$constructor$>";
        stringArray[345] = "toJson";
        stringArray[346] = "id";
        stringArray[347] = "gq";
        stringArray[348] = "buildRequestFromQuery";
        stringArray[349] = "pipeline";
        stringArray[350] = "debug";
        stringArray[351] = "id";
        stringArray[352] = "build";
        stringArray[353] = "excludeNulls";
        stringArray[354] = "<$constructor$>";
        stringArray[355] = "toJson";
        stringArray[356] = "id";
        stringArray[357] = "gq";
        stringArray[358] = "buildRequestFromQuery";
        stringArray[359] = "job";
        stringArray[360] = "debug";
        stringArray[361] = "id";
        stringArray[362] = "build";
        stringArray[363] = "excludeNulls";
        stringArray[364] = "<$constructor$>";
        stringArray[365] = "toJson";
        stringArray[366] = "id";
        stringArray[367] = "gq";
        stringArray[368] = "buildRequestFromQuery";
        stringArray[369] = "pipelineinstance";
        stringArray[370] = "debug";
        stringArray[371] = "id";
        stringArray[372] = "build";
        stringArray[373] = "excludeNulls";
        stringArray[374] = "<$constructor$>";
        stringArray[375] = "toJson";
        stringArray[376] = "id";
        stringArray[377] = "gq";
        stringArray[378] = "buildRequestFromQuery";
        stringArray[379] = "debug";
        stringArray[380] = "build";
        stringArray[381] = "get";
        stringArray[382] = "addHeader";
        stringArray[383] = "url";
        stringArray[384] = "<$constructor$>";
        stringArray[385] = "url";
        stringArray[386] = "server";
        stringArray[387] = "getCredentials";
        stringArray[388] = "build";
        stringArray[389] = "get";
        stringArray[390] = "addHeader";
        stringArray[391] = "url";
        stringArray[392] = "<$constructor$>";
        stringArray[393] = "url";
        stringArray[394] = "server";
        stringArray[395] = "debugRequest";
        stringArray[396] = "jobinstance";
        stringArray[397] = "debug";
        stringArray[398] = "id";
        stringArray[399] = "build";
        stringArray[400] = "excludeNulls";
        stringArray[401] = "<$constructor$>";
        stringArray[402] = "toJson";
        stringArray[403] = "id";
        stringArray[404] = "gq";
        stringArray[405] = "buildRequestFromQuery";
        stringArray[406] = "prettyPrint";
        stringArray[407] = "debug";
        stringArray[408] = "<$constructor$>";
        stringArray[409] = "name";
        stringArray[410] = "packageInfo";
        stringArray[411] = "jobVersion";
        stringArray[412] = "name";
        stringArray[413] = "debug";
        stringArray[414] = "absolutePath";
        stringArray[415] = "build";
        stringArray[416] = "excludeNulls";
        stringArray[417] = "<$constructor$>";
        stringArray[418] = "toJson";
        stringArray[419] = "create";
        stringArray[420] = "parse";
        stringArray[421] = "build";
        stringArray[422] = "addFormDataPart";
        stringArray[423] = "addFormDataPart";
        stringArray[424] = "addFormDataPart";
        stringArray[425] = "setType";
        stringArray[426] = "<$constructor$>";
        stringArray[427] = "FORM";
        stringArray[428] = "create";
        stringArray[429] = "create";
        stringArray[430] = "server";
        stringArray[431] = "jwt";
        stringArray[432] = "debug";
        stringArray[433] = "realm";
        stringArray[434] = "token";
        stringArray[435] = "build";
        stringArray[436] = "post";
        stringArray[437] = "addHeader";
        stringArray[438] = "addHeader";
        stringArray[439] = "addHeader";
        stringArray[440] = "url";
        stringArray[441] = "<$constructor$>";
        stringArray[442] = "url";
        stringArray[443] = "server";
        stringArray[444] = "environment";
        stringArray[445] = "server";
        stringArray[446] = "debug";
        stringArray[447] = "build";
        stringArray[448] = "post";
        stringArray[449] = "addHeader";
        stringArray[450] = "addHeader";
        stringArray[451] = "addHeader";
        stringArray[452] = "url";
        stringArray[453] = "<$constructor$>";
        stringArray[454] = "url";
        stringArray[455] = "server";
        stringArray[456] = "environment";
        stringArray[457] = "server";
        stringArray[458] = "getCredentials";
        stringArray[459] = "build";
        stringArray[460] = "post";
        stringArray[461] = "addHeader";
        stringArray[462] = "addHeader";
        stringArray[463] = "addHeader";
        stringArray[464] = "url";
        stringArray[465] = "<$constructor$>";
        stringArray[466] = "url";
        stringArray[467] = "server";
        stringArray[468] = "environment";
        stringArray[469] = "server";
        stringArray[470] = "debugRequest";
        stringArray[471] = "server";
        stringArray[472] = "debug";
        stringArray[473] = "realm";
        stringArray[474] = "token";
        stringArray[475] = "debug";
        stringArray[476] = "build";
        stringArray[477] = "get";
        stringArray[478] = "addHeader";
        stringArray[479] = "addHeader";
        stringArray[480] = "url";
        stringArray[481] = "<$constructor$>";
        stringArray[482] = "url";
        stringArray[483] = "server";
        stringArray[484] = "environment";
        stringArray[485] = "server";
        stringArray[486] = "toUpperCase";
        stringArray[487] = "toLowerCase";
        stringArray[488] = "debugRequest";
        stringArray[489] = "project";
        stringArray[490] = "debug";
        stringArray[491] = "id";
        stringArray[492] = "build";
        stringArray[493] = "excludeNulls";
        stringArray[494] = "<$constructor$>";
        stringArray[495] = "toJson";
        stringArray[496] = "id";
        stringArray[497] = "gq";
        stringArray[498] = "buildRequestFromQuery";
        stringArray[499] = "debug";
        stringArray[500] = "gq";
        stringArray[501] = "buildRequestFromQuery";
        stringArray[502] = "getPlatformListRequest";
        stringArray[503] = "project";
        stringArray[504] = "debug";
        stringArray[505] = "name";
        stringArray[506] = "build";
        stringArray[507] = "excludeNulls";
        stringArray[508] = "<$constructor$>";
        stringArray[509] = "toJson";
        stringArray[510] = "toMap";
        stringArray[511] = "gq";
        stringArray[512] = "buildRequestFromQuery";
        stringArray[513] = "job";
        stringArray[514] = "getJobDetailRequestFromParam";
        stringArray[515] = "id";
        stringArray[516] = "debug";
        stringArray[517] = "build";
        stringArray[518] = "excludeNulls";
        stringArray[519] = "<$constructor$>";
        stringArray[520] = "toJson";
        stringArray[521] = "gq";
        stringArray[522] = "buildRequestFromQuery";
        stringArray[523] = "server";
        stringArray[524] = "debug";
        stringArray[525] = "build";
        stringArray[526] = "get";
        stringArray[527] = "url";
        stringArray[528] = "<$constructor$>";
        stringArray[529] = "url";
        stringArray[530] = "environment";
        stringArray[531] = "debugRequest";
        stringArray[532] = "project";
        stringArray[533] = "job";
        stringArray[534] = "debug";
        stringArray[535] = "id";
        stringArray[536] = "id";
        stringArray[537] = "build";
        stringArray[538] = "excludeNulls";
        stringArray[539] = "<$constructor$>";
        stringArray[540] = "toJson";
        stringArray[541] = "id";
        stringArray[542] = "gq";
        stringArray[543] = "buildRequestFromQuery";
        stringArray[544] = "project";
        stringArray[545] = "debug";
        stringArray[546] = "id";
        stringArray[547] = "build";
        stringArray[548] = "excludeNulls";
        stringArray[549] = "<$constructor$>";
        stringArray[550] = "toJson";
        stringArray[551] = "toMap";
        stringArray[552] = "gq";
        stringArray[553] = "buildRequestFromQuery";
        stringArray[554] = "project";
        stringArray[555] = "debug";
        stringArray[556] = "build";
        stringArray[557] = "excludeNulls";
        stringArray[558] = "<$constructor$>";
        stringArray[559] = "toJson";
        stringArray[560] = "gq";
        stringArray[561] = "buildRequestFromQuery";
        stringArray[562] = "debug";
        stringArray[563] = "create";
        stringArray[564] = "server";
        stringArray[565] = "jwt";
        stringArray[566] = "debug";
        stringArray[567] = "realm";
        stringArray[568] = "token";
        stringArray[569] = "build";
        stringArray[570] = "post";
        stringArray[571] = "addHeader";
        stringArray[572] = "url";
        stringArray[573] = "<$constructor$>";
        stringArray[574] = "url";
        stringArray[575] = "server";
        stringArray[576] = "environment";
        stringArray[577] = "server";
        stringArray[578] = "debug";
        stringArray[579] = "build";
        stringArray[580] = "post";
        stringArray[581] = "addHeader";
        stringArray[582] = "url";
        stringArray[583] = "<$constructor$>";
        stringArray[584] = "url";
        stringArray[585] = "server";
        stringArray[586] = "environment";
        stringArray[587] = "server";
        stringArray[588] = "getCredentials";
        stringArray[589] = "build";
        stringArray[590] = "post";
        stringArray[591] = "addHeader";
        stringArray[592] = "url";
        stringArray[593] = "<$constructor$>";
        stringArray[594] = "url";
        stringArray[595] = "server";
        stringArray[596] = "environment";
        stringArray[597] = "server";
        stringArray[598] = "debugRequest";
        stringArray[599] = "debug";
        stringArray[600] = "buildRequestForFile";
        stringArray[601] = "execute";
        stringArray[602] = "newCall";
        stringArray[603] = "byteStream";
        stringArray[604] = "body";
        stringArray[605] = "<$constructor$>";
        stringArray[606] = "<$constructor$>";
        stringArray[607] = "plus";
        stringArray[608] = "plus";
        stringArray[609] = "read";
        stringArray[610] = "write";
        stringArray[611] = "plus";
        stringArray[612] = "<$constructor$>";
        stringArray[613] = "message";
        stringArray[614] = "debug";
        stringArray[615] = "close";
        stringArray[616] = "close";
        stringArray[617] = "debug";
        stringArray[618] = "server";
        stringArray[619] = "debug";
        stringArray[620] = "build";
        stringArray[621] = "addHeader";
        stringArray[622] = "url";
        stringArray[623] = "<$constructor$>";
        stringArray[624] = "getCredentials";
        stringArray[625] = "build";
        stringArray[626] = "addHeader";
        stringArray[627] = "url";
        stringArray[628] = "<$constructor$>";
        stringArray[629] = "debugRequest";
        stringArray[630] = "substring";
        stringArray[631] = "plus";
        stringArray[632] = "lastIndexOf";
        stringArray[633] = "length";
        stringArray[634] = "endsWith";
        stringArray[635] = "substring";
        stringArray[636] = "minus";
        stringArray[637] = "length";
        stringArray[638] = "basic";
        stringArray[639] = "login";
        stringArray[640] = "server";
        stringArray[641] = "password";
        stringArray[642] = "server";
        stringArray[643] = "collectEntries";
        stringArray[644] = "findAll";
        stringArray[645] = "declaredFields";
        stringArray[646] = "getClass";
        stringArray[647] = "<$constructor$>";
        stringArray[648] = "iterator";
        stringArray[649] = "contains";
        stringArray[650] = "add";
        stringArray[651] = "debug";
        stringArray[652] = "debug";
        stringArray[653] = "method";
        stringArray[654] = "path";
        stringArray[655] = "url";
        stringArray[656] = "url";
        stringArray[657] = "debug";
        stringArray[658] = "host";
        stringArray[659] = "url";
        stringArray[660] = "url";
        stringArray[661] = "each";
        stringArray[662] = "names";
        stringArray[663] = "headers";
        stringArray[664] = "body";
        stringArray[665] = "debug";
        stringArray[666] = "contentLength";
        stringArray[667] = "body";
        stringArray[668] = "<$constructor$>";
        stringArray[669] = "writeTo";
        stringArray[670] = "body";
        stringArray[671] = "debug";
        stringArray[672] = "readUtf8";
        stringArray[673] = "debug";
        stringArray[674] = "debug";
        stringArray[675] = "toString";
        stringArray[676] = "protocol";
        stringArray[677] = "code";
        stringArray[678] = "message";
        stringArray[679] = "each";
        stringArray[680] = "names";
        stringArray[681] = "headers";
        stringArray[682] = "error";
        stringArray[683] = "<$constructor$>";
        stringArray[684] = "indexOf";
        stringArray[685] = "plus";
        stringArray[686] = "indexOf";
        stringArray[687] = "throwAndLogError";
        stringArray[688] = "substring";
        stringArray[689] = "plus";
        stringArray[690] = "indexOf";
        stringArray[691] = "substring";
        stringArray[692] = "plus";
        stringArray[693] = "length";
        stringArray[694] = "substring";
        stringArray[695] = "length";
        stringArray[696] = "from";
        stringArray[697] = "toInstant";
        stringArray[698] = "parse";
        stringArray[699] = "parse";
        stringArray[700] = "value";
        stringArray[701] = "SECOND";
        stringArray[702] = "months";
        stringArray[703] = "getPeriod";
        stringArray[704] = "value";
        stringArray[705] = "MONTH";
        stringArray[706] = "plus";
        stringArray[707] = "months";
        stringArray[708] = "getPeriod";
        stringArray[709] = "value";
        stringArray[710] = "MONTH";
        stringArray[711] = "toString";
        stringArray[712] = "month";
        stringArray[713] = "days";
        stringArray[714] = "getPeriod";
        stringArray[715] = "value";
        stringArray[716] = "DAYOFMONTH";
        stringArray[717] = "plus";
        stringArray[718] = "days";
        stringArray[719] = "getPeriod";
        stringArray[720] = "value";
        stringArray[721] = "DAYOFMONTH";
        stringArray[722] = "toString";
        stringArray[723] = "day";
        stringArray[724] = "toHours";
        stringArray[725] = "getDuration";
        stringArray[726] = "toHours";
        stringArray[727] = "getDuration";
        stringArray[728] = "value";
        stringArray[729] = "HOUR";
        stringArray[730] = "plus";
        stringArray[731] = "value";
        stringArray[732] = "HOUR";
        stringArray[733] = "toString";
        stringArray[734] = "hours";
        stringArray[735] = "toHours";
        stringArray[736] = "getDuration";
        stringArray[737] = "toMinutes";
        stringArray[738] = "getDuration";
        stringArray[739] = "toHours";
        stringArray[740] = "getDuration";
        stringArray[741] = "value";
        stringArray[742] = "MINUTE";
        stringArray[743] = "plus";
        stringArray[744] = "value";
        stringArray[745] = "MINUTE";
        stringArray[746] = "toString";
        stringArray[747] = "minutes";
        stringArray[748] = "generateCronExpression";
        stringArray[749] = "format";
        stringArray[750] = "getValueOrStar";
        stringArray[751] = "getValueOrStar";
        stringArray[752] = "getValueOrStar";
        stringArray[753] = "getValueOrStar";
        stringArray[754] = "format";
        stringArray[755] = "getLogger";
        stringArray[756] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[757];
        SaagieUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SaagieUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SaagieUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

