/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.plugin.dataops.utils;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.saagie.plugin.dataops.DataOpsExtension;
import io.saagie.plugin.dataops.models.Job;
import io.saagie.plugin.dataops.models.JobInstance;
import io.saagie.plugin.dataops.models.JobMapper;
import io.saagie.plugin.dataops.models.JobVersion;
import io.saagie.plugin.dataops.models.Pipeline;
import io.saagie.plugin.dataops.models.PipelineInstance;
import io.saagie.plugin.dataops.models.PipelineVersion;
import io.saagie.plugin.dataops.models.Project;
import io.saagie.plugin.dataops.models.Server;
import io.saagie.plugin.dataops.tasks.projects.enums.UnitTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.tika.Tika;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.threeten.extra.PeriodDuration;

public class SaagieUtils
implements GroovyObject {
    private static final Logger logger;
    private static final MediaType JSON;
    private DataOpsExtension configuration;
    private static Object handleErrorClosure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SaagieUtils(DataOpsExtension configuration) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DataOpsExtension dataOpsExtension = configuration;
        this.configuration = (DataOpsExtension)ScriptBytecodeAdapter.castToType((Object)dataOpsExtension, DataOpsExtension.class);
    }

    public static String gq(String request, String vars, String operationName) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[0].call((Object)logger, (Object)"GraphQL Query:");
        callSiteArray[1].call((Object)logger, (Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)vars)) {
            callSiteArray[2].call((Object)logger, (Object)"GraphQL Variables:");
            callSiteArray[3].call((Object)logger, (Object)vars);
        }
        Object inlinedRequest = callSiteArray[4].call((Object)request, (Object)"\\n", (Object)"");
        Object query = new GStringImpl(new Object[]{inlinedRequest}, new String[]{"{\"query\":\"", "\""});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vars, null)) {
            query = callSiteArray[5].call(query, (Object)new GStringImpl(new Object[]{vars}, new String[]{",\"variables\":", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)operationName)) {
            query = callSiteArray[6].call(query, (Object)new GStringImpl(new Object[]{operationName}, new String[]{",\"operationName\":\"", "\""}));
        }
        query = callSiteArray[7].call(query, (Object)"}");
        callSiteArray[8].call((Object)logger, (Object)"Generated graphql query:\n{}", query);
        return ShortTypeHandling.castToString((Object)query);
    }

    public Request getProjectsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[9].call((Object)logger, (Object)"Generating getProjectsRequest");
        Object listProjectsRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listProjectsRequest = object = callSiteArray[10].callStatic(SaagieUtils.class, (Object)"\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
            listProjectsRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, listProjectsRequest), Request.class);
    }

    public Request getProjectJobsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ");
    }

    public Request getProjectJobsGetNameAndIdRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ");
    }

    public Request getProjectPipelinesRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[15].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[16].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[20].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[21].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[22].callStatic(SaagieUtils.class, (Object)"\n            query pipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public static boolean isCollectionOrArray(Object object) {
        Reference object2 = new Reference(object);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _isCollectionOrArray_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference object;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isCollectionOrArray_closure1(Object _outerInstance, Object _thisObject, Reference object) {
                Reference reference;
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.object = reference = object;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it, callSiteArray[1].call(this.object.get()));
            }

            public Object getObject() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.object.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isCollectionOrArray_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isAssignableFrom";
                stringArray[1] = "getClass";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _isCollectionOrArray_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isCollectionOrArray_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isCollectionOrArray_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{Collection.class, Object[].class}), (Object)new _isCollectionOrArray_closure1(SaagieUtils.class, SaagieUtils.class, object2)));
    }

    public Request getListTechnologyVersionsRequest(String technologyId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[25].call((Object)logger, (Object)"Generating getListTechnologyVersionsRequest [technology={}]", (Object)technologyId);
        Object jsonGenerator = callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[29].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"technologyId", technologyId}));
        Object listTechnologyVersions = callSiteArray[30].callStatic(SaagieUtils.class, (Object)"\n            query TechnologiesVersions($technologyId: UUID!) {\n            technologiesVersions(technologyId: $technologyId) {\n              versionLabel\n              technologyLabel\n              secondaryTechnologies {\n                   label     isAvailable      versions\n              }\n            }\n          }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callCurrent((GroovyObject)this, listTechnologyVersions), Request.class);
    }

    public Request getProjectJobsRequestBuild(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[33].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[34].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[38].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[39].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[40].callStatic(SaagieUtils.class, (Object)query, gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request archiveProjectRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[43].call((Object)logger, (Object)"Generating archiveProjectRequest [ProjectId={}]", callSiteArray[44].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[48].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[49].callGroovyObjectGetProperty((Object)project)}));
        Object getProjectInstanceStatus = callSiteArray[50].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveProjectMutation($projectId: UUID!) {\n                archiveProject(projectId: $projectId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request getProjectTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[53].call((Object)logger, (Object)"generating getProjectTechnologiesRequest [projectId={}]", callSiteArray[54].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[58].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[59].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectTechnologies = callSiteArray[60].callStatic(SaagieUtils.class, (Object)"\n            query technologiesQuery($projectId: UUID!) {\n                technologies(projectId: $projectId) {\n                    id\n                    label\n                    isAvailable\n                    icon\n                    features {\n                        field\n                        label\n                        isMandatory\n                        comment\n                        defaultValue\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callCurrent((GroovyObject)this, listProjectTechnologies), Request.class);
    }

    public Request getPipelineRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[63].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[68].callGroovyObjectGetProperty((Object)server), callSiteArray[69].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[70].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static ArrayList getDifferenceOfTwoArrays(ArrayList collection1, ArrayList collection2) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call(callSiteArray[72].call((Object)collection1, (Object)collection2), callSiteArray[73].call((Object)collection2, (Object)collection1)), ArrayList.class);
    }

    public Request getPipelineInstancesRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[75].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        HttpUrl.Builder httpBuilder = (HttpUrl.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(callSiteArray[77].call(HttpUrl.class, (Object)new GStringImpl(new Object[]{callSiteArray[78].callGroovyObjectGetProperty((Object)server), callSiteArray[79].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", "/instance"}))), HttpUrl.Builder.class);
        callSiteArray[80].call((Object)httpBuilder, (Object)"page", (Object)"1");
        callSiteArray[81].call((Object)httpBuilder, (Object)"size", (Object)"10");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].callConstructor(Request.Builder.class), callSiteArray[85].call((Object)httpBuilder))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[86].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineInstanceDetailRequestFromParamV1(String pipelineId, String instanceId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[88].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].call(callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[93].callGroovyObjectGetProperty((Object)server), callSiteArray[94].callGroovyObjectGetProperty((Object)server), pipelineId, instanceId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", "/instance/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[95].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineRequestFromParam(Object pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[97].call((Object)logger, (Object)"generating getPipelineRequest [projectId={}]", callSiteArray[98].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[102].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", pipelineId}));
        Object pipelineResult = callSiteArray[103].callStatic(SaagieUtils.class, (Object)"\n            query pipeline ($pipelineId: UUID!) {\n                pipeline(id: $pipelineId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].callCurrent((GroovyObject)this, pipelineResult), Request.class);
    }

    @Deprecated
    public Request getProjectCreateJobRequest(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[106].callGetProperty(callSiteArray[107].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[108].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object jsonGenerator = callSiteArray[109].call(callSiteArray[110].call(callSiteArray[111].call(callSiteArray[112].callConstructor(JsonGenerator.Options.class)), (Object)"usePreviousArtifact"));
        Object gqVariables = callSiteArray[113].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[114].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[115].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object createProjectJob = callSiteArray[116].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!) {\n                createJob(job: $job, jobVersion: $jobVersion) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectCreateJobRequestWithGraphQL(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[119].callGetProperty(callSiteArray[120].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[121].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Reference file = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[122].callConstructor(File.class, callSiteArray[123].callGetProperty(callSiteArray[124].callGroovyObjectGetProperty((Object)jobVersion))), File.class)));
        callSiteArray[125].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[126].callGetProperty((Object)((File)file.get())));
        public final class _getProjectCreateJobRequestWithGraphQL_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getProjectCreateJobRequestWithGraphQL_closure2(Object _outerInstance, Object _thisObject, Reference file) {
                Reference reference;
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.file = reference = file;
            }

            public Object doCall(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(this.file.get());
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)value), (String)"name");
                return value;
            }

            public Object call(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value);
            }

            public File getFile() {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProjectCreateJobRequestWithGraphQL_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "packageInfo";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProjectCreateJobRequestWithGraphQL_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jsonGenerator = callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].call(callSiteArray[130].callConstructor(JsonGenerator.Options.class)), JobVersion.class, (Object)new _getProjectCreateJobRequestWithGraphQL_closure2(this, this, file)));
        Object gqVariables = callSiteArray[131].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[132].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[133].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object object = callSiteArray[134].callGetProperty((Object)((File)file.get()));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[135].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[136].call(callSiteArray[137].call(callSiteArray[138].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object createProjectJob = callSiteArray[139].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!, $file: Upload) {\n                createJob(job: $job, jobVersion: $jobVersion, file: $file) {\n                    id\n                    name\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].callCurrent((GroovyObject)this, createProjectJob, (Object)job, (Object)jobVersion), Request.class);
    }

    public Request getProjectUpdateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].call(JobMapper.class, (Object)job, callSiteArray[143].callGetProperty(callSiteArray[144].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[145].call((Object)logger, (Object)"Generating getProjectUpdateJobRequest [job={}]", (Object)mappedJob);
        Object jsonGenerator = callSiteArray[146].call(callSiteArray[147].call(callSiteArray[148].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[149].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", mappedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].call(JobMapper.class, (Object)job, callSiteArray[153].callGetProperty(callSiteArray[154].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callCurrent((GroovyObject)this, callSiteArray[156].callGetProperty((Object)mappedJob)), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequestFromParams(Object job) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].callConstructor(JsonGenerator.Options.class)));
        Map formattedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[160].callStatic(SaagieUtils.class, job), Map.class);
        Object gqVariables = callSiteArray[161].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", formattedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobRequestFormat(String gqVariables) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object updateProjectJob = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            updateProjectJob = object = callSiteArray[163].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", (Object)gqVariables);
        } else {
            String string = SaagieUtils.gq("\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", gqVariables);
            updateProjectJob = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getAddJobVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[167].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[168].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[169].call(callSiteArray[170].call(callSiteArray[171].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[172].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[173].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[174].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[175].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[176].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public static Map getFormatForUpdateJob(Map data) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set set = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].callConstructor(HashSet.class), Set.class);
        callSiteArray[178].call((Object)set, (Object)"projectId");
        callSiteArray[179].call((Object)set, (Object)"category");
        callSiteArray[180].call((Object)set, (Object)"technology");
        callSiteArray[181].call(callSiteArray[182].call((Object)data), (Object)set);
        return data;
    }

    public Request getAddJobVersionRequestWithGraphQL(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[183].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[184].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object file = callSiteArray[185].callConstructor(File.class, callSiteArray[186].callGetProperty(callSiteArray[187].callGroovyObjectGetProperty((Object)jobVersion)));
        callSiteArray[188].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[189].callGetProperty(file));
        Object jsonGenerator = callSiteArray[190].call(callSiteArray[191].call(callSiteArray[192].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[193].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[194].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[195].call((Object)jobVersion)}));
        Object object = callSiteArray[196].callGetProperty(file);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[197].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[198].call(callSiteArray[199].call(callSiteArray[200].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object updateProjectJob = callSiteArray[201].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!, $file: Upload) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion, file: $file) {\n                    number\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callCurrent((GroovyObject)this, updateProjectJob, (Object)job, (Object)jobVersion), Request.class);
    }

    public Request getAddJobVersionRequestWithoutFile(Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[203].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[204].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGeneratorParams = callSiteArray[205].call(callSiteArray[206].call(callSiteArray[207].callConstructor(JsonGenerator.Options.class)), (Object)"packageInfo");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[208].callGetPropertySafe(callSiteArray[209].callGroovyObjectGetProperty((Object)jobVersion)))) {
            Object object;
            jsonGeneratorParams = object = callSiteArray[210].call(jsonGeneratorParams, (Object)"usePreviousArtifact");
        }
        Object jsonGenerator = callSiteArray[211].call(jsonGeneratorParams);
        Object gqVariables = callSiteArray[212].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[213].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[214].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[215].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[216].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getUploadFileToJobRequest(String jobId, String jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[217].call((Object)logger, (Object)"Generating getUploadFileToJobRequest [jobId={}, jobVersion={}]", (Object)jobId, (Object)jobVersion);
        Object file = callSiteArray[218].callConstructor(File.class, callSiteArray[219].callGetProperty(callSiteArray[220].callGetProperty(callSiteArray[221].callGroovyObjectGetProperty((Object)this.configuration))));
        Tika tika = (Tika)ScriptBytecodeAdapter.castToType((Object)callSiteArray[222].callConstructor(Tika.class), Tika.class);
        String fileMimeType = ShortTypeHandling.castToString((Object)callSiteArray[223].call((Object)tika, file));
        callSiteArray[224].call((Object)logger, (Object)"Detected file mime type: ", (Object)fileMimeType);
        Object fileType = callSiteArray[225].call(MediaType.class, (Object)fileMimeType);
        callSiteArray[226].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[227].callGetProperty(file));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[228].call(callSiteArray[229].call(callSiteArray[230].call(callSiteArray[231].callConstructor(MultipartBody.Builder.class), callSiteArray[232].callGetProperty(MultipartBody.class)), (Object)"files", callSiteArray[233].callGetProperty(file), callSiteArray[234].call(RequestBody.class, file, fileType))), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[235].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[236].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[237].call((Object)logger, (Object)"Building upload file request with jwt auth...");
            Object realm = callSiteArray[238].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[239].callGroovyObjectGetProperty((Object)server);
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[240].call(callSiteArray[241].call(callSiteArray[242].call(callSiteArray[243].call(callSiteArray[244].call(callSiteArray[245].call(callSiteArray[246].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[247].callGetProperty(callSiteArray[248].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[249].callGetProperty(callSiteArray[250].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[251].callGetProperty(callSiteArray[252].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/projects/api/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        callSiteArray[253].call((Object)logger, (Object)"Building upload file request with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[254].call(callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].call(callSiteArray[258].call(callSiteArray[259].call(callSiteArray[260].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[261].callGetProperty(callSiteArray[262].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[263].callGetProperty(callSiteArray[264].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[265].callGetProperty(callSiteArray[266].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", callSiteArray[267].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[268].call(callSiteArray[269].call(callSiteArray[270].call(callSiteArray[271].call(callSiteArray[272].call(callSiteArray[273].call(callSiteArray[274].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[275].callGetProperty(callSiteArray[276].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[277].callGetProperty(callSiteArray[278].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[279].callGetProperty(callSiteArray[280].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
    }

    public Request getRunProjectJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[281].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[282].call((Object)logger, (Object)"Generating getRunProjectJobRequest for job [id={}]", callSiteArray[283].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[284].call(callSiteArray[285].call(callSiteArray[286].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[287].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[288].callGroovyObjectGetProperty((Object)job)}));
        Object runProjectJobRequest = callSiteArray[289].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($jobId: UUID!) {\n                runJob(jobId: $jobId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[290].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public static Object cleanDirectory(File temp, Logger logger) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object object = callSiteArray[291].call((Object)temp);
        try {
            return object;
        }
        catch (Exception exception) {
            callSiteArray[292].call((Object)logger, (Object)"The directory couldn't be cleaned");
            Object object2 = callSiteArray[293].call((Object)logger, callSiteArray[294].callGetProperty((Object)exception));
            return object2;
        }
    }

    public Request getCreatePipelineRequest(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[295].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[296].call((Object)logger, (Object)"Generating getCreatePipelineRequest for project [projectId={}, pipeline={}, pipelineVersion={}]", callSiteArray[297].callGroovyObjectGetProperty((Object)project), (Object)pipeline, (Object)pipelineVersion);
        Object jsonGenerator = callSiteArray[298].call(callSiteArray[299].call(callSiteArray[300].callConstructor(JsonGenerator.Options.class)));
        Map graphqlPipelineVar = ScriptBytecodeAdapter.createMap((Object[])new Object[]{ScriptBytecodeAdapter.spreadMap((Object)callSiteArray[301].call((Object)pipeline)), callSiteArray[302].call((Object)pipeline), "projectId", callSiteArray[303].callGroovyObjectGetProperty((Object)project), "jobsId", callSiteArray[304].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[305].callGroovyObjectGetProperty((Object)pipelineVersion)});
        Object gqVariables = callSiteArray[306].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", graphqlPipelineVar}));
        Object runProjectJobRequest = callSiteArray[307].callStatic(SaagieUtils.class, (Object)"\n            mutation createPipelineMutation($pipeline: PipelineInput!) {\n                createPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[308].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getProjectJobInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[309].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[310].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[311].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[312].call(callSiteArray[313].call(callSiteArray[314].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[315].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[316].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object getJobInstanceStatus = callSiteArray[317].callStatic(SaagieUtils.class, (Object)"\n            query getJobInstanceStatus($jobId: UUID!) {\n                jobInstance(id: $jobId) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[318].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[319].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[320].call((Object)logger, (Object)"Generating getProjectPipelineInstanceStatusRequest [pipelineInstanceId={}]", callSiteArray[321].callGroovyObjectGetProperty((Object)pipelineinstance));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[322].callCurrent((GroovyObject)this, callSiteArray[323].callGroovyObjectGetProperty((Object)pipelineinstance)), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequestWithparam(String id) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[327].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", id}));
        Object getPipelineInstanceStatus = callSiteArray[328].callStatic(SaagieUtils.class, (Object)"\n            query getPipelineInstanceStatus($id: UUID!) {\n                pipelineInstance(id: $id) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[329].callCurrent((GroovyObject)this, getPipelineInstanceStatus), Request.class);
    }

    public Request getProjectUpdatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[330].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[331].call((Object)logger, (Object)"Generating getProjectUpdatePipelineRequest [pipelineId={}]", callSiteArray[332].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[333].call(callSiteArray[334].call(callSiteArray[335].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[336].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", callSiteArray[337].call((Object)pipeline)}));
        Object editPipeline = callSiteArray[338].callStatic(SaagieUtils.class, (Object)"\n            mutation editPipelineMutation($pipeline: PipelineEditionInput!) {\n                editPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[339].callCurrent((GroovyObject)this, editPipeline), Request.class);
    }

    public Request getAddPipelineVersionRequest(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[340].callCurrent((GroovyObject)this, (Object)pipeline, (Object)pipelineVersion), Request.class);
    }

    public Request getAddPipelineVersionRequestFromParams(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[341].call((Object)logger, (Object)"Generating getAddPipelineVersionRequest [pipelineId={}]", callSiteArray[342].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[343].call(callSiteArray[344].call(callSiteArray[345].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[346].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[347].callGroovyObjectGetProperty((Object)pipeline), "jobsId", callSiteArray[348].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[349].callGroovyObjectGetProperty((Object)pipelineVersion)}));
        Object addPipelineVersionRequest = callSiteArray[350].callStatic(SaagieUtils.class, (Object)"\n            mutation addPipelineVersionMutation(\n                $pipelineId: UUID!,\n                $jobsId: [UUID!]!,\n                $releaseNote: String,\n            ) {\n                addPipelineVersion(\n                    pipelineId: $pipelineId,\n                    jobsId: $jobsId,\n                    releaseNote: $releaseNote\n                ) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[351].callCurrent((GroovyObject)this, addPipelineVersionRequest), Request.class);
    }

    public Request getProjectRunPipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[352].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[353].call((Object)logger, (Object)"Generating getProjectRunPipelineRequest [pipelineId={}]", callSiteArray[354].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[355].call(callSiteArray[356].call(callSiteArray[357].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[358].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[359].callGroovyObjectGetProperty((Object)pipeline)}));
        Object runPipeline = callSiteArray[360].callStatic(SaagieUtils.class, (Object)"\n            mutation runPipelineMutation($pipelineId: UUID!) {\n                runPipeline(pipelineId: $pipelineId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[361].callCurrent((GroovyObject)this, runPipeline), Request.class);
    }

    public Request getProjectDeletePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[362].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[363].call((Object)logger, (Object)"Generating getProjectDeletePipelineRequest [pipelineId={}]", callSiteArray[364].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[365].call(callSiteArray[366].call(callSiteArray[367].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[368].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[369].callGroovyObjectGetProperty((Object)pipeline)}));
        Object deletePipeline = callSiteArray[370].callStatic(SaagieUtils.class, (Object)"\n            mutation deletePipelineMutation($id: UUID!) {\n                deletePipeline(id: $id)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[371].callCurrent((GroovyObject)this, deletePipeline), Request.class);
    }

    public Request getProjectArchiveJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[372].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[373].call((Object)logger, (Object)"Generating getProjectDeleteJobRequest [jobId={}]", callSiteArray[374].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[375].call(callSiteArray[376].call(callSiteArray[377].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[378].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[379].callGroovyObjectGetProperty((Object)job)}));
        Object getJobInstanceStatus = callSiteArray[380].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveJobMutation($jobId: UUID!) {\n                archiveJob(jobId: $jobId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[381].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectStopPipelineInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[382].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[383].call((Object)logger, (Object)"Generating getProjectStopPipelineInstanceRequest [pipelineinstanceId={}]", callSiteArray[384].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[385].call(callSiteArray[386].call(callSiteArray[387].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[388].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineInstanceId", callSiteArray[389].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getJobInstanceStatus = callSiteArray[390].callStatic(SaagieUtils.class, (Object)"\n            mutation stopPipelineInstanceMutation($pipelineInstanceId: UUID!) {\n                stopPipelineInstance(pipelineInstanceId: $pipelineInstanceId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[391].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getJwtTokenRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[392].call((Object)logger, (Object)"Requesting JWT...");
        Request newRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[393].call(callSiteArray[394].call(callSiteArray[395].call(callSiteArray[396].call(callSiteArray[397].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[398].callGetProperty(callSiteArray[399].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", callSiteArray[400].callCurrent((GroovyObject)this))));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[401].call(callSiteArray[402].call(callSiteArray[403].call(callSiteArray[404].call(callSiteArray[405].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[406].callGetProperty(callSiteArray[407].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", (Object)this.getCredentials())));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[408].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getStopJobInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[409].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[410].call((Object)logger, (Object)"Generating getStopJobInstanceRequest for job instance [id={}]", callSiteArray[411].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[412].call(callSiteArray[413].call(callSiteArray[414].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[415].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobInstanceId", callSiteArray[416].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object runProjectJobRequest = callSiteArray[417].callStatic(SaagieUtils.class, (Object)"\n            mutation stopJobMutation($jobInstanceId: UUID!) {\n                stopJobInstance(jobInstanceId: $jobInstanceId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[418].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    private boolean checkIfStringIsJson(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[419].call(JsonOutput.class, (Object)query);
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
            boolean bl2 = false;
            return bl2;
        }
    }

    private Request buildMultipartRequestFromQuery(String query, Job job, JobVersion jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[420].call((Object)logger, (Object)"Generating multipart request from query=\"{}\"", (Object)query);
        Object file = callSiteArray[421].callConstructor(File.class, callSiteArray[422].callGetProperty(callSiteArray[423].callGroovyObjectGetProperty((Object)jobVersion)));
        Object fileName = callSiteArray[424].callGetProperty(file);
        callSiteArray[425].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[426].callGetProperty(file));
        Object jsonGenerator = callSiteArray[427].call(callSiteArray[428].call(callSiteArray[429].callConstructor(JsonGenerator.Options.class)));
        Object map = callSiteArray[430].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"0", ScriptBytecodeAdapter.createList((Object[])new Object[]{"variables.file"})}));
        Object fileBody = callSiteArray[431].call(RequestBody.class, file, callSiteArray[432].call(MediaType.class, (Object)"application/octet-stream"));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[433].call(callSiteArray[434].call(callSiteArray[435].call(callSiteArray[436].call(callSiteArray[437].call(callSiteArray[438].callConstructor(MultipartBody.Builder.class, (Object)"--graphql-multipart-upload-boundary-85763456--"), callSiteArray[439].callGetProperty(MultipartBody.class)), (Object)"operations", null, callSiteArray[440].call(RequestBody.class, (Object)query, (Object)JSON)), (Object)"map", null, callSiteArray[441].call(RequestBody.class, map, (Object)JSON)), (Object)"0", fileName, fileBody)), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[442].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[443].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[444].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[445].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[446].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[447].call(callSiteArray[448].call(callSiteArray[449].call(callSiteArray[450].call(callSiteArray[451].call(callSiteArray[452].call(callSiteArray[453].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[454].callGetProperty(callSiteArray[455].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[456].callGetProperty(callSiteArray[457].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[458].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[459].call(callSiteArray[460].call(callSiteArray[461].call(callSiteArray[462].call(callSiteArray[463].call(callSiteArray[464].call(callSiteArray[465].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[466].callGetProperty(callSiteArray[467].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[468].callGetProperty(callSiteArray[469].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[470].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[471].call(callSiteArray[472].call(callSiteArray[473].call(callSiteArray[474].call(callSiteArray[475].call(callSiteArray[476].call(callSiteArray[477].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[478].callGetProperty(callSiteArray[479].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[480].callGetProperty(callSiteArray[481].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[482].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPlatformListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[483].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[484].call((Object)logger, (Object)"Generating request in order to get access rights by platforms");
        String realm = ShortTypeHandling.castToString((Object)callSiteArray[485].callGroovyObjectGetProperty((Object)server));
        String jwtToken = ShortTypeHandling.castToString((Object)callSiteArray[486].callGroovyObjectGetProperty((Object)server));
        callSiteArray[487].call((Object)logger, (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"Using realm=", " and jwt=", ""}));
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[488].call(callSiteArray[489].call(callSiteArray[490].call(callSiteArray[491].call(callSiteArray[492].call(callSiteArray[493].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[494].callGetProperty(callSiteArray[495].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[496].callGetProperty(callSiteArray[497].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/security/api/groups/authorizations/", "/permissions/projects"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{callSiteArray[498].call((Object)realm), jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Saagie-Realm", callSiteArray[499].call((Object)realm)))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[500].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getListAllPipelinesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[501].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[502].call((Object)logger, (Object)"Generating getListAllPipelinesRequest for project [id={}]", callSiteArray[503].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[504].call(callSiteArray[505].call(callSiteArray[506].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[507].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[508].callGroovyObjectGetProperty((Object)project)}));
        Object listAllPipelineRequest = callSiteArray[509].callStatic(SaagieUtils.class, (Object)"\n            query getAllPipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[510].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getListAllTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[511].call((Object)logger, (Object)"Generating getListAllTechnologiesRequest");
        Object listAllPipelineRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listAllPipelineRequest = object = callSiteArray[512].callStatic(SaagieUtils.class, (Object)"\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
            listAllPipelineRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getGroupListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[514].callCurrent((GroovyObject)this), Request.class);
        }
        return this.getPlatformListRequest();
    }

    public Request getProjectsCreateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[515].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[516].call((Object)logger, (Object)"Generating getProjectsCreateRequest for creating a new project [name={}]", callSiteArray[517].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[518].call(callSiteArray[519].call(callSiteArray[520].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[521].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[522].call((Object)project)}));
        Object createProjectRequest = callSiteArray[523].callStatic(SaagieUtils.class, (Object)"\n            mutation createProjectMutation($project: ProjectInput!) {\n                createProject(project: $project) {\n                    id\n                    name\n                    description\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[524].callCurrent((GroovyObject)this, createProjectRequest), Request.class);
    }

    public Request getJobDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[525].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[526].callCurrent((GroovyObject)this, callSiteArray[527].callGroovyObjectGetProperty((Object)job)), Request.class);
    }

    public Request getJobDetailRequestFromParam(Object jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[528].call((Object)logger, (Object)"Generating getJobDetailRequest for getting job detail [id={}]", jobId);
        Object jsonGenerator = callSiteArray[529].call(callSiteArray[530].call(callSiteArray[531].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[532].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object getJobDetailRequest = callSiteArray[533].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        runtimeVersion\n                        packageInfo {\n                            downloadUrl\n                        }\n                        dockerInfo {\n                            image\n                            dockerCredentialsId\n                        }\n                        commandLine\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[534].callCurrent((GroovyObject)this, getJobDetailRequest), Request.class);
    }

    public Request getJobDetailRequestFromParamV1(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[535].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[536].call((Object)logger, (Object)"Generating request in order to get job detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[537].call(callSiteArray[538].call(callSiteArray[539].call(callSiteArray[540].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[541].callGroovyObjectGetProperty((Object)server), callSiteArray[542].callGroovyObjectGetProperty((Object)server), jobId}, new String[]{"", "/manager/api/v1/platform/", "/job/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[543].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getJobVersionDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[544].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[545].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[546].call((Object)logger, (Object)"Getting jobVersion for job  [id={}] with project Id [id={}]", callSiteArray[547].callGroovyObjectGetProperty((Object)project), callSiteArray[548].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[549].call(callSiteArray[550].call(callSiteArray[551].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[552].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[553].callGroovyObjectGetProperty((Object)job), "number", 1}));
        Object getJobVersionRequest = callSiteArray[554].callStatic(SaagieUtils.class, (Object)"\n            query jobVersion($jobId: UUID!, $number: Int!) {\n                jobVersion(jobId: $jobId, number: $number) {\n                    commandLine\n                    dockerInfo {\n                        image\n                        dockerCredentialsId\n                    }\n                    releaseNote\n                    runtimeVersion\n                    packageInfo {\n                        name\n                        downloadUrl\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[555].callCurrent((GroovyObject)this, getJobVersionRequest), Request.class);
    }

    public Request getProjectsUpdateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[556].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[557].call((Object)logger, (Object)"Generating getProjectsUpdateRequest for updating a new project [id={}]", callSiteArray[558].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[559].call(callSiteArray[560].call(callSiteArray[561].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[562].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[563].call((Object)project)}));
        Object updateProjectRequest = callSiteArray[564].callStatic(SaagieUtils.class, (Object)"\n            mutation editProjectMutation($project: ProjectEditionInput!) {\n                editProject(project: $project) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[565].callCurrent((GroovyObject)this, updateProjectRequest), Request.class);
    }

    public Request getListVersionForJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[566].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[567].call((Object)logger, (Object)"Generating getListVersionForJobRequest for getting list a new job [id={}]", (Object)jobId);
        Object jsonGenerator = callSiteArray[568].call(callSiteArray[569].call(callSiteArray[570].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[571].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object listVersionForAJobRequest = callSiteArray[572].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    versions {\n                        number\n                        isCurrent\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[573].callCurrent((GroovyObject)this, listVersionForAJobRequest), Request.class);
    }

    private Request buildRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[574].call((Object)logger, (Object)"Generating request from query=\"{}\"", (Object)query);
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[575].call(RequestBody.class, (Object)query, (Object)JSON), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[576].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[577].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[578].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[579].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[580].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[581].call(callSiteArray[582].call(callSiteArray[583].call(callSiteArray[584].call(callSiteArray[585].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[586].callGetProperty(callSiteArray[587].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[588].callGetProperty(callSiteArray[589].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[590].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[591].call(callSiteArray[592].call(callSiteArray[593].call(callSiteArray[594].call(callSiteArray[595].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[596].callGetProperty(callSiteArray[597].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[598].callGetProperty(callSiteArray[599].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[600].callCurrent((GroovyObject)this)), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[601].call(callSiteArray[602].call(callSiteArray[603].call(callSiteArray[604].call(callSiteArray[605].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[606].callGetProperty(callSiteArray[607].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[608].callGetProperty(callSiteArray[609].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[610].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public void downloadFromHTTPSServer(String urlFrom, String to, OkHttpClient client, Object name) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            callSiteArray[611].call((Object)logger, (Object)"Downloading artifiacts ....");
            Request request = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[612].callCurrent((GroovyObject)this, (Object)urlFrom);
                request = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Request request2;
                request = request2 = this.buildRequestForFile(urlFrom);
            }
            Object response = callSiteArray[613].call(callSiteArray[614].call((Object)client, (Object)request));
            Object object = callSiteArray[615].call(callSiteArray[616].call(response));
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
            Object object2 = callSiteArray[617].callConstructor(FileOutputStream.class, callSiteArray[618].callConstructor(File.class, callSiteArray[619].call(callSiteArray[620].call((Object)to, (Object)"/"), name)));
            outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)object2, OutputStream.class);
            byte[] buffer = new byte[2048];
            int length = 0;
            int downloaded = 0;
            while (true) {
                Object object3 = callSiteArray[621].call((Object)inputStream, (Object)buffer);
                length = DefaultTypeTransformation.intUnbox((Object)object3);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)object3, (Object)-1)) {
                    callSiteArray[622].call((Object)outputStream, (Object)buffer, (Object)0, (Object)length);
                    downloaded = DefaultTypeTransformation.intUnbox((Object)callSiteArray[623].call((Object)downloaded, (Object)length));
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw (Throwable)callSiteArray[624].callConstructor(GradleException.class, callSiteArray[625].callGetProperty((Object)ex));
        }
        callSiteArray[626].call((Object)logger, (Object)"Artifacts downloaded.");
        callSiteArray[627].call((Object)outputStream);
        callSiteArray[628].call((Object)inputStream);
    }

    public Request buildRequestForFile(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[629].call((Object)logger, (Object)"Generating request for url=\"{}\"", (Object)url);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[630].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        callSiteArray[631].call((Object)logger, (Object)"Fetching file with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[632].call(callSiteArray[633].call(callSiteArray[634].call(callSiteArray[635].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", callSiteArray[636].callCurrent((GroovyObject)this)));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[637].call(callSiteArray[638].call(callSiteArray[639].call(callSiteArray[640].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", (Object)this.getCredentials()));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[641].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static String getFileNameFromUrl(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)url) ? callSiteArray[642].call((Object)url, callSiteArray[643].call(callSiteArray[644].call((Object)url, (Object)"/"), (Object)1), callSiteArray[645].call((Object)url)) : null);
    }

    public static Object removeLastSlash(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[646].call((Object)url, (Object)"/"))) {
            Object object = callSiteArray[647].call((Object)url, (Object)0, callSiteArray[648].call(callSiteArray[649].call((Object)url), (Object)1));
            url = ShortTypeHandling.castToString((Object)object);
        }
        return url;
    }

    private String getCredentials() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[650].call(Credentials.class, callSiteArray[651].callGetProperty(callSiteArray[652].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[653].callGetProperty(callSiteArray[654].callGroovyObjectGetProperty((Object)this.configuration))));
    }

    public static Map extractProperties(Object obj) {
        Reference obj2 = new Reference(obj);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _extractProperties_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "synthetic";
                return new CallSiteArray(_extractProperties_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _extractProperties_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference obj;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure4(Object _outerInstance, Object _thisObject, Reference obj) {
                Reference reference;
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.obj = reference = obj;
            }

            public Object doCall(Object field) {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(field), callSiteArray[1].call(this.obj.get(), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(field)}, new String[]{"", ""}))});
            }

            public Object getObj() {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return this.obj.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getAt";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _extractProperties_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractProperties_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[655].call(callSiteArray[656].call(callSiteArray[657].callGetProperty(callSiteArray[658].call(obj2.get())), (Object)new _extractProperties_closure3(SaagieUtils.class, SaagieUtils.class)), (Object)new _extractProperties_closure4(SaagieUtils.class, SaagieUtils.class, obj2)), Map.class);
    }

    public static boolean distinctValues(int ... arr) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set foundNumbers = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[659].callConstructor(HashSet.class), Set.class);
        String num = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[660].call((Object)arr), Iterator.class);
        while (iterator.hasNext()) {
            num = ShortTypeHandling.castToString(iterator.next());
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[661].call((Object)foundNumbers, (Object)num))) {
                return false;
            }
            callSiteArray[662].call((Object)foundNumbers, (Object)num);
        }
        return true;
    }

    public static Object debugRequest(Request request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[663].call((Object)logger, (Object)"====== Request ======");
        callSiteArray[664].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[665].callGetProperty((Object)((Request)request2.get())), callSiteArray[666].callGetProperty(callSiteArray[667].call(callSiteArray[668].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"", " ", ""}));
        callSiteArray[669].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[670].callGetProperty(callSiteArray[671].call(callSiteArray[672].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"Host: ", ""}));
        public final class _debugRequest_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugRequest_closure5(Object _outerInstance, Object _thisObject, Reference request) {
                Reference reference;
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference = request;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.request.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Request getRequest() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return (Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), Request.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugRequest_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugRequest_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugRequest_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugRequest_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[673].call(callSiteArray[674].call(callSiteArray[675].call((Object)((Request)request2.get()))), (Object)new _debugRequest_closure5(SaagieUtils.class, SaagieUtils.class, request2));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[676].call((Object)((Request)request2.get())))) {
            callSiteArray[677].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[678].call(callSiteArray[679].call((Object)((Request)request2.get())))}, new String[]{"Content-Length: ", ""}));
            Buffer buffer = (Buffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[680].callConstructor(Buffer.class), Buffer.class);
            callSiteArray[681].call(callSiteArray[682].call((Object)((Request)request2.get())), (Object)buffer);
            return callSiteArray[683].call((Object)logger, callSiteArray[684].call((Object)buffer));
        }
        return null;
    }

    public static Object debugResponse(Response response) {
        Reference response2 = new Reference((Object)response);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[685].call((Object)logger, (Object)"====== Response ======");
        callSiteArray[686].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[687].call(callSiteArray[688].call((Object)((Response)response2.get()))), callSiteArray[689].callGetProperty((Object)((Response)response2.get())), callSiteArray[690].callGetProperty((Object)((Response)response2.get()))}, new String[]{"", " ", " ", ""}));
        public final class _debugResponse_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugResponse_closure6(Object _outerInstance, Object _thisObject, Reference response) {
                Reference reference;
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.response.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Response getResponse() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return (Response)ScriptBytecodeAdapter.castToType((Object)this.response.get(), Response.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugResponse_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugResponse_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugResponse_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugResponse_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[691].call(callSiteArray[692].call(callSiteArray[693].call((Object)((Response)response2.get()))), (Object)new _debugResponse_closure6(SaagieUtils.class, SaagieUtils.class, response2));
    }

    public static Object throwAndLogError(Object l, Object message) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[694].call(l, message);
        throw (Throwable)callSiteArray[695].callConstructor(GradleException.class, message);
    }

    public static String convertScheduleV1ToCron(String cronString) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)cronString)) {
            return ShortTypeHandling.castToString(null);
        }
        int startPeriod = DefaultTypeTransformation.intUnbox((Object)callSiteArray[696].call((Object)cronString, (Object)"/", callSiteArray[697].call(callSiteArray[698].call((Object)cronString, (Object)"/"), (Object)1)));
        if (!(startPeriod != 0)) {
            callSiteArray[699].callStatic(SaagieUtils.class, (Object)"Can't parse cronString, couldn t find '/'");
        }
        String startDate = ShortTypeHandling.castToString((Object)callSiteArray[700].call((Object)cronString, callSiteArray[701].call(callSiteArray[702].call((Object)cronString, (Object)"/"), (Object)1), (Object)startPeriod));
        String cronPeriod = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[703].call((Object)cronString, callSiteArray[704].call((Object)startPeriod, (Object)1), callSiteArray[705].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[706].call((Object)cronString, (Object)(startPeriod + 1), callSiteArray[707].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        }
        Date cronDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[708].call(Date.class, callSiteArray[709].call(callSiteArray[710].call(ZonedDateTime.class, (Object)startDate, callSiteArray[711].call(callSiteArray[712].callGetProperty(DateTimeFormatter.class), callSiteArray[713].callGetProperty(ZoneOffset.class))))), Date.class);
        PeriodDuration period = (PeriodDuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[714].call(PeriodDuration.class, (Object)cronPeriod), PeriodDuration.class);
        Object minutes = null;
        Object hours = null;
        Object dayOfMonths = null;
        Object months = null;
        Object time = callSiteArray[715].callGetProperty(callSiteArray[716].callGetProperty(UnitTime.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[717].callGetProperty(callSiteArray[718].call((Object)period)))) {
            Object object;
            Object object2;
            time = object2 = callSiteArray[719].callGetProperty(callSiteArray[720].callGetProperty(UnitTime.class));
            months = object = callSiteArray[721].call((Object)"*/", callSiteArray[722].callGetProperty(callSiteArray[723].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[724].callGetProperty(callSiteArray[725].callGetProperty(UnitTime.class)))) {
            Object object;
            months = object = callSiteArray[726].call(callSiteArray[727].callGetProperty((Object)cronDate));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[728].callGetProperty(callSiteArray[729].call((Object)period)))) {
            Object object;
            Object object3;
            time = object3 = callSiteArray[730].callGetProperty(callSiteArray[731].callGetProperty(UnitTime.class));
            dayOfMonths = object = callSiteArray[732].call((Object)"*/", callSiteArray[733].callGetProperty(callSiteArray[734].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[735].callGetProperty(callSiteArray[736].callGetProperty(UnitTime.class)))) {
            Object object;
            dayOfMonths = object = callSiteArray[737].call(callSiteArray[738].callGetProperty((Object)cronDate));
        }
        Object hoursTest = callSiteArray[739].call(callSiteArray[740].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[741].call(callSiteArray[742].call((Object)period)))) {
            Object object;
            Object object4;
            time = object4 = callSiteArray[743].callGetProperty(callSiteArray[744].callGetProperty(UnitTime.class));
            hours = object = callSiteArray[745].call((Object)"*/", hoursTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[746].callGetProperty(callSiteArray[747].callGetProperty(UnitTime.class)))) {
            Object object;
            hours = object = callSiteArray[748].call(callSiteArray[749].callGetProperty((Object)cronDate));
        }
        Object minutesTest = callSiteArray[750].call(callSiteArray[751].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[752].call(callSiteArray[753].call((Object)period))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[754].call(callSiteArray[755].call((Object)period)))) {
            Object object;
            Object object5;
            time = object5 = callSiteArray[756].callGetProperty(callSiteArray[757].callGetProperty(UnitTime.class));
            minutes = object = callSiteArray[758].call((Object)"* / ", minutesTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[759].callGetProperty(callSiteArray[760].callGetProperty(UnitTime.class)))) {
            Object object;
            minutes = object = callSiteArray[761].call(callSiteArray[762].callGetProperty((Object)cronDate));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[763].callStatic(SaagieUtils.class, minutes, hours, dayOfMonths, months));
    }

    public static String generateCronExpression(String minutes, String hours, String dayOfMonth, String month) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[764].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)callSiteArray[765].callStatic(SaagieUtils.class, (Object)minutes), (Object)callSiteArray[766].callStatic(SaagieUtils.class, (Object)hours), (Object)callSiteArray[767].callStatic(SaagieUtils.class, (Object)dayOfMonth), (Object)callSiteArray[768].callStatic(SaagieUtils.class, (Object)month), (Object)"*")));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[769].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)SaagieUtils.getValueOrStar(minutes), (Object)SaagieUtils.getValueOrStar(hours), (Object)SaagieUtils.getValueOrStar(dayOfMonth), (Object)SaagieUtils.getValueOrStar(month), (Object)"*")));
    }

    private static Object getValueOrStar(String value) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? value : "*";
    }

    @Generated
    public static String gq(String request, String vars) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, vars, null);
        }
        return SaagieUtils.gq(request, vars, null);
    }

    @Generated
    public static String gq(String request) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, null, null);
        }
        return SaagieUtils.gq(request, null, null);
    }

    @Deprecated
    @Generated
    public Request getUploadFileToJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getUploadFileToJobRequest(jobId, "1");
        }
        return this.getUploadFileToJobRequest(jobId, "1");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaagieUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SaagieUtils.$getCallSiteArray()[770].call(Logging.class, SaagieUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = SaagieUtils.$getCallSiteArray()[771].call(MediaType.class, (Object)"application/json; charset=utf-8");
        JSON = (MediaType)ScriptBytecodeAdapter.castToType((Object)object2, MediaType.class);
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                callSiteArray[0].call((Object)l, (Object)"Checking server response");
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(response))) {
                    callSiteArray[2].call((Object)l, (Object)"No error in server response.");
                    return null;
                }
                String body = ShortTypeHandling.castToString((Object)callSiteArray[3].call(callSiteArray[4].call(response)));
                callSiteArray[5].callStatic(SaagieUtils.class, response);
                String status = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[6].call(response)}, new String[]{"", ""}));
                GStringImpl message = new GStringImpl(new Object[]{status, body}, new String[]{"Error ", " when requesting \n", ""});
                callSiteArray[7].call((Object)l, (Object)message);
                throw (Throwable)callSiteArray[8].callConstructor(GradleException.class, (Object)message);
            }

            public Object call(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                return callSiteArray[9].callCurrent((GroovyObject)this, (Object)l, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "successful";
                stringArray[2] = "debug";
                stringArray[3] = "string";
                stringArray[4] = "body";
                stringArray[5] = "debugResponse";
                stringArray[6] = "code";
                stringArray[7] = "error";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                __clinit__closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure7 __clinit__closure72 = new __clinit__closure7(SaagieUtils.class, SaagieUtils.class);
        handleErrorClosure = __clinit__closure72;
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static MediaType getJSON() {
        return JSON;
    }

    @Generated
    public DataOpsExtension getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(DataOpsExtension dataOpsExtension) {
        this.configuration = dataOpsExtension;
    }

    @Generated
    public static Object getHandleErrorClosure() {
        return handleErrorClosure;
    }

    @Generated
    public static void setHandleErrorClosure(Object object) {
        handleErrorClosure = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "debug";
        stringArray[1] = "debug";
        stringArray[2] = "debug";
        stringArray[3] = "debug";
        stringArray[4] = "replaceAll";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "debug";
        stringArray[9] = "debug";
        stringArray[10] = "gq";
        stringArray[11] = "buildRequestFromQuery";
        stringArray[12] = "getProjectJobsRequestBuild";
        stringArray[13] = "getProjectJobsRequestBuild";
        stringArray[14] = "project";
        stringArray[15] = "debug";
        stringArray[16] = "id";
        stringArray[17] = "build";
        stringArray[18] = "excludeNulls";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "toJson";
        stringArray[21] = "id";
        stringArray[22] = "gq";
        stringArray[23] = "buildRequestFromQuery";
        stringArray[24] = "any";
        stringArray[25] = "debug";
        stringArray[26] = "build";
        stringArray[27] = "excludeNulls";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "toJson";
        stringArray[30] = "gq";
        stringArray[31] = "buildRequestFromQuery";
        stringArray[32] = "project";
        stringArray[33] = "debug";
        stringArray[34] = "id";
        stringArray[35] = "build";
        stringArray[36] = "excludeNulls";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "toJson";
        stringArray[39] = "id";
        stringArray[40] = "gq";
        stringArray[41] = "buildRequestFromQuery";
        stringArray[42] = "project";
        stringArray[43] = "debug";
        stringArray[44] = "id";
        stringArray[45] = "build";
        stringArray[46] = "excludeNulls";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "toJson";
        stringArray[49] = "id";
        stringArray[50] = "gq";
        stringArray[51] = "buildRequestFromQuery";
        stringArray[52] = "project";
        stringArray[53] = "debug";
        stringArray[54] = "id";
        stringArray[55] = "build";
        stringArray[56] = "excludeNulls";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "toJson";
        stringArray[59] = "id";
        stringArray[60] = "gq";
        stringArray[61] = "buildRequestFromQuery";
        stringArray[62] = "server";
        stringArray[63] = "debug";
        stringArray[64] = "build";
        stringArray[65] = "get";
        stringArray[66] = "url";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "url";
        stringArray[69] = "environment";
        stringArray[70] = "debugRequest";
        stringArray[71] = "plus";
        stringArray[72] = "minus";
        stringArray[73] = "minus";
        stringArray[74] = "server";
        stringArray[75] = "debug";
        stringArray[76] = "newBuilder";
        stringArray[77] = "parse";
        stringArray[78] = "url";
        stringArray[79] = "environment";
        stringArray[80] = "addQueryParameter";
        stringArray[81] = "addQueryParameter";
        stringArray[82] = "build";
        stringArray[83] = "url";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "build";
        stringArray[86] = "debugRequest";
        stringArray[87] = "server";
        stringArray[88] = "debug";
        stringArray[89] = "build";
        stringArray[90] = "get";
        stringArray[91] = "url";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "url";
        stringArray[94] = "environment";
        stringArray[95] = "debugRequest";
        stringArray[96] = "project";
        stringArray[97] = "debug";
        stringArray[98] = "id";
        stringArray[99] = "build";
        stringArray[100] = "excludeNulls";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "toJson";
        stringArray[103] = "gq";
        stringArray[104] = "buildRequestFromQuery";
        stringArray[105] = "mapJobAndJobVersionWithoutMail";
        stringArray[106] = "id";
        stringArray[107] = "project";
        stringArray[108] = "debug";
        stringArray[109] = "build";
        stringArray[110] = "excludeFieldsByName";
        stringArray[111] = "excludeNulls";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "toJson";
        stringArray[114] = "job";
        stringArray[115] = "jobVersion";
        stringArray[116] = "gq";
        stringArray[117] = "buildRequestFromQuery";
        stringArray[118] = "mapJobAndJobVersionWithoutMail";
        stringArray[119] = "id";
        stringArray[120] = "project";
        stringArray[121] = "debug";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "name";
        stringArray[124] = "packageInfo";
        stringArray[125] = "debug";
        stringArray[126] = "absolutePath";
        stringArray[127] = "build";
        stringArray[128] = "addConverter";
        stringArray[129] = "excludeNulls";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "toJson";
        stringArray[132] = "job";
        stringArray[133] = "jobVersion";
        stringArray[134] = "absolutePath";
        stringArray[135] = "packageInfo";
        stringArray[136] = "reverse";
        stringArray[137] = "drop";
        stringArray[138] = "reverse";
        stringArray[139] = "gq";
        stringArray[140] = "buildMultipartRequestFromQuery";
        stringArray[141] = "job";
        stringArray[142] = "mapJobWithoutMail";
        stringArray[143] = "id";
        stringArray[144] = "project";
        stringArray[145] = "debug";
        stringArray[146] = "build";
        stringArray[147] = "excludeNulls";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "toJson";
        stringArray[150] = "getProjectUpdateJobRequestFormat";
        stringArray[151] = "job";
        stringArray[152] = "mapJobWithoutMail";
        stringArray[153] = "id";
        stringArray[154] = "project";
        stringArray[155] = "getProjectUpdateJobFromDataRequestFromParams";
        stringArray[156] = "job";
        stringArray[157] = "build";
        stringArray[158] = "excludeNulls";
        stringArray[159] = "<$constructor$>";
        stringArray[160] = "getFormatForUpdateJob";
        stringArray[161] = "toJson";
        stringArray[162] = "getProjectUpdateJobRequestFormat";
        stringArray[163] = "gq";
        stringArray[164] = "buildRequestFromQuery";
        stringArray[165] = "job";
        stringArray[166] = "jobVersion";
        stringArray[167] = "debug";
        stringArray[168] = "id";
        stringArray[169] = "build";
        stringArray[170] = "excludeNulls";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "toJson";
        stringArray[173] = "id";
        stringArray[174] = "toMap";
        stringArray[175] = "gq";
        stringArray[176] = "buildRequestFromQuery";
        stringArray[177] = "<$constructor$>";
        stringArray[178] = "add";
        stringArray[179] = "add";
        stringArray[180] = "add";
        stringArray[181] = "removeAll";
        stringArray[182] = "keySet";
        stringArray[183] = "debug";
        stringArray[184] = "id";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "name";
        stringArray[187] = "packageInfo";
        stringArray[188] = "debug";
        stringArray[189] = "absolutePath";
        stringArray[190] = "build";
        stringArray[191] = "excludeNulls";
        stringArray[192] = "<$constructor$>";
        stringArray[193] = "toJson";
        stringArray[194] = "id";
        stringArray[195] = "toMap";
        stringArray[196] = "absolutePath";
        stringArray[197] = "packageInfo";
        stringArray[198] = "reverse";
        stringArray[199] = "drop";
        stringArray[200] = "reverse";
        stringArray[201] = "gq";
        stringArray[202] = "buildMultipartRequestFromQuery";
        stringArray[203] = "debug";
        stringArray[204] = "id";
        stringArray[205] = "excludeFieldsByName";
        stringArray[206] = "excludeNulls";
        stringArray[207] = "<$constructor$>";
        stringArray[208] = "downloadUrl";
        stringArray[209] = "packageInfo";
        stringArray[210] = "excludeFieldsByName";
        stringArray[211] = "build";
        stringArray[212] = "toJson";
        stringArray[213] = "id";
        stringArray[214] = "toMap";
        stringArray[215] = "gq";
        stringArray[216] = "buildRequestFromQuery";
        stringArray[217] = "debug";
        stringArray[218] = "<$constructor$>";
        stringArray[219] = "name";
        stringArray[220] = "packageInfo";
        stringArray[221] = "jobVersion";
        stringArray[222] = "<$constructor$>";
        stringArray[223] = "detect";
        stringArray[224] = "debug";
        stringArray[225] = "parse";
        stringArray[226] = "debug";
        stringArray[227] = "absolutePath";
        stringArray[228] = "build";
        stringArray[229] = "addFormDataPart";
        stringArray[230] = "setType";
        stringArray[231] = "<$constructor$>";
        stringArray[232] = "FORM";
        stringArray[233] = "name";
        stringArray[234] = "create";
        stringArray[235] = "server";
        stringArray[236] = "jwt";
        stringArray[237] = "debug";
        stringArray[238] = "realm";
        stringArray[239] = "token";
        stringArray[240] = "build";
        stringArray[241] = "post";
        stringArray[242] = "addHeader";
        stringArray[243] = "addHeader";
        stringArray[244] = "addHeader";
        stringArray[245] = "url";
        stringArray[246] = "<$constructor$>";
        stringArray[247] = "url";
        stringArray[248] = "server";
        stringArray[249] = "environment";
        stringArray[250] = "server";
        stringArray[251] = "id";
        stringArray[252] = "project";
        stringArray[253] = "debug";
        stringArray[254] = "build";
        stringArray[255] = "post";
        stringArray[256] = "addHeader";
        stringArray[257] = "addHeader";
        stringArray[258] = "addHeader";
        stringArray[259] = "url";
        stringArray[260] = "<$constructor$>";
        stringArray[261] = "url";
        stringArray[262] = "server";
        stringArray[263] = "environment";
        stringArray[264] = "server";
        stringArray[265] = "id";
        stringArray[266] = "project";
        stringArray[267] = "getCredentials";
        stringArray[268] = "build";
        stringArray[269] = "post";
        stringArray[270] = "addHeader";
        stringArray[271] = "addHeader";
        stringArray[272] = "addHeader";
        stringArray[273] = "url";
        stringArray[274] = "<$constructor$>";
        stringArray[275] = "url";
        stringArray[276] = "server";
        stringArray[277] = "environment";
        stringArray[278] = "server";
        stringArray[279] = "id";
        stringArray[280] = "project";
        stringArray[281] = "job";
        stringArray[282] = "debug";
        stringArray[283] = "id";
        stringArray[284] = "build";
        stringArray[285] = "excludeNulls";
        stringArray[286] = "<$constructor$>";
        stringArray[287] = "toJson";
        stringArray[288] = "id";
        stringArray[289] = "gq";
        stringArray[290] = "buildRequestFromQuery";
        stringArray[291] = "deleteDir";
        stringArray[292] = "warn";
        stringArray[293] = "warn";
        stringArray[294] = "message";
        stringArray[295] = "project";
        stringArray[296] = "debug";
        stringArray[297] = "id";
        stringArray[298] = "build";
        stringArray[299] = "excludeNulls";
        stringArray[300] = "<$constructor$>";
        stringArray[301] = "toMap";
        stringArray[302] = "toMap";
        stringArray[303] = "id";
        stringArray[304] = "jobs";
        stringArray[305] = "releaseNote";
        stringArray[306] = "toJson";
        stringArray[307] = "gq";
        stringArray[308] = "buildRequestFromQuery";
        stringArray[309] = "jobinstance";
        stringArray[310] = "debug";
        stringArray[311] = "id";
        stringArray[312] = "build";
        stringArray[313] = "excludeNulls";
        stringArray[314] = "<$constructor$>";
        stringArray[315] = "toJson";
        stringArray[316] = "id";
        stringArray[317] = "gq";
        stringArray[318] = "buildRequestFromQuery";
        stringArray[319] = "pipelineinstance";
        stringArray[320] = "debug";
        stringArray[321] = "id";
        stringArray[322] = "getProjectPipelineInstanceStatusRequestWithparam";
        stringArray[323] = "id";
        stringArray[324] = "build";
        stringArray[325] = "excludeNulls";
        stringArray[326] = "<$constructor$>";
        stringArray[327] = "toJson";
        stringArray[328] = "gq";
        stringArray[329] = "buildRequestFromQuery";
        stringArray[330] = "pipeline";
        stringArray[331] = "debug";
        stringArray[332] = "id";
        stringArray[333] = "build";
        stringArray[334] = "excludeNulls";
        stringArray[335] = "<$constructor$>";
        stringArray[336] = "toJson";
        stringArray[337] = "toMap";
        stringArray[338] = "gq";
        stringArray[339] = "buildRequestFromQuery";
        stringArray[340] = "getAddPipelineVersionRequestFromParams";
        stringArray[341] = "debug";
        stringArray[342] = "id";
        stringArray[343] = "build";
        stringArray[344] = "excludeNulls";
        stringArray[345] = "<$constructor$>";
        stringArray[346] = "toJson";
        stringArray[347] = "id";
        stringArray[348] = "jobs";
        stringArray[349] = "releaseNote";
        stringArray[350] = "gq";
        stringArray[351] = "buildRequestFromQuery";
        stringArray[352] = "pipeline";
        stringArray[353] = "debug";
        stringArray[354] = "id";
        stringArray[355] = "build";
        stringArray[356] = "excludeNulls";
        stringArray[357] = "<$constructor$>";
        stringArray[358] = "toJson";
        stringArray[359] = "id";
        stringArray[360] = "gq";
        stringArray[361] = "buildRequestFromQuery";
        stringArray[362] = "pipeline";
        stringArray[363] = "debug";
        stringArray[364] = "id";
        stringArray[365] = "build";
        stringArray[366] = "excludeNulls";
        stringArray[367] = "<$constructor$>";
        stringArray[368] = "toJson";
        stringArray[369] = "id";
        stringArray[370] = "gq";
        stringArray[371] = "buildRequestFromQuery";
        stringArray[372] = "job";
        stringArray[373] = "debug";
        stringArray[374] = "id";
        stringArray[375] = "build";
        stringArray[376] = "excludeNulls";
        stringArray[377] = "<$constructor$>";
        stringArray[378] = "toJson";
        stringArray[379] = "id";
        stringArray[380] = "gq";
        stringArray[381] = "buildRequestFromQuery";
        stringArray[382] = "pipelineinstance";
        stringArray[383] = "debug";
        stringArray[384] = "id";
        stringArray[385] = "build";
        stringArray[386] = "excludeNulls";
        stringArray[387] = "<$constructor$>";
        stringArray[388] = "toJson";
        stringArray[389] = "id";
        stringArray[390] = "gq";
        stringArray[391] = "buildRequestFromQuery";
        stringArray[392] = "debug";
        stringArray[393] = "build";
        stringArray[394] = "get";
        stringArray[395] = "addHeader";
        stringArray[396] = "url";
        stringArray[397] = "<$constructor$>";
        stringArray[398] = "url";
        stringArray[399] = "server";
        stringArray[400] = "getCredentials";
        stringArray[401] = "build";
        stringArray[402] = "get";
        stringArray[403] = "addHeader";
        stringArray[404] = "url";
        stringArray[405] = "<$constructor$>";
        stringArray[406] = "url";
        stringArray[407] = "server";
        stringArray[408] = "debugRequest";
        stringArray[409] = "jobinstance";
        stringArray[410] = "debug";
        stringArray[411] = "id";
        stringArray[412] = "build";
        stringArray[413] = "excludeNulls";
        stringArray[414] = "<$constructor$>";
        stringArray[415] = "toJson";
        stringArray[416] = "id";
        stringArray[417] = "gq";
        stringArray[418] = "buildRequestFromQuery";
        stringArray[419] = "prettyPrint";
        stringArray[420] = "debug";
        stringArray[421] = "<$constructor$>";
        stringArray[422] = "name";
        stringArray[423] = "packageInfo";
        stringArray[424] = "name";
        stringArray[425] = "debug";
        stringArray[426] = "absolutePath";
        stringArray[427] = "build";
        stringArray[428] = "excludeNulls";
        stringArray[429] = "<$constructor$>";
        stringArray[430] = "toJson";
        stringArray[431] = "create";
        stringArray[432] = "parse";
        stringArray[433] = "build";
        stringArray[434] = "addFormDataPart";
        stringArray[435] = "addFormDataPart";
        stringArray[436] = "addFormDataPart";
        stringArray[437] = "setType";
        stringArray[438] = "<$constructor$>";
        stringArray[439] = "FORM";
        stringArray[440] = "create";
        stringArray[441] = "create";
        stringArray[442] = "server";
        stringArray[443] = "jwt";
        stringArray[444] = "debug";
        stringArray[445] = "realm";
        stringArray[446] = "token";
        stringArray[447] = "build";
        stringArray[448] = "post";
        stringArray[449] = "addHeader";
        stringArray[450] = "addHeader";
        stringArray[451] = "addHeader";
        stringArray[452] = "url";
        stringArray[453] = "<$constructor$>";
        stringArray[454] = "url";
        stringArray[455] = "server";
        stringArray[456] = "environment";
        stringArray[457] = "server";
        stringArray[458] = "debug";
        stringArray[459] = "build";
        stringArray[460] = "post";
        stringArray[461] = "addHeader";
        stringArray[462] = "addHeader";
        stringArray[463] = "addHeader";
        stringArray[464] = "url";
        stringArray[465] = "<$constructor$>";
        stringArray[466] = "url";
        stringArray[467] = "server";
        stringArray[468] = "environment";
        stringArray[469] = "server";
        stringArray[470] = "getCredentials";
        stringArray[471] = "build";
        stringArray[472] = "post";
        stringArray[473] = "addHeader";
        stringArray[474] = "addHeader";
        stringArray[475] = "addHeader";
        stringArray[476] = "url";
        stringArray[477] = "<$constructor$>";
        stringArray[478] = "url";
        stringArray[479] = "server";
        stringArray[480] = "environment";
        stringArray[481] = "server";
        stringArray[482] = "debugRequest";
        stringArray[483] = "server";
        stringArray[484] = "debug";
        stringArray[485] = "realm";
        stringArray[486] = "token";
        stringArray[487] = "debug";
        stringArray[488] = "build";
        stringArray[489] = "get";
        stringArray[490] = "addHeader";
        stringArray[491] = "addHeader";
        stringArray[492] = "url";
        stringArray[493] = "<$constructor$>";
        stringArray[494] = "url";
        stringArray[495] = "server";
        stringArray[496] = "environment";
        stringArray[497] = "server";
        stringArray[498] = "toUpperCase";
        stringArray[499] = "toLowerCase";
        stringArray[500] = "debugRequest";
        stringArray[501] = "project";
        stringArray[502] = "debug";
        stringArray[503] = "id";
        stringArray[504] = "build";
        stringArray[505] = "excludeNulls";
        stringArray[506] = "<$constructor$>";
        stringArray[507] = "toJson";
        stringArray[508] = "id";
        stringArray[509] = "gq";
        stringArray[510] = "buildRequestFromQuery";
        stringArray[511] = "debug";
        stringArray[512] = "gq";
        stringArray[513] = "buildRequestFromQuery";
        stringArray[514] = "getPlatformListRequest";
        stringArray[515] = "project";
        stringArray[516] = "debug";
        stringArray[517] = "name";
        stringArray[518] = "build";
        stringArray[519] = "excludeNulls";
        stringArray[520] = "<$constructor$>";
        stringArray[521] = "toJson";
        stringArray[522] = "toMap";
        stringArray[523] = "gq";
        stringArray[524] = "buildRequestFromQuery";
        stringArray[525] = "job";
        stringArray[526] = "getJobDetailRequestFromParam";
        stringArray[527] = "id";
        stringArray[528] = "debug";
        stringArray[529] = "build";
        stringArray[530] = "excludeNulls";
        stringArray[531] = "<$constructor$>";
        stringArray[532] = "toJson";
        stringArray[533] = "gq";
        stringArray[534] = "buildRequestFromQuery";
        stringArray[535] = "server";
        stringArray[536] = "debug";
        stringArray[537] = "build";
        stringArray[538] = "get";
        stringArray[539] = "url";
        stringArray[540] = "<$constructor$>";
        stringArray[541] = "url";
        stringArray[542] = "environment";
        stringArray[543] = "debugRequest";
        stringArray[544] = "project";
        stringArray[545] = "job";
        stringArray[546] = "debug";
        stringArray[547] = "id";
        stringArray[548] = "id";
        stringArray[549] = "build";
        stringArray[550] = "excludeNulls";
        stringArray[551] = "<$constructor$>";
        stringArray[552] = "toJson";
        stringArray[553] = "id";
        stringArray[554] = "gq";
        stringArray[555] = "buildRequestFromQuery";
        stringArray[556] = "project";
        stringArray[557] = "debug";
        stringArray[558] = "id";
        stringArray[559] = "build";
        stringArray[560] = "excludeNulls";
        stringArray[561] = "<$constructor$>";
        stringArray[562] = "toJson";
        stringArray[563] = "toMap";
        stringArray[564] = "gq";
        stringArray[565] = "buildRequestFromQuery";
        stringArray[566] = "project";
        stringArray[567] = "debug";
        stringArray[568] = "build";
        stringArray[569] = "excludeNulls";
        stringArray[570] = "<$constructor$>";
        stringArray[571] = "toJson";
        stringArray[572] = "gq";
        stringArray[573] = "buildRequestFromQuery";
        stringArray[574] = "debug";
        stringArray[575] = "create";
        stringArray[576] = "server";
        stringArray[577] = "jwt";
        stringArray[578] = "debug";
        stringArray[579] = "realm";
        stringArray[580] = "token";
        stringArray[581] = "build";
        stringArray[582] = "post";
        stringArray[583] = "addHeader";
        stringArray[584] = "url";
        stringArray[585] = "<$constructor$>";
        stringArray[586] = "url";
        stringArray[587] = "server";
        stringArray[588] = "environment";
        stringArray[589] = "server";
        stringArray[590] = "debug";
        stringArray[591] = "build";
        stringArray[592] = "post";
        stringArray[593] = "addHeader";
        stringArray[594] = "url";
        stringArray[595] = "<$constructor$>";
        stringArray[596] = "url";
        stringArray[597] = "server";
        stringArray[598] = "environment";
        stringArray[599] = "server";
        stringArray[600] = "getCredentials";
        stringArray[601] = "build";
        stringArray[602] = "post";
        stringArray[603] = "addHeader";
        stringArray[604] = "url";
        stringArray[605] = "<$constructor$>";
        stringArray[606] = "url";
        stringArray[607] = "server";
        stringArray[608] = "environment";
        stringArray[609] = "server";
        stringArray[610] = "debugRequest";
        stringArray[611] = "debug";
        stringArray[612] = "buildRequestForFile";
        stringArray[613] = "execute";
        stringArray[614] = "newCall";
        stringArray[615] = "byteStream";
        stringArray[616] = "body";
        stringArray[617] = "<$constructor$>";
        stringArray[618] = "<$constructor$>";
        stringArray[619] = "plus";
        stringArray[620] = "plus";
        stringArray[621] = "read";
        stringArray[622] = "write";
        stringArray[623] = "plus";
        stringArray[624] = "<$constructor$>";
        stringArray[625] = "message";
        stringArray[626] = "debug";
        stringArray[627] = "close";
        stringArray[628] = "close";
        stringArray[629] = "debug";
        stringArray[630] = "server";
        stringArray[631] = "debug";
        stringArray[632] = "build";
        stringArray[633] = "addHeader";
        stringArray[634] = "url";
        stringArray[635] = "<$constructor$>";
        stringArray[636] = "getCredentials";
        stringArray[637] = "build";
        stringArray[638] = "addHeader";
        stringArray[639] = "url";
        stringArray[640] = "<$constructor$>";
        stringArray[641] = "debugRequest";
        stringArray[642] = "substring";
        stringArray[643] = "plus";
        stringArray[644] = "lastIndexOf";
        stringArray[645] = "length";
        stringArray[646] = "endsWith";
        stringArray[647] = "substring";
        stringArray[648] = "minus";
        stringArray[649] = "length";
        stringArray[650] = "basic";
        stringArray[651] = "login";
        stringArray[652] = "server";
        stringArray[653] = "password";
        stringArray[654] = "server";
        stringArray[655] = "collectEntries";
        stringArray[656] = "findAll";
        stringArray[657] = "declaredFields";
        stringArray[658] = "getClass";
        stringArray[659] = "<$constructor$>";
        stringArray[660] = "iterator";
        stringArray[661] = "contains";
        stringArray[662] = "add";
        stringArray[663] = "debug";
        stringArray[664] = "debug";
        stringArray[665] = "method";
        stringArray[666] = "path";
        stringArray[667] = "url";
        stringArray[668] = "url";
        stringArray[669] = "debug";
        stringArray[670] = "host";
        stringArray[671] = "url";
        stringArray[672] = "url";
        stringArray[673] = "each";
        stringArray[674] = "names";
        stringArray[675] = "headers";
        stringArray[676] = "body";
        stringArray[677] = "debug";
        stringArray[678] = "contentLength";
        stringArray[679] = "body";
        stringArray[680] = "<$constructor$>";
        stringArray[681] = "writeTo";
        stringArray[682] = "body";
        stringArray[683] = "debug";
        stringArray[684] = "readUtf8";
        stringArray[685] = "debug";
        stringArray[686] = "debug";
        stringArray[687] = "toString";
        stringArray[688] = "protocol";
        stringArray[689] = "code";
        stringArray[690] = "message";
        stringArray[691] = "each";
        stringArray[692] = "names";
        stringArray[693] = "headers";
        stringArray[694] = "error";
        stringArray[695] = "<$constructor$>";
        stringArray[696] = "indexOf";
        stringArray[697] = "plus";
        stringArray[698] = "indexOf";
        stringArray[699] = "throwAndLogError";
        stringArray[700] = "substring";
        stringArray[701] = "plus";
        stringArray[702] = "indexOf";
        stringArray[703] = "substring";
        stringArray[704] = "plus";
        stringArray[705] = "length";
        stringArray[706] = "substring";
        stringArray[707] = "length";
        stringArray[708] = "from";
        stringArray[709] = "toInstant";
        stringArray[710] = "parse";
        stringArray[711] = "withZone";
        stringArray[712] = "ISO_ZONED_DATE_TIME";
        stringArray[713] = "UTC";
        stringArray[714] = "parse";
        stringArray[715] = "value";
        stringArray[716] = "SECOND";
        stringArray[717] = "months";
        stringArray[718] = "getPeriod";
        stringArray[719] = "value";
        stringArray[720] = "MONTH";
        stringArray[721] = "plus";
        stringArray[722] = "months";
        stringArray[723] = "getPeriod";
        stringArray[724] = "value";
        stringArray[725] = "MONTH";
        stringArray[726] = "toString";
        stringArray[727] = "month";
        stringArray[728] = "days";
        stringArray[729] = "getPeriod";
        stringArray[730] = "value";
        stringArray[731] = "DAYOFMONTH";
        stringArray[732] = "plus";
        stringArray[733] = "days";
        stringArray[734] = "getPeriod";
        stringArray[735] = "value";
        stringArray[736] = "DAYOFMONTH";
        stringArray[737] = "toString";
        stringArray[738] = "day";
        stringArray[739] = "toHours";
        stringArray[740] = "getDuration";
        stringArray[741] = "toHours";
        stringArray[742] = "getDuration";
        stringArray[743] = "value";
        stringArray[744] = "HOUR";
        stringArray[745] = "plus";
        stringArray[746] = "value";
        stringArray[747] = "HOUR";
        stringArray[748] = "toString";
        stringArray[749] = "hours";
        stringArray[750] = "toHours";
        stringArray[751] = "getDuration";
        stringArray[752] = "toMinutes";
        stringArray[753] = "getDuration";
        stringArray[754] = "toHours";
        stringArray[755] = "getDuration";
        stringArray[756] = "value";
        stringArray[757] = "MINUTE";
        stringArray[758] = "plus";
        stringArray[759] = "value";
        stringArray[760] = "MINUTE";
        stringArray[761] = "toString";
        stringArray[762] = "minutes";
        stringArray[763] = "generateCronExpression";
        stringArray[764] = "format";
        stringArray[765] = "getValueOrStar";
        stringArray[766] = "getValueOrStar";
        stringArray[767] = "getValueOrStar";
        stringArray[768] = "getValueOrStar";
        stringArray[769] = "format";
        stringArray[770] = "getLogger";
        stringArray[771] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[772];
        SaagieUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SaagieUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SaagieUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

