/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.plugin.dataops.utils;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.saagie.plugin.dataops.DataOpsExtension;
import io.saagie.plugin.dataops.models.Job;
import io.saagie.plugin.dataops.models.JobInstance;
import io.saagie.plugin.dataops.models.JobMapper;
import io.saagie.plugin.dataops.models.JobVersion;
import io.saagie.plugin.dataops.models.Pipeline;
import io.saagie.plugin.dataops.models.PipelineInstance;
import io.saagie.plugin.dataops.models.PipelineVersion;
import io.saagie.plugin.dataops.models.Project;
import io.saagie.plugin.dataops.models.Server;
import io.saagie.plugin.dataops.tasks.projects.enums.UnitTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.tika.Tika;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.threeten.extra.PeriodDuration;

public class SaagieUtils
implements GroovyObject {
    private static final Logger logger;
    private static final MediaType JSON;
    private DataOpsExtension configuration;
    private static Object handleErrorClosure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SaagieUtils(DataOpsExtension configuration) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DataOpsExtension dataOpsExtension = configuration;
        this.configuration = (DataOpsExtension)ScriptBytecodeAdapter.castToType((Object)dataOpsExtension, DataOpsExtension.class);
    }

    public static String gq(String request, String vars, String operationName) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[0].call((Object)logger, (Object)"GraphQL Query:");
        callSiteArray[1].call((Object)logger, (Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)vars)) {
            callSiteArray[2].call((Object)logger, (Object)"GraphQL Variables:");
            callSiteArray[3].call((Object)logger, (Object)vars);
        }
        Object inlinedRequest = callSiteArray[4].call((Object)request, (Object)"\\n", (Object)"");
        Object query = new GStringImpl(new Object[]{inlinedRequest}, new String[]{"{\"query\":\"", "\""});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vars, null)) {
            query = callSiteArray[5].call(query, (Object)new GStringImpl(new Object[]{vars}, new String[]{",\"variables\":", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)operationName)) {
            query = callSiteArray[6].call(query, (Object)new GStringImpl(new Object[]{operationName}, new String[]{",\"operationName\":\"", "\""}));
        }
        query = callSiteArray[7].call(query, (Object)"}");
        callSiteArray[8].call((Object)logger, (Object)"Generated graphql query:\n{}", query);
        return ShortTypeHandling.castToString((Object)query);
    }

    public Request getProjectsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[9].call((Object)logger, (Object)"Generating getProjectsRequest");
        Object listProjectsRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listProjectsRequest = object = callSiteArray[10].callStatic(SaagieUtils.class, (Object)"\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
            listProjectsRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, listProjectsRequest), Request.class);
    }

    public Request getProjectJobsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ");
    }

    public Request getProjectJobsGetNameAndIdRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ");
    }

    public Request getProjectPipelinesRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[15].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[16].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[20].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[21].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[22].callStatic(SaagieUtils.class, (Object)"\n            query pipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public static boolean isCollectionOrArray(Object object) {
        Reference object2 = new Reference(object);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _isCollectionOrArray_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference object;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isCollectionOrArray_closure1(Object _outerInstance, Object _thisObject, Reference object) {
                Reference reference;
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.object = reference = object;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it, callSiteArray[1].call(this.object.get()));
            }

            public Object getObject() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.object.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isCollectionOrArray_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isAssignableFrom";
                stringArray[1] = "getClass";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _isCollectionOrArray_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isCollectionOrArray_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isCollectionOrArray_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{Collection.class, Object[].class}), (Object)new _isCollectionOrArray_closure1(SaagieUtils.class, SaagieUtils.class, object2)));
    }

    public Request getListTechnologyVersionsRequest(String technologyId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[25].call((Object)logger, (Object)"Generating getListTechnologyVersionsRequest [technology={}]", (Object)technologyId);
        Object jsonGenerator = callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[29].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"technologyId", technologyId}));
        Object listTechnologyVersions = callSiteArray[30].callStatic(SaagieUtils.class, (Object)"\n            query TechnologiesVersions($technologyId: UUID!) {\n            technologiesVersions(technologyId: $technologyId) {\n              versionLabel\n              technologyLabel\n              secondaryTechnologies {\n                   label     isAvailable      versions\n              }\n            }\n          }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callCurrent((GroovyObject)this, listTechnologyVersions), Request.class);
    }

    public Request getProjectJobsRequestBuild(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[33].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[34].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[38].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[39].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[40].callStatic(SaagieUtils.class, (Object)query, gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request archiveProjectRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[43].call((Object)logger, (Object)"Generating archiveProjectRequest [ProjectId={}]", callSiteArray[44].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[48].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[49].callGroovyObjectGetProperty((Object)project)}));
        Object getProjectInstanceStatus = callSiteArray[50].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveProjectMutation($projectId: UUID!) {\n                archiveProject(projectId: $projectId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request getProjectTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[53].call((Object)logger, (Object)"generating getProjectTechnologiesRequest [projectId={}]", callSiteArray[54].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[58].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[59].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectTechnologies = callSiteArray[60].callStatic(SaagieUtils.class, (Object)"\n            query technologiesQuery($projectId: UUID!) {\n                technologies(projectId: $projectId) {\n                    id\n                    label\n                    isAvailable\n                    icon\n                    features {\n                        field\n                        label\n                        isMandatory\n                        comment\n                        defaultValue\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callCurrent((GroovyObject)this, listProjectTechnologies), Request.class);
    }

    public Request getPipelineRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[63].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[68].callGroovyObjectGetProperty((Object)server), callSiteArray[69].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[70].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static ArrayList getDifferenceOfTwoArrays(ArrayList collection1, ArrayList collection2) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call(callSiteArray[72].call((Object)collection1, (Object)collection2), callSiteArray[73].call((Object)collection2, (Object)collection1)), ArrayList.class);
    }

    public Request getPipelineInstancesRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[75].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        HttpUrl.Builder httpBuilder = (HttpUrl.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(callSiteArray[77].call(HttpUrl.class, (Object)new GStringImpl(new Object[]{callSiteArray[78].callGroovyObjectGetProperty((Object)server), callSiteArray[79].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", "/instance"}))), HttpUrl.Builder.class);
        callSiteArray[80].call((Object)httpBuilder, (Object)"page", (Object)"1");
        callSiteArray[81].call((Object)httpBuilder, (Object)"size", (Object)"10");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].callConstructor(Request.Builder.class), callSiteArray[85].call((Object)httpBuilder))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[86].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineInstanceDetailRequestFromParamV1(String pipelineId, String instanceId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[88].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].call(callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[93].callGroovyObjectGetProperty((Object)server), callSiteArray[94].callGroovyObjectGetProperty((Object)server), pipelineId, instanceId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", "/instance/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[95].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineRequestFromParam(Object pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[97].call((Object)logger, (Object)"generating getPipelineRequest [projectId={}]", callSiteArray[98].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[102].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", pipelineId}));
        Object pipelineResult = callSiteArray[103].callStatic(SaagieUtils.class, (Object)"\n            query pipeline ($pipelineId: UUID!) {\n                pipeline(id: $pipelineId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].callCurrent((GroovyObject)this, pipelineResult), Request.class);
    }

    @Deprecated
    public Request getProjectCreateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[108].callGetProperty(callSiteArray[109].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[110].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object jsonGenerator = callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].callConstructor(JsonGenerator.Options.class)), (Object)"usePreviousArtifact"));
        Object gqVariables = callSiteArray[115].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[116].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[117].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object createProjectJob = callSiteArray[118].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!) {\n                createJob(job: $job, jobVersion: $jobVersion) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectCreateJobRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[122].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[123].callGetProperty(callSiteArray[124].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[125].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Reference file = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].callConstructor(File.class, callSiteArray[127].callGetProperty(callSiteArray[128].callGroovyObjectGetProperty((Object)jobVersion))), File.class)));
        callSiteArray[129].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[130].callGetProperty((Object)((File)file.get())));
        public final class _getProjectCreateJobRequestWithGraphQL_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getProjectCreateJobRequestWithGraphQL_closure2(Object _outerInstance, Object _thisObject, Reference file) {
                Reference reference;
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.file = reference = file;
            }

            public Object doCall(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(this.file.get());
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)value), (String)"name");
                return value;
            }

            public Object call(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value);
            }

            public File getFile() {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProjectCreateJobRequestWithGraphQL_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "packageInfo";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProjectCreateJobRequestWithGraphQL_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jsonGenerator = callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call(callSiteArray[134].callConstructor(JsonGenerator.Options.class)), JobVersion.class, (Object)new _getProjectCreateJobRequestWithGraphQL_closure2(this, this, file)));
        Object gqVariables = callSiteArray[135].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[136].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[137].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object object = callSiteArray[138].callGetProperty((Object)((File)file.get()));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[139].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[140].call(callSiteArray[141].call(callSiteArray[142].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object createProjectJob = callSiteArray[143].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!, $file: Upload) {\n                createJob(job: $job, jobVersion: $jobVersion, file: $file) {\n                    id\n                    name\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectUpdateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].call(JobMapper.class, (Object)job, callSiteArray[147].callGetProperty(callSiteArray[148].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[149].call((Object)logger, (Object)"Generating getProjectUpdateJobRequest [job={}]", (Object)mappedJob);
        Object jsonGenerator = callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[153].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", mappedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[156].call(JobMapper.class, (Object)job, callSiteArray[157].callGetProperty(callSiteArray[158].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].callCurrent((GroovyObject)this, callSiteArray[160].callGetProperty((Object)mappedJob)), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequestFromParams(Object job) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].callConstructor(JsonGenerator.Options.class)));
        Map formattedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callStatic(SaagieUtils.class, job), Map.class);
        Object gqVariables = callSiteArray[165].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", formattedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobRequestFormat(String gqVariables) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object updateProjectJob = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            updateProjectJob = object = callSiteArray[167].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", (Object)gqVariables);
        } else {
            String string = SaagieUtils.gq("\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", gqVariables);
            updateProjectJob = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getAddJobVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[171].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[172].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[173].call(callSiteArray[174].call(callSiteArray[175].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[176].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[177].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[178].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[179].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[180].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public static Map getFormatForUpdateJob(Map data) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set set = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].callConstructor(HashSet.class), Set.class);
        callSiteArray[182].call((Object)set, (Object)"projectId");
        callSiteArray[183].call((Object)set, (Object)"category");
        callSiteArray[184].call((Object)set, (Object)"technology");
        callSiteArray[185].call(callSiteArray[186].call((Object)data), (Object)set);
        return data;
    }

    public Request getAddJobVersionRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[187].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[189].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[190].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object file = callSiteArray[191].callConstructor(File.class, callSiteArray[192].callGetProperty(callSiteArray[193].callGroovyObjectGetProperty((Object)jobVersion)));
        callSiteArray[194].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[195].callGetProperty(file));
        Object jsonGenerator = callSiteArray[196].call(callSiteArray[197].call(callSiteArray[198].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[199].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[200].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[201].call((Object)jobVersion)}));
        Object object = callSiteArray[202].callGetProperty(file);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[203].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[204].call(callSiteArray[205].call(callSiteArray[206].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object updateProjectJob = callSiteArray[207].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!, $file: Upload) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion, file: $file) {\n                    number\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[208].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public Request getAddJobVersionRequestWithoutFile() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[210].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[211].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[212].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGeneratorParams = callSiteArray[213].call(callSiteArray[214].call(callSiteArray[215].callConstructor(JsonGenerator.Options.class)), (Object)"packageInfo");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[216].callGetPropertySafe(callSiteArray[217].callGetProperty(callSiteArray[218].callGroovyObjectGetProperty((Object)this.configuration))))) {
            Object object;
            jsonGeneratorParams = object = callSiteArray[219].call(jsonGeneratorParams, (Object)"usePreviousArtifact");
        }
        Object jsonGenerator = callSiteArray[220].call(jsonGeneratorParams);
        Object gqVariables = callSiteArray[221].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[222].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[223].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[224].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[225].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getUploadFileToJobRequest(String jobId, String jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[226].call((Object)logger, (Object)"Generating getUploadFileToJobRequest [jobId={}, jobVersion={}]", (Object)jobId, (Object)jobVersion);
        Object file = callSiteArray[227].callConstructor(File.class, callSiteArray[228].callGetProperty(callSiteArray[229].callGetProperty(callSiteArray[230].callGroovyObjectGetProperty((Object)this.configuration))));
        Tika tika = (Tika)ScriptBytecodeAdapter.castToType((Object)callSiteArray[231].callConstructor(Tika.class), Tika.class);
        String fileMimeType = ShortTypeHandling.castToString((Object)callSiteArray[232].call((Object)tika, file));
        callSiteArray[233].call((Object)logger, (Object)"Detected file mime type: ", (Object)fileMimeType);
        Object fileType = callSiteArray[234].call(MediaType.class, (Object)fileMimeType);
        callSiteArray[235].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[236].callGetProperty(file));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[237].call(callSiteArray[238].call(callSiteArray[239].call(callSiteArray[240].callConstructor(MultipartBody.Builder.class), callSiteArray[241].callGetProperty(MultipartBody.class)), (Object)"files", callSiteArray[242].callGetProperty(file), callSiteArray[243].call(RequestBody.class, file, fileType))), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[245].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[246].call((Object)logger, (Object)"Building upload file request with jwt auth...");
            Object realm = callSiteArray[247].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[248].callGroovyObjectGetProperty((Object)server);
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[249].call(callSiteArray[250].call(callSiteArray[251].call(callSiteArray[252].call(callSiteArray[253].call(callSiteArray[254].call(callSiteArray[255].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[256].callGetProperty(callSiteArray[257].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[258].callGetProperty(callSiteArray[259].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[260].callGetProperty(callSiteArray[261].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/projects/api/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        callSiteArray[262].call((Object)logger, (Object)"Building upload file request with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[263].call(callSiteArray[264].call(callSiteArray[265].call(callSiteArray[266].call(callSiteArray[267].call(callSiteArray[268].call(callSiteArray[269].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[270].callGetProperty(callSiteArray[271].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[272].callGetProperty(callSiteArray[273].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[274].callGetProperty(callSiteArray[275].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", callSiteArray[276].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[277].call(callSiteArray[278].call(callSiteArray[279].call(callSiteArray[280].call(callSiteArray[281].call(callSiteArray[282].call(callSiteArray[283].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[284].callGetProperty(callSiteArray[285].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[286].callGetProperty(callSiteArray[287].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[288].callGetProperty(callSiteArray[289].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
    }

    public Request getRunProjectJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[290].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[291].call((Object)logger, (Object)"Generating getRunProjectJobRequest for job [id={}]", callSiteArray[292].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[293].call(callSiteArray[294].call(callSiteArray[295].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[296].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[297].callGroovyObjectGetProperty((Object)job)}));
        Object runProjectJobRequest = callSiteArray[298].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($jobId: UUID!) {\n                runJob(jobId: $jobId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[299].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public static Object cleanDirectory(File temp, Logger logger) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object object = callSiteArray[300].call((Object)temp);
        try {
            return object;
        }
        catch (Exception exception) {
            callSiteArray[301].call((Object)logger, (Object)"The directory couldn't be cleaned");
            Object object2 = callSiteArray[302].call((Object)logger, callSiteArray[303].callGetProperty((Object)exception));
            return object2;
        }
    }

    public Request getCreatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[304].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[305].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[306].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        callSiteArray[307].call((Object)logger, (Object)"Generating getCreatePipelineRequest for project [projectId={}, pipeline={}, pipelineVersion={}]", callSiteArray[308].callGroovyObjectGetProperty((Object)project), (Object)pipeline, (Object)pipelineVersion);
        Object jsonGenerator = callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].callConstructor(JsonGenerator.Options.class)));
        Map graphqlPipelineVar = ScriptBytecodeAdapter.createMap((Object[])new Object[]{ScriptBytecodeAdapter.spreadMap((Object)callSiteArray[312].call((Object)pipeline)), callSiteArray[313].call((Object)pipeline), "projectId", callSiteArray[314].callGroovyObjectGetProperty((Object)project), "jobsId", callSiteArray[315].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[316].callGroovyObjectGetProperty((Object)pipelineVersion)});
        Object gqVariables = callSiteArray[317].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", graphqlPipelineVar}));
        Object runProjectJobRequest = callSiteArray[318].callStatic(SaagieUtils.class, (Object)"\n            mutation createPipelineMutation($pipeline: PipelineInput!) {\n                createPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[319].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getProjectJobInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[320].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[321].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[322].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[323].call(callSiteArray[324].call(callSiteArray[325].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[326].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[327].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object getJobInstanceStatus = callSiteArray[328].callStatic(SaagieUtils.class, (Object)"\n            query getJobInstanceStatus($jobId: UUID!) {\n                jobInstance(id: $jobId) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[329].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[330].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[331].call((Object)logger, (Object)"Generating getProjectPipelineInstanceStatusRequest [pipelineInstanceId={}]", callSiteArray[332].callGroovyObjectGetProperty((Object)pipelineinstance));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[333].callCurrent((GroovyObject)this, callSiteArray[334].callGroovyObjectGetProperty((Object)pipelineinstance)), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequestWithparam(String id) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[335].call(callSiteArray[336].call(callSiteArray[337].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[338].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", id}));
        Object getPipelineInstanceStatus = callSiteArray[339].callStatic(SaagieUtils.class, (Object)"\n            query getPipelineInstanceStatus($id: UUID!) {\n                pipelineInstance(id: $id) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[340].callCurrent((GroovyObject)this, getPipelineInstanceStatus), Request.class);
    }

    public Request getProjectUpdatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[341].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[342].call((Object)logger, (Object)"Generating getProjectUpdatePipelineRequest [pipelineId={}]", callSiteArray[343].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[344].call(callSiteArray[345].call(callSiteArray[346].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[347].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", callSiteArray[348].call((Object)pipeline)}));
        Object editPipeline = callSiteArray[349].callStatic(SaagieUtils.class, (Object)"\n            mutation editPipelineMutation($pipeline: PipelineEditionInput!) {\n                editPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[350].callCurrent((GroovyObject)this, editPipeline), Request.class);
    }

    public Request getAddPipelineVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[351].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[352].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[353].callCurrent((GroovyObject)this, (Object)pipeline, (Object)pipelineVersion), Request.class);
    }

    public Request getAddPipelineVersionRequestFromParams(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[354].call((Object)logger, (Object)"Generating getAddPipelineVersionRequest [pipelineId={}]", callSiteArray[355].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[356].call(callSiteArray[357].call(callSiteArray[358].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[359].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[360].callGroovyObjectGetProperty((Object)pipeline), "jobsId", callSiteArray[361].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[362].callGroovyObjectGetProperty((Object)pipelineVersion)}));
        Object addPipelineVersionRequest = callSiteArray[363].callStatic(SaagieUtils.class, (Object)"\n            mutation addPipelineVersionMutation(\n                $pipelineId: UUID!,\n                $jobsId: [UUID!]!,\n                $releaseNote: String,\n            ) {\n                addPipelineVersion(\n                    pipelineId: $pipelineId,\n                    jobsId: $jobsId,\n                    releaseNote: $releaseNote\n                ) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[364].callCurrent((GroovyObject)this, addPipelineVersionRequest), Request.class);
    }

    public Request getProjectRunPipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[365].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[366].call((Object)logger, (Object)"Generating getProjectRunPipelineRequest [pipelineId={}]", callSiteArray[367].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[368].call(callSiteArray[369].call(callSiteArray[370].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[371].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[372].callGroovyObjectGetProperty((Object)pipeline)}));
        Object runPipeline = callSiteArray[373].callStatic(SaagieUtils.class, (Object)"\n            mutation runPipelineMutation($pipelineId: UUID!) {\n                runPipeline(pipelineId: $pipelineId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[374].callCurrent((GroovyObject)this, runPipeline), Request.class);
    }

    public Request getProjectDeletePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[375].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[376].call((Object)logger, (Object)"Generating getProjectDeletePipelineRequest [pipelineId={}]", callSiteArray[377].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[378].call(callSiteArray[379].call(callSiteArray[380].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[381].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[382].callGroovyObjectGetProperty((Object)pipeline)}));
        Object deletePipeline = callSiteArray[383].callStatic(SaagieUtils.class, (Object)"\n            mutation deletePipelineMutation($id: UUID!) {\n                deletePipeline(id: $id)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[384].callCurrent((GroovyObject)this, deletePipeline), Request.class);
    }

    public Request getProjectArchiveJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[385].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[386].call((Object)logger, (Object)"Generating getProjectDeleteJobRequest [jobId={}]", callSiteArray[387].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[388].call(callSiteArray[389].call(callSiteArray[390].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[391].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[392].callGroovyObjectGetProperty((Object)job)}));
        Object getJobInstanceStatus = callSiteArray[393].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveJobMutation($jobId: UUID!) {\n                archiveJob(jobId: $jobId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[394].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectStopPipelineInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[395].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[396].call((Object)logger, (Object)"Generating getProjectStopPipelineInstanceRequest [pipelineinstanceId={}]", callSiteArray[397].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[398].call(callSiteArray[399].call(callSiteArray[400].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[401].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineInstanceId", callSiteArray[402].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getJobInstanceStatus = callSiteArray[403].callStatic(SaagieUtils.class, (Object)"\n            mutation stopPipelineInstanceMutation($pipelineInstanceId: UUID!) {\n                stopPipelineInstance(pipelineInstanceId: $pipelineInstanceId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[404].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getJwtTokenRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[405].call((Object)logger, (Object)"Requesting JWT...");
        Request newRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[406].call(callSiteArray[407].call(callSiteArray[408].call(callSiteArray[409].call(callSiteArray[410].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[411].callGetProperty(callSiteArray[412].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", callSiteArray[413].callCurrent((GroovyObject)this))));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[414].call(callSiteArray[415].call(callSiteArray[416].call(callSiteArray[417].call(callSiteArray[418].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[419].callGetProperty(callSiteArray[420].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", (Object)this.getCredentials())));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[421].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getStopJobInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[422].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[423].call((Object)logger, (Object)"Generating getStopJobInstanceRequest for job instance [id={}]", callSiteArray[424].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[425].call(callSiteArray[426].call(callSiteArray[427].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[428].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobInstanceId", callSiteArray[429].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object runProjectJobRequest = callSiteArray[430].callStatic(SaagieUtils.class, (Object)"\n            mutation stopJobMutation($jobInstanceId: UUID!) {\n                stopJobInstance(jobInstanceId: $jobInstanceId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[431].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    private boolean checkIfStringIsJson(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[432].call(JsonOutput.class, (Object)query);
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
            boolean bl2 = false;
            return bl2;
        }
    }

    private Request buildMultipartRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[433].call((Object)logger, (Object)"Generating multipart request from query=\"{}\"", (Object)query);
        Object file = callSiteArray[434].callConstructor(File.class, callSiteArray[435].callGetProperty(callSiteArray[436].callGetProperty(callSiteArray[437].callGroovyObjectGetProperty((Object)this.configuration))));
        Object fileName = callSiteArray[438].callGetProperty(file);
        callSiteArray[439].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[440].callGetProperty(file));
        Object jsonGenerator = callSiteArray[441].call(callSiteArray[442].call(callSiteArray[443].callConstructor(JsonGenerator.Options.class)));
        Object map = callSiteArray[444].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"0", ScriptBytecodeAdapter.createList((Object[])new Object[]{"variables.file"})}));
        Object fileBody = callSiteArray[445].call(RequestBody.class, file, callSiteArray[446].call(MediaType.class, (Object)"application/octet-stream"));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[447].call(callSiteArray[448].call(callSiteArray[449].call(callSiteArray[450].call(callSiteArray[451].call(callSiteArray[452].callConstructor(MultipartBody.Builder.class, (Object)"--graphql-multipart-upload-boundary-85763456--"), callSiteArray[453].callGetProperty(MultipartBody.class)), (Object)"operations", null, callSiteArray[454].call(RequestBody.class, (Object)query, (Object)JSON)), (Object)"map", null, callSiteArray[455].call(RequestBody.class, map, (Object)JSON)), (Object)"0", fileName, fileBody)), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[456].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[457].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[458].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[459].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[460].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[461].call(callSiteArray[462].call(callSiteArray[463].call(callSiteArray[464].call(callSiteArray[465].call(callSiteArray[466].call(callSiteArray[467].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[468].callGetProperty(callSiteArray[469].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[470].callGetProperty(callSiteArray[471].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[472].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[473].call(callSiteArray[474].call(callSiteArray[475].call(callSiteArray[476].call(callSiteArray[477].call(callSiteArray[478].call(callSiteArray[479].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[480].callGetProperty(callSiteArray[481].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[482].callGetProperty(callSiteArray[483].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[484].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[485].call(callSiteArray[486].call(callSiteArray[487].call(callSiteArray[488].call(callSiteArray[489].call(callSiteArray[490].call(callSiteArray[491].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[492].callGetProperty(callSiteArray[493].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[494].callGetProperty(callSiteArray[495].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[496].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPlatformListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[497].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[498].call((Object)logger, (Object)"Generating request in order to get access rights by platforms");
        String realm = ShortTypeHandling.castToString((Object)callSiteArray[499].callGroovyObjectGetProperty((Object)server));
        String jwtToken = ShortTypeHandling.castToString((Object)callSiteArray[500].callGroovyObjectGetProperty((Object)server));
        callSiteArray[501].call((Object)logger, (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"Using realm=", " and jwt=", ""}));
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[502].call(callSiteArray[503].call(callSiteArray[504].call(callSiteArray[505].call(callSiteArray[506].call(callSiteArray[507].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[508].callGetProperty(callSiteArray[509].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[510].callGetProperty(callSiteArray[511].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/security/api/groups/authorizations/", "/permissions/projects"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{callSiteArray[512].call((Object)realm), jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Saagie-Realm", callSiteArray[513].call((Object)realm)))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[514].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getListAllPipelinesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[515].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[516].call((Object)logger, (Object)"Generating getListAllPipelinesRequest for project [id={}]", callSiteArray[517].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[518].call(callSiteArray[519].call(callSiteArray[520].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[521].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[522].callGroovyObjectGetProperty((Object)project)}));
        Object listAllPipelineRequest = callSiteArray[523].callStatic(SaagieUtils.class, (Object)"\n            query getAllPipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[524].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getListAllTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[525].call((Object)logger, (Object)"Generating getListAllTechnologiesRequest");
        Object listAllPipelineRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listAllPipelineRequest = object = callSiteArray[526].callStatic(SaagieUtils.class, (Object)"\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
            listAllPipelineRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[527].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getGroupListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[528].callCurrent((GroovyObject)this), Request.class);
        }
        return this.getPlatformListRequest();
    }

    public Request getProjectsCreateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[529].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[530].call((Object)logger, (Object)"Generating getProjectsCreateRequest for creating a new project [name={}]", callSiteArray[531].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[532].call(callSiteArray[533].call(callSiteArray[534].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[535].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[536].call((Object)project)}));
        Object createProjectRequest = callSiteArray[537].callStatic(SaagieUtils.class, (Object)"\n            mutation createProjectMutation($project: ProjectInput!) {\n                createProject(project: $project) {\n                    id\n                    name\n                    description\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[538].callCurrent((GroovyObject)this, createProjectRequest), Request.class);
    }

    public Request getJobDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[539].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[540].callCurrent((GroovyObject)this, callSiteArray[541].callGroovyObjectGetProperty((Object)job)), Request.class);
    }

    public Request getJobDetailRequestFromParam(Object jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[542].call((Object)logger, (Object)"Generating getJobDetailRequest for getting job detail [id={}]", jobId);
        Object jsonGenerator = callSiteArray[543].call(callSiteArray[544].call(callSiteArray[545].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[546].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object getJobDetailRequest = callSiteArray[547].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        runtimeVersion\n                        packageInfo {\n                            downloadUrl\n                        }\n                        dockerInfo {\n                            image\n                            dockerCredentialsId\n                        }\n                        commandLine\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[548].callCurrent((GroovyObject)this, getJobDetailRequest), Request.class);
    }

    public Request getJobDetailRequestFromParamV1(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[549].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[550].call((Object)logger, (Object)"Generating request in order to get job detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[551].call(callSiteArray[552].call(callSiteArray[553].call(callSiteArray[554].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[555].callGroovyObjectGetProperty((Object)server), callSiteArray[556].callGroovyObjectGetProperty((Object)server), jobId}, new String[]{"", "/manager/api/v1/platform/", "/job/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[557].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getJobVersionDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[558].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[559].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[560].call((Object)logger, (Object)"Getting jobVersion for job  [id={}] with project Id [id={}]", callSiteArray[561].callGroovyObjectGetProperty((Object)project), callSiteArray[562].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[563].call(callSiteArray[564].call(callSiteArray[565].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[566].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[567].callGroovyObjectGetProperty((Object)job), "number", 1}));
        Object getJobVersionRequest = callSiteArray[568].callStatic(SaagieUtils.class, (Object)"\n            query jobVersion($jobId: UUID!, $number: Int!) {\n                jobVersion(jobId: $jobId, number: $number) {\n                    commandLine\n                    dockerInfo {\n                        image\n                        dockerCredentialsId\n                    }\n                    releaseNote\n                    runtimeVersion\n                    packageInfo {\n                        name\n                        downloadUrl\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[569].callCurrent((GroovyObject)this, getJobVersionRequest), Request.class);
    }

    public Request getProjectsUpdateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[570].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[571].call((Object)logger, (Object)"Generating getProjectsUpdateRequest for updating a new project [id={}]", callSiteArray[572].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[573].call(callSiteArray[574].call(callSiteArray[575].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[576].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[577].call((Object)project)}));
        Object updateProjectRequest = callSiteArray[578].callStatic(SaagieUtils.class, (Object)"\n            mutation editProjectMutation($project: ProjectEditionInput!) {\n                editProject(project: $project) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[579].callCurrent((GroovyObject)this, updateProjectRequest), Request.class);
    }

    public Request getListVersionForJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[580].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[581].call((Object)logger, (Object)"Generating getListVersionForJobRequest for getting list a new job [id={}]", (Object)jobId);
        Object jsonGenerator = callSiteArray[582].call(callSiteArray[583].call(callSiteArray[584].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[585].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object listVersionForAJobRequest = callSiteArray[586].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    versions {\n                        number\n                        isCurrent\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[587].callCurrent((GroovyObject)this, listVersionForAJobRequest), Request.class);
    }

    private Request buildRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[588].call((Object)logger, (Object)"Generating request from query=\"{}\"", (Object)query);
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[589].call(RequestBody.class, (Object)query, (Object)JSON), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[590].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[591].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[592].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[593].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[594].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[595].call(callSiteArray[596].call(callSiteArray[597].call(callSiteArray[598].call(callSiteArray[599].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[600].callGetProperty(callSiteArray[601].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[602].callGetProperty(callSiteArray[603].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[604].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[605].call(callSiteArray[606].call(callSiteArray[607].call(callSiteArray[608].call(callSiteArray[609].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[610].callGetProperty(callSiteArray[611].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[612].callGetProperty(callSiteArray[613].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[614].callCurrent((GroovyObject)this)), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[615].call(callSiteArray[616].call(callSiteArray[617].call(callSiteArray[618].call(callSiteArray[619].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[620].callGetProperty(callSiteArray[621].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[622].callGetProperty(callSiteArray[623].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[624].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public void downloadFromHTTPSServer(String urlFrom, String to, OkHttpClient client, Object name) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            callSiteArray[625].call((Object)logger, (Object)"Downloading artifiacts ....");
            Request request = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[626].callCurrent((GroovyObject)this, (Object)urlFrom);
                request = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Request request2;
                request = request2 = this.buildRequestForFile(urlFrom);
            }
            Object response = callSiteArray[627].call(callSiteArray[628].call((Object)client, (Object)request));
            Object object = callSiteArray[629].call(callSiteArray[630].call(response));
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
            Object object2 = callSiteArray[631].callConstructor(FileOutputStream.class, callSiteArray[632].callConstructor(File.class, callSiteArray[633].call(callSiteArray[634].call((Object)to, (Object)"/"), name)));
            outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)object2, OutputStream.class);
            byte[] buffer = new byte[2048];
            int length = 0;
            int downloaded = 0;
            while (true) {
                Object object3 = callSiteArray[635].call((Object)inputStream, (Object)buffer);
                length = DefaultTypeTransformation.intUnbox((Object)object3);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)object3, (Object)-1)) {
                    callSiteArray[636].call((Object)outputStream, (Object)buffer, (Object)0, (Object)length);
                    downloaded = DefaultTypeTransformation.intUnbox((Object)callSiteArray[637].call((Object)downloaded, (Object)length));
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw (Throwable)callSiteArray[638].callConstructor(GradleException.class, callSiteArray[639].callGetProperty((Object)ex));
        }
        callSiteArray[640].call((Object)logger, (Object)"Artifacts downloaded.");
        callSiteArray[641].call((Object)outputStream);
        callSiteArray[642].call((Object)inputStream);
    }

    public Request buildRequestForFile(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[643].call((Object)logger, (Object)"Generating request for url=\"{}\"", (Object)url);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[644].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        callSiteArray[645].call((Object)logger, (Object)"Fetching file with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[646].call(callSiteArray[647].call(callSiteArray[648].call(callSiteArray[649].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", callSiteArray[650].callCurrent((GroovyObject)this)));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[651].call(callSiteArray[652].call(callSiteArray[653].call(callSiteArray[654].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", (Object)this.getCredentials()));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[655].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static String getFileNameFromUrl(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)url) ? callSiteArray[656].call((Object)url, callSiteArray[657].call(callSiteArray[658].call((Object)url, (Object)"/"), (Object)1), callSiteArray[659].call((Object)url)) : null);
    }

    public static Object removeLastSlash(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[660].call((Object)url, (Object)"/"))) {
            Object object = callSiteArray[661].call((Object)url, (Object)0, callSiteArray[662].call(callSiteArray[663].call((Object)url), (Object)1));
            url = ShortTypeHandling.castToString((Object)object);
        }
        return url;
    }

    private String getCredentials() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[664].call(Credentials.class, callSiteArray[665].callGetProperty(callSiteArray[666].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[667].callGetProperty(callSiteArray[668].callGroovyObjectGetProperty((Object)this.configuration))));
    }

    public static Map extractProperties(Object obj) {
        Reference obj2 = new Reference(obj);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _extractProperties_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "synthetic";
                return new CallSiteArray(_extractProperties_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _extractProperties_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference obj;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure4(Object _outerInstance, Object _thisObject, Reference obj) {
                Reference reference;
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.obj = reference = obj;
            }

            public Object doCall(Object field) {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(field), callSiteArray[1].call(this.obj.get(), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(field)}, new String[]{"", ""}))});
            }

            public Object getObj() {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return this.obj.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getAt";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _extractProperties_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractProperties_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[669].call(callSiteArray[670].call(callSiteArray[671].callGetProperty(callSiteArray[672].call(obj2.get())), (Object)new _extractProperties_closure3(SaagieUtils.class, SaagieUtils.class)), (Object)new _extractProperties_closure4(SaagieUtils.class, SaagieUtils.class, obj2)), Map.class);
    }

    public static boolean distinctValues(int ... arr) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set foundNumbers = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[673].callConstructor(HashSet.class), Set.class);
        String num = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[674].call((Object)arr), Iterator.class);
        while (iterator.hasNext()) {
            num = ShortTypeHandling.castToString(iterator.next());
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[675].call((Object)foundNumbers, (Object)num))) {
                return false;
            }
            callSiteArray[676].call((Object)foundNumbers, (Object)num);
        }
        return true;
    }

    public static Object debugRequest(Request request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[677].call((Object)logger, (Object)"====== Request ======");
        callSiteArray[678].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[679].callGetProperty((Object)((Request)request2.get())), callSiteArray[680].callGetProperty(callSiteArray[681].call(callSiteArray[682].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"", " ", ""}));
        callSiteArray[683].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[684].callGetProperty(callSiteArray[685].call(callSiteArray[686].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"Host: ", ""}));
        public final class _debugRequest_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugRequest_closure5(Object _outerInstance, Object _thisObject, Reference request) {
                Reference reference;
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference = request;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.request.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Request getRequest() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return (Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), Request.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugRequest_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugRequest_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugRequest_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugRequest_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[687].call(callSiteArray[688].call(callSiteArray[689].call((Object)((Request)request2.get()))), (Object)new _debugRequest_closure5(SaagieUtils.class, SaagieUtils.class, request2));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[690].call((Object)((Request)request2.get())))) {
            callSiteArray[691].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[692].call(callSiteArray[693].call((Object)((Request)request2.get())))}, new String[]{"Content-Length: ", ""}));
            Buffer buffer = (Buffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[694].callConstructor(Buffer.class), Buffer.class);
            callSiteArray[695].call(callSiteArray[696].call((Object)((Request)request2.get())), (Object)buffer);
            return callSiteArray[697].call((Object)logger, callSiteArray[698].call((Object)buffer));
        }
        return null;
    }

    public static Object debugResponse(Response response) {
        Reference response2 = new Reference((Object)response);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[699].call((Object)logger, (Object)"====== Response ======");
        callSiteArray[700].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[701].call(callSiteArray[702].call((Object)((Response)response2.get()))), callSiteArray[703].callGetProperty((Object)((Response)response2.get())), callSiteArray[704].callGetProperty((Object)((Response)response2.get()))}, new String[]{"", " ", " ", ""}));
        public final class _debugResponse_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugResponse_closure6(Object _outerInstance, Object _thisObject, Reference response) {
                Reference reference;
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.response.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Response getResponse() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return (Response)ScriptBytecodeAdapter.castToType((Object)this.response.get(), Response.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugResponse_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugResponse_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugResponse_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugResponse_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[705].call(callSiteArray[706].call(callSiteArray[707].call((Object)((Response)response2.get()))), (Object)new _debugResponse_closure6(SaagieUtils.class, SaagieUtils.class, response2));
    }

    public static Object throwAndLogError(Object l, Object message) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[708].call(l, message);
        throw (Throwable)callSiteArray[709].callConstructor(GradleException.class, message);
    }

    public static String convertScheduleV1ToCron(String cronString) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)cronString)) {
            return ShortTypeHandling.castToString(null);
        }
        int startPeriod = DefaultTypeTransformation.intUnbox((Object)callSiteArray[710].call((Object)cronString, (Object)"/", callSiteArray[711].call(callSiteArray[712].call((Object)cronString, (Object)"/"), (Object)1)));
        if (!(startPeriod != 0)) {
            callSiteArray[713].callStatic(SaagieUtils.class, (Object)"Can't parse cronString, couldn t find '/'");
        }
        String startDate = ShortTypeHandling.castToString((Object)callSiteArray[714].call((Object)cronString, callSiteArray[715].call(callSiteArray[716].call((Object)cronString, (Object)"/"), (Object)1), (Object)startPeriod));
        String cronPeriod = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[717].call((Object)cronString, callSiteArray[718].call((Object)startPeriod, (Object)1), callSiteArray[719].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[720].call((Object)cronString, (Object)(startPeriod + 1), callSiteArray[721].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        }
        Date cronDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[722].call(Date.class, callSiteArray[723].call(callSiteArray[724].call(ZonedDateTime.class, (Object)startDate, callSiteArray[725].call(callSiteArray[726].callGetProperty(DateTimeFormatter.class), callSiteArray[727].callGetProperty(ZoneOffset.class))))), Date.class);
        PeriodDuration period = (PeriodDuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[728].call(PeriodDuration.class, (Object)cronPeriod), PeriodDuration.class);
        Object minutes = null;
        Object hours = null;
        Object dayOfMonths = null;
        Object months = null;
        Object time = callSiteArray[729].callGetProperty(callSiteArray[730].callGetProperty(UnitTime.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[731].callGetProperty(callSiteArray[732].call((Object)period)))) {
            Object object;
            Object object2;
            time = object2 = callSiteArray[733].callGetProperty(callSiteArray[734].callGetProperty(UnitTime.class));
            months = object = callSiteArray[735].call((Object)"*/", callSiteArray[736].callGetProperty(callSiteArray[737].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[738].callGetProperty(callSiteArray[739].callGetProperty(UnitTime.class)))) {
            Object object;
            months = object = callSiteArray[740].call(callSiteArray[741].callGetProperty((Object)cronDate));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[742].callGetProperty(callSiteArray[743].call((Object)period)))) {
            Object object;
            Object object3;
            time = object3 = callSiteArray[744].callGetProperty(callSiteArray[745].callGetProperty(UnitTime.class));
            dayOfMonths = object = callSiteArray[746].call((Object)"*/", callSiteArray[747].callGetProperty(callSiteArray[748].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[749].callGetProperty(callSiteArray[750].callGetProperty(UnitTime.class)))) {
            Object object;
            dayOfMonths = object = callSiteArray[751].call(callSiteArray[752].callGetProperty((Object)cronDate));
        }
        Object hoursTest = callSiteArray[753].call(callSiteArray[754].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[755].call(callSiteArray[756].call((Object)period)))) {
            Object object;
            Object object4;
            time = object4 = callSiteArray[757].callGetProperty(callSiteArray[758].callGetProperty(UnitTime.class));
            hours = object = callSiteArray[759].call((Object)"*/", hoursTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[760].callGetProperty(callSiteArray[761].callGetProperty(UnitTime.class)))) {
            Object object;
            hours = object = callSiteArray[762].call(callSiteArray[763].callGetProperty((Object)cronDate));
        }
        Object minutesTest = callSiteArray[764].call(callSiteArray[765].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[766].call(callSiteArray[767].call((Object)period))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[768].call(callSiteArray[769].call((Object)period)))) {
            Object object;
            Object object5;
            time = object5 = callSiteArray[770].callGetProperty(callSiteArray[771].callGetProperty(UnitTime.class));
            minutes = object = callSiteArray[772].call((Object)"* / ", minutesTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[773].callGetProperty(callSiteArray[774].callGetProperty(UnitTime.class)))) {
            Object object;
            minutes = object = callSiteArray[775].call(callSiteArray[776].callGetProperty((Object)cronDate));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[777].callStatic(SaagieUtils.class, minutes, hours, dayOfMonths, months));
    }

    public static String generateCronExpression(String minutes, String hours, String dayOfMonth, String month) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[778].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)callSiteArray[779].callStatic(SaagieUtils.class, (Object)minutes), (Object)callSiteArray[780].callStatic(SaagieUtils.class, (Object)hours), (Object)callSiteArray[781].callStatic(SaagieUtils.class, (Object)dayOfMonth), (Object)callSiteArray[782].callStatic(SaagieUtils.class, (Object)month), (Object)"*")));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[783].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)SaagieUtils.getValueOrStar(minutes), (Object)SaagieUtils.getValueOrStar(hours), (Object)SaagieUtils.getValueOrStar(dayOfMonth), (Object)SaagieUtils.getValueOrStar(month), (Object)"*")));
    }

    private static Object getValueOrStar(String value) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? value : "*";
    }

    @Generated
    public static String gq(String request, String vars) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, vars, null);
        }
        return SaagieUtils.gq(request, vars, null);
    }

    @Generated
    public static String gq(String request) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, null, null);
        }
        return SaagieUtils.gq(request, null, null);
    }

    @Deprecated
    @Generated
    public Request getUploadFileToJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getUploadFileToJobRequest(jobId, "1");
        }
        return this.getUploadFileToJobRequest(jobId, "1");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaagieUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SaagieUtils.$getCallSiteArray()[784].call(Logging.class, SaagieUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = SaagieUtils.$getCallSiteArray()[785].call(MediaType.class, (Object)"application/json; charset=utf-8");
        JSON = (MediaType)ScriptBytecodeAdapter.castToType((Object)object2, MediaType.class);
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                callSiteArray[0].call((Object)l, (Object)"Checking server response");
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(response))) {
                    callSiteArray[2].call((Object)l, (Object)"No error in server response.");
                    return null;
                }
                String body = ShortTypeHandling.castToString((Object)callSiteArray[3].call(callSiteArray[4].call(response)));
                callSiteArray[5].callStatic(SaagieUtils.class, response);
                String status = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[6].call(response)}, new String[]{"", ""}));
                GStringImpl message = new GStringImpl(new Object[]{status, body}, new String[]{"Error ", " when requesting \n", ""});
                callSiteArray[7].call((Object)l, (Object)message);
                throw (Throwable)callSiteArray[8].callConstructor(GradleException.class, (Object)message);
            }

            public Object call(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                return callSiteArray[9].callCurrent((GroovyObject)this, (Object)l, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "successful";
                stringArray[2] = "debug";
                stringArray[3] = "string";
                stringArray[4] = "body";
                stringArray[5] = "debugResponse";
                stringArray[6] = "code";
                stringArray[7] = "error";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                __clinit__closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure7 __clinit__closure72 = new __clinit__closure7(SaagieUtils.class, SaagieUtils.class);
        handleErrorClosure = __clinit__closure72;
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static MediaType getJSON() {
        return JSON;
    }

    @Generated
    public DataOpsExtension getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(DataOpsExtension dataOpsExtension) {
        this.configuration = dataOpsExtension;
    }

    @Generated
    public static Object getHandleErrorClosure() {
        return handleErrorClosure;
    }

    @Generated
    public static void setHandleErrorClosure(Object object) {
        handleErrorClosure = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "debug";
        stringArray[1] = "debug";
        stringArray[2] = "debug";
        stringArray[3] = "debug";
        stringArray[4] = "replaceAll";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "debug";
        stringArray[9] = "debug";
        stringArray[10] = "gq";
        stringArray[11] = "buildRequestFromQuery";
        stringArray[12] = "getProjectJobsRequestBuild";
        stringArray[13] = "getProjectJobsRequestBuild";
        stringArray[14] = "project";
        stringArray[15] = "debug";
        stringArray[16] = "id";
        stringArray[17] = "build";
        stringArray[18] = "excludeNulls";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "toJson";
        stringArray[21] = "id";
        stringArray[22] = "gq";
        stringArray[23] = "buildRequestFromQuery";
        stringArray[24] = "any";
        stringArray[25] = "debug";
        stringArray[26] = "build";
        stringArray[27] = "excludeNulls";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "toJson";
        stringArray[30] = "gq";
        stringArray[31] = "buildRequestFromQuery";
        stringArray[32] = "project";
        stringArray[33] = "debug";
        stringArray[34] = "id";
        stringArray[35] = "build";
        stringArray[36] = "excludeNulls";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "toJson";
        stringArray[39] = "id";
        stringArray[40] = "gq";
        stringArray[41] = "buildRequestFromQuery";
        stringArray[42] = "project";
        stringArray[43] = "debug";
        stringArray[44] = "id";
        stringArray[45] = "build";
        stringArray[46] = "excludeNulls";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "toJson";
        stringArray[49] = "id";
        stringArray[50] = "gq";
        stringArray[51] = "buildRequestFromQuery";
        stringArray[52] = "project";
        stringArray[53] = "debug";
        stringArray[54] = "id";
        stringArray[55] = "build";
        stringArray[56] = "excludeNulls";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "toJson";
        stringArray[59] = "id";
        stringArray[60] = "gq";
        stringArray[61] = "buildRequestFromQuery";
        stringArray[62] = "server";
        stringArray[63] = "debug";
        stringArray[64] = "build";
        stringArray[65] = "get";
        stringArray[66] = "url";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "url";
        stringArray[69] = "environment";
        stringArray[70] = "debugRequest";
        stringArray[71] = "plus";
        stringArray[72] = "minus";
        stringArray[73] = "minus";
        stringArray[74] = "server";
        stringArray[75] = "debug";
        stringArray[76] = "newBuilder";
        stringArray[77] = "parse";
        stringArray[78] = "url";
        stringArray[79] = "environment";
        stringArray[80] = "addQueryParameter";
        stringArray[81] = "addQueryParameter";
        stringArray[82] = "build";
        stringArray[83] = "url";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "build";
        stringArray[86] = "debugRequest";
        stringArray[87] = "server";
        stringArray[88] = "debug";
        stringArray[89] = "build";
        stringArray[90] = "get";
        stringArray[91] = "url";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "url";
        stringArray[94] = "environment";
        stringArray[95] = "debugRequest";
        stringArray[96] = "project";
        stringArray[97] = "debug";
        stringArray[98] = "id";
        stringArray[99] = "build";
        stringArray[100] = "excludeNulls";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "toJson";
        stringArray[103] = "gq";
        stringArray[104] = "buildRequestFromQuery";
        stringArray[105] = "job";
        stringArray[106] = "jobVersion";
        stringArray[107] = "mapJobAndJobVersionWithoutMail";
        stringArray[108] = "id";
        stringArray[109] = "project";
        stringArray[110] = "debug";
        stringArray[111] = "build";
        stringArray[112] = "excludeFieldsByName";
        stringArray[113] = "excludeNulls";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "toJson";
        stringArray[116] = "job";
        stringArray[117] = "jobVersion";
        stringArray[118] = "gq";
        stringArray[119] = "buildRequestFromQuery";
        stringArray[120] = "job";
        stringArray[121] = "jobVersion";
        stringArray[122] = "mapJobAndJobVersionWithoutMail";
        stringArray[123] = "id";
        stringArray[124] = "project";
        stringArray[125] = "debug";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "name";
        stringArray[128] = "packageInfo";
        stringArray[129] = "debug";
        stringArray[130] = "absolutePath";
        stringArray[131] = "build";
        stringArray[132] = "addConverter";
        stringArray[133] = "excludeNulls";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "toJson";
        stringArray[136] = "job";
        stringArray[137] = "jobVersion";
        stringArray[138] = "absolutePath";
        stringArray[139] = "packageInfo";
        stringArray[140] = "reverse";
        stringArray[141] = "drop";
        stringArray[142] = "reverse";
        stringArray[143] = "gq";
        stringArray[144] = "buildMultipartRequestFromQuery";
        stringArray[145] = "job";
        stringArray[146] = "mapJobWithoutMail";
        stringArray[147] = "id";
        stringArray[148] = "project";
        stringArray[149] = "debug";
        stringArray[150] = "build";
        stringArray[151] = "excludeNulls";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "toJson";
        stringArray[154] = "getProjectUpdateJobRequestFormat";
        stringArray[155] = "job";
        stringArray[156] = "mapJobWithoutMail";
        stringArray[157] = "id";
        stringArray[158] = "project";
        stringArray[159] = "getProjectUpdateJobFromDataRequestFromParams";
        stringArray[160] = "job";
        stringArray[161] = "build";
        stringArray[162] = "excludeNulls";
        stringArray[163] = "<$constructor$>";
        stringArray[164] = "getFormatForUpdateJob";
        stringArray[165] = "toJson";
        stringArray[166] = "getProjectUpdateJobRequestFormat";
        stringArray[167] = "gq";
        stringArray[168] = "buildRequestFromQuery";
        stringArray[169] = "job";
        stringArray[170] = "jobVersion";
        stringArray[171] = "debug";
        stringArray[172] = "id";
        stringArray[173] = "build";
        stringArray[174] = "excludeNulls";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "toJson";
        stringArray[177] = "id";
        stringArray[178] = "toMap";
        stringArray[179] = "gq";
        stringArray[180] = "buildRequestFromQuery";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "add";
        stringArray[183] = "add";
        stringArray[184] = "add";
        stringArray[185] = "removeAll";
        stringArray[186] = "keySet";
        stringArray[187] = "job";
        stringArray[188] = "jobVersion";
        stringArray[189] = "debug";
        stringArray[190] = "id";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "name";
        stringArray[193] = "packageInfo";
        stringArray[194] = "debug";
        stringArray[195] = "absolutePath";
        stringArray[196] = "build";
        stringArray[197] = "excludeNulls";
        stringArray[198] = "<$constructor$>";
        stringArray[199] = "toJson";
        stringArray[200] = "id";
        stringArray[201] = "toMap";
        stringArray[202] = "absolutePath";
        stringArray[203] = "packageInfo";
        stringArray[204] = "reverse";
        stringArray[205] = "drop";
        stringArray[206] = "reverse";
        stringArray[207] = "gq";
        stringArray[208] = "buildMultipartRequestFromQuery";
        stringArray[209] = "job";
        stringArray[210] = "jobVersion";
        stringArray[211] = "debug";
        stringArray[212] = "id";
        stringArray[213] = "excludeFieldsByName";
        stringArray[214] = "excludeNulls";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "downloadUrl";
        stringArray[217] = "packageInfo";
        stringArray[218] = "jobVersion";
        stringArray[219] = "excludeFieldsByName";
        stringArray[220] = "build";
        stringArray[221] = "toJson";
        stringArray[222] = "id";
        stringArray[223] = "toMap";
        stringArray[224] = "gq";
        stringArray[225] = "buildRequestFromQuery";
        stringArray[226] = "debug";
        stringArray[227] = "<$constructor$>";
        stringArray[228] = "name";
        stringArray[229] = "packageInfo";
        stringArray[230] = "jobVersion";
        stringArray[231] = "<$constructor$>";
        stringArray[232] = "detect";
        stringArray[233] = "debug";
        stringArray[234] = "parse";
        stringArray[235] = "debug";
        stringArray[236] = "absolutePath";
        stringArray[237] = "build";
        stringArray[238] = "addFormDataPart";
        stringArray[239] = "setType";
        stringArray[240] = "<$constructor$>";
        stringArray[241] = "FORM";
        stringArray[242] = "name";
        stringArray[243] = "create";
        stringArray[244] = "server";
        stringArray[245] = "jwt";
        stringArray[246] = "debug";
        stringArray[247] = "realm";
        stringArray[248] = "token";
        stringArray[249] = "build";
        stringArray[250] = "post";
        stringArray[251] = "addHeader";
        stringArray[252] = "addHeader";
        stringArray[253] = "addHeader";
        stringArray[254] = "url";
        stringArray[255] = "<$constructor$>";
        stringArray[256] = "url";
        stringArray[257] = "server";
        stringArray[258] = "environment";
        stringArray[259] = "server";
        stringArray[260] = "id";
        stringArray[261] = "project";
        stringArray[262] = "debug";
        stringArray[263] = "build";
        stringArray[264] = "post";
        stringArray[265] = "addHeader";
        stringArray[266] = "addHeader";
        stringArray[267] = "addHeader";
        stringArray[268] = "url";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "url";
        stringArray[271] = "server";
        stringArray[272] = "environment";
        stringArray[273] = "server";
        stringArray[274] = "id";
        stringArray[275] = "project";
        stringArray[276] = "getCredentials";
        stringArray[277] = "build";
        stringArray[278] = "post";
        stringArray[279] = "addHeader";
        stringArray[280] = "addHeader";
        stringArray[281] = "addHeader";
        stringArray[282] = "url";
        stringArray[283] = "<$constructor$>";
        stringArray[284] = "url";
        stringArray[285] = "server";
        stringArray[286] = "environment";
        stringArray[287] = "server";
        stringArray[288] = "id";
        stringArray[289] = "project";
        stringArray[290] = "job";
        stringArray[291] = "debug";
        stringArray[292] = "id";
        stringArray[293] = "build";
        stringArray[294] = "excludeNulls";
        stringArray[295] = "<$constructor$>";
        stringArray[296] = "toJson";
        stringArray[297] = "id";
        stringArray[298] = "gq";
        stringArray[299] = "buildRequestFromQuery";
        stringArray[300] = "deleteDir";
        stringArray[301] = "warn";
        stringArray[302] = "warn";
        stringArray[303] = "message";
        stringArray[304] = "project";
        stringArray[305] = "pipeline";
        stringArray[306] = "pipelineVersion";
        stringArray[307] = "debug";
        stringArray[308] = "id";
        stringArray[309] = "build";
        stringArray[310] = "excludeNulls";
        stringArray[311] = "<$constructor$>";
        stringArray[312] = "toMap";
        stringArray[313] = "toMap";
        stringArray[314] = "id";
        stringArray[315] = "jobs";
        stringArray[316] = "releaseNote";
        stringArray[317] = "toJson";
        stringArray[318] = "gq";
        stringArray[319] = "buildRequestFromQuery";
        stringArray[320] = "jobinstance";
        stringArray[321] = "debug";
        stringArray[322] = "id";
        stringArray[323] = "build";
        stringArray[324] = "excludeNulls";
        stringArray[325] = "<$constructor$>";
        stringArray[326] = "toJson";
        stringArray[327] = "id";
        stringArray[328] = "gq";
        stringArray[329] = "buildRequestFromQuery";
        stringArray[330] = "pipelineinstance";
        stringArray[331] = "debug";
        stringArray[332] = "id";
        stringArray[333] = "getProjectPipelineInstanceStatusRequestWithparam";
        stringArray[334] = "id";
        stringArray[335] = "build";
        stringArray[336] = "excludeNulls";
        stringArray[337] = "<$constructor$>";
        stringArray[338] = "toJson";
        stringArray[339] = "gq";
        stringArray[340] = "buildRequestFromQuery";
        stringArray[341] = "pipeline";
        stringArray[342] = "debug";
        stringArray[343] = "id";
        stringArray[344] = "build";
        stringArray[345] = "excludeNulls";
        stringArray[346] = "<$constructor$>";
        stringArray[347] = "toJson";
        stringArray[348] = "toMap";
        stringArray[349] = "gq";
        stringArray[350] = "buildRequestFromQuery";
        stringArray[351] = "pipeline";
        stringArray[352] = "pipelineVersion";
        stringArray[353] = "getAddPipelineVersionRequestFromParams";
        stringArray[354] = "debug";
        stringArray[355] = "id";
        stringArray[356] = "build";
        stringArray[357] = "excludeNulls";
        stringArray[358] = "<$constructor$>";
        stringArray[359] = "toJson";
        stringArray[360] = "id";
        stringArray[361] = "jobs";
        stringArray[362] = "releaseNote";
        stringArray[363] = "gq";
        stringArray[364] = "buildRequestFromQuery";
        stringArray[365] = "pipeline";
        stringArray[366] = "debug";
        stringArray[367] = "id";
        stringArray[368] = "build";
        stringArray[369] = "excludeNulls";
        stringArray[370] = "<$constructor$>";
        stringArray[371] = "toJson";
        stringArray[372] = "id";
        stringArray[373] = "gq";
        stringArray[374] = "buildRequestFromQuery";
        stringArray[375] = "pipeline";
        stringArray[376] = "debug";
        stringArray[377] = "id";
        stringArray[378] = "build";
        stringArray[379] = "excludeNulls";
        stringArray[380] = "<$constructor$>";
        stringArray[381] = "toJson";
        stringArray[382] = "id";
        stringArray[383] = "gq";
        stringArray[384] = "buildRequestFromQuery";
        stringArray[385] = "job";
        stringArray[386] = "debug";
        stringArray[387] = "id";
        stringArray[388] = "build";
        stringArray[389] = "excludeNulls";
        stringArray[390] = "<$constructor$>";
        stringArray[391] = "toJson";
        stringArray[392] = "id";
        stringArray[393] = "gq";
        stringArray[394] = "buildRequestFromQuery";
        stringArray[395] = "pipelineinstance";
        stringArray[396] = "debug";
        stringArray[397] = "id";
        stringArray[398] = "build";
        stringArray[399] = "excludeNulls";
        stringArray[400] = "<$constructor$>";
        stringArray[401] = "toJson";
        stringArray[402] = "id";
        stringArray[403] = "gq";
        stringArray[404] = "buildRequestFromQuery";
        stringArray[405] = "debug";
        stringArray[406] = "build";
        stringArray[407] = "get";
        stringArray[408] = "addHeader";
        stringArray[409] = "url";
        stringArray[410] = "<$constructor$>";
        stringArray[411] = "url";
        stringArray[412] = "server";
        stringArray[413] = "getCredentials";
        stringArray[414] = "build";
        stringArray[415] = "get";
        stringArray[416] = "addHeader";
        stringArray[417] = "url";
        stringArray[418] = "<$constructor$>";
        stringArray[419] = "url";
        stringArray[420] = "server";
        stringArray[421] = "debugRequest";
        stringArray[422] = "jobinstance";
        stringArray[423] = "debug";
        stringArray[424] = "id";
        stringArray[425] = "build";
        stringArray[426] = "excludeNulls";
        stringArray[427] = "<$constructor$>";
        stringArray[428] = "toJson";
        stringArray[429] = "id";
        stringArray[430] = "gq";
        stringArray[431] = "buildRequestFromQuery";
        stringArray[432] = "prettyPrint";
        stringArray[433] = "debug";
        stringArray[434] = "<$constructor$>";
        stringArray[435] = "name";
        stringArray[436] = "packageInfo";
        stringArray[437] = "jobVersion";
        stringArray[438] = "name";
        stringArray[439] = "debug";
        stringArray[440] = "absolutePath";
        stringArray[441] = "build";
        stringArray[442] = "excludeNulls";
        stringArray[443] = "<$constructor$>";
        stringArray[444] = "toJson";
        stringArray[445] = "create";
        stringArray[446] = "parse";
        stringArray[447] = "build";
        stringArray[448] = "addFormDataPart";
        stringArray[449] = "addFormDataPart";
        stringArray[450] = "addFormDataPart";
        stringArray[451] = "setType";
        stringArray[452] = "<$constructor$>";
        stringArray[453] = "FORM";
        stringArray[454] = "create";
        stringArray[455] = "create";
        stringArray[456] = "server";
        stringArray[457] = "jwt";
        stringArray[458] = "debug";
        stringArray[459] = "realm";
        stringArray[460] = "token";
        stringArray[461] = "build";
        stringArray[462] = "post";
        stringArray[463] = "addHeader";
        stringArray[464] = "addHeader";
        stringArray[465] = "addHeader";
        stringArray[466] = "url";
        stringArray[467] = "<$constructor$>";
        stringArray[468] = "url";
        stringArray[469] = "server";
        stringArray[470] = "environment";
        stringArray[471] = "server";
        stringArray[472] = "debug";
        stringArray[473] = "build";
        stringArray[474] = "post";
        stringArray[475] = "addHeader";
        stringArray[476] = "addHeader";
        stringArray[477] = "addHeader";
        stringArray[478] = "url";
        stringArray[479] = "<$constructor$>";
        stringArray[480] = "url";
        stringArray[481] = "server";
        stringArray[482] = "environment";
        stringArray[483] = "server";
        stringArray[484] = "getCredentials";
        stringArray[485] = "build";
        stringArray[486] = "post";
        stringArray[487] = "addHeader";
        stringArray[488] = "addHeader";
        stringArray[489] = "addHeader";
        stringArray[490] = "url";
        stringArray[491] = "<$constructor$>";
        stringArray[492] = "url";
        stringArray[493] = "server";
        stringArray[494] = "environment";
        stringArray[495] = "server";
        stringArray[496] = "debugRequest";
        stringArray[497] = "server";
        stringArray[498] = "debug";
        stringArray[499] = "realm";
        stringArray[500] = "token";
        stringArray[501] = "debug";
        stringArray[502] = "build";
        stringArray[503] = "get";
        stringArray[504] = "addHeader";
        stringArray[505] = "addHeader";
        stringArray[506] = "url";
        stringArray[507] = "<$constructor$>";
        stringArray[508] = "url";
        stringArray[509] = "server";
        stringArray[510] = "environment";
        stringArray[511] = "server";
        stringArray[512] = "toUpperCase";
        stringArray[513] = "toLowerCase";
        stringArray[514] = "debugRequest";
        stringArray[515] = "project";
        stringArray[516] = "debug";
        stringArray[517] = "id";
        stringArray[518] = "build";
        stringArray[519] = "excludeNulls";
        stringArray[520] = "<$constructor$>";
        stringArray[521] = "toJson";
        stringArray[522] = "id";
        stringArray[523] = "gq";
        stringArray[524] = "buildRequestFromQuery";
        stringArray[525] = "debug";
        stringArray[526] = "gq";
        stringArray[527] = "buildRequestFromQuery";
        stringArray[528] = "getPlatformListRequest";
        stringArray[529] = "project";
        stringArray[530] = "debug";
        stringArray[531] = "name";
        stringArray[532] = "build";
        stringArray[533] = "excludeNulls";
        stringArray[534] = "<$constructor$>";
        stringArray[535] = "toJson";
        stringArray[536] = "toMap";
        stringArray[537] = "gq";
        stringArray[538] = "buildRequestFromQuery";
        stringArray[539] = "job";
        stringArray[540] = "getJobDetailRequestFromParam";
        stringArray[541] = "id";
        stringArray[542] = "debug";
        stringArray[543] = "build";
        stringArray[544] = "excludeNulls";
        stringArray[545] = "<$constructor$>";
        stringArray[546] = "toJson";
        stringArray[547] = "gq";
        stringArray[548] = "buildRequestFromQuery";
        stringArray[549] = "server";
        stringArray[550] = "debug";
        stringArray[551] = "build";
        stringArray[552] = "get";
        stringArray[553] = "url";
        stringArray[554] = "<$constructor$>";
        stringArray[555] = "url";
        stringArray[556] = "environment";
        stringArray[557] = "debugRequest";
        stringArray[558] = "project";
        stringArray[559] = "job";
        stringArray[560] = "debug";
        stringArray[561] = "id";
        stringArray[562] = "id";
        stringArray[563] = "build";
        stringArray[564] = "excludeNulls";
        stringArray[565] = "<$constructor$>";
        stringArray[566] = "toJson";
        stringArray[567] = "id";
        stringArray[568] = "gq";
        stringArray[569] = "buildRequestFromQuery";
        stringArray[570] = "project";
        stringArray[571] = "debug";
        stringArray[572] = "id";
        stringArray[573] = "build";
        stringArray[574] = "excludeNulls";
        stringArray[575] = "<$constructor$>";
        stringArray[576] = "toJson";
        stringArray[577] = "toMap";
        stringArray[578] = "gq";
        stringArray[579] = "buildRequestFromQuery";
        stringArray[580] = "project";
        stringArray[581] = "debug";
        stringArray[582] = "build";
        stringArray[583] = "excludeNulls";
        stringArray[584] = "<$constructor$>";
        stringArray[585] = "toJson";
        stringArray[586] = "gq";
        stringArray[587] = "buildRequestFromQuery";
        stringArray[588] = "debug";
        stringArray[589] = "create";
        stringArray[590] = "server";
        stringArray[591] = "jwt";
        stringArray[592] = "debug";
        stringArray[593] = "realm";
        stringArray[594] = "token";
        stringArray[595] = "build";
        stringArray[596] = "post";
        stringArray[597] = "addHeader";
        stringArray[598] = "url";
        stringArray[599] = "<$constructor$>";
        stringArray[600] = "url";
        stringArray[601] = "server";
        stringArray[602] = "environment";
        stringArray[603] = "server";
        stringArray[604] = "debug";
        stringArray[605] = "build";
        stringArray[606] = "post";
        stringArray[607] = "addHeader";
        stringArray[608] = "url";
        stringArray[609] = "<$constructor$>";
        stringArray[610] = "url";
        stringArray[611] = "server";
        stringArray[612] = "environment";
        stringArray[613] = "server";
        stringArray[614] = "getCredentials";
        stringArray[615] = "build";
        stringArray[616] = "post";
        stringArray[617] = "addHeader";
        stringArray[618] = "url";
        stringArray[619] = "<$constructor$>";
        stringArray[620] = "url";
        stringArray[621] = "server";
        stringArray[622] = "environment";
        stringArray[623] = "server";
        stringArray[624] = "debugRequest";
        stringArray[625] = "debug";
        stringArray[626] = "buildRequestForFile";
        stringArray[627] = "execute";
        stringArray[628] = "newCall";
        stringArray[629] = "byteStream";
        stringArray[630] = "body";
        stringArray[631] = "<$constructor$>";
        stringArray[632] = "<$constructor$>";
        stringArray[633] = "plus";
        stringArray[634] = "plus";
        stringArray[635] = "read";
        stringArray[636] = "write";
        stringArray[637] = "plus";
        stringArray[638] = "<$constructor$>";
        stringArray[639] = "message";
        stringArray[640] = "debug";
        stringArray[641] = "close";
        stringArray[642] = "close";
        stringArray[643] = "debug";
        stringArray[644] = "server";
        stringArray[645] = "debug";
        stringArray[646] = "build";
        stringArray[647] = "addHeader";
        stringArray[648] = "url";
        stringArray[649] = "<$constructor$>";
        stringArray[650] = "getCredentials";
        stringArray[651] = "build";
        stringArray[652] = "addHeader";
        stringArray[653] = "url";
        stringArray[654] = "<$constructor$>";
        stringArray[655] = "debugRequest";
        stringArray[656] = "substring";
        stringArray[657] = "plus";
        stringArray[658] = "lastIndexOf";
        stringArray[659] = "length";
        stringArray[660] = "endsWith";
        stringArray[661] = "substring";
        stringArray[662] = "minus";
        stringArray[663] = "length";
        stringArray[664] = "basic";
        stringArray[665] = "login";
        stringArray[666] = "server";
        stringArray[667] = "password";
        stringArray[668] = "server";
        stringArray[669] = "collectEntries";
        stringArray[670] = "findAll";
        stringArray[671] = "declaredFields";
        stringArray[672] = "getClass";
        stringArray[673] = "<$constructor$>";
        stringArray[674] = "iterator";
        stringArray[675] = "contains";
        stringArray[676] = "add";
        stringArray[677] = "debug";
        stringArray[678] = "debug";
        stringArray[679] = "method";
        stringArray[680] = "path";
        stringArray[681] = "url";
        stringArray[682] = "url";
        stringArray[683] = "debug";
        stringArray[684] = "host";
        stringArray[685] = "url";
        stringArray[686] = "url";
        stringArray[687] = "each";
        stringArray[688] = "names";
        stringArray[689] = "headers";
        stringArray[690] = "body";
        stringArray[691] = "debug";
        stringArray[692] = "contentLength";
        stringArray[693] = "body";
        stringArray[694] = "<$constructor$>";
        stringArray[695] = "writeTo";
        stringArray[696] = "body";
        stringArray[697] = "debug";
        stringArray[698] = "readUtf8";
        stringArray[699] = "debug";
        stringArray[700] = "debug";
        stringArray[701] = "toString";
        stringArray[702] = "protocol";
        stringArray[703] = "code";
        stringArray[704] = "message";
        stringArray[705] = "each";
        stringArray[706] = "names";
        stringArray[707] = "headers";
        stringArray[708] = "error";
        stringArray[709] = "<$constructor$>";
        stringArray[710] = "indexOf";
        stringArray[711] = "plus";
        stringArray[712] = "indexOf";
        stringArray[713] = "throwAndLogError";
        stringArray[714] = "substring";
        stringArray[715] = "plus";
        stringArray[716] = "indexOf";
        stringArray[717] = "substring";
        stringArray[718] = "plus";
        stringArray[719] = "length";
        stringArray[720] = "substring";
        stringArray[721] = "length";
        stringArray[722] = "from";
        stringArray[723] = "toInstant";
        stringArray[724] = "parse";
        stringArray[725] = "withZone";
        stringArray[726] = "ISO_ZONED_DATE_TIME";
        stringArray[727] = "UTC";
        stringArray[728] = "parse";
        stringArray[729] = "value";
        stringArray[730] = "SECOND";
        stringArray[731] = "months";
        stringArray[732] = "getPeriod";
        stringArray[733] = "value";
        stringArray[734] = "MONTH";
        stringArray[735] = "plus";
        stringArray[736] = "months";
        stringArray[737] = "getPeriod";
        stringArray[738] = "value";
        stringArray[739] = "MONTH";
        stringArray[740] = "toString";
        stringArray[741] = "month";
        stringArray[742] = "days";
        stringArray[743] = "getPeriod";
        stringArray[744] = "value";
        stringArray[745] = "DAYOFMONTH";
        stringArray[746] = "plus";
        stringArray[747] = "days";
        stringArray[748] = "getPeriod";
        stringArray[749] = "value";
        stringArray[750] = "DAYOFMONTH";
        stringArray[751] = "toString";
        stringArray[752] = "day";
        stringArray[753] = "toHours";
        stringArray[754] = "getDuration";
        stringArray[755] = "toHours";
        stringArray[756] = "getDuration";
        stringArray[757] = "value";
        stringArray[758] = "HOUR";
        stringArray[759] = "plus";
        stringArray[760] = "value";
        stringArray[761] = "HOUR";
        stringArray[762] = "toString";
        stringArray[763] = "hours";
        stringArray[764] = "toHours";
        stringArray[765] = "getDuration";
        stringArray[766] = "toMinutes";
        stringArray[767] = "getDuration";
        stringArray[768] = "toHours";
        stringArray[769] = "getDuration";
        stringArray[770] = "value";
        stringArray[771] = "MINUTE";
        stringArray[772] = "plus";
        stringArray[773] = "value";
        stringArray[774] = "MINUTE";
        stringArray[775] = "toString";
        stringArray[776] = "minutes";
        stringArray[777] = "generateCronExpression";
        stringArray[778] = "format";
        stringArray[779] = "getValueOrStar";
        stringArray[780] = "getValueOrStar";
        stringArray[781] = "getValueOrStar";
        stringArray[782] = "getValueOrStar";
        stringArray[783] = "format";
        stringArray[784] = "getLogger";
        stringArray[785] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[786];
        SaagieUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SaagieUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SaagieUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

