/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.plugin.dataops.utils;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.saagie.plugin.dataops.DataOpsExtension;
import io.saagie.plugin.dataops.models.Job;
import io.saagie.plugin.dataops.models.JobInstance;
import io.saagie.plugin.dataops.models.JobMapper;
import io.saagie.plugin.dataops.models.JobVersion;
import io.saagie.plugin.dataops.models.Pipeline;
import io.saagie.plugin.dataops.models.PipelineInstance;
import io.saagie.plugin.dataops.models.PipelineVersion;
import io.saagie.plugin.dataops.models.Project;
import io.saagie.plugin.dataops.models.Server;
import io.saagie.plugin.dataops.tasks.projects.enums.UnitTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.tika.Tika;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.threeten.extra.PeriodDuration;

public class SaagieUtils
implements GroovyObject {
    private static final Logger logger;
    private static final MediaType JSON;
    private DataOpsExtension configuration;
    private static Object handleErrorClosure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SaagieUtils(DataOpsExtension configuration) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DataOpsExtension dataOpsExtension = configuration;
        this.configuration = (DataOpsExtension)ScriptBytecodeAdapter.castToType((Object)dataOpsExtension, DataOpsExtension.class);
    }

    public static String gq(String request, String vars, String operationName) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[0].call((Object)logger, (Object)"GraphQL Query:");
        callSiteArray[1].call((Object)logger, (Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)vars)) {
            callSiteArray[2].call((Object)logger, (Object)"GraphQL Variables:");
            callSiteArray[3].call((Object)logger, (Object)vars);
        }
        Object inlinedRequest = callSiteArray[4].call((Object)request, (Object)"\\n", (Object)"");
        Object query = new GStringImpl(new Object[]{inlinedRequest}, new String[]{"{\"query\":\"", "\""});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vars, null)) {
            query = callSiteArray[5].call(query, (Object)new GStringImpl(new Object[]{vars}, new String[]{",\"variables\":", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)operationName)) {
            query = callSiteArray[6].call(query, (Object)new GStringImpl(new Object[]{operationName}, new String[]{",\"operationName\":\"", "\""}));
        }
        query = callSiteArray[7].call(query, (Object)"}");
        callSiteArray[8].call((Object)logger, (Object)"Generated graphql query:\n{}", query);
        return ShortTypeHandling.castToString((Object)query);
    }

    public Request getProjectsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[9].call((Object)logger, (Object)"Generating getProjectsRequest");
        Object listProjectsRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listProjectsRequest = object = callSiteArray[10].callStatic(SaagieUtils.class, (Object)"\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
            listProjectsRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, listProjectsRequest), Request.class);
    }

    public Request getProjectJobsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ");
    }

    public Request getProjectJobsRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        "), Request.class);
        }
        return this.getProjectJobsRequestBuild("\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ");
    }

    public Request getProjectPipelinesRequestGetNameAndId() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[15].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[16].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[20].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[21].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[22].callStatic(SaagieUtils.class, (Object)"\n            query pipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public static boolean isCollectionOrArray(Object object) {
        Reference object2 = new Reference(object);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _isCollectionOrArray_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference object;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isCollectionOrArray_closure1(Object _outerInstance, Object _thisObject, Reference object) {
                Reference reference;
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.object = reference = object;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return callSiteArray[0].call(it, callSiteArray[1].call(this.object.get()));
            }

            public Object getObject() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.object.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _isCollectionOrArray_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isCollectionOrArray_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isAssignableFrom";
                stringArray[1] = "getClass";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _isCollectionOrArray_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isCollectionOrArray_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isCollectionOrArray_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{Collection.class, Object[].class}), (Object)new _isCollectionOrArray_closure1(SaagieUtils.class, SaagieUtils.class, object2)));
    }

    public Request getListTechnologyVersionsRequest(String technologyId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[25].call((Object)logger, (Object)"Generating getListTechnologyVersionsRequest [technology={}]", (Object)technologyId);
        Object jsonGenerator = callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[29].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"technologyId", technologyId}));
        Object listTechnologyVersions = callSiteArray[30].callStatic(SaagieUtils.class, (Object)"\n            query TechnologiesVersions($technologyId: UUID!) {\n            technologiesVersions(technologyId: $technologyId) {\n              versionLabel\n              technologyLabel\n              secondaryTechnologies {\n                   label     isAvailable      versions\n              }\n            }\n          }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callCurrent((GroovyObject)this, listTechnologyVersions), Request.class);
    }

    public Request getProjectJobsRequestBuild(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[33].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[34].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[38].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[39].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[40].callStatic(SaagieUtils.class, (Object)query, gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request archiveProjectRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[43].call((Object)logger, (Object)"Generating archiveProjectRequest [ProjectId={}]", callSiteArray[44].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[48].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[49].callGroovyObjectGetProperty((Object)project)}));
        Object getProjectInstanceStatus = callSiteArray[50].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveProjectMutation($projectId: UUID!) {\n                archiveProject(projectId: $projectId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, getProjectInstanceStatus), Request.class);
    }

    public Request getProjectTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[53].call((Object)logger, (Object)"generating getProjectTechnologiesRequest [projectId={}]", callSiteArray[54].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[58].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[59].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectTechnologies = callSiteArray[60].callStatic(SaagieUtils.class, (Object)"\n            query technologiesQuery($projectId: UUID!) {\n                technologies(projectId: $projectId) {\n                    id\n                    label\n                    isAvailable\n                    icon\n                    features {\n                        field\n                        label\n                        isMandatory\n                        comment\n                        defaultValue\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callCurrent((GroovyObject)this, listProjectTechnologies), Request.class);
    }

    public Request getPipelineRequestFromParamV1(String pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[63].call((Object)logger, (Object)"Generating request in order to get pipeline detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[68].callGroovyObjectGetProperty((Object)server), callSiteArray[69].callGroovyObjectGetProperty((Object)server), pipelineId}, new String[]{"", "/manager/api/v1/platform/", "/workflow/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[70].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPipelineRequestFromParam(Object pipelineId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[72].call((Object)logger, (Object)"generating getPipelineRequest [projectId={}]", callSiteArray[73].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[77].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", pipelineId}));
        Object pipelineResult = callSiteArray[78].callStatic(SaagieUtils.class, (Object)"\n            query pipeline ($pipelineId: UUID!) {\n                pipeline(id: $pipelineId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callCurrent((GroovyObject)this, pipelineResult), Request.class);
    }

    @Deprecated
    public Request getProjectCreateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[83].callGetProperty(callSiteArray[84].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[85].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object jsonGenerator = callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].call(callSiteArray[89].callConstructor(JsonGenerator.Options.class)), (Object)"usePreviousArtifact"));
        Object gqVariables = callSiteArray[90].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[91].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[92].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object createProjectJob = callSiteArray[93].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!) {\n                createJob(job: $job, jobVersion: $jobVersion) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectCreateJobRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        Map mapedJobAndJobVersion = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].call(JobMapper.class, (Object)job, (Object)jobVersion, callSiteArray[98].callGetProperty(callSiteArray[99].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[100].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Reference file = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].callConstructor(File.class, callSiteArray[102].callGetProperty(callSiteArray[103].callGroovyObjectGetProperty((Object)jobVersion))), File.class)));
        callSiteArray[104].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[105].callGetProperty((Object)((File)file.get())));
        public final class _getProjectCreateJobRequestWithGraphQL_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getProjectCreateJobRequestWithGraphQL_closure2(Object _outerInstance, Object _thisObject, Reference file) {
                Reference reference;
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.file = reference = file;
            }

            public Object doCall(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(this.file.get());
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)value), (String)"name");
                return value;
            }

            public Object call(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value);
            }

            public File getFile() {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProjectCreateJobRequestWithGraphQL_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "packageInfo";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProjectCreateJobRequestWithGraphQL_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jsonGenerator = callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].callConstructor(JsonGenerator.Options.class)), JobVersion.class, (Object)new _getProjectCreateJobRequestWithGraphQL_closure2(this, this, file)));
        Object gqVariables = callSiteArray[110].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[111].callGetPropertySafe((Object)mapedJobAndJobVersion), "jobVersion", callSiteArray[112].callGetPropertySafe((Object)mapedJobAndJobVersion)}));
        Object object = callSiteArray[113].callGetProperty((Object)((File)file.get()));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[114].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[115].call(callSiteArray[116].call(callSiteArray[117].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object createProjectJob = callSiteArray[118].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!, $file: Upload) {\n                createJob(job: $job, jobVersion: $jobVersion, file: $file) {\n                    id\n                    name\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectUpdateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].call(JobMapper.class, (Object)job, callSiteArray[122].callGetProperty(callSiteArray[123].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        callSiteArray[124].call((Object)logger, (Object)"Generating getProjectUpdateJobRequest [job={}]", (Object)mappedJob);
        Object jsonGenerator = callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[128].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", mappedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        Map mappedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[131].call(JobMapper.class, (Object)job, callSiteArray[132].callGetProperty(callSiteArray[133].callGroovyObjectGetProperty((Object)this.configuration))), Map.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].callCurrent((GroovyObject)this, callSiteArray[135].callGetProperty((Object)mappedJob)), Request.class);
    }

    public Request getProjectUpdateJobFromDataRequestFromParams(Object job) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[136].call(callSiteArray[137].call(callSiteArray[138].callConstructor(JsonGenerator.Options.class)));
        Map formattedJob = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].callStatic(SaagieUtils.class, job), Map.class);
        Object gqVariables = callSiteArray[140].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", formattedJob}));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callCurrent((GroovyObject)this, gqVariables), Request.class);
    }

    public Request getProjectUpdateJobRequestFormat(String gqVariables) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object updateProjectJob = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            updateProjectJob = object = callSiteArray[142].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", (Object)gqVariables);
        } else {
            String string = SaagieUtils.gq("\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", gqVariables);
            updateProjectJob = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getAddJobVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[146].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[147].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[148].call(callSiteArray[149].call(callSiteArray[150].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[151].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[152].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[153].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[154].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public static Map getFormatForUpdateJob(Map data) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set set = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[156].callConstructor(HashSet.class), Set.class);
        callSiteArray[157].call((Object)set, (Object)"projectId");
        callSiteArray[158].call((Object)set, (Object)"category");
        callSiteArray[159].call((Object)set, (Object)"technology");
        callSiteArray[160].call(callSiteArray[161].call((Object)data), (Object)set);
        return data;
    }

    public Request getAddJobVersionRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[163].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[164].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[165].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object file = callSiteArray[166].callConstructor(File.class, callSiteArray[167].callGetProperty(callSiteArray[168].callGroovyObjectGetProperty((Object)jobVersion)));
        callSiteArray[169].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[170].callGetProperty(file));
        Object jsonGenerator = callSiteArray[171].call(callSiteArray[172].call(callSiteArray[173].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[174].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[175].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[176].call((Object)jobVersion)}));
        Object object = callSiteArray[177].callGetProperty(file);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[178].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object updateProjectJob = callSiteArray[182].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!, $file: Upload) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion, file: $file) {\n                    number\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public Request getAddJobVersionRequestWithoutFile() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[185].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[186].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[187].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGeneratorParams = callSiteArray[188].call(callSiteArray[189].call(callSiteArray[190].callConstructor(JsonGenerator.Options.class)), (Object)"packageInfo");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[191].callGetPropertySafe(callSiteArray[192].callGetProperty(callSiteArray[193].callGroovyObjectGetProperty((Object)this.configuration))))) {
            Object object;
            jsonGeneratorParams = object = callSiteArray[194].call(jsonGeneratorParams, (Object)"usePreviousArtifact");
        }
        Object jsonGenerator = callSiteArray[195].call(jsonGeneratorParams);
        Object gqVariables = callSiteArray[196].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[197].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[198].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[199].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[200].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getUploadFileToJobRequest(String jobId, String jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[201].call((Object)logger, (Object)"Generating getUploadFileToJobRequest [jobId={}, jobVersion={}]", (Object)jobId, (Object)jobVersion);
        Object file = callSiteArray[202].callConstructor(File.class, callSiteArray[203].callGetProperty(callSiteArray[204].callGetProperty(callSiteArray[205].callGroovyObjectGetProperty((Object)this.configuration))));
        Tika tika = (Tika)ScriptBytecodeAdapter.castToType((Object)callSiteArray[206].callConstructor(Tika.class), Tika.class);
        String fileMimeType = ShortTypeHandling.castToString((Object)callSiteArray[207].call((Object)tika, file));
        callSiteArray[208].call((Object)logger, (Object)"Detected file mime type: ", (Object)fileMimeType);
        Object fileType = callSiteArray[209].call(MediaType.class, (Object)fileMimeType);
        callSiteArray[210].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[211].callGetProperty(file));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].call(callSiteArray[213].call(callSiteArray[214].call(callSiteArray[215].callConstructor(MultipartBody.Builder.class), callSiteArray[216].callGetProperty(MultipartBody.class)), (Object)"files", callSiteArray[217].callGetProperty(file), callSiteArray[218].call(RequestBody.class, file, fileType))), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[219].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[220].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[221].call((Object)logger, (Object)"Building upload file request with jwt auth...");
            Object realm = callSiteArray[222].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[223].callGroovyObjectGetProperty((Object)server);
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].call(callSiteArray[227].call(callSiteArray[228].call(callSiteArray[229].call(callSiteArray[230].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[231].callGetProperty(callSiteArray[232].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[233].callGetProperty(callSiteArray[234].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[235].callGetProperty(callSiteArray[236].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/projects/api/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        callSiteArray[237].call((Object)logger, (Object)"Building upload file request with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[238].call(callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call(callSiteArray[242].call(callSiteArray[243].call(callSiteArray[244].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[245].callGetProperty(callSiteArray[246].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[247].callGetProperty(callSiteArray[248].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[249].callGetProperty(callSiteArray[250].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", callSiteArray[251].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].call(callSiteArray[253].call(callSiteArray[254].call(callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].call(callSiteArray[258].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[259].callGetProperty(callSiteArray[260].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[261].callGetProperty(callSiteArray[262].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[263].callGetProperty(callSiteArray[264].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
    }

    public Request getRunProjectJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[265].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[266].call((Object)logger, (Object)"Generating getRunProjectJobRequest for job [id={}]", callSiteArray[267].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[268].call(callSiteArray[269].call(callSiteArray[270].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[271].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[272].callGroovyObjectGetProperty((Object)job)}));
        Object runProjectJobRequest = callSiteArray[273].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($jobId: UUID!) {\n                runJob(jobId: $jobId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[274].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public static Object cleanDirectory(File temp, Logger logger) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object object = callSiteArray[275].call((Object)temp);
        try {
            return object;
        }
        catch (Exception exception) {
            callSiteArray[276].call((Object)logger, (Object)"The directory couldn't be cleaned");
            Object object2 = callSiteArray[277].call((Object)logger, callSiteArray[278].callGetProperty((Object)exception));
            return object2;
        }
    }

    public Request getCreatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[280].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[281].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        callSiteArray[282].call((Object)logger, (Object)"Generating getCreatePipelineRequest for project [projectId={}, pipeline={}, pipelineVersion={}]", callSiteArray[283].callGroovyObjectGetProperty((Object)project), (Object)pipeline, (Object)pipelineVersion);
        Object jsonGenerator = callSiteArray[284].call(callSiteArray[285].call(callSiteArray[286].callConstructor(JsonGenerator.Options.class)));
        Map graphqlPipelineVar = ScriptBytecodeAdapter.createMap((Object[])new Object[]{ScriptBytecodeAdapter.spreadMap((Object)callSiteArray[287].call((Object)pipeline)), callSiteArray[288].call((Object)pipeline), "projectId", callSiteArray[289].callGroovyObjectGetProperty((Object)project), "jobsId", callSiteArray[290].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[291].callGroovyObjectGetProperty((Object)pipelineVersion)});
        Object gqVariables = callSiteArray[292].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", graphqlPipelineVar}));
        Object runProjectJobRequest = callSiteArray[293].callStatic(SaagieUtils.class, (Object)"\n            mutation createPipelineMutation($pipeline: PipelineInput!) {\n                createPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[294].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getProjectJobInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[295].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[296].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[297].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[298].call(callSiteArray[299].call(callSiteArray[300].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[301].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[302].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object getJobInstanceStatus = callSiteArray[303].callStatic(SaagieUtils.class, (Object)"\n            query getJobInstanceStatus($jobId: UUID!) {\n                jobInstance(id: $jobId) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[304].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[305].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[306].call((Object)logger, (Object)"Generating getProjectPipelineInstanceStatusRequest [pipelineInstanceId={}]", callSiteArray[307].callGroovyObjectGetProperty((Object)pipelineinstance));
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[308].callCurrent((GroovyObject)this, callSiteArray[309].callGroovyObjectGetProperty((Object)pipelineinstance)), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequestWithparam(String id) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Object jsonGenerator = callSiteArray[310].call(callSiteArray[311].call(callSiteArray[312].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[313].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", id}));
        Object getPipelineInstanceStatus = callSiteArray[314].callStatic(SaagieUtils.class, (Object)"\n            query getPipelineInstanceStatus($id: UUID!) {\n                pipelineInstance(id: $id) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[315].callCurrent((GroovyObject)this, getPipelineInstanceStatus), Request.class);
    }

    public Request getProjectUpdatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[316].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[317].call((Object)logger, (Object)"Generating getProjectUpdatePipelineRequest [pipelineId={}]", callSiteArray[318].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[319].call(callSiteArray[320].call(callSiteArray[321].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[322].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", callSiteArray[323].call((Object)pipeline)}));
        Object editPipeline = callSiteArray[324].callStatic(SaagieUtils.class, (Object)"\n            mutation editPipelineMutation($pipeline: PipelineEditionInput!) {\n                editPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[325].callCurrent((GroovyObject)this, editPipeline), Request.class);
    }

    public Request getAddPipelineVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[326].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[327].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[328].callCurrent((GroovyObject)this, (Object)pipeline, (Object)pipelineVersion), Request.class);
    }

    public Request getAddPipelineVersionRequestFromParams(Pipeline pipeline, PipelineVersion pipelineVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[329].call((Object)logger, (Object)"Generating getAddPipelineVersionRequest [pipelineId={}]", callSiteArray[330].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[331].call(callSiteArray[332].call(callSiteArray[333].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[334].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[335].callGroovyObjectGetProperty((Object)pipeline), "jobsId", callSiteArray[336].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[337].callGroovyObjectGetProperty((Object)pipelineVersion)}));
        Object addPipelineVersionRequest = callSiteArray[338].callStatic(SaagieUtils.class, (Object)"\n            mutation addPipelineVersionMutation(\n                $pipelineId: UUID!,\n                $jobsId: [UUID!]!,\n                $releaseNote: String,\n            ) {\n                addPipelineVersion(\n                    pipelineId: $pipelineId,\n                    jobsId: $jobsId,\n                    releaseNote: $releaseNote\n                ) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[339].callCurrent((GroovyObject)this, addPipelineVersionRequest), Request.class);
    }

    public Request getProjectRunPipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[340].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[341].call((Object)logger, (Object)"Generating getProjectRunPipelineRequest [pipelineId={}]", callSiteArray[342].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[343].call(callSiteArray[344].call(callSiteArray[345].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[346].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[347].callGroovyObjectGetProperty((Object)pipeline)}));
        Object runPipeline = callSiteArray[348].callStatic(SaagieUtils.class, (Object)"\n            mutation runPipelineMutation($pipelineId: UUID!) {\n                runPipeline(pipelineId: $pipelineId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[349].callCurrent((GroovyObject)this, runPipeline), Request.class);
    }

    public Request getProjectDeletePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[350].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[351].call((Object)logger, (Object)"Generating getProjectDeletePipelineRequest [pipelineId={}]", callSiteArray[352].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[353].call(callSiteArray[354].call(callSiteArray[355].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[356].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[357].callGroovyObjectGetProperty((Object)pipeline)}));
        Object deletePipeline = callSiteArray[358].callStatic(SaagieUtils.class, (Object)"\n            mutation deletePipelineMutation($id: UUID!) {\n                deletePipeline(id: $id)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[359].callCurrent((GroovyObject)this, deletePipeline), Request.class);
    }

    public Request getProjectArchiveJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[360].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[361].call((Object)logger, (Object)"Generating getProjectDeleteJobRequest [jobId={}]", callSiteArray[362].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[363].call(callSiteArray[364].call(callSiteArray[365].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[366].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[367].callGroovyObjectGetProperty((Object)job)}));
        Object getJobInstanceStatus = callSiteArray[368].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveJobMutation($jobId: UUID!) {\n                archiveJob(jobId: $jobId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[369].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectStopPipelineInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[370].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[371].call((Object)logger, (Object)"Generating getProjectStopPipelineInstanceRequest [pipelineinstanceId={}]", callSiteArray[372].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[373].call(callSiteArray[374].call(callSiteArray[375].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[376].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineInstanceId", callSiteArray[377].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getJobInstanceStatus = callSiteArray[378].callStatic(SaagieUtils.class, (Object)"\n            mutation stopPipelineInstanceMutation($pipelineInstanceId: UUID!) {\n                stopPipelineInstance(pipelineInstanceId: $pipelineInstanceId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[379].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getJwtTokenRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[380].call((Object)logger, (Object)"Requesting JWT...");
        Request newRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[381].call(callSiteArray[382].call(callSiteArray[383].call(callSiteArray[384].call(callSiteArray[385].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[386].callGetProperty(callSiteArray[387].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", callSiteArray[388].callCurrent((GroovyObject)this))));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[389].call(callSiteArray[390].call(callSiteArray[391].call(callSiteArray[392].call(callSiteArray[393].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[394].callGetProperty(callSiteArray[395].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", (Object)this.getCredentials())));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[396].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getStopJobInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[397].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[398].call((Object)logger, (Object)"Generating getStopJobInstanceRequest for job instance [id={}]", callSiteArray[399].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[400].call(callSiteArray[401].call(callSiteArray[402].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[403].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobInstanceId", callSiteArray[404].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object runProjectJobRequest = callSiteArray[405].callStatic(SaagieUtils.class, (Object)"\n            mutation stopJobMutation($jobInstanceId: UUID!) {\n                stopJobInstance(jobInstanceId: $jobInstanceId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[406].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    private boolean checkIfStringIsJson(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[407].call(JsonOutput.class, (Object)query);
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
            boolean bl2 = false;
            return bl2;
        }
    }

    private Request buildMultipartRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[408].call((Object)logger, (Object)"Generating multipart request from query=\"{}\"", (Object)query);
        Object file = callSiteArray[409].callConstructor(File.class, callSiteArray[410].callGetProperty(callSiteArray[411].callGetProperty(callSiteArray[412].callGroovyObjectGetProperty((Object)this.configuration))));
        Object fileName = callSiteArray[413].callGetProperty(file);
        callSiteArray[414].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[415].callGetProperty(file));
        Object jsonGenerator = callSiteArray[416].call(callSiteArray[417].call(callSiteArray[418].callConstructor(JsonGenerator.Options.class)));
        Object map = callSiteArray[419].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"0", ScriptBytecodeAdapter.createList((Object[])new Object[]{"variables.file"})}));
        Object fileBody = callSiteArray[420].call(RequestBody.class, file, callSiteArray[421].call(MediaType.class, (Object)"application/octet-stream"));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[422].call(callSiteArray[423].call(callSiteArray[424].call(callSiteArray[425].call(callSiteArray[426].call(callSiteArray[427].callConstructor(MultipartBody.Builder.class, (Object)"--graphql-multipart-upload-boundary-85763456--"), callSiteArray[428].callGetProperty(MultipartBody.class)), (Object)"operations", null, callSiteArray[429].call(RequestBody.class, (Object)query, (Object)JSON)), (Object)"map", null, callSiteArray[430].call(RequestBody.class, map, (Object)JSON)), (Object)"0", fileName, fileBody)), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[431].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[432].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[433].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[434].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[435].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[436].call(callSiteArray[437].call(callSiteArray[438].call(callSiteArray[439].call(callSiteArray[440].call(callSiteArray[441].call(callSiteArray[442].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[443].callGetProperty(callSiteArray[444].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[445].callGetProperty(callSiteArray[446].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[447].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[448].call(callSiteArray[449].call(callSiteArray[450].call(callSiteArray[451].call(callSiteArray[452].call(callSiteArray[453].call(callSiteArray[454].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[455].callGetProperty(callSiteArray[456].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[457].callGetProperty(callSiteArray[458].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[459].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[460].call(callSiteArray[461].call(callSiteArray[462].call(callSiteArray[463].call(callSiteArray[464].call(callSiteArray[465].call(callSiteArray[466].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[467].callGetProperty(callSiteArray[468].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[469].callGetProperty(callSiteArray[470].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[471].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPlatformListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[472].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[473].call((Object)logger, (Object)"Generating request in order to get access rights by platforms");
        String realm = ShortTypeHandling.castToString((Object)callSiteArray[474].callGroovyObjectGetProperty((Object)server));
        String jwtToken = ShortTypeHandling.castToString((Object)callSiteArray[475].callGroovyObjectGetProperty((Object)server));
        callSiteArray[476].call((Object)logger, (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"Using realm=", " and jwt=", ""}));
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[477].call(callSiteArray[478].call(callSiteArray[479].call(callSiteArray[480].call(callSiteArray[481].call(callSiteArray[482].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[483].callGetProperty(callSiteArray[484].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[485].callGetProperty(callSiteArray[486].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/security/api/groups/authorizations/", "/permissions/projects"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{callSiteArray[487].call((Object)realm), jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Saagie-Realm", callSiteArray[488].call((Object)realm)))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[489].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getListAllPipelinesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[490].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[491].call((Object)logger, (Object)"Generating getListAllPipelinesRequest for project [id={}]", callSiteArray[492].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[493].call(callSiteArray[494].call(callSiteArray[495].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[496].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[497].callGroovyObjectGetProperty((Object)project)}));
        Object listAllPipelineRequest = callSiteArray[498].callStatic(SaagieUtils.class, (Object)"\n            query getAllPipelines($projectId: UUID!) {\n                pipelines(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        jobs {\n                          id\n                        }\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[499].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getListAllTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[500].call((Object)logger, (Object)"Generating getListAllTechnologiesRequest");
        Object listAllPipelineRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listAllPipelineRequest = object = callSiteArray[501].callStatic(SaagieUtils.class, (Object)"\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getAllTechnologies {\n                technologies {\n                    id\n                    label\n                    isAvailable\n                }\n            }\n        ");
            listAllPipelineRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[502].callCurrent((GroovyObject)this, listAllPipelineRequest), Request.class);
    }

    public Request getGroupListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[503].callCurrent((GroovyObject)this), Request.class);
        }
        return this.getPlatformListRequest();
    }

    public Request getProjectsCreateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[504].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[505].call((Object)logger, (Object)"Generating getProjectsCreateRequest for creating a new project [name={}]", callSiteArray[506].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[507].call(callSiteArray[508].call(callSiteArray[509].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[510].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[511].call((Object)project)}));
        Object createProjectRequest = callSiteArray[512].callStatic(SaagieUtils.class, (Object)"\n            mutation createProjectMutation($project: ProjectInput!) {\n                createProject(project: $project) {\n                    id\n                    name\n                    description\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].callCurrent((GroovyObject)this, createProjectRequest), Request.class);
    }

    public Request getJobDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[514].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[515].callCurrent((GroovyObject)this, callSiteArray[516].callGroovyObjectGetProperty((Object)job)), Request.class);
    }

    public Request getJobDetailRequestFromParam(Object jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[517].call((Object)logger, (Object)"Generating getJobDetailRequest for getting job detail [id={}]", jobId);
        Object jsonGenerator = callSiteArray[518].call(callSiteArray[519].call(callSiteArray[520].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[521].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object getJobDetailRequest = callSiteArray[522].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                        creationDate\n                        releaseNote\n                        runtimeVersion\n                        packageInfo {\n                            downloadUrl\n                        }\n                        dockerInfo {\n                            image\n                            dockerCredentialsId\n                        }\n                        commandLine\n                        isCurrent\n                        isMajor\n                        creator\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[523].callCurrent((GroovyObject)this, getJobDetailRequest), Request.class);
    }

    public Request getJobDetailRequestFromParamV1(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[524].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[525].call((Object)logger, (Object)"Generating request in order to get job detail from V1");
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[526].call(callSiteArray[527].call(callSiteArray[528].call(callSiteArray[529].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[530].callGroovyObjectGetProperty((Object)server), callSiteArray[531].callGroovyObjectGetProperty((Object)server), jobId}, new String[]{"", "/manager/api/v1/platform/", "/job/", ""})))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[532].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getJobVersionDetailRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[533].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[534].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[535].call((Object)logger, (Object)"Getting jobVersion for job  [id={}] with project Id [id={}]", callSiteArray[536].callGroovyObjectGetProperty((Object)project), callSiteArray[537].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[538].call(callSiteArray[539].call(callSiteArray[540].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[541].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[542].callGroovyObjectGetProperty((Object)job), "number", 1}));
        Object getJobVersionRequest = callSiteArray[543].callStatic(SaagieUtils.class, (Object)"\n            query jobVersion($jobId: UUID!, $number: Int!) {\n                jobVersion(jobId: $jobId, number: $number) {\n                    commandLine\n                    dockerInfo {\n                        image\n                        dockerCredentialsId\n                    }\n                    releaseNote\n                    runtimeVersion\n                    packageInfo {\n                        name\n                        downloadUrl\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[544].callCurrent((GroovyObject)this, getJobVersionRequest), Request.class);
    }

    public Request getProjectsUpdateRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[545].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[546].call((Object)logger, (Object)"Generating getProjectsUpdateRequest for updating a new project [id={}]", callSiteArray[547].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[548].call(callSiteArray[549].call(callSiteArray[550].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[551].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", callSiteArray[552].call((Object)project)}));
        Object updateProjectRequest = callSiteArray[553].callStatic(SaagieUtils.class, (Object)"\n            mutation editProjectMutation($project: ProjectEditionInput!) {\n                editProject(project: $project) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[554].callCurrent((GroovyObject)this, updateProjectRequest), Request.class);
    }

    public Request getListVersionForJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[555].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[556].call((Object)logger, (Object)"Generating getListVersionForJobRequest for getting list a new job [id={}]", (Object)jobId);
        Object jsonGenerator = callSiteArray[557].call(callSiteArray[558].call(callSiteArray[559].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[560].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", jobId}));
        Object listVersionForAJobRequest = callSiteArray[561].callStatic(SaagieUtils.class, (Object)"\n           query job($jobId: UUID!) {\n                job(id: $jobId) {\n                    versions {\n                        number\n                        isCurrent\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[562].callCurrent((GroovyObject)this, listVersionForAJobRequest), Request.class);
    }

    private Request buildRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[563].call((Object)logger, (Object)"Generating request from query=\"{}\"", (Object)query);
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[564].call(RequestBody.class, (Object)query, (Object)JSON), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[565].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[566].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[567].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[568].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[569].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[570].call(callSiteArray[571].call(callSiteArray[572].call(callSiteArray[573].call(callSiteArray[574].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[575].callGetProperty(callSiteArray[576].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[577].callGetProperty(callSiteArray[578].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[579].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[580].call(callSiteArray[581].call(callSiteArray[582].call(callSiteArray[583].call(callSiteArray[584].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[585].callGetProperty(callSiteArray[586].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[587].callGetProperty(callSiteArray[588].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[589].callCurrent((GroovyObject)this)), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[590].call(callSiteArray[591].call(callSiteArray[592].call(callSiteArray[593].call(callSiteArray[594].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[595].callGetProperty(callSiteArray[596].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[597].callGetProperty(callSiteArray[598].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[599].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public void downloadFromHTTPSServer(String urlFrom, String to, OkHttpClient client, Object name) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            callSiteArray[600].call((Object)logger, (Object)"Downloading artifiacts ....");
            Request request = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[601].callCurrent((GroovyObject)this, (Object)urlFrom);
                request = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Request request2;
                request = request2 = this.buildRequestForFile(urlFrom);
            }
            Object response = callSiteArray[602].call(callSiteArray[603].call((Object)client, (Object)request));
            Object object = callSiteArray[604].call(callSiteArray[605].call(response));
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
            Object object2 = callSiteArray[606].callConstructor(FileOutputStream.class, callSiteArray[607].callConstructor(File.class, callSiteArray[608].call(callSiteArray[609].call((Object)to, (Object)"/"), name)));
            outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)object2, OutputStream.class);
            byte[] buffer = new byte[2048];
            int length = 0;
            int downloaded = 0;
            while (true) {
                Object object3 = callSiteArray[610].call((Object)inputStream, (Object)buffer);
                length = DefaultTypeTransformation.intUnbox((Object)object3);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)object3, (Object)-1)) {
                    callSiteArray[611].call((Object)outputStream, (Object)buffer, (Object)0, (Object)length);
                    downloaded = DefaultTypeTransformation.intUnbox((Object)callSiteArray[612].call((Object)downloaded, (Object)length));
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw (Throwable)callSiteArray[613].callConstructor(GradleException.class, callSiteArray[614].callGetProperty((Object)ex));
        }
        callSiteArray[615].call((Object)logger, (Object)"Artifacts downloaded.");
        callSiteArray[616].call((Object)outputStream);
        callSiteArray[617].call((Object)inputStream);
    }

    public Request buildRequestForFile(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[618].call((Object)logger, (Object)"Generating request for url=\"{}\"", (Object)url);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[619].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        callSiteArray[620].call((Object)logger, (Object)"Fetching file with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[621].call(callSiteArray[622].call(callSiteArray[623].call(callSiteArray[624].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", callSiteArray[625].callCurrent((GroovyObject)this)));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[626].call(callSiteArray[627].call(callSiteArray[628].call(callSiteArray[629].callConstructor(Request.Builder.class), (Object)url), (Object)"Authorization", (Object)this.getCredentials()));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[630].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public static String getFileNameFromUrl(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[631].call((Object)url, callSiteArray[632].call(callSiteArray[633].call((Object)url, (Object)"/"), (Object)1), callSiteArray[634].call((Object)url)));
    }

    public static Object removeLastSlash(String url) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[635].call((Object)url, (Object)"/"))) {
            Object object = callSiteArray[636].call((Object)url, (Object)0, callSiteArray[637].call(callSiteArray[638].call((Object)url), (Object)1));
            url = ShortTypeHandling.castToString((Object)object);
        }
        return url;
    }

    private String getCredentials() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[639].call(Credentials.class, callSiteArray[640].callGetProperty(callSiteArray[641].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[642].callGetProperty(callSiteArray[643].callGroovyObjectGetProperty((Object)this.configuration))));
    }

    public static Map extractProperties(Object obj) {
        Reference obj2 = new Reference(obj);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _extractProperties_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "synthetic";
                return new CallSiteArray(_extractProperties_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _extractProperties_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference obj;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure4(Object _outerInstance, Object _thisObject, Reference obj) {
                Reference reference;
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.obj = reference = obj;
            }

            public Object doCall(Object field) {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(field), callSiteArray[1].call(this.obj.get(), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(field)}, new String[]{"", ""}))});
            }

            public Object getObj() {
                CallSite[] callSiteArray = _extractProperties_closure4.$getCallSiteArray();
                return this.obj.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getAt";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _extractProperties_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractProperties_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[644].call(callSiteArray[645].call(callSiteArray[646].callGetProperty(callSiteArray[647].call(obj2.get())), (Object)new _extractProperties_closure3(SaagieUtils.class, SaagieUtils.class)), (Object)new _extractProperties_closure4(SaagieUtils.class, SaagieUtils.class, obj2)), Map.class);
    }

    public static boolean distinctValues(int ... arr) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Set foundNumbers = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[648].callConstructor(HashSet.class), Set.class);
        String num = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[649].call((Object)arr), Iterator.class);
        while (iterator.hasNext()) {
            num = ShortTypeHandling.castToString(iterator.next());
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[650].call((Object)foundNumbers, (Object)num))) {
                return false;
            }
            callSiteArray[651].call((Object)foundNumbers, (Object)num);
        }
        return true;
    }

    public static Object debugRequest(Request request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[652].call((Object)logger, (Object)"====== Request ======");
        callSiteArray[653].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[654].callGetProperty((Object)((Request)request2.get())), callSiteArray[655].callGetProperty(callSiteArray[656].call(callSiteArray[657].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"", " ", ""}));
        callSiteArray[658].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[659].callGetProperty(callSiteArray[660].call(callSiteArray[661].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"Host: ", ""}));
        public final class _debugRequest_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugRequest_closure5(Object _outerInstance, Object _thisObject, Reference request) {
                Reference reference;
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference = request;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.request.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Request getRequest() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return (Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), Request.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugRequest_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugRequest_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugRequest_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugRequest_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugRequest_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[662].call(callSiteArray[663].call(callSiteArray[664].call((Object)((Request)request2.get()))), (Object)new _debugRequest_closure5(SaagieUtils.class, SaagieUtils.class, request2));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[665].call((Object)((Request)request2.get())))) {
            callSiteArray[666].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[667].call(callSiteArray[668].call((Object)((Request)request2.get())))}, new String[]{"Content-Length: ", ""}));
            Buffer buffer = (Buffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[669].callConstructor(Buffer.class), Buffer.class);
            callSiteArray[670].call(callSiteArray[671].call((Object)((Request)request2.get())), (Object)buffer);
            return callSiteArray[672].call((Object)logger, callSiteArray[673].call((Object)buffer));
        }
        return null;
    }

    public static Object debugResponse(Response response) {
        Reference response2 = new Reference((Object)response);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[674].call((Object)logger, (Object)"====== Response ======");
        callSiteArray[675].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[676].call(callSiteArray[677].call((Object)((Response)response2.get()))), callSiteArray[678].callGetProperty((Object)((Response)response2.get())), callSiteArray[679].callGetProperty((Object)((Response)response2.get()))}, new String[]{"", " ", " ", ""}));
        public final class _debugResponse_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugResponse_closure6(Object _outerInstance, Object _thisObject, Reference response) {
                Reference reference;
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.response.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Response getResponse() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return (Response)ScriptBytecodeAdapter.castToType((Object)this.response.get(), Response.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugResponse_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugResponse_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugResponse_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugResponse_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugResponse_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[680].call(callSiteArray[681].call(callSiteArray[682].call((Object)((Response)response2.get()))), (Object)new _debugResponse_closure6(SaagieUtils.class, SaagieUtils.class, response2));
    }

    public static Object throwAndLogError(Object l, Object message) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[683].call(l, message);
        throw (Throwable)callSiteArray[684].callConstructor(GradleException.class, message);
    }

    public static String convertScheduleV1ToCron(String cronString) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)cronString)) {
            return ShortTypeHandling.castToString(null);
        }
        int startPeriod = DefaultTypeTransformation.intUnbox((Object)callSiteArray[685].call((Object)cronString, (Object)"/", callSiteArray[686].call(callSiteArray[687].call((Object)cronString, (Object)"/"), (Object)1)));
        if (!(startPeriod != 0)) {
            callSiteArray[688].callStatic(SaagieUtils.class, (Object)"Can't parse cronString, couldn t find '/'");
        }
        String startDate = ShortTypeHandling.castToString((Object)callSiteArray[689].call((Object)cronString, callSiteArray[690].call(callSiteArray[691].call((Object)cronString, (Object)"/"), (Object)1), (Object)startPeriod));
        String cronPeriod = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[692].call((Object)cronString, callSiteArray[693].call((Object)startPeriod, (Object)1), callSiteArray[694].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[695].call((Object)cronString, (Object)(startPeriod + 1), callSiteArray[696].call((Object)cronString));
            cronPeriod = ShortTypeHandling.castToString((Object)object);
        }
        Date cronDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[697].call(Date.class, callSiteArray[698].call(callSiteArray[699].call(ZonedDateTime.class, (Object)startDate, callSiteArray[700].call(callSiteArray[701].callGetProperty(DateTimeFormatter.class), callSiteArray[702].callGetProperty(ZoneOffset.class))))), Date.class);
        PeriodDuration period = (PeriodDuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[703].call(PeriodDuration.class, (Object)cronPeriod), PeriodDuration.class);
        Object minutes = null;
        Object hours = null;
        Object dayOfMonths = null;
        Object months = null;
        Object time = callSiteArray[704].callGetProperty(callSiteArray[705].callGetProperty(UnitTime.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[706].callGetProperty(callSiteArray[707].call((Object)period)))) {
            Object object;
            Object object2;
            time = object2 = callSiteArray[708].callGetProperty(callSiteArray[709].callGetProperty(UnitTime.class));
            months = object = callSiteArray[710].call((Object)"*/", callSiteArray[711].callGetProperty(callSiteArray[712].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[713].callGetProperty(callSiteArray[714].callGetProperty(UnitTime.class)))) {
            Object object;
            months = object = callSiteArray[715].call(callSiteArray[716].callGetProperty((Object)cronDate));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[717].callGetProperty(callSiteArray[718].call((Object)period)))) {
            Object object;
            Object object3;
            time = object3 = callSiteArray[719].callGetProperty(callSiteArray[720].callGetProperty(UnitTime.class));
            dayOfMonths = object = callSiteArray[721].call((Object)"*/", callSiteArray[722].callGetProperty(callSiteArray[723].call((Object)period)));
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[724].callGetProperty(callSiteArray[725].callGetProperty(UnitTime.class)))) {
            Object object;
            dayOfMonths = object = callSiteArray[726].call(callSiteArray[727].callGetProperty((Object)cronDate));
        }
        Object hoursTest = callSiteArray[728].call(callSiteArray[729].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[730].call(callSiteArray[731].call((Object)period)))) {
            Object object;
            Object object4;
            time = object4 = callSiteArray[732].callGetProperty(callSiteArray[733].callGetProperty(UnitTime.class));
            hours = object = callSiteArray[734].call((Object)"*/", hoursTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[735].callGetProperty(callSiteArray[736].callGetProperty(UnitTime.class)))) {
            Object object;
            hours = object = callSiteArray[737].call(callSiteArray[738].callGetProperty((Object)cronDate));
        }
        Object minutesTest = callSiteArray[739].call(callSiteArray[740].call((Object)period));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[741].call(callSiteArray[742].call((Object)period))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[743].call(callSiteArray[744].call((Object)period)))) {
            Object object;
            Object object5;
            time = object5 = callSiteArray[745].callGetProperty(callSiteArray[746].callGetProperty(UnitTime.class));
            minutes = object = callSiteArray[747].call((Object)"* / ", minutesTest);
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)time, (Object)callSiteArray[748].callGetProperty(callSiteArray[749].callGetProperty(UnitTime.class)))) {
            Object object;
            minutes = object = callSiteArray[750].call(callSiteArray[751].callGetProperty((Object)cronDate));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[752].callStatic(SaagieUtils.class, minutes, hours, dayOfMonths, months));
    }

    public static String generateCronExpression(String minutes, String hours, String dayOfMonth, String month) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[753].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)callSiteArray[754].callStatic(SaagieUtils.class, (Object)minutes), (Object)callSiteArray[755].callStatic(SaagieUtils.class, (Object)hours), (Object)callSiteArray[756].callStatic(SaagieUtils.class, (Object)dayOfMonth), (Object)callSiteArray[757].callStatic(SaagieUtils.class, (Object)month), (Object)"*")));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[758].call(String.class, ArrayUtil.createArray((Object)"%1$s %2$s %3$s %4$s %5$s", (Object)SaagieUtils.getValueOrStar(minutes), (Object)SaagieUtils.getValueOrStar(hours), (Object)SaagieUtils.getValueOrStar(dayOfMonth), (Object)SaagieUtils.getValueOrStar(month), (Object)"*")));
    }

    private static Object getValueOrStar(String value) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? value : "*";
    }

    @Generated
    public static String gq(String request, String vars) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, vars, null);
        }
        return SaagieUtils.gq(request, vars, null);
    }

    @Generated
    public static String gq(String request) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, null, null);
        }
        return SaagieUtils.gq(request, null, null);
    }

    @Deprecated
    @Generated
    public Request getUploadFileToJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getUploadFileToJobRequest(jobId, "1");
        }
        return this.getUploadFileToJobRequest(jobId, "1");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaagieUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SaagieUtils.$getCallSiteArray()[759].call(Logging.class, SaagieUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = SaagieUtils.$getCallSiteArray()[760].call(MediaType.class, (Object)"application/json; charset=utf-8");
        JSON = (MediaType)ScriptBytecodeAdapter.castToType((Object)object2, MediaType.class);
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                callSiteArray[0].call((Object)l, (Object)"Checking server response");
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(response))) {
                    callSiteArray[2].call((Object)l, (Object)"No error in server response.");
                    return null;
                }
                String body = ShortTypeHandling.castToString((Object)callSiteArray[3].call(callSiteArray[4].call(response)));
                callSiteArray[5].callStatic(SaagieUtils.class, response);
                String status = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[6].call(response)}, new String[]{"", ""}));
                GStringImpl message = new GStringImpl(new Object[]{status, body}, new String[]{"Error ", " when requesting \n", ""});
                callSiteArray[7].call((Object)l, (Object)message);
                throw (Throwable)callSiteArray[8].callConstructor(GradleException.class, (Object)message);
            }

            public Object call(Logger l, Object response) {
                CallSite[] callSiteArray = __clinit__closure7.$getCallSiteArray();
                return callSiteArray[9].callCurrent((GroovyObject)this, (Object)l, response);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "successful";
                stringArray[2] = "debug";
                stringArray[3] = "string";
                stringArray[4] = "body";
                stringArray[5] = "debugResponse";
                stringArray[6] = "code";
                stringArray[7] = "error";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                __clinit__closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure7 __clinit__closure72 = new __clinit__closure7(SaagieUtils.class, SaagieUtils.class);
        handleErrorClosure = __clinit__closure72;
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static MediaType getJSON() {
        return JSON;
    }

    @Generated
    public DataOpsExtension getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(DataOpsExtension dataOpsExtension) {
        this.configuration = dataOpsExtension;
    }

    @Generated
    public static Object getHandleErrorClosure() {
        return handleErrorClosure;
    }

    @Generated
    public static void setHandleErrorClosure(Object object) {
        handleErrorClosure = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "debug";
        stringArray[1] = "debug";
        stringArray[2] = "debug";
        stringArray[3] = "debug";
        stringArray[4] = "replaceAll";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "debug";
        stringArray[9] = "debug";
        stringArray[10] = "gq";
        stringArray[11] = "buildRequestFromQuery";
        stringArray[12] = "getProjectJobsRequestBuild";
        stringArray[13] = "getProjectJobsRequestBuild";
        stringArray[14] = "project";
        stringArray[15] = "debug";
        stringArray[16] = "id";
        stringArray[17] = "build";
        stringArray[18] = "excludeNulls";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "toJson";
        stringArray[21] = "id";
        stringArray[22] = "gq";
        stringArray[23] = "buildRequestFromQuery";
        stringArray[24] = "any";
        stringArray[25] = "debug";
        stringArray[26] = "build";
        stringArray[27] = "excludeNulls";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "toJson";
        stringArray[30] = "gq";
        stringArray[31] = "buildRequestFromQuery";
        stringArray[32] = "project";
        stringArray[33] = "debug";
        stringArray[34] = "id";
        stringArray[35] = "build";
        stringArray[36] = "excludeNulls";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "toJson";
        stringArray[39] = "id";
        stringArray[40] = "gq";
        stringArray[41] = "buildRequestFromQuery";
        stringArray[42] = "project";
        stringArray[43] = "debug";
        stringArray[44] = "id";
        stringArray[45] = "build";
        stringArray[46] = "excludeNulls";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "toJson";
        stringArray[49] = "id";
        stringArray[50] = "gq";
        stringArray[51] = "buildRequestFromQuery";
        stringArray[52] = "project";
        stringArray[53] = "debug";
        stringArray[54] = "id";
        stringArray[55] = "build";
        stringArray[56] = "excludeNulls";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "toJson";
        stringArray[59] = "id";
        stringArray[60] = "gq";
        stringArray[61] = "buildRequestFromQuery";
        stringArray[62] = "server";
        stringArray[63] = "debug";
        stringArray[64] = "build";
        stringArray[65] = "get";
        stringArray[66] = "url";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "url";
        stringArray[69] = "environment";
        stringArray[70] = "debugRequest";
        stringArray[71] = "project";
        stringArray[72] = "debug";
        stringArray[73] = "id";
        stringArray[74] = "build";
        stringArray[75] = "excludeNulls";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "toJson";
        stringArray[78] = "gq";
        stringArray[79] = "buildRequestFromQuery";
        stringArray[80] = "job";
        stringArray[81] = "jobVersion";
        stringArray[82] = "mapJobAndJobVersionWithoutMail";
        stringArray[83] = "id";
        stringArray[84] = "project";
        stringArray[85] = "debug";
        stringArray[86] = "build";
        stringArray[87] = "excludeFieldsByName";
        stringArray[88] = "excludeNulls";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "toJson";
        stringArray[91] = "job";
        stringArray[92] = "jobVersion";
        stringArray[93] = "gq";
        stringArray[94] = "buildRequestFromQuery";
        stringArray[95] = "job";
        stringArray[96] = "jobVersion";
        stringArray[97] = "mapJobAndJobVersionWithoutMail";
        stringArray[98] = "id";
        stringArray[99] = "project";
        stringArray[100] = "debug";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "name";
        stringArray[103] = "packageInfo";
        stringArray[104] = "debug";
        stringArray[105] = "absolutePath";
        stringArray[106] = "build";
        stringArray[107] = "addConverter";
        stringArray[108] = "excludeNulls";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "toJson";
        stringArray[111] = "job";
        stringArray[112] = "jobVersion";
        stringArray[113] = "absolutePath";
        stringArray[114] = "packageInfo";
        stringArray[115] = "reverse";
        stringArray[116] = "drop";
        stringArray[117] = "reverse";
        stringArray[118] = "gq";
        stringArray[119] = "buildMultipartRequestFromQuery";
        stringArray[120] = "job";
        stringArray[121] = "mapJobWithoutMail";
        stringArray[122] = "id";
        stringArray[123] = "project";
        stringArray[124] = "debug";
        stringArray[125] = "build";
        stringArray[126] = "excludeNulls";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "toJson";
        stringArray[129] = "getProjectUpdateJobRequestFormat";
        stringArray[130] = "job";
        stringArray[131] = "mapJobWithoutMail";
        stringArray[132] = "id";
        stringArray[133] = "project";
        stringArray[134] = "getProjectUpdateJobFromDataRequestFromParams";
        stringArray[135] = "job";
        stringArray[136] = "build";
        stringArray[137] = "excludeNulls";
        stringArray[138] = "<$constructor$>";
        stringArray[139] = "getFormatForUpdateJob";
        stringArray[140] = "toJson";
        stringArray[141] = "getProjectUpdateJobRequestFormat";
        stringArray[142] = "gq";
        stringArray[143] = "buildRequestFromQuery";
        stringArray[144] = "job";
        stringArray[145] = "jobVersion";
        stringArray[146] = "debug";
        stringArray[147] = "id";
        stringArray[148] = "build";
        stringArray[149] = "excludeNulls";
        stringArray[150] = "<$constructor$>";
        stringArray[151] = "toJson";
        stringArray[152] = "id";
        stringArray[153] = "toMap";
        stringArray[154] = "gq";
        stringArray[155] = "buildRequestFromQuery";
        stringArray[156] = "<$constructor$>";
        stringArray[157] = "add";
        stringArray[158] = "add";
        stringArray[159] = "add";
        stringArray[160] = "removeAll";
        stringArray[161] = "keySet";
        stringArray[162] = "job";
        stringArray[163] = "jobVersion";
        stringArray[164] = "debug";
        stringArray[165] = "id";
        stringArray[166] = "<$constructor$>";
        stringArray[167] = "name";
        stringArray[168] = "packageInfo";
        stringArray[169] = "debug";
        stringArray[170] = "absolutePath";
        stringArray[171] = "build";
        stringArray[172] = "excludeNulls";
        stringArray[173] = "<$constructor$>";
        stringArray[174] = "toJson";
        stringArray[175] = "id";
        stringArray[176] = "toMap";
        stringArray[177] = "absolutePath";
        stringArray[178] = "packageInfo";
        stringArray[179] = "reverse";
        stringArray[180] = "drop";
        stringArray[181] = "reverse";
        stringArray[182] = "gq";
        stringArray[183] = "buildMultipartRequestFromQuery";
        stringArray[184] = "job";
        stringArray[185] = "jobVersion";
        stringArray[186] = "debug";
        stringArray[187] = "id";
        stringArray[188] = "excludeFieldsByName";
        stringArray[189] = "excludeNulls";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "downloadUrl";
        stringArray[192] = "packageInfo";
        stringArray[193] = "jobVersion";
        stringArray[194] = "excludeFieldsByName";
        stringArray[195] = "build";
        stringArray[196] = "toJson";
        stringArray[197] = "id";
        stringArray[198] = "toMap";
        stringArray[199] = "gq";
        stringArray[200] = "buildRequestFromQuery";
        stringArray[201] = "debug";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "name";
        stringArray[204] = "packageInfo";
        stringArray[205] = "jobVersion";
        stringArray[206] = "<$constructor$>";
        stringArray[207] = "detect";
        stringArray[208] = "debug";
        stringArray[209] = "parse";
        stringArray[210] = "debug";
        stringArray[211] = "absolutePath";
        stringArray[212] = "build";
        stringArray[213] = "addFormDataPart";
        stringArray[214] = "setType";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "FORM";
        stringArray[217] = "name";
        stringArray[218] = "create";
        stringArray[219] = "server";
        stringArray[220] = "jwt";
        stringArray[221] = "debug";
        stringArray[222] = "realm";
        stringArray[223] = "token";
        stringArray[224] = "build";
        stringArray[225] = "post";
        stringArray[226] = "addHeader";
        stringArray[227] = "addHeader";
        stringArray[228] = "addHeader";
        stringArray[229] = "url";
        stringArray[230] = "<$constructor$>";
        stringArray[231] = "url";
        stringArray[232] = "server";
        stringArray[233] = "environment";
        stringArray[234] = "server";
        stringArray[235] = "id";
        stringArray[236] = "project";
        stringArray[237] = "debug";
        stringArray[238] = "build";
        stringArray[239] = "post";
        stringArray[240] = "addHeader";
        stringArray[241] = "addHeader";
        stringArray[242] = "addHeader";
        stringArray[243] = "url";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "url";
        stringArray[246] = "server";
        stringArray[247] = "environment";
        stringArray[248] = "server";
        stringArray[249] = "id";
        stringArray[250] = "project";
        stringArray[251] = "getCredentials";
        stringArray[252] = "build";
        stringArray[253] = "post";
        stringArray[254] = "addHeader";
        stringArray[255] = "addHeader";
        stringArray[256] = "addHeader";
        stringArray[257] = "url";
        stringArray[258] = "<$constructor$>";
        stringArray[259] = "url";
        stringArray[260] = "server";
        stringArray[261] = "environment";
        stringArray[262] = "server";
        stringArray[263] = "id";
        stringArray[264] = "project";
        stringArray[265] = "job";
        stringArray[266] = "debug";
        stringArray[267] = "id";
        stringArray[268] = "build";
        stringArray[269] = "excludeNulls";
        stringArray[270] = "<$constructor$>";
        stringArray[271] = "toJson";
        stringArray[272] = "id";
        stringArray[273] = "gq";
        stringArray[274] = "buildRequestFromQuery";
        stringArray[275] = "deleteDir";
        stringArray[276] = "warn";
        stringArray[277] = "warn";
        stringArray[278] = "message";
        stringArray[279] = "project";
        stringArray[280] = "pipeline";
        stringArray[281] = "pipelineVersion";
        stringArray[282] = "debug";
        stringArray[283] = "id";
        stringArray[284] = "build";
        stringArray[285] = "excludeNulls";
        stringArray[286] = "<$constructor$>";
        stringArray[287] = "toMap";
        stringArray[288] = "toMap";
        stringArray[289] = "id";
        stringArray[290] = "jobs";
        stringArray[291] = "releaseNote";
        stringArray[292] = "toJson";
        stringArray[293] = "gq";
        stringArray[294] = "buildRequestFromQuery";
        stringArray[295] = "jobinstance";
        stringArray[296] = "debug";
        stringArray[297] = "id";
        stringArray[298] = "build";
        stringArray[299] = "excludeNulls";
        stringArray[300] = "<$constructor$>";
        stringArray[301] = "toJson";
        stringArray[302] = "id";
        stringArray[303] = "gq";
        stringArray[304] = "buildRequestFromQuery";
        stringArray[305] = "pipelineinstance";
        stringArray[306] = "debug";
        stringArray[307] = "id";
        stringArray[308] = "getProjectPipelineInstanceStatusRequestWithparam";
        stringArray[309] = "id";
        stringArray[310] = "build";
        stringArray[311] = "excludeNulls";
        stringArray[312] = "<$constructor$>";
        stringArray[313] = "toJson";
        stringArray[314] = "gq";
        stringArray[315] = "buildRequestFromQuery";
        stringArray[316] = "pipeline";
        stringArray[317] = "debug";
        stringArray[318] = "id";
        stringArray[319] = "build";
        stringArray[320] = "excludeNulls";
        stringArray[321] = "<$constructor$>";
        stringArray[322] = "toJson";
        stringArray[323] = "toMap";
        stringArray[324] = "gq";
        stringArray[325] = "buildRequestFromQuery";
        stringArray[326] = "pipeline";
        stringArray[327] = "pipelineVersion";
        stringArray[328] = "getAddPipelineVersionRequestFromParams";
        stringArray[329] = "debug";
        stringArray[330] = "id";
        stringArray[331] = "build";
        stringArray[332] = "excludeNulls";
        stringArray[333] = "<$constructor$>";
        stringArray[334] = "toJson";
        stringArray[335] = "id";
        stringArray[336] = "jobs";
        stringArray[337] = "releaseNote";
        stringArray[338] = "gq";
        stringArray[339] = "buildRequestFromQuery";
        stringArray[340] = "pipeline";
        stringArray[341] = "debug";
        stringArray[342] = "id";
        stringArray[343] = "build";
        stringArray[344] = "excludeNulls";
        stringArray[345] = "<$constructor$>";
        stringArray[346] = "toJson";
        stringArray[347] = "id";
        stringArray[348] = "gq";
        stringArray[349] = "buildRequestFromQuery";
        stringArray[350] = "pipeline";
        stringArray[351] = "debug";
        stringArray[352] = "id";
        stringArray[353] = "build";
        stringArray[354] = "excludeNulls";
        stringArray[355] = "<$constructor$>";
        stringArray[356] = "toJson";
        stringArray[357] = "id";
        stringArray[358] = "gq";
        stringArray[359] = "buildRequestFromQuery";
        stringArray[360] = "job";
        stringArray[361] = "debug";
        stringArray[362] = "id";
        stringArray[363] = "build";
        stringArray[364] = "excludeNulls";
        stringArray[365] = "<$constructor$>";
        stringArray[366] = "toJson";
        stringArray[367] = "id";
        stringArray[368] = "gq";
        stringArray[369] = "buildRequestFromQuery";
        stringArray[370] = "pipelineinstance";
        stringArray[371] = "debug";
        stringArray[372] = "id";
        stringArray[373] = "build";
        stringArray[374] = "excludeNulls";
        stringArray[375] = "<$constructor$>";
        stringArray[376] = "toJson";
        stringArray[377] = "id";
        stringArray[378] = "gq";
        stringArray[379] = "buildRequestFromQuery";
        stringArray[380] = "debug";
        stringArray[381] = "build";
        stringArray[382] = "get";
        stringArray[383] = "addHeader";
        stringArray[384] = "url";
        stringArray[385] = "<$constructor$>";
        stringArray[386] = "url";
        stringArray[387] = "server";
        stringArray[388] = "getCredentials";
        stringArray[389] = "build";
        stringArray[390] = "get";
        stringArray[391] = "addHeader";
        stringArray[392] = "url";
        stringArray[393] = "<$constructor$>";
        stringArray[394] = "url";
        stringArray[395] = "server";
        stringArray[396] = "debugRequest";
        stringArray[397] = "jobinstance";
        stringArray[398] = "debug";
        stringArray[399] = "id";
        stringArray[400] = "build";
        stringArray[401] = "excludeNulls";
        stringArray[402] = "<$constructor$>";
        stringArray[403] = "toJson";
        stringArray[404] = "id";
        stringArray[405] = "gq";
        stringArray[406] = "buildRequestFromQuery";
        stringArray[407] = "prettyPrint";
        stringArray[408] = "debug";
        stringArray[409] = "<$constructor$>";
        stringArray[410] = "name";
        stringArray[411] = "packageInfo";
        stringArray[412] = "jobVersion";
        stringArray[413] = "name";
        stringArray[414] = "debug";
        stringArray[415] = "absolutePath";
        stringArray[416] = "build";
        stringArray[417] = "excludeNulls";
        stringArray[418] = "<$constructor$>";
        stringArray[419] = "toJson";
        stringArray[420] = "create";
        stringArray[421] = "parse";
        stringArray[422] = "build";
        stringArray[423] = "addFormDataPart";
        stringArray[424] = "addFormDataPart";
        stringArray[425] = "addFormDataPart";
        stringArray[426] = "setType";
        stringArray[427] = "<$constructor$>";
        stringArray[428] = "FORM";
        stringArray[429] = "create";
        stringArray[430] = "create";
        stringArray[431] = "server";
        stringArray[432] = "jwt";
        stringArray[433] = "debug";
        stringArray[434] = "realm";
        stringArray[435] = "token";
        stringArray[436] = "build";
        stringArray[437] = "post";
        stringArray[438] = "addHeader";
        stringArray[439] = "addHeader";
        stringArray[440] = "addHeader";
        stringArray[441] = "url";
        stringArray[442] = "<$constructor$>";
        stringArray[443] = "url";
        stringArray[444] = "server";
        stringArray[445] = "environment";
        stringArray[446] = "server";
        stringArray[447] = "debug";
        stringArray[448] = "build";
        stringArray[449] = "post";
        stringArray[450] = "addHeader";
        stringArray[451] = "addHeader";
        stringArray[452] = "addHeader";
        stringArray[453] = "url";
        stringArray[454] = "<$constructor$>";
        stringArray[455] = "url";
        stringArray[456] = "server";
        stringArray[457] = "environment";
        stringArray[458] = "server";
        stringArray[459] = "getCredentials";
        stringArray[460] = "build";
        stringArray[461] = "post";
        stringArray[462] = "addHeader";
        stringArray[463] = "addHeader";
        stringArray[464] = "addHeader";
        stringArray[465] = "url";
        stringArray[466] = "<$constructor$>";
        stringArray[467] = "url";
        stringArray[468] = "server";
        stringArray[469] = "environment";
        stringArray[470] = "server";
        stringArray[471] = "debugRequest";
        stringArray[472] = "server";
        stringArray[473] = "debug";
        stringArray[474] = "realm";
        stringArray[475] = "token";
        stringArray[476] = "debug";
        stringArray[477] = "build";
        stringArray[478] = "get";
        stringArray[479] = "addHeader";
        stringArray[480] = "addHeader";
        stringArray[481] = "url";
        stringArray[482] = "<$constructor$>";
        stringArray[483] = "url";
        stringArray[484] = "server";
        stringArray[485] = "environment";
        stringArray[486] = "server";
        stringArray[487] = "toUpperCase";
        stringArray[488] = "toLowerCase";
        stringArray[489] = "debugRequest";
        stringArray[490] = "project";
        stringArray[491] = "debug";
        stringArray[492] = "id";
        stringArray[493] = "build";
        stringArray[494] = "excludeNulls";
        stringArray[495] = "<$constructor$>";
        stringArray[496] = "toJson";
        stringArray[497] = "id";
        stringArray[498] = "gq";
        stringArray[499] = "buildRequestFromQuery";
        stringArray[500] = "debug";
        stringArray[501] = "gq";
        stringArray[502] = "buildRequestFromQuery";
        stringArray[503] = "getPlatformListRequest";
        stringArray[504] = "project";
        stringArray[505] = "debug";
        stringArray[506] = "name";
        stringArray[507] = "build";
        stringArray[508] = "excludeNulls";
        stringArray[509] = "<$constructor$>";
        stringArray[510] = "toJson";
        stringArray[511] = "toMap";
        stringArray[512] = "gq";
        stringArray[513] = "buildRequestFromQuery";
        stringArray[514] = "job";
        stringArray[515] = "getJobDetailRequestFromParam";
        stringArray[516] = "id";
        stringArray[517] = "debug";
        stringArray[518] = "build";
        stringArray[519] = "excludeNulls";
        stringArray[520] = "<$constructor$>";
        stringArray[521] = "toJson";
        stringArray[522] = "gq";
        stringArray[523] = "buildRequestFromQuery";
        stringArray[524] = "server";
        stringArray[525] = "debug";
        stringArray[526] = "build";
        stringArray[527] = "get";
        stringArray[528] = "url";
        stringArray[529] = "<$constructor$>";
        stringArray[530] = "url";
        stringArray[531] = "environment";
        stringArray[532] = "debugRequest";
        stringArray[533] = "project";
        stringArray[534] = "job";
        stringArray[535] = "debug";
        stringArray[536] = "id";
        stringArray[537] = "id";
        stringArray[538] = "build";
        stringArray[539] = "excludeNulls";
        stringArray[540] = "<$constructor$>";
        stringArray[541] = "toJson";
        stringArray[542] = "id";
        stringArray[543] = "gq";
        stringArray[544] = "buildRequestFromQuery";
        stringArray[545] = "project";
        stringArray[546] = "debug";
        stringArray[547] = "id";
        stringArray[548] = "build";
        stringArray[549] = "excludeNulls";
        stringArray[550] = "<$constructor$>";
        stringArray[551] = "toJson";
        stringArray[552] = "toMap";
        stringArray[553] = "gq";
        stringArray[554] = "buildRequestFromQuery";
        stringArray[555] = "project";
        stringArray[556] = "debug";
        stringArray[557] = "build";
        stringArray[558] = "excludeNulls";
        stringArray[559] = "<$constructor$>";
        stringArray[560] = "toJson";
        stringArray[561] = "gq";
        stringArray[562] = "buildRequestFromQuery";
        stringArray[563] = "debug";
        stringArray[564] = "create";
        stringArray[565] = "server";
        stringArray[566] = "jwt";
        stringArray[567] = "debug";
        stringArray[568] = "realm";
        stringArray[569] = "token";
        stringArray[570] = "build";
        stringArray[571] = "post";
        stringArray[572] = "addHeader";
        stringArray[573] = "url";
        stringArray[574] = "<$constructor$>";
        stringArray[575] = "url";
        stringArray[576] = "server";
        stringArray[577] = "environment";
        stringArray[578] = "server";
        stringArray[579] = "debug";
        stringArray[580] = "build";
        stringArray[581] = "post";
        stringArray[582] = "addHeader";
        stringArray[583] = "url";
        stringArray[584] = "<$constructor$>";
        stringArray[585] = "url";
        stringArray[586] = "server";
        stringArray[587] = "environment";
        stringArray[588] = "server";
        stringArray[589] = "getCredentials";
        stringArray[590] = "build";
        stringArray[591] = "post";
        stringArray[592] = "addHeader";
        stringArray[593] = "url";
        stringArray[594] = "<$constructor$>";
        stringArray[595] = "url";
        stringArray[596] = "server";
        stringArray[597] = "environment";
        stringArray[598] = "server";
        stringArray[599] = "debugRequest";
        stringArray[600] = "debug";
        stringArray[601] = "buildRequestForFile";
        stringArray[602] = "execute";
        stringArray[603] = "newCall";
        stringArray[604] = "byteStream";
        stringArray[605] = "body";
        stringArray[606] = "<$constructor$>";
        stringArray[607] = "<$constructor$>";
        stringArray[608] = "plus";
        stringArray[609] = "plus";
        stringArray[610] = "read";
        stringArray[611] = "write";
        stringArray[612] = "plus";
        stringArray[613] = "<$constructor$>";
        stringArray[614] = "message";
        stringArray[615] = "debug";
        stringArray[616] = "close";
        stringArray[617] = "close";
        stringArray[618] = "debug";
        stringArray[619] = "server";
        stringArray[620] = "debug";
        stringArray[621] = "build";
        stringArray[622] = "addHeader";
        stringArray[623] = "url";
        stringArray[624] = "<$constructor$>";
        stringArray[625] = "getCredentials";
        stringArray[626] = "build";
        stringArray[627] = "addHeader";
        stringArray[628] = "url";
        stringArray[629] = "<$constructor$>";
        stringArray[630] = "debugRequest";
        stringArray[631] = "substring";
        stringArray[632] = "plus";
        stringArray[633] = "lastIndexOf";
        stringArray[634] = "length";
        stringArray[635] = "endsWith";
        stringArray[636] = "substring";
        stringArray[637] = "minus";
        stringArray[638] = "length";
        stringArray[639] = "basic";
        stringArray[640] = "login";
        stringArray[641] = "server";
        stringArray[642] = "password";
        stringArray[643] = "server";
        stringArray[644] = "collectEntries";
        stringArray[645] = "findAll";
        stringArray[646] = "declaredFields";
        stringArray[647] = "getClass";
        stringArray[648] = "<$constructor$>";
        stringArray[649] = "iterator";
        stringArray[650] = "contains";
        stringArray[651] = "add";
        stringArray[652] = "debug";
        stringArray[653] = "debug";
        stringArray[654] = "method";
        stringArray[655] = "path";
        stringArray[656] = "url";
        stringArray[657] = "url";
        stringArray[658] = "debug";
        stringArray[659] = "host";
        stringArray[660] = "url";
        stringArray[661] = "url";
        stringArray[662] = "each";
        stringArray[663] = "names";
        stringArray[664] = "headers";
        stringArray[665] = "body";
        stringArray[666] = "debug";
        stringArray[667] = "contentLength";
        stringArray[668] = "body";
        stringArray[669] = "<$constructor$>";
        stringArray[670] = "writeTo";
        stringArray[671] = "body";
        stringArray[672] = "debug";
        stringArray[673] = "readUtf8";
        stringArray[674] = "debug";
        stringArray[675] = "debug";
        stringArray[676] = "toString";
        stringArray[677] = "protocol";
        stringArray[678] = "code";
        stringArray[679] = "message";
        stringArray[680] = "each";
        stringArray[681] = "names";
        stringArray[682] = "headers";
        stringArray[683] = "error";
        stringArray[684] = "<$constructor$>";
        stringArray[685] = "indexOf";
        stringArray[686] = "plus";
        stringArray[687] = "indexOf";
        stringArray[688] = "throwAndLogError";
        stringArray[689] = "substring";
        stringArray[690] = "plus";
        stringArray[691] = "indexOf";
        stringArray[692] = "substring";
        stringArray[693] = "plus";
        stringArray[694] = "length";
        stringArray[695] = "substring";
        stringArray[696] = "length";
        stringArray[697] = "from";
        stringArray[698] = "toInstant";
        stringArray[699] = "parse";
        stringArray[700] = "withZone";
        stringArray[701] = "ISO_ZONED_DATE_TIME";
        stringArray[702] = "UTC";
        stringArray[703] = "parse";
        stringArray[704] = "value";
        stringArray[705] = "SECOND";
        stringArray[706] = "months";
        stringArray[707] = "getPeriod";
        stringArray[708] = "value";
        stringArray[709] = "MONTH";
        stringArray[710] = "plus";
        stringArray[711] = "months";
        stringArray[712] = "getPeriod";
        stringArray[713] = "value";
        stringArray[714] = "MONTH";
        stringArray[715] = "toString";
        stringArray[716] = "month";
        stringArray[717] = "days";
        stringArray[718] = "getPeriod";
        stringArray[719] = "value";
        stringArray[720] = "DAYOFMONTH";
        stringArray[721] = "plus";
        stringArray[722] = "days";
        stringArray[723] = "getPeriod";
        stringArray[724] = "value";
        stringArray[725] = "DAYOFMONTH";
        stringArray[726] = "toString";
        stringArray[727] = "day";
        stringArray[728] = "toHours";
        stringArray[729] = "getDuration";
        stringArray[730] = "toHours";
        stringArray[731] = "getDuration";
        stringArray[732] = "value";
        stringArray[733] = "HOUR";
        stringArray[734] = "plus";
        stringArray[735] = "value";
        stringArray[736] = "HOUR";
        stringArray[737] = "toString";
        stringArray[738] = "hours";
        stringArray[739] = "toHours";
        stringArray[740] = "getDuration";
        stringArray[741] = "toMinutes";
        stringArray[742] = "getDuration";
        stringArray[743] = "toHours";
        stringArray[744] = "getDuration";
        stringArray[745] = "value";
        stringArray[746] = "MINUTE";
        stringArray[747] = "plus";
        stringArray[748] = "value";
        stringArray[749] = "MINUTE";
        stringArray[750] = "toString";
        stringArray[751] = "minutes";
        stringArray[752] = "generateCronExpression";
        stringArray[753] = "format";
        stringArray[754] = "getValueOrStar";
        stringArray[755] = "getValueOrStar";
        stringArray[756] = "getValueOrStar";
        stringArray[757] = "getValueOrStar";
        stringArray[758] = "format";
        stringArray[759] = "getLogger";
        stringArray[760] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[761];
        SaagieUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SaagieUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SaagieUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

