/*
 * Decompiled with CFR 0.152.
 */
package io.saagie.plugin.dataops.utils;

import groovy.json.JsonGenerator;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.saagie.plugin.dataops.DataOpsExtension;
import io.saagie.plugin.dataops.models.Job;
import io.saagie.plugin.dataops.models.JobInstance;
import io.saagie.plugin.dataops.models.JobVersion;
import io.saagie.plugin.dataops.models.Pipeline;
import io.saagie.plugin.dataops.models.PipelineInstance;
import io.saagie.plugin.dataops.models.PipelineVersion;
import io.saagie.plugin.dataops.models.Project;
import io.saagie.plugin.dataops.models.Server;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.tika.Tika;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SaagieUtils
implements GroovyObject {
    private static final Logger logger;
    private static final MediaType JSON;
    private DataOpsExtension configuration;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SaagieUtils(DataOpsExtension configuration) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DataOpsExtension dataOpsExtension = configuration;
        this.configuration = (DataOpsExtension)ScriptBytecodeAdapter.castToType((Object)dataOpsExtension, DataOpsExtension.class);
    }

    public static String gq(String request, String vars, String operationName) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[0].call((Object)logger, (Object)"GraphQL Query:");
        callSiteArray[1].call((Object)logger, (Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)vars)) {
            callSiteArray[2].call((Object)logger, (Object)"GraphQL Variables:");
            callSiteArray[3].call((Object)logger, (Object)vars);
        }
        Object inlinedRequest = callSiteArray[4].call((Object)request, (Object)"\\n", (Object)"");
        Object query = new GStringImpl(new Object[]{inlinedRequest}, new String[]{"{\"query\":\"", "\""});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vars, null)) {
            query = callSiteArray[5].call(query, (Object)new GStringImpl(new Object[]{vars}, new String[]{",\"variables\":", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)operationName)) {
            query = callSiteArray[6].call(query, (Object)new GStringImpl(new Object[]{operationName}, new String[]{",\"operationName\":\"", "\""}));
        }
        query = callSiteArray[7].call(query, (Object)"}");
        callSiteArray[8].call((Object)logger, (Object)"Generated graphql query:\n{}", query);
        return ShortTypeHandling.castToString((Object)query);
    }

    public Request getProjectsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[9].call((Object)logger, (Object)"Generating getProjectsRequest");
        Object listProjectsRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            listProjectsRequest = object = callSiteArray[10].callStatic(SaagieUtils.class, (Object)"\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
        } else {
            String string = SaagieUtils.gq("\n            query getProjects {\n                projects {\n                    id\n                    name\n                    creator\n                    description\n                    jobsCount\n                    status\n                }\n            }\n        ");
            listProjectsRequest = string;
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callCurrent((GroovyObject)this, listProjectsRequest), Request.class);
    }

    public Request getProjectJobsRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[13].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[14].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[18].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[19].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectJobs = callSiteArray[20].callStatic(SaagieUtils.class, (Object)"\n            query jobs($projectId: UUID!) {\n                jobs(projectId: $projectId) {\n                    id\n                    name\n                    description\n                    countJobInstance\n                    versions {\n                        number\n                    }\n                    category\n                    technology {\n                        id\n                        label\n                        isAvailable\n                    }\n                    isScheduled\n                    cronScheduling\n                    scheduleStatus\n                    alerting {\n                        loginEmails {\n                            login\n                            email\n                        }\n                        emails\n                        statusList\n                    }\n                    isStreaming\n                    creationDate\n                    migrationStatus\n                    migrationProjectId\n                    isDeletable\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callCurrent((GroovyObject)this, listProjectJobs), Request.class);
    }

    public Request getProjectTechnologiesRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        callSiteArray[23].call((Object)logger, (Object)"generating getProjectTechnologiesRequest [projectId={}]", callSiteArray[24].callGroovyObjectGetProperty((Object)project));
        Object jsonGenerator = callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[28].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", callSiteArray[29].callGroovyObjectGetProperty((Object)project)}));
        Object listProjectTechnologies = callSiteArray[30].callStatic(SaagieUtils.class, (Object)"\n            query technologiesQuery($projectId: UUID!) {\n                technologies(projectId: $projectId) {\n                    id\n                    label\n                    isAvailable\n                    icon\n                    features {\n                        field\n                        label\n                        isMandatory\n                        comment\n                        defaultValue\n                    }\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callCurrent((GroovyObject)this, listProjectTechnologies), Request.class);
    }

    @Deprecated
    public Request getProjectCreateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[34].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object object = callSiteArray[35].callGetProperty(callSiteArray[36].callGroovyObjectGetProperty((Object)this.configuration));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SaagieUtils.class, (GroovyObject)job, (String)"projectId");
        Object jsonGenerator = callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].callConstructor(JsonGenerator.Options.class)), (Object)"dockerInfo"), (Object)"usePreviousArtifact"));
        Object gqVariables = callSiteArray[42].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[43].call((Object)job), "jobVersion", callSiteArray[44].call((Object)jobVersion)}));
        Object createProjectJob = callSiteArray[45].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!) {\n                createJob(job: $job, jobVersion: $jobVersion) {\n                    id\n                    name\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectCreateJobRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[49].call((Object)logger, (Object)"Generating getProjectCreateJobRequest [job={}, jobVersion={}]", (Object)job, (Object)jobVersion);
        Object object = callSiteArray[50].callGetProperty(callSiteArray[51].callGroovyObjectGetProperty((Object)this.configuration));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SaagieUtils.class, (GroovyObject)job, (String)"projectId");
        Reference file = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callConstructor(File.class, callSiteArray[53].callGetProperty(callSiteArray[54].callGroovyObjectGetProperty((Object)jobVersion))), File.class)));
        callSiteArray[55].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[56].callGetProperty((Object)((File)file.get())));
        public final class _getProjectCreateJobRequestWithGraphQL_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getProjectCreateJobRequestWithGraphQL_closure1(Object _outerInstance, Object _thisObject, Reference file) {
                Reference reference;
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.file = reference = file;
            }

            public Object doCall(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(this.file.get());
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)value), (String)"name");
                return value;
            }

            public Object call(JobVersion value) {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value);
            }

            public File getFile() {
                CallSite[] callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getProjectCreateJobRequestWithGraphQL_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "packageInfo";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getProjectCreateJobRequestWithGraphQL_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getProjectCreateJobRequestWithGraphQL_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getProjectCreateJobRequestWithGraphQL_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object jsonGenerator = callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].callConstructor(JsonGenerator.Options.class)), (Object)"dockerInfo"), JobVersion.class, (Object)new _getProjectCreateJobRequestWithGraphQL_closure1(this, this, file)));
        Object gqVariables = callSiteArray[62].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[63].call((Object)job), "jobVersion", callSiteArray[64].call((Object)jobVersion)}));
        Object object2 = callSiteArray[65].callGetProperty((Object)((File)file.get()));
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[66].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[67].call(callSiteArray[68].call(callSiteArray[69].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object createProjectJob = callSiteArray[70].callStatic(SaagieUtils.class, (Object)"\n            mutation createJobMutation($job: JobInput!, $jobVersion: JobVersionInput!, $file: Upload) {\n                createJob(job: $job, jobVersion: $jobVersion, file: $file) {\n                    id\n                    name\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].callCurrent((GroovyObject)this, createProjectJob), Request.class);
    }

    public Request getProjectUpdateJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[73].call((Object)logger, (Object)"Generating getProjectUpdateJobRequest [job={}]", (Object)job);
        Object jsonGenerator = callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[77].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"job", callSiteArray[78].call((Object)job)}));
        Object updateProjectJob = callSiteArray[79].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($job: JobEditionInput!) {\n                editJob(job: $job) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getAddJobVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[83].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[84].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].callConstructor(JsonGenerator.Options.class)), (Object)"dockerInfo"));
        Object gqVariables = callSiteArray[89].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[90].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[91].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[92].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public Request getAddJobVersionRequestWithGraphQL() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[96].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[97].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object file = callSiteArray[98].callConstructor(File.class, callSiteArray[99].callGetProperty(callSiteArray[100].callGroovyObjectGetProperty((Object)jobVersion)));
        callSiteArray[101].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[102].callGetProperty(file));
        Object jsonGenerator = callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].callConstructor(JsonGenerator.Options.class)), (Object)"dockerInfo"));
        Object gqVariables = callSiteArray[107].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[108].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[109].call((Object)jobVersion)}));
        Object object = callSiteArray[110].callGetProperty(file);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[111].callGroovyObjectGetProperty((Object)jobVersion), (String)"name");
        String nullFile = "},\"file\":null}";
        GStringImpl gqVariablesWithNullFile = new GStringImpl(new Object[]{callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call(gqVariables), (Object)2)), nullFile}, new String[]{"", "", ""});
        Object updateProjectJob = callSiteArray[115].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!, $file: Upload) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion, file: $file) {\n                    number\n                }\n            }\n        ", (Object)gqVariablesWithNullFile);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    public Request getAddJobVersionRequestWithoutFile() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        JobVersion jobVersion = (JobVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].callGroovyObjectGetProperty((Object)this.configuration), JobVersion.class);
        callSiteArray[119].call((Object)logger, (Object)"Generating getAddJobVersionRequest for [jobId={}, jobVersion={}]", callSiteArray[120].callGroovyObjectGetProperty((Object)job), (Object)jobVersion);
        Object jsonGenerator = callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call(callSiteArray[125].callConstructor(JsonGenerator.Options.class)), (Object)"dockerInfo"), (Object)"packageInfo"));
        Object gqVariables = callSiteArray[126].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[127].callGroovyObjectGetProperty((Object)job), "jobVersion", callSiteArray[128].call((Object)jobVersion)}));
        Object updateProjectJob = callSiteArray[129].callStatic(SaagieUtils.class, (Object)"\n            mutation addJobVersionMutation($jobId: UUID!, $jobVersion: JobVersionInput!) {\n                addJobVersion(jobId: $jobId, jobVersion: $jobVersion) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[130].callCurrent((GroovyObject)this, updateProjectJob), Request.class);
    }

    @Deprecated
    public Request getUploadFileToJobRequest(String jobId, String jobVersion) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[131].call((Object)logger, (Object)"Generating getUploadFileToJobRequest [jobId={}, jobVersion={}]", (Object)jobId, (Object)jobVersion);
        Object file = callSiteArray[132].callConstructor(File.class, callSiteArray[133].callGetProperty(callSiteArray[134].callGetProperty(callSiteArray[135].callGroovyObjectGetProperty((Object)this.configuration))));
        Tika tika = (Tika)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].callConstructor(Tika.class), Tika.class);
        String fileMimeType = ShortTypeHandling.castToString((Object)callSiteArray[137].call((Object)tika, file));
        callSiteArray[138].call((Object)logger, (Object)"Detected file mime type: ", (Object)fileMimeType);
        Object fileType = callSiteArray[139].call(MediaType.class, (Object)fileMimeType);
        callSiteArray[140].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[141].callGetProperty(file));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].call(callSiteArray[143].call(callSiteArray[144].call(callSiteArray[145].callConstructor(MultipartBody.Builder.class), callSiteArray[146].callGetProperty(MultipartBody.class)), (Object)"files", callSiteArray[147].callGetProperty(file), callSiteArray[148].call(RequestBody.class, file, fileType))), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[151].call((Object)logger, (Object)"Building upload file request with jwt auth...");
            Object realm = callSiteArray[152].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[153].callGroovyObjectGetProperty((Object)server);
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].call(callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[161].callGetProperty(callSiteArray[162].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[163].callGetProperty(callSiteArray[164].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[165].callGetProperty(callSiteArray[166].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/projects/api/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        callSiteArray[167].call((Object)logger, (Object)"Building upload file request with basic auth...");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call(callSiteArray[171].call(callSiteArray[172].call(callSiteArray[173].call(callSiteArray[174].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[175].callGetProperty(callSiteArray[176].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[177].callGetProperty(callSiteArray[178].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[179].callGetProperty(callSiteArray[180].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", callSiteArray[181].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
        }
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].call(callSiteArray[185].call(callSiteArray[186].call(callSiteArray[187].call(callSiteArray[188].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[189].callGetProperty(callSiteArray[190].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[191].callGetProperty(callSiteArray[192].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[193].callGetProperty(callSiteArray[194].callGroovyObjectGetProperty((Object)this.configuration)), jobId, jobVersion}, new String[]{"", "/api/v1/projects/platform/", "/project/", "/job/", "/version/", "/uploadArtifact"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body)), Request.class);
    }

    public Request getRunProjectJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[195].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[196].call((Object)logger, (Object)"Generating getRunProjectJobRequest for job [id={}]", callSiteArray[197].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[198].call(callSiteArray[199].call(callSiteArray[200].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[201].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[202].callGroovyObjectGetProperty((Object)job)}));
        Object runProjectJobRequest = callSiteArray[203].callStatic(SaagieUtils.class, (Object)"\n            mutation editJobMutation($jobId: UUID!) {\n                runJob(jobId: $jobId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[204].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getCreatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Project project = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[205].callGroovyObjectGetProperty((Object)this.configuration), Project.class);
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[206].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[207].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        callSiteArray[208].call((Object)logger, (Object)"Generating getCreatePipelineRequest for project [projectId={}, pipeline={}, pipelineVersion={}]", callSiteArray[209].callGroovyObjectGetProperty((Object)project), (Object)pipeline, (Object)pipelineVersion);
        Object jsonGenerator = callSiteArray[210].call(callSiteArray[211].call(callSiteArray[212].callConstructor(JsonGenerator.Options.class)));
        Map graphqlPipelineVar = ScriptBytecodeAdapter.createMap((Object[])new Object[]{ScriptBytecodeAdapter.spreadMap((Object)callSiteArray[213].call((Object)pipeline)), callSiteArray[214].call((Object)pipeline), "projectId", callSiteArray[215].callGroovyObjectGetProperty((Object)project), "jobsId", callSiteArray[216].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[217].callGroovyObjectGetProperty((Object)pipelineVersion)});
        Object gqVariables = callSiteArray[218].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", graphqlPipelineVar}));
        Object runProjectJobRequest = callSiteArray[219].callStatic(SaagieUtils.class, (Object)"\n            mutation createPipelineMutation($pipeline: PipelineInput!) {\n                createPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[220].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    public Request getProjectJobInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[222].call((Object)logger, (Object)"Generating getProjectJobsRequest [projectId={}]", callSiteArray[223].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[227].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[228].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object getJobInstanceStatus = callSiteArray[229].callStatic(SaagieUtils.class, (Object)"\n            query getJobInstanceStatus($jobId: UUID!) {\n                jobInstance(id: $jobId) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[230].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectPipelineInstanceStatusRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[231].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[232].call((Object)logger, (Object)"Generating getProjectPipelineInstanceStatusRequest [pipelineInstanceId={}]", callSiteArray[233].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[234].call(callSiteArray[235].call(callSiteArray[236].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[237].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[238].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getPipelineInstanceStatus = callSiteArray[239].callStatic(SaagieUtils.class, (Object)"\n            query getPipelineInstanceStatus($id: UUID!) {\n                pipelineInstance(id: $id) {\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[240].callCurrent((GroovyObject)this, getPipelineInstanceStatus), Request.class);
    }

    public Request getProjectUpdatePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[241].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[242].call((Object)logger, (Object)"Generating getProjectUpdatePipelineRequest [pipelineId={}]", callSiteArray[243].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[244].call(callSiteArray[245].call(callSiteArray[246].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[247].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipeline", callSiteArray[248].call((Object)pipeline)}));
        Object editPipeline = callSiteArray[249].callStatic(SaagieUtils.class, (Object)"\n            mutation editPipelineMutation($pipeline: PipelineEditionInput!) {\n                editPipeline(pipeline: $pipeline) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[250].callCurrent((GroovyObject)this, editPipeline), Request.class);
    }

    public Request getAddPipelineVersionRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[251].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        PipelineVersion pipelineVersion = (PipelineVersion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callGroovyObjectGetProperty((Object)this.configuration), PipelineVersion.class);
        callSiteArray[253].call((Object)logger, (Object)"Generating getAddPipelineVersionRequest [pipelineId={}]", callSiteArray[254].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[258].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[259].callGroovyObjectGetProperty((Object)pipeline), "jobsId", callSiteArray[260].callGroovyObjectGetProperty((Object)pipelineVersion), "releaseNote", callSiteArray[261].callGroovyObjectGetProperty((Object)pipelineVersion)}));
        Object addPipelineVersionRequest = callSiteArray[262].callStatic(SaagieUtils.class, (Object)"\n            mutation addPipelineVersionMutation(\n                $pipelineId: UUID!,\n                $jobsId: [UUID!]!,\n                $releaseNote: String,\n            ) {\n                addPipelineVersion(\n                    pipelineId: $pipelineId,\n                    jobsId: $jobsId,\n                    releaseNote: $releaseNote\n                ) {\n                    number\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[263].callCurrent((GroovyObject)this, addPipelineVersionRequest), Request.class);
    }

    public Request getProjectRunPipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[264].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[265].call((Object)logger, (Object)"Generating getProjectRunPipelineRequest [pipelineId={}]", callSiteArray[266].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[267].call(callSiteArray[268].call(callSiteArray[269].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[270].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineId", callSiteArray[271].callGroovyObjectGetProperty((Object)pipeline)}));
        Object runPipeline = callSiteArray[272].callStatic(SaagieUtils.class, (Object)"\n            mutation runPipelineMutation($pipelineId: UUID!) {\n                runPipeline(pipelineId: $pipelineId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[273].callCurrent((GroovyObject)this, runPipeline), Request.class);
    }

    public Request getProjectDeletePipelineRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Pipeline pipeline = (Pipeline)ScriptBytecodeAdapter.castToType((Object)callSiteArray[274].callGroovyObjectGetProperty((Object)this.configuration), Pipeline.class);
        callSiteArray[275].call((Object)logger, (Object)"Generating getProjectDeletePipelineRequest [pipelineId={}]", callSiteArray[276].callGroovyObjectGetProperty((Object)pipeline));
        Object jsonGenerator = callSiteArray[277].call(callSiteArray[278].call(callSiteArray[279].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[280].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[281].callGroovyObjectGetProperty((Object)pipeline)}));
        Object deletePipeline = callSiteArray[282].callStatic(SaagieUtils.class, (Object)"\n            mutation deletePipelineMutation($id: UUID!) {\n                deletePipeline(id: $id)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[283].callCurrent((GroovyObject)this, deletePipeline), Request.class);
    }

    public Request getProjectArchiveJobRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Job job = (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[284].callGroovyObjectGetProperty((Object)this.configuration), Job.class);
        callSiteArray[285].call((Object)logger, (Object)"Generating getProjectArchiveJobRequest [jobId={}]", callSiteArray[286].callGroovyObjectGetProperty((Object)job));
        Object jsonGenerator = callSiteArray[287].call(callSiteArray[288].call(callSiteArray[289].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[290].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobId", callSiteArray[291].callGroovyObjectGetProperty((Object)job)}));
        Object getJobInstanceStatus = callSiteArray[292].callStatic(SaagieUtils.class, (Object)"\n            mutation archiveJobMutation($jobId: UUID!) {\n                archiveJob(jobId: $jobId)\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[293].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getProjectStopPipelineInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        PipelineInstance pipelineinstance = (PipelineInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[294].callGroovyObjectGetProperty((Object)this.configuration), PipelineInstance.class);
        callSiteArray[295].call((Object)logger, (Object)"Generating getProjectStopPipelineInstanceRequest [pipelineinstanceId={}]", callSiteArray[296].callGroovyObjectGetProperty((Object)pipelineinstance));
        Object jsonGenerator = callSiteArray[297].call(callSiteArray[298].call(callSiteArray[299].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[300].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pipelineInstanceId", callSiteArray[301].callGroovyObjectGetProperty((Object)pipelineinstance)}));
        Object getJobInstanceStatus = callSiteArray[302].callStatic(SaagieUtils.class, (Object)"\n            mutation stopPipelineInstanceMutation($pipelineInstanceId: UUID!) {\n                stopPipelineInstance(pipelineInstanceId: $pipelineInstanceId) {\n                    id\n                    status\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[303].callCurrent((GroovyObject)this, getJobInstanceStatus), Request.class);
    }

    public Request getJwtTokenRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[304].call((Object)logger, (Object)"Requesting JWT...");
        Request newRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[305].call(callSiteArray[306].call(callSiteArray[307].call(callSiteArray[308].call(callSiteArray[309].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[310].callGetProperty(callSiteArray[311].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", callSiteArray[312].callCurrent((GroovyObject)this))));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            Object object = callSiteArray[313].call(callSiteArray[314].call(callSiteArray[315].call(callSiteArray[316].call(callSiteArray[317].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[318].callGetProperty(callSiteArray[319].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/data-fabric/api/auth"})), (Object)"Authorization", (Object)this.getCredentials())));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[320].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getStopJobInstanceRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        JobInstance jobInstance = (JobInstance)ScriptBytecodeAdapter.castToType((Object)callSiteArray[321].callGroovyObjectGetProperty((Object)this.configuration), JobInstance.class);
        callSiteArray[322].call((Object)logger, (Object)"Generating getStopJobInstanceRequest for job instance [id={}]", callSiteArray[323].callGroovyObjectGetProperty((Object)jobInstance));
        Object jsonGenerator = callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].callConstructor(JsonGenerator.Options.class)));
        Object gqVariables = callSiteArray[327].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jobInstanceId", callSiteArray[328].callGroovyObjectGetProperty((Object)jobInstance)}));
        Object runProjectJobRequest = callSiteArray[329].callStatic(SaagieUtils.class, (Object)"\n            mutation stopJobMutation($jobInstanceId: UUID!) {\n                stopJobInstance(jobInstanceId: $jobInstanceId) {\n                    id\n                }\n            }\n        ", gqVariables);
        return (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[330].callCurrent((GroovyObject)this, runProjectJobRequest), Request.class);
    }

    private Request buildMultipartRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[331].call((Object)logger, (Object)"Generating multipart request from query=\"{}\"", (Object)query);
        Object file = callSiteArray[332].callConstructor(File.class, callSiteArray[333].callGetProperty(callSiteArray[334].callGetProperty(callSiteArray[335].callGroovyObjectGetProperty((Object)this.configuration))));
        Object fileName = callSiteArray[336].callGetProperty(file);
        callSiteArray[337].call((Object)logger, (Object)"Using [file={}] for upload", callSiteArray[338].callGetProperty(file));
        Object jsonGenerator = callSiteArray[339].call(callSiteArray[340].call(callSiteArray[341].callConstructor(JsonGenerator.Options.class)));
        Object map = callSiteArray[342].call(jsonGenerator, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"0", ScriptBytecodeAdapter.createList((Object[])new Object[]{"variables.file"})}));
        Object fileBody = callSiteArray[343].call(RequestBody.class, file, callSiteArray[344].call(MediaType.class, (Object)"application/octet-stream"));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[345].call(callSiteArray[346].call(callSiteArray[347].call(callSiteArray[348].call(callSiteArray[349].call(callSiteArray[350].callConstructor(MultipartBody.Builder.class, (Object)"--graphql-multipart-upload-boundary-85763456--"), callSiteArray[351].callGetProperty(MultipartBody.class)), (Object)"operations", null, callSiteArray[352].call(RequestBody.class, (Object)query, (Object)JSON)), (Object)"map", null, callSiteArray[353].call(RequestBody.class, map, (Object)JSON)), (Object)"0", fileName, fileBody)), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[354].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[355].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[356].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[357].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[358].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[359].call(callSiteArray[360].call(callSiteArray[361].call(callSiteArray[362].call(callSiteArray[363].call(callSiteArray[364].call(callSiteArray[365].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[366].callGetProperty(callSiteArray[367].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[368].callGetProperty(callSiteArray[369].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[370].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[371].call(callSiteArray[372].call(callSiteArray[373].call(callSiteArray[374].call(callSiteArray[375].call(callSiteArray[376].call(callSiteArray[377].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[378].callGetProperty(callSiteArray[379].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[380].callGetProperty(callSiteArray[381].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[382].callCurrent((GroovyObject)this)), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[383].call(callSiteArray[384].call(callSiteArray[385].call(callSiteArray[386].call(callSiteArray[387].call(callSiteArray[388].call(callSiteArray[389].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[390].callGetProperty(callSiteArray[391].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[392].callGetProperty(callSiteArray[393].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)"Accept", (Object)"application/json"), (Object)"Content-Type", (Object)"multipart/form-data"), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[394].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    public Request getPlatformListRequest() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[395].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        callSiteArray[396].call((Object)logger, (Object)"Generating request in order to get access rights by platforms");
        String realm = ShortTypeHandling.castToString((Object)callSiteArray[397].callGroovyObjectGetProperty((Object)server));
        String jwtToken = ShortTypeHandling.castToString((Object)callSiteArray[398].callGroovyObjectGetProperty((Object)server));
        callSiteArray[399].call((Object)logger, (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"Using realm=", " and jwt=", ""}));
        Request newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[400].call(callSiteArray[401].call(callSiteArray[402].call(callSiteArray[403].call(callSiteArray[404].call(callSiteArray[405].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[406].callGetProperty(callSiteArray[407].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/security/api/rights"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{callSiteArray[408].call((Object)realm), jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)"Saagie-Realm", callSiteArray[409].call((Object)realm)))), Request.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[410].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    private Request buildRequestFromQuery(String query) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[411].call((Object)logger, (Object)"Generating request from query=\"{}\"", (Object)query);
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[412].call(RequestBody.class, (Object)query, (Object)JSON), RequestBody.class);
        Server server = (Server)ScriptBytecodeAdapter.castToType((Object)callSiteArray[413].callGroovyObjectGetProperty((Object)this.configuration), Server.class);
        Request newRequest = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[414].callGroovyObjectGetProperty((Object)server))) {
            callSiteArray[415].call((Object)logger, (Object)"Generating graphql request with JWT auth...");
            Object realm = callSiteArray[416].callGroovyObjectGetProperty((Object)server);
            Object jwtToken = callSiteArray[417].callGroovyObjectGetProperty((Object)server);
            Object object = callSiteArray[418].call(callSiteArray[419].call(callSiteArray[420].call(callSiteArray[421].call(callSiteArray[422].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[423].callGetProperty(callSiteArray[424].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[425].callGetProperty(callSiteArray[426].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/projects/api/platform/", "/graphql"})), (Object)"Cookie", (Object)new GStringImpl(new Object[]{realm, jwtToken}, new String[]{"SAAGIETOKEN", "=", ""})), (Object)body));
            newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
        } else {
            callSiteArray[427].call((Object)logger, (Object)"Generating graphql request with basic auth...");
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[428].call(callSiteArray[429].call(callSiteArray[430].call(callSiteArray[431].call(callSiteArray[432].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[433].callGetProperty(callSiteArray[434].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[435].callGetProperty(callSiteArray[436].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", callSiteArray[437].callCurrent((GroovyObject)this)), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            } else {
                Object object = callSiteArray[438].call(callSiteArray[439].call(callSiteArray[440].call(callSiteArray[441].call(callSiteArray[442].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[443].callGetProperty(callSiteArray[444].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[445].callGetProperty(callSiteArray[446].callGroovyObjectGetProperty((Object)this.configuration))}, new String[]{"", "/api/v1/projects/platform/", "/graphql"})), (Object)"Authorization", (Object)this.getCredentials()), (Object)body));
                newRequest = (Request)ScriptBytecodeAdapter.castToType((Object)object, Request.class);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[447].callStatic(SaagieUtils.class, (Object)newRequest);
        } else {
            SaagieUtils.debugRequest(newRequest);
        }
        return newRequest;
    }

    private String getCredentials() {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[448].call(Credentials.class, callSiteArray[449].callGetProperty(callSiteArray[450].callGroovyObjectGetProperty((Object)this.configuration)), callSiteArray[451].callGetProperty(callSiteArray[452].callGroovyObjectGetProperty((Object)this.configuration))));
    }

    private static Map extractProperties(Object obj) {
        Reference obj2 = new Reference(obj);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        public final class _extractProperties_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _extractProperties_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _extractProperties_closure2.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _extractProperties_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "synthetic";
                return new CallSiteArray(_extractProperties_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _extractProperties_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference obj;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractProperties_closure3(Object _outerInstance, Object _thisObject, Reference obj) {
                Reference reference;
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.obj = reference = obj;
            }

            public Object doCall(Object field) {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(field), callSiteArray[1].call(this.obj.get(), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(field)}, new String[]{"", ""}))});
            }

            public Object getObj() {
                CallSite[] callSiteArray = _extractProperties_closure3.$getCallSiteArray();
                return this.obj.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractProperties_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getAt";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _extractProperties_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractProperties_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractProperties_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[453].call(callSiteArray[454].call(callSiteArray[455].callGetProperty(callSiteArray[456].call(obj2.get())), (Object)new _extractProperties_closure2(SaagieUtils.class, SaagieUtils.class)), (Object)new _extractProperties_closure3(SaagieUtils.class, SaagieUtils.class, obj2)), Map.class);
    }

    public static Object debugRequest(Request request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[457].call((Object)logger, (Object)"====== Request ======");
        callSiteArray[458].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[459].callGetProperty((Object)((Request)request2.get())), callSiteArray[460].callGetProperty(callSiteArray[461].call(callSiteArray[462].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"", " ", ""}));
        callSiteArray[463].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[464].callGetProperty(callSiteArray[465].call(callSiteArray[466].callGetProperty((Object)((Request)request2.get()))))}, new String[]{"Host: ", ""}));
        public final class _debugRequest_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugRequest_closure4(Object _outerInstance, Object _thisObject, Reference request) {
                Reference reference;
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference = request;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.request.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Request getRequest() {
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                return (Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), Request.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugRequest_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugRequest_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugRequest_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugRequest_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugRequest_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[467].call(callSiteArray[468].call(callSiteArray[469].call((Object)((Request)request2.get()))), (Object)new _debugRequest_closure4(SaagieUtils.class, SaagieUtils.class, request2));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[470].call((Object)((Request)request2.get())))) {
            callSiteArray[471].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[472].call(callSiteArray[473].call((Object)((Request)request2.get())))}, new String[]{"Content-Length: ", ""}));
            Buffer buffer = (Buffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[474].callConstructor(Buffer.class), Buffer.class);
            callSiteArray[475].call(callSiteArray[476].call((Object)((Request)request2.get())), (Object)buffer);
            return callSiteArray[477].call((Object)logger, callSiteArray[478].call((Object)buffer));
        }
        return null;
    }

    public static Object debugResponse(Response response) {
        Reference response2 = new Reference((Object)response);
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        callSiteArray[479].call((Object)logger, (Object)"====== Response ======");
        callSiteArray[480].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[481].call(callSiteArray[482].call((Object)((Response)response2.get()))), callSiteArray[483].callGetProperty((Object)((Response)response2.get())), callSiteArray[484].callGetProperty((Object)((Response)response2.get()))}, new String[]{"", " ", " ", ""}));
        public final class _debugResponse_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference response;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _debugResponse_closure5(Object _outerInstance, Object _thisObject, Reference response) {
                Reference reference;
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.response = reference = response;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(SaagieUtils.class), (Object)new GStringImpl(new Object[]{it, callSiteArray[2].call(callSiteArray[3].call(this.response.get()), it)}, new String[]{"", ": ", ""}));
            }

            public Response getResponse() {
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                return (Response)ScriptBytecodeAdapter.castToType((Object)this.response.get(), Response.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _debugResponse_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _debugResponse_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "headers";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _debugResponse_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_debugResponse_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _debugResponse_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[485].call(callSiteArray[486].call(callSiteArray[487].call((Object)((Response)response2.get()))), (Object)new _debugResponse_closure5(SaagieUtils.class, SaagieUtils.class, response2));
    }

    @Generated
    public static String gq(String request, String vars) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, vars, null);
        }
        return SaagieUtils.gq(request, vars, null);
    }

    @Generated
    public static String gq(String request) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return SaagieUtils.gq(request, null, null);
        }
        return SaagieUtils.gq(request, null, null);
    }

    @Deprecated
    @Generated
    public Request getUploadFileToJobRequest(String jobId) {
        CallSite[] callSiteArray = SaagieUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getUploadFileToJobRequest(jobId, "1");
        }
        return this.getUploadFileToJobRequest(jobId, "1");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaagieUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SaagieUtils.$getCallSiteArray()[488].call(Logging.class, SaagieUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = SaagieUtils.$getCallSiteArray()[489].call(MediaType.class, (Object)"application/json; charset=utf-8");
        JSON = (MediaType)ScriptBytecodeAdapter.castToType((Object)object2, MediaType.class);
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static MediaType getJSON() {
        return JSON;
    }

    @Generated
    public DataOpsExtension getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(DataOpsExtension dataOpsExtension) {
        this.configuration = dataOpsExtension;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "debug";
        stringArray[1] = "debug";
        stringArray[2] = "debug";
        stringArray[3] = "debug";
        stringArray[4] = "replaceAll";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "debug";
        stringArray[9] = "debug";
        stringArray[10] = "gq";
        stringArray[11] = "buildRequestFromQuery";
        stringArray[12] = "project";
        stringArray[13] = "debug";
        stringArray[14] = "id";
        stringArray[15] = "build";
        stringArray[16] = "excludeNulls";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "toJson";
        stringArray[19] = "id";
        stringArray[20] = "gq";
        stringArray[21] = "buildRequestFromQuery";
        stringArray[22] = "project";
        stringArray[23] = "debug";
        stringArray[24] = "id";
        stringArray[25] = "build";
        stringArray[26] = "excludeNulls";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "toJson";
        stringArray[29] = "id";
        stringArray[30] = "gq";
        stringArray[31] = "buildRequestFromQuery";
        stringArray[32] = "job";
        stringArray[33] = "jobVersion";
        stringArray[34] = "debug";
        stringArray[35] = "id";
        stringArray[36] = "project";
        stringArray[37] = "build";
        stringArray[38] = "excludeFieldsByName";
        stringArray[39] = "excludeFieldsByName";
        stringArray[40] = "excludeNulls";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "toJson";
        stringArray[43] = "toMap";
        stringArray[44] = "toMap";
        stringArray[45] = "gq";
        stringArray[46] = "buildRequestFromQuery";
        stringArray[47] = "job";
        stringArray[48] = "jobVersion";
        stringArray[49] = "debug";
        stringArray[50] = "id";
        stringArray[51] = "project";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "name";
        stringArray[54] = "packageInfo";
        stringArray[55] = "debug";
        stringArray[56] = "absolutePath";
        stringArray[57] = "build";
        stringArray[58] = "addConverter";
        stringArray[59] = "excludeFieldsByName";
        stringArray[60] = "excludeNulls";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "toJson";
        stringArray[63] = "toMap";
        stringArray[64] = "toMap";
        stringArray[65] = "absolutePath";
        stringArray[66] = "packageInfo";
        stringArray[67] = "reverse";
        stringArray[68] = "drop";
        stringArray[69] = "reverse";
        stringArray[70] = "gq";
        stringArray[71] = "buildMultipartRequestFromQuery";
        stringArray[72] = "job";
        stringArray[73] = "debug";
        stringArray[74] = "build";
        stringArray[75] = "excludeNulls";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "toJson";
        stringArray[78] = "toMap";
        stringArray[79] = "gq";
        stringArray[80] = "buildRequestFromQuery";
        stringArray[81] = "job";
        stringArray[82] = "jobVersion";
        stringArray[83] = "debug";
        stringArray[84] = "id";
        stringArray[85] = "build";
        stringArray[86] = "excludeFieldsByName";
        stringArray[87] = "excludeNulls";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "toJson";
        stringArray[90] = "id";
        stringArray[91] = "toMap";
        stringArray[92] = "gq";
        stringArray[93] = "buildRequestFromQuery";
        stringArray[94] = "job";
        stringArray[95] = "jobVersion";
        stringArray[96] = "debug";
        stringArray[97] = "id";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "name";
        stringArray[100] = "packageInfo";
        stringArray[101] = "debug";
        stringArray[102] = "absolutePath";
        stringArray[103] = "build";
        stringArray[104] = "excludeFieldsByName";
        stringArray[105] = "excludeNulls";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "toJson";
        stringArray[108] = "id";
        stringArray[109] = "toMap";
        stringArray[110] = "absolutePath";
        stringArray[111] = "packageInfo";
        stringArray[112] = "reverse";
        stringArray[113] = "drop";
        stringArray[114] = "reverse";
        stringArray[115] = "gq";
        stringArray[116] = "buildMultipartRequestFromQuery";
        stringArray[117] = "job";
        stringArray[118] = "jobVersion";
        stringArray[119] = "debug";
        stringArray[120] = "id";
        stringArray[121] = "build";
        stringArray[122] = "excludeFieldsByName";
        stringArray[123] = "excludeFieldsByName";
        stringArray[124] = "excludeNulls";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "toJson";
        stringArray[127] = "id";
        stringArray[128] = "toMap";
        stringArray[129] = "gq";
        stringArray[130] = "buildRequestFromQuery";
        stringArray[131] = "debug";
        stringArray[132] = "<$constructor$>";
        stringArray[133] = "name";
        stringArray[134] = "packageInfo";
        stringArray[135] = "jobVersion";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "detect";
        stringArray[138] = "debug";
        stringArray[139] = "parse";
        stringArray[140] = "debug";
        stringArray[141] = "absolutePath";
        stringArray[142] = "build";
        stringArray[143] = "addFormDataPart";
        stringArray[144] = "setType";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "FORM";
        stringArray[147] = "name";
        stringArray[148] = "create";
        stringArray[149] = "server";
        stringArray[150] = "jwt";
        stringArray[151] = "debug";
        stringArray[152] = "realm";
        stringArray[153] = "token";
        stringArray[154] = "build";
        stringArray[155] = "post";
        stringArray[156] = "addHeader";
        stringArray[157] = "addHeader";
        stringArray[158] = "addHeader";
        stringArray[159] = "url";
        stringArray[160] = "<$constructor$>";
        stringArray[161] = "url";
        stringArray[162] = "server";
        stringArray[163] = "environment";
        stringArray[164] = "server";
        stringArray[165] = "id";
        stringArray[166] = "project";
        stringArray[167] = "debug";
        stringArray[168] = "build";
        stringArray[169] = "post";
        stringArray[170] = "addHeader";
        stringArray[171] = "addHeader";
        stringArray[172] = "addHeader";
        stringArray[173] = "url";
        stringArray[174] = "<$constructor$>";
        stringArray[175] = "url";
        stringArray[176] = "server";
        stringArray[177] = "environment";
        stringArray[178] = "server";
        stringArray[179] = "id";
        stringArray[180] = "project";
        stringArray[181] = "getCredentials";
        stringArray[182] = "build";
        stringArray[183] = "post";
        stringArray[184] = "addHeader";
        stringArray[185] = "addHeader";
        stringArray[186] = "addHeader";
        stringArray[187] = "url";
        stringArray[188] = "<$constructor$>";
        stringArray[189] = "url";
        stringArray[190] = "server";
        stringArray[191] = "environment";
        stringArray[192] = "server";
        stringArray[193] = "id";
        stringArray[194] = "project";
        stringArray[195] = "job";
        stringArray[196] = "debug";
        stringArray[197] = "id";
        stringArray[198] = "build";
        stringArray[199] = "excludeNulls";
        stringArray[200] = "<$constructor$>";
        stringArray[201] = "toJson";
        stringArray[202] = "id";
        stringArray[203] = "gq";
        stringArray[204] = "buildRequestFromQuery";
        stringArray[205] = "project";
        stringArray[206] = "pipeline";
        stringArray[207] = "pipelineVersion";
        stringArray[208] = "debug";
        stringArray[209] = "id";
        stringArray[210] = "build";
        stringArray[211] = "excludeNulls";
        stringArray[212] = "<$constructor$>";
        stringArray[213] = "toMap";
        stringArray[214] = "toMap";
        stringArray[215] = "id";
        stringArray[216] = "jobs";
        stringArray[217] = "releaseNote";
        stringArray[218] = "toJson";
        stringArray[219] = "gq";
        stringArray[220] = "buildRequestFromQuery";
        stringArray[221] = "jobinstance";
        stringArray[222] = "debug";
        stringArray[223] = "id";
        stringArray[224] = "build";
        stringArray[225] = "excludeNulls";
        stringArray[226] = "<$constructor$>";
        stringArray[227] = "toJson";
        stringArray[228] = "id";
        stringArray[229] = "gq";
        stringArray[230] = "buildRequestFromQuery";
        stringArray[231] = "pipelineinstance";
        stringArray[232] = "debug";
        stringArray[233] = "id";
        stringArray[234] = "build";
        stringArray[235] = "excludeNulls";
        stringArray[236] = "<$constructor$>";
        stringArray[237] = "toJson";
        stringArray[238] = "id";
        stringArray[239] = "gq";
        stringArray[240] = "buildRequestFromQuery";
        stringArray[241] = "pipeline";
        stringArray[242] = "debug";
        stringArray[243] = "id";
        stringArray[244] = "build";
        stringArray[245] = "excludeNulls";
        stringArray[246] = "<$constructor$>";
        stringArray[247] = "toJson";
        stringArray[248] = "toMap";
        stringArray[249] = "gq";
        stringArray[250] = "buildRequestFromQuery";
        stringArray[251] = "pipeline";
        stringArray[252] = "pipelineVersion";
        stringArray[253] = "debug";
        stringArray[254] = "id";
        stringArray[255] = "build";
        stringArray[256] = "excludeNulls";
        stringArray[257] = "<$constructor$>";
        stringArray[258] = "toJson";
        stringArray[259] = "id";
        stringArray[260] = "jobs";
        stringArray[261] = "releaseNote";
        stringArray[262] = "gq";
        stringArray[263] = "buildRequestFromQuery";
        stringArray[264] = "pipeline";
        stringArray[265] = "debug";
        stringArray[266] = "id";
        stringArray[267] = "build";
        stringArray[268] = "excludeNulls";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "toJson";
        stringArray[271] = "id";
        stringArray[272] = "gq";
        stringArray[273] = "buildRequestFromQuery";
        stringArray[274] = "pipeline";
        stringArray[275] = "debug";
        stringArray[276] = "id";
        stringArray[277] = "build";
        stringArray[278] = "excludeNulls";
        stringArray[279] = "<$constructor$>";
        stringArray[280] = "toJson";
        stringArray[281] = "id";
        stringArray[282] = "gq";
        stringArray[283] = "buildRequestFromQuery";
        stringArray[284] = "job";
        stringArray[285] = "debug";
        stringArray[286] = "id";
        stringArray[287] = "build";
        stringArray[288] = "excludeNulls";
        stringArray[289] = "<$constructor$>";
        stringArray[290] = "toJson";
        stringArray[291] = "id";
        stringArray[292] = "gq";
        stringArray[293] = "buildRequestFromQuery";
        stringArray[294] = "pipelineinstance";
        stringArray[295] = "debug";
        stringArray[296] = "id";
        stringArray[297] = "build";
        stringArray[298] = "excludeNulls";
        stringArray[299] = "<$constructor$>";
        stringArray[300] = "toJson";
        stringArray[301] = "id";
        stringArray[302] = "gq";
        stringArray[303] = "buildRequestFromQuery";
        stringArray[304] = "debug";
        stringArray[305] = "build";
        stringArray[306] = "get";
        stringArray[307] = "addHeader";
        stringArray[308] = "url";
        stringArray[309] = "<$constructor$>";
        stringArray[310] = "url";
        stringArray[311] = "server";
        stringArray[312] = "getCredentials";
        stringArray[313] = "build";
        stringArray[314] = "get";
        stringArray[315] = "addHeader";
        stringArray[316] = "url";
        stringArray[317] = "<$constructor$>";
        stringArray[318] = "url";
        stringArray[319] = "server";
        stringArray[320] = "debugRequest";
        stringArray[321] = "jobinstance";
        stringArray[322] = "debug";
        stringArray[323] = "id";
        stringArray[324] = "build";
        stringArray[325] = "excludeNulls";
        stringArray[326] = "<$constructor$>";
        stringArray[327] = "toJson";
        stringArray[328] = "id";
        stringArray[329] = "gq";
        stringArray[330] = "buildRequestFromQuery";
        stringArray[331] = "debug";
        stringArray[332] = "<$constructor$>";
        stringArray[333] = "name";
        stringArray[334] = "packageInfo";
        stringArray[335] = "jobVersion";
        stringArray[336] = "name";
        stringArray[337] = "debug";
        stringArray[338] = "absolutePath";
        stringArray[339] = "build";
        stringArray[340] = "excludeNulls";
        stringArray[341] = "<$constructor$>";
        stringArray[342] = "toJson";
        stringArray[343] = "create";
        stringArray[344] = "parse";
        stringArray[345] = "build";
        stringArray[346] = "addFormDataPart";
        stringArray[347] = "addFormDataPart";
        stringArray[348] = "addFormDataPart";
        stringArray[349] = "setType";
        stringArray[350] = "<$constructor$>";
        stringArray[351] = "FORM";
        stringArray[352] = "create";
        stringArray[353] = "create";
        stringArray[354] = "server";
        stringArray[355] = "jwt";
        stringArray[356] = "debug";
        stringArray[357] = "realm";
        stringArray[358] = "token";
        stringArray[359] = "build";
        stringArray[360] = "post";
        stringArray[361] = "addHeader";
        stringArray[362] = "addHeader";
        stringArray[363] = "addHeader";
        stringArray[364] = "url";
        stringArray[365] = "<$constructor$>";
        stringArray[366] = "url";
        stringArray[367] = "server";
        stringArray[368] = "environment";
        stringArray[369] = "server";
        stringArray[370] = "debug";
        stringArray[371] = "build";
        stringArray[372] = "post";
        stringArray[373] = "addHeader";
        stringArray[374] = "addHeader";
        stringArray[375] = "addHeader";
        stringArray[376] = "url";
        stringArray[377] = "<$constructor$>";
        stringArray[378] = "url";
        stringArray[379] = "server";
        stringArray[380] = "environment";
        stringArray[381] = "server";
        stringArray[382] = "getCredentials";
        stringArray[383] = "build";
        stringArray[384] = "post";
        stringArray[385] = "addHeader";
        stringArray[386] = "addHeader";
        stringArray[387] = "addHeader";
        stringArray[388] = "url";
        stringArray[389] = "<$constructor$>";
        stringArray[390] = "url";
        stringArray[391] = "server";
        stringArray[392] = "environment";
        stringArray[393] = "server";
        stringArray[394] = "debugRequest";
        stringArray[395] = "server";
        stringArray[396] = "debug";
        stringArray[397] = "realm";
        stringArray[398] = "token";
        stringArray[399] = "debug";
        stringArray[400] = "build";
        stringArray[401] = "get";
        stringArray[402] = "addHeader";
        stringArray[403] = "addHeader";
        stringArray[404] = "url";
        stringArray[405] = "<$constructor$>";
        stringArray[406] = "url";
        stringArray[407] = "server";
        stringArray[408] = "toUpperCase";
        stringArray[409] = "toLowerCase";
        stringArray[410] = "debugRequest";
        stringArray[411] = "debug";
        stringArray[412] = "create";
        stringArray[413] = "server";
        stringArray[414] = "jwt";
        stringArray[415] = "debug";
        stringArray[416] = "realm";
        stringArray[417] = "token";
        stringArray[418] = "build";
        stringArray[419] = "post";
        stringArray[420] = "addHeader";
        stringArray[421] = "url";
        stringArray[422] = "<$constructor$>";
        stringArray[423] = "url";
        stringArray[424] = "server";
        stringArray[425] = "environment";
        stringArray[426] = "server";
        stringArray[427] = "debug";
        stringArray[428] = "build";
        stringArray[429] = "post";
        stringArray[430] = "addHeader";
        stringArray[431] = "url";
        stringArray[432] = "<$constructor$>";
        stringArray[433] = "url";
        stringArray[434] = "server";
        stringArray[435] = "environment";
        stringArray[436] = "server";
        stringArray[437] = "getCredentials";
        stringArray[438] = "build";
        stringArray[439] = "post";
        stringArray[440] = "addHeader";
        stringArray[441] = "url";
        stringArray[442] = "<$constructor$>";
        stringArray[443] = "url";
        stringArray[444] = "server";
        stringArray[445] = "environment";
        stringArray[446] = "server";
        stringArray[447] = "debugRequest";
        stringArray[448] = "basic";
        stringArray[449] = "login";
        stringArray[450] = "server";
        stringArray[451] = "password";
        stringArray[452] = "server";
        stringArray[453] = "collectEntries";
        stringArray[454] = "findAll";
        stringArray[455] = "declaredFields";
        stringArray[456] = "getClass";
        stringArray[457] = "debug";
        stringArray[458] = "debug";
        stringArray[459] = "method";
        stringArray[460] = "path";
        stringArray[461] = "url";
        stringArray[462] = "url";
        stringArray[463] = "debug";
        stringArray[464] = "host";
        stringArray[465] = "url";
        stringArray[466] = "url";
        stringArray[467] = "each";
        stringArray[468] = "names";
        stringArray[469] = "headers";
        stringArray[470] = "body";
        stringArray[471] = "debug";
        stringArray[472] = "contentLength";
        stringArray[473] = "body";
        stringArray[474] = "<$constructor$>";
        stringArray[475] = "writeTo";
        stringArray[476] = "body";
        stringArray[477] = "debug";
        stringArray[478] = "readUtf8";
        stringArray[479] = "debug";
        stringArray[480] = "debug";
        stringArray[481] = "toString";
        stringArray[482] = "protocol";
        stringArray[483] = "code";
        stringArray[484] = "message";
        stringArray[485] = "each";
        stringArray[486] = "names";
        stringArray[487] = "headers";
        stringArray[488] = "getLogger";
        stringArray[489] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[490];
        SaagieUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SaagieUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SaagieUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

