/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.json;

import io.runon.trading.PriceQuantity;
import io.runon.trading.PriceQuantityData;
import io.runon.trading.order.OrderBook;
import io.runon.trading.order.OrderBookData;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonOrderBook {
    public static OrderBook make(String jsonValue) {
        JSONObject jsonObject = new JSONObject(jsonValue);
        OrderBookData orderBook = new OrderBookData();
        orderBook.setTime(jsonObject.getLong("t"));
        JSONArray askArray = jsonObject.getJSONArray("asks");
        PriceQuantity[] asks = new PriceQuantity[askArray.length()];
        for (int i = 0; i < asks.length; ++i) {
            JSONArray ask = askArray.getJSONArray(i);
            PriceQuantityData priceQuantity = new PriceQuantityData();
            priceQuantity.setPrice(ask.getBigDecimal(0));
            priceQuantity.setQuantity(ask.getBigDecimal(1));
            asks[i] = priceQuantity;
        }
        orderBook.setAsks(asks);
        JSONArray bidArray = jsonObject.getJSONArray("bids");
        PriceQuantity[] bids = new PriceQuantity[bidArray.length()];
        for (int i = 0; i < bids.length; ++i) {
            JSONArray bid = bidArray.getJSONArray(i);
            PriceQuantityData priceQuantity = new PriceQuantityData();
            priceQuantity.setPrice(bid.getBigDecimal(0));
            priceQuantity.setQuantity(bid.getBigDecimal(1));
            bids[i] = priceQuantity;
        }
        orderBook.setBids(bids);
        return orderBook;
    }

    public static String value(OrderBook orderBook) {
        return OrderBook.value((OrderBook)orderBook);
    }

    public static void main(String[] args) {
        OrderBook orderBook = JsonOrderBook.make("{\"t\":1667360182989,\"asks\":[[\"20536.42\",\"0.00499\"],[\"20536.55\",\"0.0074\"],[\"20536.56\",\"0.10094\"],[\"20536.57\",\"0.13625\"],[\"20536.61\",\"0.0008\"],[\"20536.62\",\"0.00132\"],[\"20536.63\",\"0.018\"],[\"20536.64\",\"0.00579\"],[\"20536.66\",\"0.04\"],[\"20536.68\",\"0.0027\"],[\"20536.69\",\"0.0005\"],[\"20536.71\",\"0.0008\"],[\"20536.72\",\"0.0075\"],[\"20536.73\",\"0.5\"],[\"20536.79\",\"0.00056\"],[\"20536.8\",\"0.0008\"],[\"20536.89\",\"0.06484\"],[\"20536.9\",\"0.05\"],[\"20536.92\",\"0.0008\"],[\"20536.93\",\"0.0008\"],[\"20536.95\",\"0.00097\"],[\"20536.99\",\"0.00644\"],[\"20537\",\"0.00624\"],[\"20537.03\",\"0.00201\"],[\"20537.05\",\"0.06398\"],[\"20537.07\",\"0.23236\"],[\"20537.11\",\"0.0007\"],[\"20537.13\",\"0.018\"],[\"20537.2\",\"0.01272\"],[\"20537.23\",\"0.0008\"],[\"20537.29\",\"0.07115\"],[\"20537.32\",\"0.0027\"],[\"20537.4\",\"0.00857\"],[\"20537.42\",\"0.02992\"],[\"20537.44\",\"0.43695\"],[\"20537.49\",\"0.02601\"],[\"20537.5\",\"0.01957\"],[\"20537.51\",\"0.00055\"],[\"20537.55\",\"0.221\"],[\"20537.58\",\"0.00857\"],[\"20537.6\",\"0.00107\"],[\"20537.63\",\"0.018\"],[\"20537.65\",\"0.00675\"],[\"20537.66\",\"0.00557\"],[\"20537.68\",\"0.001\"],[\"20537.69\",\"0.03213\"],[\"20537.75\",\"0.0098\"],[\"20537.77\",\"0.1199\"],[\"20537.8\",\"0.00857\"],[\"20537.86\",\"0.0098\"],[\"20537.88\",\"0.00978\"],[\"20537.93\",\"0.0008\"],[\"20537.96\",\"0.00107\"],[\"20537.97\",\"0.08192\"],[\"20537.98\",\"0.05289\"],[\"20537.99\",\"0.11073\"],[\"20538\",\"21.46557\"],[\"20538.07\",\"0.00107\"],[\"20538.09\",\"0.00116\"],[\"20538.13\",\"0.018\"],[\"20538.15\",\"0.00107\"],[\"20538.16\",\"0.00136\"],[\"20538.17\",\"0.00116\"],[\"20538.19\",\"0.10136\"],[\"20538.21\",\"0.0098\"],[\"20538.23\",\"0.075\"],[\"20538.25\",\"0.00136\"],[\"20538.28\",\"0.00256\"],[\"20538.29\",\"0.00116\"],[\"20538.31\",\"0.00107\"],[\"20538.35\",\"0.00058\"],[\"20538.38\",\"0.00665\"],[\"20538.46\",\"0.09717\"],[\"20538.55\",\"0.09152\"],[\"20538.62\",\"0.02628\"],[\"20538.63\",\"0.018\"],[\"20538.64\",\"0.13029\"],[\"20538.65\",\"0.003\"],[\"20538.67\",\"0.04884\"],[\"20538.68\",\"0.00243\"],[\"20538.69\",\"0.00136\"],[\"20538.7\",\"0.003\"],[\"20538.73\",\"0.05642\"],[\"20538.75\",\"0.04\"],[\"20538.77\",\"0.05\"],[\"20538.83\",\"0.00974\"],[\"20538.87\",\"0.02\"],[\"20538.92\",\"0.13061\"],[\"20538.95\",\"0.19476\"],[\"20538.97\",\"0.05165\"],[\"20538.99\",\"0.0248\"],[\"20539\",\"0.00261\"],[\"20539.08\",\"0.1\"],[\"20539.13\",\"0.02443\"],[\"20539.14\",\"0.00482\"],[\"20539.18\",\"0.00683\"],[\"20539.23\",\"0.16\"],[\"20539.32\",\"0.003\"],[\"20539.33\",\"0.05\"],[\"20539.35\",\"0.09\"]],\"bids\":[[\"20536.1\",\"0.01466\"],[\"20535.64\",\"0.45814\"],[\"20535.63\",\"0.11008\"],[\"20535.17\",\"0.26782\"],[\"20535.16\",\"0.0115\"],[\"20535.14\",\"0.1981\"],[\"20535.12\",\"0.03755\"],[\"20535.11\",\"0.04508\"],[\"20535.09\",\"0.08204\"],[\"20535\",\"0.00161\"],[\"20534.99\",\"0.00857\"],[\"20534.89\",\"0.001\"],[\"20534.88\",\"0.00857\"],[\"20534.74\",\"0.06065\"],[\"20534.7\",\"0.02957\"],[\"20534.67\",\"0.03449\"],[\"20534.64\",\"0.02178\"],[\"20534.59\",\"0.06\"],[\"20534.58\",\"0.04582\"],[\"20534.52\",\"0.09688\"],[\"20534.51\",\"0.00501\"],[\"20534.49\",\"0.00055\"],[\"20534.47\",\"0.001\"],[\"20534.44\",\"0.1516\"],[\"20534.43\",\"0.00485\"],[\"20534.42\",\"0.00574\"],[\"20534.32\",\"0.0098\"],[\"20534.31\",\"0.0008\"],[\"20534.28\",\"0.0008\"],[\"20534.25\",\"0.0008\"],[\"20534.24\",\"0.02029\"],[\"20534.23\",\"0.00691\"],[\"20534.12\",\"0.0098\"],[\"20534.11\",\"0.01217\"],[\"20534.04\",\"0.10291\"],[\"20534.03\",\"0.07115\"],[\"20534.01\",\"0.12701\"],[\"20534\",\"0.25724\"],[\"20533.99\",\"0.0098\"],[\"20533.98\",\"0.034\"],[\"20533.95\",\"0.0008\"],[\"20533.88\",\"0.10243\"],[\"20533.75\",\"0.045\"],[\"20533.71\",\"0.01095\"],[\"20533.7\",\"0.0225\"],[\"20533.56\",\"0.1\"],[\"20533.55\",\"0.05475\"],[\"20533.53\",\"0.04031\"],[\"20533.49\",\"0.10243\"],[\"20533.47\",\"0.07339\"],[\"20533.46\",\"0.04921\"],[\"20533.43\",\"0.01219\"],[\"20533.42\",\"0.05147\"],[\"20533.39\",\"0.00243\"],[\"20533.36\",\"0.02248\"],[\"20533.35\",\"0.06\"],[\"20533.2\",\"0.02\"],[\"20533.15\",\"0.02288\"],[\"20533.13\",\"0.0008\"],[\"20533.04\",\"0.00323\"],[\"20533.02\",\"0.02\"],[\"20533\",\"0.0131\"],[\"20532.91\",\"1.29274\"],[\"20532.9\",\"3.21283\"],[\"20532.81\",\"0.29218\"],[\"20532.76\",\"0.0064\"],[\"20532.63\",\"0.14987\"],[\"20532.62\",\"0.2005\"],[\"20532.44\",\"0.00097\"],[\"20532.43\",\"0.28449\"],[\"20532.38\",\"0.0008\"],[\"20532.36\",\"0.0008\"],[\"20532.35\",\"0.00243\"],[\"20532.19\",\"0.02185\"],[\"20532.18\",\"0.0008\"],[\"20532.14\",\"0.00055\"],[\"20532.12\",\"0.14609\"],[\"20532.08\",\"0.0008\"],[\"20532.05\",\"0.0008\"],[\"20532\",\"0.18343\"],[\"20531.91\",\"0.01695\"],[\"20531.9\",\"0.00937\"],[\"20531.79\",\"0.02973\"],[\"20531.77\",\"0.05475\"],[\"20531.73\",\"0.005\"],[\"20531.69\",\"0.13029\"],[\"20531.68\",\"0.30403\"],[\"20531.67\",\"0.04964\"],[\"20531.66\",\"0.0008\"],[\"20531.65\",\"0.22\"],[\"20531.63\",\"0.0488\"],[\"20531.61\",\"0.00768\"],[\"20531.54\",\"0.075\"],[\"20531.52\",\"0.00544\"],[\"20531.5\",\"0.0008\"],[\"20531.41\",\"0.76006\"],[\"20531.4\",\"0.06\"],[\"20531.39\",\"0.06385\"],[\"20531.37\",\"0.00696\"],[\"20531.36\",\"0.0062\"]],\"update_id\":26695014698}");
        System.out.println(JsonOrderBook.value(orderBook));
    }
}

