/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.file;

import com.seomse.commons.utils.time.DateUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class TimeName {
    public static String getName(long time, Type type, ZoneId zoneId) {
        Instant i = Instant.ofEpochMilli(time);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(i, zoneId);
        if (type == Type.YEAR_100) {
            return zonedDateTime.getYear() / 100 + "00";
        }
        if (type == Type.YEAR_20) {
            return Integer.toString(zonedDateTime.getYear() - zonedDateTime.getYear() % 20);
        }
        if (type == Type.YEAR_10) {
            return zonedDateTime.getYear() / 10 + "0";
        }
        if (type == Type.YEAR_1) {
            return Integer.toString(zonedDateTime.getYear());
        }
        if (type == Type.MONTH_1) {
            return zonedDateTime.getYear() + DateUtil.getDateText((int)zonedDateTime.getMonthValue());
        }
        if (type == Type.DAY_5) {
            int day = zonedDateTime.getDayOfMonth() - (zonedDateTime.getDayOfMonth() - 1) % 5;
            if (day > 26) {
                day = 26;
            }
            return zonedDateTime.getYear() + DateUtil.getDateText((int)zonedDateTime.getMonthValue()) + DateUtil.getDateText((int)day);
        }
        if (type == Type.DAY_2) {
            int day = zonedDateTime.getDayOfMonth() - (zonedDateTime.getDayOfMonth() - 1) % 2;
            if (day > 29) {
                day = 29;
            }
            return zonedDateTime.getYear() + DateUtil.getDateText((int)zonedDateTime.getMonthValue()) + DateUtil.getDateText((int)day);
        }
        if (type == Type.DAY_1) {
            return zonedDateTime.getYear() + DateUtil.getDateText((int)zonedDateTime.getMonthValue()) + DateUtil.getDateText((int)zonedDateTime.getDayOfMonth());
        }
        return zonedDateTime.getYear() + DateUtil.getDateText((int)zonedDateTime.getMonthValue()) + DateUtil.getDateText((int)zonedDateTime.getDayOfMonth()) + DateUtil.getDateText((int)zonedDateTime.getHour());
    }

    public static enum Type {
        YEAR_100,
        YEAR_20,
        YEAR_10,
        YEAR_1,
        MONTH_1,
        DAY_5,
        DAY_2,
        DAY_1,
        HOUR_1;

    }
}

