/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.file;

import com.seomse.commons.utils.FileUtil;
import com.seomse.commons.validation.FileValidation;
import com.seomse.commons.validation.NumberNameFileValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class TimeFiles {
    public static File[] getFilesDir(String path) {
        File dirFile = new File(path);
        if (!dirFile.isDirectory()) {
            return new File[0];
        }
        File[] files = dirFile.listFiles();
        if (files == null || files.length == 0) {
            return new File[0];
        }
        NumberNameFileValidation validation = new NumberNameFileValidation();
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            if (!validation.isValid(file)) continue;
            fileList.add(file);
        }
        files = fileList.toArray(new File[0]);
        Arrays.sort(files, FileUtil.SORT_NAME_LONG);
        return files;
    }

    public static File[] getFilesDirs(String path) {
        return FileUtil.getFiles((String)path, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG);
    }

    public static boolean isInDir(String path) {
        File dirFile = new File(path);
        if (!dirFile.isDirectory()) {
            return false;
        }
        File[] files = dirFile.listFiles();
        if (files == null || files.length == 0) {
            return false;
        }
        NumberNameFileValidation validation = new NumberNameFileValidation();
        for (File file : files) {
            if (!validation.isValid(file)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInDirs(String path) {
        File[] files = FileUtil.getFiles((String)path, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG);
        return files.length > 0;
    }

    public static String getLastLine(String dirPath) {
        File[] files = FileUtil.getFiles((String)dirPath, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG_DESC);
        if (files.length == 0) {
            return null;
        }
        for (File file : files) {
            String line = FileUtil.getLastTextLine((File)file);
            if ("".equals(line)) continue;
            return line;
        }
        return null;
    }
}

