/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.file;

import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.FileUtil;
import io.runon.trading.TradingTimes;
import io.runon.trading.data.file.TimeFiles;
import io.runon.trading.data.file.TimeName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.ZoneId;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeFilePathChange {
    private static final Logger log = LoggerFactory.getLogger(TimeFilePathChange.class);
    protected TimeName.Type type = TimeName.Type.MONTH_1;
    protected ZoneId zoneId = TradingTimes.UTC_ZONE_ID;

    public void setType(TimeName.Type type) {
        this.type = type;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void outDirs(String readPath, String outPath) {
        File[] files;
        readPath = new File(readPath).getAbsolutePath();
        outPath = new File(outPath).getAbsolutePath();
        for (File file : files = FileUtil.getFiles((String)readPath)) {
            if (!file.isDirectory()) continue;
            String next = file.getAbsolutePath().substring(readPath.length());
            this.outDir(file.getAbsolutePath(), outPath + next);
        }
    }

    public void outDir(String readPath, String outPath) {
        File[] checkFiles;
        File[] readFiles = TimeFiles.getFilesDir(readPath);
        if (readFiles.length == 0) {
            return;
        }
        File outDir = new File(outPath);
        if (!outDir.isDirectory()) {
            outDir.mkdirs();
        }
        if ((checkFiles = TimeFiles.getFilesDir(outPath)).length > 0) {
            throw new IORuntimeException("directory is not empty: " + outPath);
        }
        Object pathStart = outPath;
        if (!((String)pathStart).endsWith("\\") && !((String)pathStart).endsWith("/")) {
            pathStart = (String)pathStart + "/";
        }
        StringBuilder sb = new StringBuilder();
        String lastName = "";
        HashSet<String> overSet = new HashSet<String>();
        String lastLine = "";
        for (File readFile : readFiles) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(readFile)));){
                String line;
                while ((line = br.readLine()) != null) {
                    long time = this.getTime(line);
                    String name = TimeName.getName(time, this.type, this.zoneId);
                    if (!name.equals(lastName)) {
                        if (sb.length() > 0) {
                            if (!overSet.contains(lastName)) {
                                FileUtil.fileOutput((String)sb.substring(1), (String)((String)pathStart + lastName), (boolean)false);
                                overSet.add(lastName);
                            } else {
                                log.error(lastName + " sort error line: " + lastLine);
                            }
                            sb.setLength(0);
                        }
                        lastName = name;
                    }
                    sb.append("\n").append(line);
                    lastLine = line;
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        if (sb.length() > 0) {
            if (!overSet.contains(lastName)) {
                FileUtil.fileOutput((String)sb.substring(1), (String)((String)pathStart + lastName), (boolean)false);
            } else {
                log.error(lastName + " sort error line: " + lastLine);
            }
            sb.setLength(0);
        }
        overSet.clear();
    }

    public abstract long getTime(String var1);
}

