/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.file;

import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeFileLineRead {
    private static final Logger log = LoggerFactory.getLogger(TimeFileLineRead.class);
    protected long startName = -1L;
    protected long endName = -1L;
    private boolean isEnd = false;
    protected boolean isStop = false;

    public void setStartName(long startName) {
        this.startName = startName;
    }

    public void setStartName(String startName) {
        this.startName = Long.parseLong(startName);
    }

    public void setEndName(long endName) {
        this.endName = endName;
    }

    public void setEndName(String endName) {
        this.endName = Long.parseLong(endName);
    }

    public void read(String path) {
        this.isEnd = false;
        File[] files = FileUtil.getFiles((String)path);
        int dirCount = 0;
        for (File checkFile : files) {
            if (!checkFile.isDirectory()) continue;
            ++dirCount;
        }
        if (dirCount > 0) {
            int index = 0;
            File[] array = new File[files.length - dirCount];
            for (File file : files) {
                if (!file.isFile()) continue;
                array[index++] = file;
            }
            files = array;
        }
        if (files.length == 0) {
            log.debug("file length 0: " + path);
            return;
        }
        FileUtil.sortToNameLong((File[])files, (boolean)true);
        block10: for (File file : files) {
            if (this.startName != -1L || this.endName != -1L) {
                long name = Long.parseLong(file.getName());
                if (this.startName != -1L && name < this.startName || this.endName != -1L && name > this.endName) continue;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (this.isStop) break block10;
                    if ("".equals(line = line.trim())) continue;
                    this.addLine(line);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        this.end();
        this.isEnd = true;
    }

    public void stop() {
        this.isStop = true;
    }

    public void end() {
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public abstract void addLine(String var1);
}

