/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.csv;

import io.runon.trading.Trade;
import io.runon.trading.data.csv.CsvCommon;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvTrade {
    private static final Logger log = LoggerFactory.getLogger(CsvTrade.class);
    private static final Field TRADING_PRICE_FILED = CsvTrade.getTradingPriceFiled();

    private static Field getTradingPriceFiled() {
        try {
            Field field = Trade.class.getDeclaredField("tradingPrice");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String value(Trade trade) {
        StringBuilder sb = new StringBuilder();
        sb.append(trade.getTime());
        sb.append(",").append(trade.getType().toString());
        CsvCommon.append(sb, trade.getPrice());
        CsvCommon.append(sb, trade.getVolume());
        try {
            Object obj = TRADING_PRICE_FILED.get(trade);
            if (obj != null) {
                CsvCommon.append(sb, trade.getTradingPrice());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static Trade make(String csv) {
        String[] values = csv.split(",");
        long time = Long.parseLong(values[0]);
        Trade.Type type = Trade.Type.valueOf((String)values[1]);
        Trade trade = new Trade(type, CsvCommon.getBigDecimal(values[2]), CsvCommon.getBigDecimal(values[3]), time);
        if (values.length > 4) {
            trade.setTradingPrice(CsvCommon.getBigDecimal(values[4]));
        }
        return trade;
    }

    public static void main(String[] args) {
        Trade trade = new Trade(Trade.Type.BUY, new BigDecimal(1), new BigDecimal(2), System.currentTimeMillis());
        String value = CsvTrade.value(trade);
        System.out.println(value);
        trade = CsvTrade.make(value);
        System.out.println(CsvTrade.value(trade));
    }
}

