/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.csv;

import io.runon.trading.TradingTimes;
import io.runon.trading.data.file.TimeName;
import java.time.ZoneId;

public class CsvTimeName {
    public static String getPath(String dirPath, String symbol, long standardTime, ZoneId zoneId, long time) {
        return dirPath + "/" + symbol + "/" + TradingTimes.getInterval((long)standardTime) + "/" + CsvTimeName.getName(time, standardTime, zoneId);
    }

    public static String getPath(String dirPath, String symbol, long standardTime, ZoneId zoneId, String interval, long time) {
        return dirPath + "/" + symbol + "/" + interval + "/" + CsvTimeName.getName(time, standardTime, zoneId);
    }

    public static String getName(long time, long standardTime) {
        return CsvTimeName.getName(time, standardTime, TradingTimes.UTC_ZONE_ID);
    }

    public static String getName(long time, long standardTime, ZoneId zoneId) {
        TimeName.Type type = standardTime >= 86400000L ? TimeName.Type.YEAR_100 : (standardTime >= 0x6DDD00L ? TimeName.Type.YEAR_20 : (standardTime >= 3600000L ? TimeName.Type.YEAR_10 : (standardTime >= 300000L ? TimeName.Type.YEAR_1 : (standardTime >= 60000L ? TimeName.Type.MONTH_1 : (standardTime >= 5000L ? TimeName.Type.DAY_5 : (standardTime >= 2000L ? TimeName.Type.DAY_2 : (standardTime >= 1000L ? TimeName.Type.DAY_1 : TimeName.Type.HOUR_1)))))));
        return TimeName.getName(time, type, zoneId);
    }
}

