/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.csv;

import io.runon.trading.TradingTimes;
import io.runon.trading.data.csv.CsvCandle;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.symbol.SymbolCandle;
import io.runon.trading.technical.analysis.symbol.SymbolCandleData;
import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvSymbolCandle {
    private static final Logger log = LoggerFactory.getLogger(CsvSymbolCandle.class);
    private final String path;
    private final String interval;
    private final long candleTime;
    private ZoneId zoneId = TradingTimes.UTC_ZONE_ID;

    public CsvSymbolCandle(String path, String interval) {
        this.path = path;
        this.interval = interval;
        this.candleTime = TradingTimes.getIntervalTime((String)interval);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public SymbolCandle[] load(long startTime, long endTime) {
        String[] nullArray = null;
        return this.load(startTime, endTime, nullArray, null);
    }

    public SymbolCandle[] load(long startTime, long endTime, String startWith, String endWith) {
        String[] startWiths = new String[]{startWith};
        String[] endWiths = new String[]{endWith};
        return this.load(startTime, endTime, startWiths, endWiths);
    }

    public SymbolCandle[] load(long startTime, long endTime, String[] startWiths, String[] endWiths) {
        if (startTime == -1L || endTime == -1L || startTime >= endTime) {
            throw new IllegalArgumentException("time error start time: " + startTime + ", end time: " + endTime);
        }
        File[] files = new File(this.path).listFiles();
        if (files == null) {
            log.info("path file length 0: " + this.path);
            return SymbolCandle.EMPTY_ARRAY;
        }
        ArrayList<SymbolCandleData> list = new ArrayList<SymbolCandleData>();
        for (File file : files) {
            TradeCandle[] candles;
            boolean isLike;
            if (!file.isDirectory()) continue;
            String symbol = file.getName();
            if (startWiths != null) {
                isLike = false;
                for (String startWith : startWiths) {
                    if (!symbol.startsWith(startWith)) continue;
                    isLike = true;
                    break;
                }
                if (!isLike) continue;
            }
            if (endWiths != null) {
                isLike = false;
                for (String endWith : endWiths) {
                    if (!symbol.endsWith(endWith)) continue;
                    isLike = true;
                    break;
                }
                if (!isLike) continue;
            }
            if ((candles = CsvCandle.load(file.getAbsolutePath() + "/" + this.interval, this.candleTime, startTime, endTime, this.zoneId)).length == 0) continue;
            list.add(new SymbolCandleData(symbol, candles));
        }
        if (list.size() == 0) {
            return SymbolCandle.EMPTY_ARRAY;
        }
        SymbolCandle[] array = list.toArray(new SymbolCandle[0]);
        list.clear();
        return array;
    }
}

