/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.csv;

import com.seomse.commons.utils.FileUtil;
import com.seomse.commons.validation.FileValidation;
import com.seomse.commons.validation.NumberNameFileValidation;
import io.runon.trading.oi.LongShortRatio;
import io.runon.trading.oi.LongShortRatioData;
import io.runon.trading.oi.OpenInterest;
import io.runon.trading.oi.OpenInterestData;
import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;

public class CsvOpenInterest {
    public static String value(OpenInterest openInterest) {
        return CsvOpenInterest.value(openInterest.getTime(), openInterest.getOpenInterest(), openInterest.getNotionalValue());
    }

    public static String value(long time, BigDecimal openInterest, BigDecimal notionalValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(time).append(",").append(openInterest.stripTrailingZeros().toPlainString());
        if (notionalValue != null) {
            sb.append(",").append(notionalValue.stripTrailingZeros().toPlainString());
        }
        return sb.toString();
    }

    public static OpenInterest[] loadOpenInterest(String path) {
        return CsvOpenInterest.loadOpenInterest(path, 0);
    }

    public static OpenInterest[] loadOpenInterest(String path, int limit) {
        String[] lines = FileUtil.getLines((File)new File(path), (Charset)StandardCharsets.UTF_8, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG, (int)limit);
        OpenInterest[] array = new OpenInterest[lines.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = CsvOpenInterest.make(lines[i]);
        }
        return array;
    }

    public static LongShortRatio[] loadLongShortRatio(String path) {
        return CsvOpenInterest.loadLongShortRatio(path, 0);
    }

    public static LongShortRatio[] loadLongShortRatio(String path, int limit) {
        String[] lines = FileUtil.getLines((File)new File(path), (Charset)StandardCharsets.UTF_8, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG, (int)limit);
        LongShortRatio[] array = new LongShortRatio[lines.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = CsvOpenInterest.makeLongShortRatio(lines[i]);
        }
        return array;
    }

    public static OpenInterest make(String csv) {
        String[] values = csv.split(",");
        OpenInterestData openInterestData = new OpenInterestData();
        openInterestData.setTime(Long.parseLong(values[0]));
        openInterestData.setOpenInterest(new BigDecimal(values[1]));
        if (values.length > 2) {
            openInterestData.setNotionalValue(new BigDecimal(values[2]));
        }
        return openInterestData;
    }

    public static LongShortRatio makeLongShortRatio(String csv) {
        String[] values = csv.split(",");
        LongShortRatioData longShortRatioData = new LongShortRatioData();
        longShortRatioData.setTime(Long.parseLong(values[0]));
        longShortRatioData.setRatio(new BigDecimal(values[1]));
        if (values.length > 2) {
            longShortRatioData.setLongAccount(new BigDecimal(values[2]));
            longShortRatioData.setShortAccount(new BigDecimal(values[3]));
        }
        return longShortRatioData;
    }
}

