/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.csv;

import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.FileUtil;
import com.seomse.commons.validation.FileValidation;
import com.seomse.commons.validation.NumberNameFileValidation;
import io.runon.trading.data.csv.CsvCommon;
import io.runon.trading.data.csv.CsvTimeFile;
import io.runon.trading.data.csv.CsvTimeName;
import io.runon.trading.technical.analysis.candle.TimeCandle;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CsvCandle {
    public static TradeCandle[] load(String path, long time) {
        return CsvCandle.load(new File(path), time);
    }

    public static TradeCandle[] load(File file, long time) {
        ArrayList<TradeCandle> list = new ArrayList<TradeCandle>();
        if (file.isFile()) {
            CsvCandle.addFile(list, file, time);
        } else {
            File[] files;
            for (File f : files = FileUtil.getFiles((String)file.getAbsolutePath(), (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG)) {
                CsvCandle.addFile(list, f, time);
            }
        }
        TradeCandle[] candles = list.toArray(new TradeCandle[0]);
        list.clear();
        return candles;
    }

    public static TradeCandle[] load(String path, long time, int limit) {
        if (limit < 1) {
            return CsvCandle.load(new File(path), time);
        }
        String[] lines = FileUtil.getLines((File)new File(path), (Charset)StandardCharsets.UTF_8, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG, (int)limit);
        TradeCandle[] candles = new TradeCandle[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            candles[i] = CsvCandle.make(lines[i], time);
        }
        return candles;
    }

    public static void addFile(List<TradeCandle> list, File file, long time) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(CsvCandle.make(line, time));
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void out(String path, TradeCandle[] candles) {
        if (candles.length == 0) {
            throw new IllegalArgumentException("candles length > 0");
        }
        StringBuilder sb = new StringBuilder();
        for (TradeCandle candle : candles) {
            sb.append("\n").append(CsvCandle.value(candle));
        }
        FileUtil.fileOutput((String)sb.substring(1), (String)path, (boolean)false);
    }

    public static String value(TradeCandle tradeCandle) {
        StringBuilder sb = new StringBuilder();
        sb.append(tradeCandle.getOpenTime());
        CsvCommon.append(sb, tradeCandle.getClose());
        CsvCommon.append(sb, tradeCandle.getOpen());
        CsvCommon.append(sb, tradeCandle.getHigh());
        CsvCommon.append(sb, tradeCandle.getLow());
        CsvCommon.append(sb, tradeCandle.getPrevious());
        CsvCommon.append(sb, tradeCandle.getVolume());
        CsvCommon.append(sb, tradeCandle.getTradingPrice());
        sb.append(",").append(tradeCandle.getTradeCount());
        CsvCommon.append(sb, tradeCandle.getBuyVolume());
        CsvCommon.append(sb, tradeCandle.getBuyTradingPrice());
        return sb.toString();
    }

    public static long getOpenTime(String csvLine) {
        return CsvTimeFile.getTime(csvLine);
    }

    public static String value(long time, TradeCandle tradeCandle) {
        return time + "," + CsvCandle.value(tradeCandle);
    }

    public static TimeCandle makeTimeCandle(String csv, long time) {
        int index = csv.indexOf(44);
        long initTime = Long.parseLong(csv.substring(0, index));
        return new TimeCandle(initTime, CsvCandle.make(csv.substring(index + 1), time));
    }

    public static TradeCandle make(String csv, long time) {
        String[] values = csv.split(",", -1);
        return CsvCandle.make(values, time);
    }

    public static TradeCandle make(String[] values, long time) {
        long openTime = Long.parseLong(values[0]);
        TradeCandle tradeCandle = new TradeCandle();
        tradeCandle.setOpenTime(openTime);
        tradeCandle.setCloseTime(openTime + time);
        tradeCandle.setClose(CsvCommon.getBigDecimal(values[1]));
        tradeCandle.setOpen(CsvCommon.getBigDecimal(values[2]));
        tradeCandle.setHigh(CsvCommon.getBigDecimal(values[3]));
        tradeCandle.setLow(CsvCommon.getBigDecimal(values[4]));
        tradeCandle.setPrevious(CsvCommon.getBigDecimal(values[5]));
        tradeCandle.setVolume(CsvCommon.getBigDecimal(values[6]));
        tradeCandle.setTradingPrice(CsvCommon.getBigDecimal(values[7]));
        if (values[8] != null && !values[8].equals("")) {
            tradeCandle.setTradeCount(Integer.parseInt(values[8]));
        }
        if (tradeCandle.getPrevious() == null) {
            tradeCandle.setPrevious(tradeCandle.getOpen());
        }
        if (values[9] != null && !values[9].equals("")) {
            tradeCandle.setBuyVolume(CsvCommon.getBigDecimal(values[9]));
        }
        if (values[10] != null && !values[10].equals("")) {
            tradeCandle.setBuyTradingPrice(CsvCommon.getBigDecimal(values[10]));
        }
        tradeCandle.setSellVolume();
        tradeCandle.setSellTradingPrice();
        tradeCandle.setChange();
        tradeCandle.setEndTrade();
        return tradeCandle;
    }

    public static TradeCandle[] load(String path, long candleTime, long startTime, long endTime, ZoneId zoneId) {
        File[] files = FileUtil.getFiles((String)path, (FileValidation)new NumberNameFileValidation(), (Comparator)FileUtil.SORT_NAME_LONG);
        if (files.length == 0) {
            return TradeCandle.EMPTY_CANDLES;
        }
        String startName = CsvTimeName.getName(startTime, candleTime, zoneId);
        String endName = CsvTimeName.getName(endTime, candleTime, zoneId);
        int startFileNum = Integer.parseInt(startName);
        int endFileNum = Integer.parseInt(endName);
        ArrayList<TradeCandle> candleList = new ArrayList<TradeCandle>();
        block8: for (File file : files) {
            int fileNum = Integer.parseInt(file.getName());
            if (fileNum < startFileNum) continue;
            if (fileNum > endFileNum) break;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] values = line.split(",");
                    long openTime = Long.parseLong(values[0]);
                    long closeTime = openTime + candleTime;
                    if (openTime < startTime) continue;
                    if (closeTime > endTime) break block8;
                    candleList.add(CsvCandle.make(values, candleTime));
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        TradeCandle[] candles = candleList.toArray(new TradeCandle[0]);
        candleList.clear();
        return candles;
    }
}

