/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.candle;

import com.seomse.commons.utils.FileUtil;
import io.runon.trading.data.csv.CsvCandle;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.candle.candles.TradeCandles;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandleStorage {
    private static final Logger log = LoggerFactory.getLogger(CandleStorage.class);
    private final Map<Long, TradeCandles> candlesMap = new HashMap<Long, TradeCandles>();

    public TradeCandles loadCandle(String path, long time) {
        if (!FileUtil.isFile((String)path)) {
            log.error("candle file not find: " + path);
            return null;
        }
        TradeCandle[] candles = CsvCandle.load(path, time);
        TradeCandles tradeCandles = new TradeCandles(time);
        tradeCandles.setCount(candles.length);
        tradeCandles.addCandle(candles);
        this.candlesMap.put(time, tradeCandles);
        return tradeCandles;
    }

    public TradeCandle[] getCandles(long time, long endTime, int count) {
        return this.candlesMap.get(time).getCandles(endTime, count);
    }

    public TradeCandle[] getCandles(long time) {
        return this.candlesMap.get(time).getCandles();
    }

    public TradeCandle[] getCandles(long time, int count) {
        return this.candlesMap.get(time).getCandles(count);
    }
}

