/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.indicator.ma;

import io.runon.trading.Price;
import io.runon.trading.technical.analysis.CandleBigDecimalChange;
import java.math.BigDecimal;
import java.math.MathContext;

public class MovingAverage {
    public static BigDecimal getAverage(Price[] array, int n) {
        int averageCount = Math.min(array.length, n);
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = array.length - averageCount; i < array.length; ++i) {
            sum = sum.add(array[i].getClose());
        }
        return sum.divide(new BigDecimal(averageCount), MathContext.DECIMAL128);
    }

    public static BigDecimal getAverage(BigDecimal[] array, int n) {
        int averageCount = Math.min(array.length, n);
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = array.length - averageCount; i < array.length; ++i) {
            sum = sum.add(array[i]);
        }
        return sum.divide(new BigDecimal(averageCount), MathContext.DECIMAL128);
    }

    public static BigDecimal[] getArray(Price[] array, int n, int averageCount) {
        return MovingAverage.getArray(CandleBigDecimalChange.getCloseArray(array), n, averageCount);
    }

    public static BigDecimal[] getArray(BigDecimal[] array, int n, int averageCount) {
        if (averageCount > array.length) {
            averageCount = array.length;
        }
        BigDecimal[] averages = new BigDecimal[averageCount];
        int arrayGap = array.length - averageCount + 1;
        for (int i = 0; i < averageCount; ++i) {
            int end = arrayGap + i;
            int start = end - n;
            double length = n;
            if (start < 0) {
                start = 0;
                length = end;
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (int j = start; j < end; ++j) {
                sum = sum.add(array[j]);
            }
            averages[i] = sum.divide(new BigDecimal(length), MathContext.DECIMAL128);
        }
        return averages;
    }
}

