/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.pattern.upper.shadow;

import io.runon.trading.BigDecimals;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.pattern.CandlePatternPoint;
import io.runon.trading.technical.analysis.trend.line.TrendLine;
import java.math.BigDecimal;
import java.math.MathContext;

public class UpperShadowPattern {
    public static boolean isValid(TradeCandle tradeCandle) {
        if (tradeCandle.getType() != CandleStick.Type.UPPER_SHADOW) {
            return false;
        }
        BigDecimal change = tradeCandle.changeAbs();
        BigDecimal upperTail = tradeCandle.getUpperTail();
        if (change.multiply(BigDecimals.DECIMAL_2_5).compareTo(upperTail) > 0) {
            return false;
        }
        BigDecimal lowerTail = tradeCandle.getLowerTail();
        return lowerTail.multiply(BigDecimals.DECIMAL_2).compareTo(change) <= 0;
    }

    public static CandlePatternPoint makePoint(TrendLine trendLine, TradeCandle[] candles, int index, BigDecimal shortGapPercent) {
        TradeCandle tradeCandle = candles[index];
        if (!UpperShadowPattern.isValid(tradeCandle)) {
            return null;
        }
        BigDecimal trendLineScore = trendLine.score(candles, index, 7, shortGapPercent);
        if (trendLineScore == null) {
            return null;
        }
        if (trendLineScore.compareTo(BigDecimal.ONE) < 0) {
            return null;
        }
        if (trendLineScore.compareTo(BigDecimals.DECIMAL_1_5) > 0) {
            trendLineScore = BigDecimals.DECIMAL_1_5;
        }
        BigDecimal absChange = tradeCandle.changeAbs();
        BigDecimal upperTail = tradeCandle.getUpperTail();
        BigDecimal score = upperTail.divide(absChange.multiply(BigDecimals.DECIMAL_2), MathContext.DECIMAL128).multiply(trendLineScore);
        return new CandlePatternPoint(candles[index], score);
    }
}

