/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import com.seomse.commons.utils.time.DateUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class CandleTime {
    public static String ymdhm(long time, ZoneId zoneId) {
        Instant i = Instant.ofEpochMilli(time);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(i, zoneId);
        return zonedDateTime.getYear() + DateUtil.getDateText((int)zonedDateTime.getMonthValue()) + DateUtil.getDateText((int)zonedDateTime.getDayOfMonth()) + " " + DateUtil.getDateText((int)zonedDateTime.getHour()) + DateUtil.getDateText((int)zonedDateTime.getMinute());
    }

    public static long getIntervalTime(String interval) {
        long time;
        char timeUnit = interval.charAt(interval.length() - 1);
        String timeNumber = interval.substring(0, interval.length() - 1);
        if (timeUnit == 'm') {
            time = 60000L * Long.parseLong(timeNumber);
        } else if (timeUnit == 'h') {
            time = 3600000L * Long.parseLong(timeNumber);
        } else if (timeUnit == 'd') {
            time = 86400000L * Long.parseLong(timeNumber);
        } else if (timeUnit == 's') {
            time = 1000L * Long.parseLong(timeNumber);
        } else if (timeUnit == 'w') {
            time = 604800000L * Long.parseLong(timeNumber);
        } else {
            if (timeUnit == 'M') {
                throw new IllegalArgumentException("interval error: " + interval);
            }
            throw new IllegalArgumentException("interval error: " + interval);
        }
        return time;
    }
}

