/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import io.runon.trading.Trade;
import io.runon.trading.technical.analysis.candle.candles.TradeCandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CandleManager {
    private final Map<Long, TradeCandles> candleMap = new HashMap<Long, TradeCandles>();
    private final TradeCandles[] tradeCandles;

    public CandleManager(long[] candleTimes) {
        TradeCandles[] tradeCandles = new TradeCandles[candleTimes.length];
        for (int i = 0; i < candleTimes.length; ++i) {
            tradeCandles[i] = new TradeCandles(candleTimes[i]);
            this.candleMap.put(candleTimes[i], tradeCandles[i]);
        }
        this.tradeCandles = tradeCandles;
    }

    public void setSaveCount(int saveCount) {
        for (TradeCandles tradeCandle : this.tradeCandles) {
            tradeCandle.setCount(saveCount);
        }
    }

    public void addTrade(Trade trade) {
        for (TradeCandles tradeCandles : this.tradeCandles) {
            tradeCandles.addTrade(trade);
        }
    }

    public TradeCandles getCandles(long time) {
        return this.candleMap.get(time);
    }

    public long[] getTimes() {
        long[] times = new long[this.candleMap.size()];
        Set<Long> keys = this.candleMap.keySet();
        int index = 0;
        for (Long time : keys) {
            times[index] = time;
            ++index;
        }
        Arrays.sort(times);
        return times;
    }
}

