/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import io.runon.trading.technical.analysis.candle.TradeCandle;

public class CandleCombine {
    private final TradeCandle[] candles;
    private boolean isOpenTimeChange = false;
    private final long time;

    public CandleCombine(TradeCandle[] candles) {
        this.candles = candles;
        this.time = candles[0].getCloseTime() - candles[0].getOpenTime();
    }

    public TradeCandle combineLast(int count) {
        if (count > this.candles.length) {
            count = this.candles.length;
        }
        TradeCandle candle = new TradeCandle();
        for (int i = this.candles.length - count; i < this.candles.length; ++i) {
            candle.addCandle(this.candles[i]);
        }
        if (this.isOpenTimeChange) {
            candle.setOpenTime(candle.getCloseTime() - this.time);
        }
        candle.setChange();
        return candle;
    }

    public TradeCandle[] combine(int count) {
        if (count >= this.candles.length) {
            TradeCandle[] combineCandle = new TradeCandle[]{this.combineLast(count)};
            return combineCandle;
        }
        return this.combine(count, count - 1, this.candles.length);
    }

    public TradeCandle[] combine(int count, int startIndex, int end) {
        TradeCandle[] combineCandles = new TradeCandle[end - startIndex];
        int idx = 0;
        for (int i = startIndex; i < end; ++i) {
            int combineEnd = i + 1;
            int combineStart = combineEnd - count;
            if (combineStart < 0) {
                combineStart = 0;
            }
            TradeCandle candle = new TradeCandle();
            for (int j = combineStart; j < combineEnd; ++j) {
                candle.addCandle(this.candles[j]);
            }
            if (this.isOpenTimeChange) {
                candle.setOpenTime(candle.getCloseTime() - this.time);
            }
            candle.setChange();
            combineCandles[idx++] = candle;
        }
        return combineCandles;
    }

    public void setOpenTimeChange(boolean openTimeChange) {
        this.isOpenTimeChange = openTimeChange;
    }
}

