/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.indicator.ichimoku;

import com.seomse.commons.utils.time.DateUtil;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.indicator.ichimoku.IchimokuAnalysisData;
import io.runon.trading.technical.analysis.indicator.ichimoku.IchimokuData;

public class IchimokuBalanceAnalysis {
    public static IchimokuAnalysisData[] getAnalysisDataArray(CandleStick[] candleStickArray, IchimokuData[] ichimokuDataArray) {
        int i;
        IchimokuAnalysisData[] resultArray = new IchimokuAnalysisData[candleStickArray.length];
        for (i = candleStickArray.length - 1; i >= 0; --i) {
            double closePrice = candleStickArray[i].getClose().doubleValue();
            String openStr = DateUtil.getDateYmd((long)candleStickArray[i].getOpenTime(), (String)"yyyy-MM-dd");
            long time = candleStickArray[i].getOpenTime();
            boolean cloudStart = false;
            double cloudSize = 0.0;
            double cloudAvgHeight = 0.0;
            boolean cloudPriceOverlap = false;
            double leading1Price = ichimokuDataArray[i].getLeading1();
            double leading2Price = ichimokuDataArray[i].getLeading2();
            double cloudTopPrice = -1.0;
            double cloudBottomPrice = -1.0;
            if (leading1Price >= leading2Price) {
                cloudTopPrice = leading1Price;
                cloudBottomPrice = leading2Price;
            } else {
                cloudTopPrice = leading2Price;
                cloudBottomPrice = leading1Price;
            }
            if (closePrice <= cloudTopPrice && closePrice >= cloudBottomPrice) {
                cloudPriceOverlap = true;
            }
            double cloudHeightDistance = 0.0;
            if (!cloudPriceOverlap) {
                if (cloudBottomPrice < closePrice) {
                    double diffPrice = cloudBottomPrice - closePrice;
                    cloudHeightDistance = diffPrice / closePrice * -1.0;
                } else {
                    double diffPrice = closePrice - cloudTopPrice;
                    cloudHeightDistance = diffPrice / closePrice;
                }
            }
            Enum cloudType = null;
            int cloudCalcCount = 0;
            for (int j = i; j >= 0; --j) {
                double cloudHeight;
                ++cloudCalcCount;
                double loopLeading1Price = ichimokuDataArray[j].getLeading1();
                double loopLeading2Price = ichimokuDataArray[j].getLeading2();
                if (loopLeading1Price == -1.0 || loopLeading2Price == -1.0) continue;
                double leadingPriceDistance = loopLeading1Price - loopLeading2Price;
                if (leadingPriceDistance < 0.0) {
                    leadingPriceDistance *= -1.0;
                }
                if ((cloudHeight = leadingPriceDistance / (closePrice / 0.01)) < 0.0) {
                    cloudHeight *= -1.0;
                }
                if (loopLeading1Price == loopLeading2Price) continue;
                if (loopLeading1Price > loopLeading2Price) {
                    if (cloudStart && cloudType.equals((Object)IchimokuAnalysisData.IchimokuCloudType.NEGATIVE)) break;
                    cloudStart = true;
                    cloudType = IchimokuAnalysisData.IchimokuCloudType.POSITIVE;
                } else {
                    if (cloudStart && cloudType.equals((Object)IchimokuAnalysisData.IchimokuCloudType.POSITIVE)) break;
                    cloudStart = true;
                    cloudType = IchimokuAnalysisData.IchimokuCloudType.NEGATIVE;
                }
                cloudSize += cloudHeight;
            }
            cloudAvgHeight = cloudSize / (double)cloudCalcCount;
            IchimokuAnalysisData ichimokuAnalysisData = new IchimokuAnalysisData();
            ichimokuAnalysisData.setCloudSize(cloudSize);
            ichimokuAnalysisData.setCloudAvgHeight(cloudAvgHeight);
            ichimokuAnalysisData.setCloudType((IchimokuAnalysisData.IchimokuCloudType)cloudType);
            ichimokuAnalysisData.setTime(time);
            ichimokuAnalysisData.setCloudHeightDistance(cloudHeightDistance);
            ichimokuAnalysisData.setCloudPriceOverlap(cloudPriceOverlap);
            resultArray[i] = ichimokuAnalysisData;
        }
        for (i = 1; i < resultArray.length; ++i) {
            IchimokuAnalysisData loopIchimokuAnalysisData;
            double loopCloudHeightDistance;
            boolean upper;
            IchimokuAnalysisData ichimokuAnalysisData = resultArray[i];
            double cloudHeightDistance = ichimokuAnalysisData.getCloudHeightDistance();
            boolean bl = upper = cloudHeightDistance >= 0.0;
            if (cloudHeightDistance == 0.0) {
                ichimokuAnalysisData.setCloudBreakThroughDay(0);
                continue;
            }
            int dayCount = 0;
            for (int j = i - 1; j > 0 && (loopCloudHeightDistance = (loopIchimokuAnalysisData = resultArray[j]).getCloudHeightDistance()) != 0.0; --j) {
                boolean loopUpper;
                boolean bl2 = loopUpper = loopCloudHeightDistance >= 0.0;
                if (upper != loopUpper) break;
                ++dayCount;
            }
            if (cloudHeightDistance < 0.0) {
                dayCount = (int)((double)dayCount * -1.0);
            }
            ichimokuAnalysisData.setCloudBreakThroughDay(dayCount);
        }
        return resultArray;
    }
}

