/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.indicator;

import io.runon.trading.BigDecimals;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Cross {
    public static final int MIN_COUNT = 15;
    public static final Cross NONE = Cross.none();
    Type type;
    int index;
    BigDecimal disparity;

    private static Cross none() {
        Cross none = new Cross();
        none.type = Type.NONE;
        return none;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public BigDecimal getDisparity() {
        return this.disparity;
    }

    public static Cross getCross(BigDecimal[] shotArray, BigDecimal[] longArray, BigDecimal disparity) {
        return Cross.getCross(shotArray, longArray, disparity, 15);
    }

    public static Cross getCross(BigDecimal[] shotArray, BigDecimal[] longArray, BigDecimal disparity, int minCount) {
        int lastIndex = longArray.length - 1;
        if (disparity == null || disparity.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("disparity more than 0: " + disparity);
        }
        if (shotArray.length < minCount) {
            throw new IllegalArgumentException("array length more than min count array: " + shotArray.length + ", min count:" + minCount);
        }
        if (shotArray.length != longArray.length) {
            throw new IllegalArgumentException("shotArray.length == longArray.length short length: " + shotArray.length + ", long length: " + longArray.length);
        }
        if (shotArray[lastIndex].compareTo(longArray[lastIndex]) > 0 && disparity.compareTo(BigDecimals.DECIMAL_100) >= 0) {
            int crossIndex = Cross.getCrossIndex(longArray, shotArray, minCount);
            if (crossIndex == -1) {
                return NONE;
            }
            int index = shotArray.length - 1;
            BigDecimal lastDisparity = shotArray[index].divide(longArray[index], 10, RoundingMode.HALF_UP).multiply(BigDecimals.DECIMAL_100);
            if (lastDisparity.compareTo(disparity) < 0) {
                return NONE;
            }
            if (Cross.isBetween(shotArray, longArray, crossIndex, shotArray.length - 1, disparity, true)) {
                return NONE;
            }
            Cross cross = new Cross();
            cross.type = Type.GOLDEN;
            cross.index = crossIndex;
            cross.disparity = lastDisparity;
            return cross;
        }
        if (shotArray[lastIndex].compareTo(longArray[lastIndex]) < 0 && disparity.compareTo(BigDecimals.DECIMAL_100) <= 0) {
            int crossIndex = Cross.getCrossIndex(shotArray, longArray, minCount);
            if (crossIndex == -1) {
                return NONE;
            }
            int index = shotArray.length - 1;
            BigDecimal lastDisparity = shotArray[index].divide(longArray[index], 10, RoundingMode.HALF_UP).multiply(BigDecimals.DECIMAL_100);
            if (lastDisparity.compareTo(disparity) > 0) {
                return NONE;
            }
            if (Cross.isBetween(shotArray, longArray, crossIndex, shotArray.length - 1, disparity, false)) {
                return NONE;
            }
            Cross cross = new Cross();
            cross.type = Type.DEAD;
            cross.index = crossIndex;
            cross.disparity = lastDisparity;
            return cross;
        }
        return NONE;
    }

    public static boolean isBetween(BigDecimal[] shotArray, BigDecimal[] longArray, int start, int end, BigDecimal disparity, boolean isLong) {
        for (int i = start; i < end; ++i) {
            if (isLong && shotArray[i].divide(longArray[i], 10, RoundingMode.HALF_UP).multiply(BigDecimals.DECIMAL_100).compareTo(disparity) >= 0) {
                return true;
            }
            if (isLong || shotArray[i].divide(longArray[i], 10, RoundingMode.HALF_UP).multiply(BigDecimals.DECIMAL_100).compareTo(disparity) > 0) continue;
            return true;
        }
        return false;
    }

    private static int getCrossIndex(BigDecimal[] small, BigDecimal[] large, int minCount) {
        int min = minCount - 1;
        int index = -1;
        for (int i = small.length - 2; i > min; --i) {
            if (large[i].compareTo(small[i]) >= 0) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return -1;
        }
        int count = 0;
        for (int i = index; i > -1 && large[i].compareTo(small[i]) <= 0; --i) {
            if (large[i].compareTo(small[i]) <= 0) {
                ++count;
            }
            if (count < minCount) continue;
            return index + 1;
        }
        if (count < minCount) {
            return -1;
        }
        return index + 1;
    }

    public static enum Type {
        NONE,
        GOLDEN,
        DEAD;

    }
}

