/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.subindex.rsi;

import io.runon.trading.BigDecimals;
import io.runon.trading.PriceChangeRate;
import io.runon.trading.technical.analysis.CandleBigDecimalChange;
import io.runon.trading.technical.analysis.subindex.ma.MovingAverage;
import java.math.BigDecimal;
import java.math.MathContext;

public class RSI {
    public static final int DEFAULT_N = 14;
    public static final int DEFAULT_SIGNAL = 6;

    public static BigDecimal getScore(PriceChangeRate[] priceChangeRates) {
        BigDecimal[] array = CandleBigDecimalChange.getChangeRateArray(priceChangeRates);
        return RSI.getScore(array, 14, array.length);
    }

    public static BigDecimal getScore(PriceChangeRate[] priceChangeRates, int n, int end) {
        BigDecimal[] array = CandleBigDecimalChange.getChangeRateArray(priceChangeRates);
        return RSI.getScore(array, n, end);
    }

    public static BigDecimal getScore(BigDecimal[] priceChangeRates) {
        return RSI.getScore(priceChangeRates, 14, priceChangeRates.length);
    }

    public static BigDecimal getScore(BigDecimal[] priceChangeRates, int n, int end) {
        int upCount = 0;
        int downCount = 0;
        BigDecimal upSum = BigDecimal.ZERO;
        BigDecimal downSum = BigDecimal.ZERO;
        int start = end - n;
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < end; ++i) {
            if (priceChangeRates[i].compareTo(BigDecimal.ZERO) > 0) {
                ++upCount;
                upSum = upSum.add(priceChangeRates[i]);
                continue;
            }
            if (priceChangeRates[i].compareTo(BigDecimal.ZERO) >= 0) continue;
            ++downCount;
            downSum = downSum.add(priceChangeRates[i]);
        }
        if (upCount == 0) {
            return BigDecimal.ZERO;
        }
        if (downCount == 0) {
            return BigDecimals.DECIMAL_100;
        }
        BigDecimal averageUps = upSum.divide(new BigDecimal(upCount), MathContext.DECIMAL128);
        BigDecimal averageDowns = downSum.divide(new BigDecimal(downCount).multiply(BigDecimals.DECIMAL_M_1), MathContext.DECIMAL128);
        BigDecimal rs = averageUps.divide(averageDowns, MathContext.DECIMAL128);
        BigDecimal rsi = rs.divide(BigDecimal.ONE.add(rs), MathContext.DECIMAL128);
        return rsi.multiply(BigDecimals.DECIMAL_100);
    }

    public static BigDecimal[] getScores(BigDecimal[] priceChangeRates, int n, int rsiCount) {
        if (rsiCount > priceChangeRates.length) {
            rsiCount = priceChangeRates.length;
        }
        BigDecimal[] rsiScores = new BigDecimal[rsiCount];
        int endGap = rsiCount;
        for (int i = 0; i < rsiCount; ++i) {
            rsiScores[i] = RSI.getScore(priceChangeRates, n, priceChangeRates.length - endGap--);
        }
        return rsiScores;
    }

    public static BigDecimal[] getSignal(BigDecimal[] rsiArray) {
        return MovingAverage.getArray(rsiArray, 6, rsiArray.length - 5);
    }

    public static BigDecimal[] getSignal(BigDecimal[] rsiArray, int n, int signalCount) {
        return MovingAverage.getArray(rsiArray, n, signalCount);
    }
}

