/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.subindex.ma;

import io.runon.trading.technical.analysis.CandleBigDecimalChange;
import io.runon.trading.technical.analysis.candle.Candle;
import java.math.BigDecimal;
import java.math.MathContext;

public class MovingAverage {
    public static BigDecimal[] getArray(Candle[] candles, int n, int averageCount) {
        return MovingAverage.getArray(CandleBigDecimalChange.getCloseArray(candles), n, averageCount);
    }

    public static BigDecimal[] getArray(BigDecimal[] array, int n, int averageCount) {
        if (averageCount > array.length) {
            averageCount = array.length;
        }
        BigDecimal[] averages = new BigDecimal[averageCount];
        int arrayGap = array.length - averageCount + 1;
        for (int i = 0; i < averageCount; ++i) {
            int end = arrayGap + i;
            int start = end - n;
            double length = n;
            if (start < 0) {
                start = 0;
                length = end;
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (int j = start; j < end; ++j) {
                sum = sum.add(array[j]);
            }
            averages[i] = sum.divide(new BigDecimal(length), MathContext.DECIMAL128);
        }
        return averages;
    }
}

