/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.pattern;

import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.candle.candles.CandleChangeObserver;
import io.runon.trading.technical.analysis.candle.candles.TradeCandles;
import io.runon.trading.technical.analysis.pattern.CandlePattern;
import io.runon.trading.technical.analysis.pattern.CandlePatternPoint;
import java.math.BigDecimal;
import java.util.ArrayList;

public abstract class CandlePatternDefault
implements CandlePattern {
    protected TradeCandles tradeCandles;
    protected CandlePatternPoint lastPoint;
    protected TradeCandle lastCheckCandle = null;
    protected CandleChangeObserver candleChangeObserver = null;

    @Override
    public void setCandles(TradeCandles tradeCandles) {
        this.tradeCandles = tradeCandles;
    }

    @Override
    public void initRealTime() {
        TradeCandle[] candles = this.tradeCandles.getCandles();
        if (candles.length == 0) {
            return;
        }
        this.lastCheckCandle = candles[candles.length - 1];
        for (int i = candles.length - 1; i > -1; --i) {
            CandlePatternPoint point = this.getPoint(candles, i, this.tradeCandles.getShortGapRatio());
            if (point == null) continue;
            this.lastPoint = point;
            return;
        }
        this.setObserver();
    }

    public void setObserver() {
        this.candleChangeObserver = (lastEndCandle, newCandle) -> this.changeLastCandle(lastEndCandle);
        this.tradeCandles.addChangeObserver(this.candleChangeObserver);
    }

    public void removeObserver() {
        if (this.candleChangeObserver == null) {
            return;
        }
        this.tradeCandles.removeObserver(this.candleChangeObserver);
    }

    public void changeLastCandle(TradeCandle lastEndCandle) {
        if (lastEndCandle == null) {
            return;
        }
        if (lastEndCandle == this.lastCheckCandle) {
            return;
        }
        this.lastCheckCandle = lastEndCandle;
        TradeCandle[] candles = this.tradeCandles.getCandles();
        for (int i = candles.length - 1; i > -1; --i) {
            TradeCandle tradeCandle = candles[i];
            if (tradeCandle != lastEndCandle) continue;
            CandlePatternPoint point = this.getPoint(candles, i, this.tradeCandles.getShortGapRatio());
            if (point == null) break;
            this.lastPoint = point;
            break;
        }
    }

    @Override
    public CandlePatternPoint[] getPoints() {
        TradeCandle[] candles = this.tradeCandles.getCandles();
        ArrayList<CandlePatternPoint> pointList = null;
        for (int i = 5; i < candles.length; ++i) {
            CandlePatternPoint point = this.getPoint(candles, i, this.tradeCandles.getShortGapRatio());
            if (point == null) continue;
            if (pointList == null) {
                pointList = new ArrayList<CandlePatternPoint>();
            }
            pointList.add(point);
        }
        if (pointList == null) {
            return CandlePatternPoint.EMPTY_POINT;
        }
        CandlePatternPoint[] result = pointList.toArray(new CandlePatternPoint[pointList.size()]);
        pointList.clear();
        return result;
    }

    @Override
    public CandlePatternPoint getLastPoint() {
        return this.lastPoint;
    }

    public abstract CandlePatternPoint getPoint(TradeCandle[] var1, int var2, BigDecimal var3);
}

