/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import io.runon.trading.BigDecimals;
import io.runon.trading.Trade;
import io.runon.trading.technical.analysis.candle.CandleStick;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeCandle
extends CandleStick {
    private static final Logger logger = LoggerFactory.getLogger(TradeCandle.class);
    private BigDecimal volume = BigDecimal.ZERO;
    private BigDecimal buyVolume = BigDecimal.ZERO;
    private BigDecimal sellVolume = BigDecimal.ZERO;
    private BigDecimal tradingPrice = BigDecimal.ZERO;
    private BigDecimal buyTradingPrice = BigDecimal.ZERO;
    private BigDecimal sellTradingPrice = BigDecimal.ZERO;
    private int tradeCount = 0;
    private List<Trade> tradeList = null;
    private boolean isTradeRecord = false;
    private boolean isInit = false;
    private long lastTradeTime = System.currentTimeMillis();
    public static final BigDecimal MAX_STRENGTH = new BigDecimal(500);
    private BigDecimal strength = null;

    public BigDecimal getAverage() {
        return this.tradingPrice.divide(this.volume, MathContext.DECIMAL128);
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public void setTradeRecord(boolean tradeRecord) {
        this.isTradeRecord = tradeRecord;
    }

    public void addTrade(Trade trade) {
        this.lastTradeTime = trade.getTime();
        if (!this.isInit) {
            this.isInit = true;
            this.setOpen(trade.getPrice());
            this.setClose(trade.getPrice());
            this.high = trade.getPrice();
            this.low = trade.getPrice();
        } else {
            if (this.high.compareTo(trade.getPrice()) < 0) {
                this.high = trade.getPrice();
            } else if (this.low.compareTo(trade.getPrice()) > 0) {
                this.low = trade.getPrice();
            }
            this.setClose(trade.getPrice());
        }
        if (this.isTradeRecord) {
            if (this.tradeList == null) {
                this.tradeList = new ArrayList<Trade>();
            }
            this.tradeCount = this.tradeList.size();
            this.tradeList.add(trade);
        } else {
            ++this.tradeCount;
        }
        if (trade.getType() == Trade.Type.BUY) {
            this.buyVolume = this.buyVolume.add(trade.getVolume());
            this.buyTradingPrice = this.buyTradingPrice.add(trade.getTradingPrice());
        } else {
            this.sellVolume = this.sellVolume.add(trade.getVolume());
            this.sellTradingPrice = this.sellTradingPrice.add(trade.getTradingPrice());
        }
        this.volume = this.volume.add(trade.getVolume());
        this.tradingPrice = this.tradingPrice.add(trade.getTradingPrice());
    }

    public void addCandle(TradeCandle tradeCandle) {
        if (this.openTime == -1L) {
            this.openTime = tradeCandle.getOpenTime();
            this.open = tradeCandle.getOpen();
        }
        if (this.closeTime == -1L) {
            this.closeTime = tradeCandle.getCloseTime();
            this.close = tradeCandle.getClose();
        }
        if (this.lastTradeTime < tradeCandle.getLastTradeTime()) {
            this.lastTradeTime = tradeCandle.getLastTradeTime();
            if (tradeCandle.getClose() != null) {
                this.close = tradeCandle.getClose();
            }
        }
        this.low = BigDecimals.getMax((BigDecimal)this.low, (BigDecimal)tradeCandle.getLow());
        this.high = BigDecimals.getMax((BigDecimal)this.high, (BigDecimal)tradeCandle.getHigh());
        if (this.isTradeRecord && tradeCandle.getTradeList() != null) {
            if (this.tradeList == null) {
                this.tradeList = new ArrayList<Trade>();
            }
            this.tradeList.addAll(tradeCandle.getTradeList());
        }
        this.tradeCount += tradeCandle.getTradeCount();
        this.buyVolume = this.buyVolume.add(tradeCandle.getBuyVolume());
        this.buyTradingPrice = this.buyTradingPrice.add(tradeCandle.getBuyTradingPrice());
        this.sellVolume = this.sellVolume.add(tradeCandle.getSellVolume());
        this.sellTradingPrice = this.sellTradingPrice.add(tradeCandle.getSellTradingPrice());
        this.volume = this.volume.add(tradeCandle.getVolume());
        this.tradingPrice = this.tradingPrice.add(tradeCandle.getTradingPrice());
    }

    public List<Trade> getTradeList() {
        return this.tradeList;
    }

    public int getTradeCount() {
        return this.tradeCount;
    }

    public void setCandleToTrade() {
        if (this.tradeList == null || this.tradeList.size() == 0) {
            logger.error("trade data not set");
            return;
        }
        for (Trade trade : this.tradeList) {
            this.addTrade(trade);
        }
    }

    public void setStrength(BigDecimal strength) {
        this.strength = strength;
    }

    public BigDecimal strength() {
        if (this.isEndTrade && this.strength != null) {
            return this.strength;
        }
        if (this.sellVolume == null && this.buyVolume == null) {
            return BigDecimals.DECIMAL_100;
        }
        if (this.sellVolume == null || this.sellVolume.compareTo(BigDecimal.ZERO) == 0) {
            return MAX_STRENGTH;
        }
        BigDecimal strength = this.buyVolume.divide(this.sellVolume, MathContext.DECIMAL128).multiply(BigDecimals.DECIMAL_100);
        if (strength.compareTo(MAX_STRENGTH) > 0) {
            this.strength = MAX_STRENGTH;
            return MAX_STRENGTH;
        }
        this.strength = strength;
        return strength;
    }

    public void clearTrade() {
        if (this.tradeList == null) {
            return;
        }
        this.tradeList.clear();
        this.tradeList = null;
    }

    public void setTradeCount(int tradeCount) {
        this.tradeCount = tradeCount;
    }

    public BigDecimal getBuyVolume() {
        return this.buyVolume;
    }

    public BigDecimal getSellVolume() {
        return this.sellVolume;
    }

    public BigDecimal getTradingPrice() {
        return this.tradingPrice;
    }

    public BigDecimal getBuyTradingPrice() {
        return this.buyTradingPrice;
    }

    public BigDecimal getSellTradingPrice() {
        return this.sellTradingPrice;
    }

    public void setTradingPrice(BigDecimal tradingPrice) {
        this.tradingPrice = tradingPrice;
    }

    public void setBuyVolume(BigDecimal buyVolume) {
        this.buyVolume = buyVolume;
    }

    public void setSellVolume(BigDecimal sellVolume) {
        this.sellVolume = sellVolume;
    }

    public void setSellVolume() {
        if (this.buyVolume == null || this.volume == null) {
            return;
        }
        this.sellVolume = this.volume.subtract(this.buyVolume);
    }

    public void setBuyTradingPrice(BigDecimal buyTradingPrice) {
        this.buyTradingPrice = buyTradingPrice;
    }

    public void setSellTradingPrice(BigDecimal sellTradingPrice) {
        this.sellTradingPrice = sellTradingPrice;
    }

    public void setSellTradingPrice() {
        if (this.tradingPrice == null || this.buyTradingPrice == null) {
            return;
        }
        this.sellTradingPrice = this.tradingPrice.subtract(this.buyTradingPrice);
    }

    public long getLastTradeTime() {
        return this.lastTradeTime;
    }

    public void setLastTradeTime(long lastTradeTime) {
        this.lastTradeTime = lastTradeTime;
    }

    public static TradeCandle sumCandles(TradeCandle[] candles, long openTime, long closeTime) {
        TradeCandle candle;
        TradeCandle tradeCandle = new TradeCandle();
        tradeCandle.addCandle(candles[candles.length - 1]);
        for (int i = candles.length - 2; i > -1 && (openTime <= (candle = candles[i]).getOpenTime() && closeTime >= candle.getOpenTime() || candle.getOpenTime() <= openTime && candle.getCloseTime() > openTime || candle.getOpenTime() <= closeTime && candle.getCloseTime() > closeTime); --i) {
            tradeCandle.addCandle(candle);
        }
        return tradeCandle;
    }

    public void addTradingCount(int count) {
        this.tradeCount += count;
    }
}

