/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.data.csv;

import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.FileUtil;
import io.runon.trading.data.csv.CsvCommon;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.candle.candles.TradeCandles;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class CsvCandle {
    private final long time;
    private int candleCount = -1;
    private TradeCandles tradeCandles = null;

    public CsvCandle(long time) {
        this.time = time;
    }

    public void setCandleCount(int candleCount) {
        if (candleCount < 1) {
            throw new IllegalArgumentException("candle count > 0");
        }
        this.candleCount = candleCount;
    }

    public void setTradeCandles(TradeCandles tradeCandles) {
        this.tradeCandles = tradeCandles;
    }

    public TradeCandles load(String filePath) {
        if (this.tradeCandles == null) {
            this.tradeCandles = new TradeCandles(this.time);
        }
        if (this.candleCount != -1) {
            this.tradeCandles.setCount(this.candleCount);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
            String line;
            while ((line = br.readLine()) != null) {
                this.tradeCandles.addCandle(CsvCandle.make(line, this.time));
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.tradeCandles;
    }

    public void out(String path) {
        this.out(path, this.tradeCandles);
    }

    public void out(String path, TradeCandles tradeCandles) {
        TradeCandle[] candles = tradeCandles.getCandles();
        if (candles.length == 0) {
            throw new IllegalArgumentException("candles length > 0");
        }
        StringBuilder sb = new StringBuilder();
        for (TradeCandle candle : candles) {
            sb.append("\n").append(CsvCandle.value(candle));
        }
        FileUtil.fileOutput((String)sb.substring(1), (String)path, (boolean)false);
    }

    public static String value(TradeCandle tradeCandle) {
        StringBuilder sb = new StringBuilder();
        sb.append(tradeCandle.getOpenTime());
        CsvCommon.append(sb, tradeCandle.getClose());
        CsvCommon.append(sb, tradeCandle.getOpen());
        CsvCommon.append(sb, tradeCandle.getHigh());
        CsvCommon.append(sb, tradeCandle.getLow());
        CsvCommon.append(sb, tradeCandle.getPrevious());
        CsvCommon.append(sb, tradeCandle.getVolume());
        CsvCommon.append(sb, tradeCandle.getTradingPrice());
        sb.append(",").append(tradeCandle.getTradeCount());
        CsvCommon.append(sb, tradeCandle.getBuyVolume());
        CsvCommon.append(sb, tradeCandle.getBuyTradingPrice());
        return sb.toString();
    }

    public static TradeCandle make(String csv, long time) {
        String[] values = csv.split(",");
        long openTime = Long.parseLong(values[0]);
        TradeCandle tradeCandle = new TradeCandle();
        tradeCandle.setOpenTime(openTime);
        tradeCandle.setCloseTime(openTime + time);
        tradeCandle.setClose(CsvCommon.getBigDecimal(values[1]));
        tradeCandle.setOpen(CsvCommon.getBigDecimal(values[2]));
        tradeCandle.setHigh(CsvCommon.getBigDecimal(values[3]));
        tradeCandle.setLow(CsvCommon.getBigDecimal(values[4]));
        tradeCandle.setPrevious(CsvCommon.getBigDecimal(values[5]));
        tradeCandle.setVolume(CsvCommon.getBigDecimal(values[6]));
        tradeCandle.setTradingPrice(CsvCommon.getBigDecimal(values[7]));
        if (values[8] != null) {
            tradeCandle.setTradeCount(Integer.parseInt(values[8]));
        }
        tradeCandle.setBuyVolume(CsvCommon.getBigDecimal(values[9]));
        tradeCandle.setBuyTradingPrice(CsvCommon.getBigDecimal(values[10]));
        tradeCandle.setSellVolume();
        tradeCandle.setSellTradingPrice();
        tradeCandle.setChange();
        return tradeCandle;
    }
}

