/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading;

import java.math.BigDecimal;

public class Trade {
    private Type type;
    private BigDecimal volume;
    private BigDecimal price;
    private BigDecimal tradingPrice = null;
    private long time;

    public Trade() {
    }

    public Trade(Type type, BigDecimal price, BigDecimal volume, long time) {
        if (price == null || volume == null) {
            throw new IllegalArgumentException("price, volume is not null");
        }
        this.type = type;
        this.price = price;
        this.volume = volume;
        this.time = time;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public long getTime() {
        return this.time;
    }

    public BigDecimal getTradingPrice() {
        if (this.tradingPrice == null) {
            this.tradingPrice = this.price.multiply(this.volume);
        }
        return this.tradingPrice;
    }

    public void setTradingPrice(BigDecimal tradingPrice) {
        this.tradingPrice = tradingPrice;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public static enum Type {
        BUY,
        SELL;

    }
}

