/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.subindex.rsi;

import io.runon.trading.PriceChangeRate;
import io.runon.trading.technical.analysis.subindex.cross.Cross;
import io.runon.trading.technical.analysis.subindex.cross.CrossIndex;
import io.runon.trading.technical.analysis.subindex.rsi.RSI;
import java.math.BigDecimal;
import java.util.Arrays;

public class RsiSignalArray {
    private int n = 14;
    private int signalN = 6;
    private int length = -1;
    private BigDecimal[] rsiArray;
    private BigDecimal[] signalArray;

    public void setN(int n) {
        this.n = n;
    }

    public void setSignalN(int signalN) {
        this.signalN = signalN;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void make(PriceChangeRate[] priceChangeRates) {
        BigDecimal[] array = new BigDecimal[priceChangeRates.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = priceChangeRates[i].getChangeRate();
        }
        this.make(array);
    }

    public void make(BigDecimal[] priceChangeRates) {
        int makeLength = priceChangeRates.length - this.n - this.signalN + 2;
        if (this.length != -1 && makeLength > this.length) {
            makeLength = this.length;
        }
        BigDecimal[] tempRsiArray = RSI.getScores(priceChangeRates, this.n, makeLength + this.signalN - 1);
        this.signalArray = RSI.getSignal(tempRsiArray, this.signalN, makeLength);
        this.rsiArray = Arrays.copyOfRange(tempRsiArray, this.signalN - 1, tempRsiArray.length);
    }

    public BigDecimal[] getRsiArray() {
        return this.rsiArray;
    }

    public BigDecimal[] getSignalArray() {
        return this.signalArray;
    }

    public CrossIndex cross(BigDecimal rate) {
        return Cross.getIndex(this.rsiArray, this.signalArray, rate);
    }

    public BigDecimal getLastRsi() {
        return this.rsiArray[this.rsiArray.length - 1];
    }

    public BigDecimal getLastSignal() {
        return this.signalArray[this.signalArray.length - 1];
    }
}

