/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.subindex.cross;

import io.runon.trading.technical.analysis.subindex.cross.CrossIndex;
import java.math.BigDecimal;
import java.math.MathContext;

public class Cross {
    public static CrossIndex getIndex(BigDecimal[] shotArray, BigDecimal[] longArray, BigDecimal rate) {
        int i;
        int lastIndex = longArray.length - 1;
        if (shotArray[lastIndex].compareTo(longArray[lastIndex]) > 0) {
            for (int i2 = lastIndex; i2 > 4; --i2) {
                if (shotArray[i2].compareTo(longArray[i2]) <= 0) {
                    return null;
                }
                int gap = Cross.gap(longArray, shotArray, i2);
                if (gap == -1) continue;
                if (!Cross.isRate(longArray, shotArray, i2, rate)) {
                    return null;
                }
                CrossIndex crossIndex = new CrossIndex();
                crossIndex.type = Type.GOLDEN;
                crossIndex.index = i2;
                crossIndex.gap = gap;
                return crossIndex;
            }
        } else if (shotArray[lastIndex].compareTo(longArray[lastIndex]) < 0 && (i = lastIndex) > 4) {
            if (shotArray[i].compareTo(longArray[i]) >= 0) {
                return null;
            }
            int gap = Cross.gap(shotArray, longArray, i);
            if (!Cross.isRate(shotArray, longArray, i, rate)) {
                return null;
            }
            CrossIndex crossIndex = new CrossIndex();
            crossIndex.type = Type.DEAD;
            crossIndex.index = i;
            crossIndex.gap = gap;
            return crossIndex;
        }
        return null;
    }

    private static boolean isRate(BigDecimal[] small, BigDecimal[] large, int index, BigDecimal rate) {
        for (int i = index; i < small.length; ++i) {
            BigDecimal length = large[i].subtract(small[i]);
            if (length.divide(small[i], MathContext.DECIMAL128).compareTo(rate) < 0) continue;
            return true;
        }
        return false;
    }

    private static int gap(BigDecimal[] small, BigDecimal[] large, int index) {
        int count = 0;
        int last = index;
        int i = index - 1;
        while (i > -1 && large[i].compareTo(small[i]) <= 0) {
            if (large[i].compareTo(small[i]) < 0) {
                ++count;
            }
            last = i--;
        }
        if (count < 5) {
            return -1;
        }
        return index - last;
    }

    public static enum Type {
        GOLDEN,
        DEAD;

    }
}

