/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.trend.line;

import io.runon.trading.BigDecimals;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.trend.line.TrendLineCase;
import io.runon.trading.technical.analysis.trend.line.TrendLineDown;
import io.runon.trading.technical.analysis.trend.line.TrendLineUp;
import java.math.BigDecimal;
import java.math.MathContext;

public class TrendLine {
    private final Type type;
    private TrendLineCase trendLineCase;

    public TrendLine(Type type) {
        this.type = type;
        switch (type) {
            case UP: {
                this.trendLineCase = new TrendLineUp();
                break;
            }
            case DOWN: {
                this.trendLineCase = new TrendLineDown();
                break;
            }
        }
    }

    public BigDecimal score(TradeCandle[] candles, int index, int leftCount, BigDecimal shortGapRate) {
        if (index < 5) {
            return null;
        }
        int minCount = (int)((double)leftCount * 0.6);
        if (index < minCount) {
            return null;
        }
        int startIndex = index - leftCount;
        if (startIndex < 0) {
            startIndex = 0;
        }
        int shortGapCount = 0;
        int validCount = 0;
        BigDecimal changeRateSum = BigDecimal.ZERO;
        for (int i = startIndex; i < index; ++i) {
            changeRateSum = changeRateSum.add(candles[i].getChangeRate());
            if (!this.trendLineCase.isCountValid(candles[i])) continue;
            ++validCount;
            if (candles[i].getChangeRate().abs().compareTo(shortGapRate) <= 0) continue;
            ++shortGapCount;
        }
        int minShortCount = (int)((double)leftCount * 0.45);
        if (validCount < minCount || shortGapCount < minShortCount) {
            return null;
        }
        int count = index - startIndex;
        BigDecimal avg = changeRateSum.abs().divide(new BigDecimal(count), MathContext.DECIMAL128);
        BigDecimal half = shortGapRate.multiply(BigDecimals.DECIMAL_0_5);
        if (half.compareTo(avg) > 0) {
            return null;
        }
        return candles[index - 1].getClose().subtract(candles[startIndex].getOpen()).abs().divide(new BigDecimal(count).multiply(BigDecimals.DECIMAL_0_5), MathContext.DECIMAL128);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        UP,
        DOWN;

    }
}

