/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.subindex.ichimoku;

import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.subindex.ichimoku.IchimokuData;

public class IchimokuBalance {
    public static final int DEFAULT_REVERSE_N = 9;
    public static final int DEFAULT_STANDARD_N = 26;
    public static final int DEFAULT_LAGGING_N = 26;
    public static final int DEFAULT_LEADING_N = 26;

    public static double getScore(double[] priceChangeRates) {
        return IchimokuBalance.getScore(priceChangeRates, 14, priceChangeRates.length);
    }

    public static double getScore(double[] priceChangeRates, int n, int end) {
        int upCount = 0;
        int downCount = 0;
        double upSum = 0.0;
        double downSum = 0.0;
        int start = end - n;
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < end; ++i) {
            if (priceChangeRates[i] > 0.0) {
                ++upCount;
                upSum += priceChangeRates[i];
                continue;
            }
            if (!(priceChangeRates[i] < 0.0)) continue;
            ++downCount;
            downSum += priceChangeRates[i];
        }
        if (upCount == 0) {
            return 0.0;
        }
        if (downCount == 0) {
            return 100.0;
        }
        double averageUps = upSum / (double)upCount;
        double averageDowns = downSum / (double)downCount * -1.0;
        double rs = averageUps / averageDowns;
        double rsi = rs / (1.0 + rs);
        return (double)Math.round(rsi * 10000.0) / 100.0;
    }

    public static double[] getScores(double[] priceChangeRates, int n, int rsiCount) {
        if (rsiCount > priceChangeRates.length) {
            rsiCount = priceChangeRates.length;
        }
        double[] rsiScores = new double[rsiCount];
        int endGap = rsiCount;
        for (int i = 0; i < rsiCount; ++i) {
            rsiScores[i] = IchimokuBalance.getScore(priceChangeRates, n, priceChangeRates.length - endGap--);
        }
        return rsiScores;
    }

    public static double[] getMiddlePriceArray(CandleStick[] candleStickArray, int n) {
        double[] middlePriceArray = new double[candleStickArray.length - n];
        int insertCnt = 0;
        for (int i = n; i < candleStickArray.length; ++i) {
            double maxPrice = -1.0;
            double minPrice = 2.147483647E9;
            for (int j = i - n; j < i; ++j) {
                double highPrice = candleStickArray[j].getHigh().doubleValue();
                double lowPrice = candleStickArray[j].getLow().doubleValue();
                if (highPrice > maxPrice) {
                    maxPrice = highPrice;
                }
                if (!(lowPrice < minPrice)) continue;
                minPrice = lowPrice;
            }
            double middlePrice = (maxPrice + minPrice) / 2.0;
            middlePriceArray[insertCnt++] = middlePrice;
        }
        return middlePriceArray;
    }

    public static double[] getLaggingArray(CandleStick[] candleStickArray) {
        double[] laggingArray = new double[candleStickArray.length];
        for (int i = 0; i < candleStickArray.length; ++i) {
            laggingArray[i] = candleStickArray[i].getClose().doubleValue();
        }
        return laggingArray;
    }

    public static double[] getLeading1Array(double[] reverseArray, int reverseN, double[] standardArray, int standardN) {
        int timeFixN = standardN - reverseN;
        double[] leading1Array = new double[standardArray.length];
        for (int i = 0; i < standardArray.length; ++i) {
            double reversePrice = reverseArray[i + timeFixN];
            double standardPrice = standardArray[i];
            leading1Array[i] = (reversePrice + standardPrice) / 2.0;
        }
        return leading1Array;
    }

    public static IchimokuData[] getIchimokuDataArray(CandleStick[] candleStickArray, int reverseN, int standardN, int laggingN, int leadingN) {
        int i;
        int candleStickArrayLength = candleStickArray.length;
        IchimokuData[] ichimokuDataArray = new IchimokuData[candleStickArrayLength];
        for (int i2 = 0; i2 < candleStickArrayLength; ++i2) {
            CandleStick candleStick = candleStickArray[i2];
            IchimokuData ichimokuData = new IchimokuData();
            ichimokuData.setTime(candleStick.getOpenTime());
            ichimokuDataArray[i2] = ichimokuData;
        }
        double[] reverseArray = IchimokuBalance.getMiddlePriceArray(candleStickArray, reverseN);
        double[] standardArray = IchimokuBalance.getMiddlePriceArray(candleStickArray, standardN);
        double[] laggingArray = IchimokuBalance.getLaggingArray(candleStickArray);
        double[] leading2Array = IchimokuBalance.getMiddlePriceArray(candleStickArray, leadingN * 2);
        int reverseNLength = candleStickArrayLength - reverseN;
        for (int i3 = 0; i3 < reverseNLength; ++i3) {
            ichimokuDataArray[i3 + reverseN].setReverse(reverseArray[i3]);
        }
        int standardNLength = candleStickArrayLength - standardN;
        for (i = 0; i < standardNLength; ++i) {
            ichimokuDataArray[i + standardN].setStandard(standardArray[i]);
        }
        for (i = 0; i < candleStickArrayLength - laggingN; ++i) {
            ichimokuDataArray[i].setLagging(laggingArray[i + laggingN]);
        }
        for (i = 0; i < candleStickArrayLength - leadingN; ++i) {
            IchimokuData ichimokuData = ichimokuDataArray[i];
            if (ichimokuData.getReverse() == -1.0 || ichimokuData.getStandard() == -1.0) continue;
            ichimokuDataArray[i + leadingN].setLeading1((ichimokuData.getReverse() + ichimokuData.getStandard()) / 2.0);
        }
        int leading2NLength = candleStickArrayLength - leadingN * 3;
        for (int i4 = 0; i4 < leading2NLength; ++i4) {
            ichimokuDataArray[i4 + leadingN * 3].setLeading2(leading2Array[i4]);
        }
        return ichimokuDataArray;
    }
}

