/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.subindex.divergence;

import io.runon.trading.technical.analysis.candle.Candle;
import io.runon.trading.technical.analysis.subindex.divergence.DivergenceSignal;
import io.runon.trading.technical.analysis.subindex.divergence.DivergenceSignalSearch;
import io.runon.trading.technical.analysis.subindex.divergence.ExaggeratedDivergence;
import io.runon.trading.technical.analysis.subindex.divergence.HiddenDivergence;
import io.runon.trading.technical.analysis.subindex.divergence.RegularDivergence;

public class Divergence {
    public static final int MIN_LENGTH = 5;
    public static final double HOLD_RATE = 0.02;
    public static final int[] CANDLE_COUNT_ARRAY = new int[]{260, 200, 150, 120, 90, 60, 30, 25, 20, 15, 10};
    private DivergenceSignalSearch[] searchArray;
    private int[] candleCountArray = CANDLE_COUNT_ARRAY;
    private double steadyRate = 0.1;

    public Divergence() {
        this.searchArray = new DivergenceSignalSearch[3];
        this.searchArray[0] = new RegularDivergence();
        this.searchArray[1] = new HiddenDivergence();
        this.searchArray[2] = new ExaggeratedDivergence();
    }

    public void setDivergenceSignalSearchArray(DivergenceSignalSearch[] searchArray) {
        this.searchArray = searchArray;
    }

    public void setCandleCountArray(int[] candleCountArray) {
        this.candleCountArray = candleCountArray;
    }

    public void setSteadyRate(double steadyRate) {
        this.steadyRate = steadyRate;
    }

    public DivergenceSignal[] signal(Candle[] priceCandles, Candle[] subIndexCandles) {
        DivergenceSignal divergenceIndex;
        DivergenceSignal lastDivergenceIndex = null;
        int lastIndex = -1;
        for (DivergenceSignalSearch divergenceSignal : this.searchArray) {
            divergenceIndex = divergenceSignal.fall(priceCandles, subIndexCandles, this.steadyRate, 250);
            if (divergenceIndex == null) continue;
            if (lastDivergenceIndex == null) {
                lastDivergenceIndex = divergenceIndex;
                continue;
            }
            if (lastDivergenceIndex.index >= divergenceIndex.index) continue;
            lastDivergenceIndex = divergenceIndex;
        }
        for (DivergenceSignalSearch divergenceSignal : this.searchArray) {
            divergenceIndex = divergenceSignal.rise(priceCandles, subIndexCandles, this.steadyRate, 250);
            if (divergenceIndex == null) continue;
            if (lastDivergenceIndex == null) {
                lastDivergenceIndex = divergenceIndex;
                continue;
            }
            if (lastDivergenceIndex.index >= divergenceIndex.index) continue;
            lastDivergenceIndex = divergenceIndex;
        }
        return null;
    }

    public static enum Type {
        REGULAR,
        HIDDEN,
        EXAGGERATED;

    }
}

