/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.pattern.upper.shadow;

import io.runon.trading.PriceChangeType;
import io.runon.trading.TradingBigDecimal;
import io.runon.trading.TrendChangeType;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.pattern.CandlePatternDefault;
import io.runon.trading.technical.analysis.pattern.CandlePatternPoint;
import io.runon.trading.technical.analysis.pattern.upper.shadow.UpperShadowPattern;
import io.runon.trading.technical.analysis.trend.line.TrendLine;
import java.math.BigDecimal;

public class ShootingStar
extends CandlePatternDefault {
    @Override
    public PriceChangeType getPriceChangeType() {
        return PriceChangeType.FALL;
    }

    @Override
    public TrendChangeType getTrendChangeType() {
        return TrendChangeType.REVERSE;
    }

    @Override
    public CandlePatternPoint getPoint(TradeCandle[] candles, int index, BigDecimal shortGapRate) {
        TradeCandle tradeCandle = candles[index];
        if (tradeCandle.getOpen().compareTo(tradeCandle.getClose()) < 0) {
            return null;
        }
        BigDecimal change = tradeCandle.changeAbs();
        BigDecimal upperTail = tradeCandle.getUpperTail();
        if (change.multiply(TradingBigDecimal.DECIMAL_3).compareTo(upperTail) > 0) {
            return null;
        }
        BigDecimal shortGapPrice = tradeCandle.getOpen().multiply(shortGapRate);
        if (shortGapPrice.multiply(TradingBigDecimal.DECIMAL_2).compareTo(upperTail) > 0) {
            return null;
        }
        TrendLine trendLine = new TrendLine(TrendLine.Type.UP);
        return UpperShadowPattern.makePoint(trendLine, candles, index, shortGapRate);
    }
}

