/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.pattern.lower.shadow;

import io.runon.trading.TradingBigDecimal;
import io.runon.trading.technical.analysis.candle.CandleStick;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.pattern.CandlePatternPoint;
import io.runon.trading.technical.analysis.trend.line.TrendLine;
import java.math.BigDecimal;
import java.math.MathContext;

public class LowerShadowPattern {
    public static boolean isValid(TradeCandle tradeCandle) {
        if (tradeCandle.getType() != CandleStick.Type.LOWER_SHADOW) {
            return false;
        }
        BigDecimal absChange = tradeCandle.changeAbs();
        BigDecimal lowerTail = tradeCandle.getLowerTail();
        if (absChange.multiply(TradingBigDecimal.DECIMAL_2).compareTo(lowerTail) > 0) {
            return false;
        }
        BigDecimal upperTail = tradeCandle.getUpperTail();
        return upperTail.multiply(TradingBigDecimal.DECIMAL_2).compareTo(absChange) <= 0;
    }

    public static CandlePatternPoint makePoint(TrendLine trendLine, TradeCandle[] candles, int index, BigDecimal shortGapPercent) {
        TradeCandle tradeCandle = candles[index];
        if (!LowerShadowPattern.isValid(tradeCandle)) {
            return null;
        }
        BigDecimal trendLineScore = trendLine.score(candles, index, 7, shortGapPercent);
        if (trendLineScore == null) {
            return null;
        }
        if (trendLineScore.compareTo(BigDecimal.ONE) < 0) {
            return null;
        }
        if (trendLineScore.compareTo(TradingBigDecimal.DECIMAL_1_5) > 0) {
            trendLineScore = TradingBigDecimal.DECIMAL_1_5;
        }
        BigDecimal absChange = tradeCandle.changeAbs();
        BigDecimal lowerTail = tradeCandle.getLowerTail();
        BigDecimal score = lowerTail.divide(absChange.multiply(TradingBigDecimal.DECIMAL_100), MathContext.DECIMAL128).multiply(trendLineScore);
        return new CandlePatternPoint(candles[index], score);
    }
}

