/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle.candles;

import io.runon.trading.Trade;
import io.runon.trading.TradeAdd;
import io.runon.trading.technical.analysis.candle.CandleTimeGap;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import io.runon.trading.technical.analysis.candle.candles.TradeCandles;
import java.math.BigDecimal;

class NextTradeAdd
implements TradeAdd {
    private final TradeCandles tradeCandles;

    NextTradeAdd(TradeCandles tradeCandles) {
        this.tradeCandles = tradeCandles;
    }

    @Override
    public void addTrade(Trade trade) {
        if (trade.getTime() < this.tradeCandles.lastCandle.getCloseTime()) {
            this.tradeCandles.lastCandle.addTrade(trade);
            return;
        }
        long timeGap = this.tradeCandles.getTimeGap();
        long nextStartTime = this.tradeCandles.lastCandle.getCloseTime();
        long nextEndTime = nextStartTime + timeGap;
        if (trade.getTime() < nextEndTime) {
            this.tradeCandles.addTradeNewCandle(trade, nextStartTime, nextEndTime);
            return;
        }
        BigDecimal lastPrice = this.tradeCandles.lastCandle.getClose();
        if (this.tradeCandles.isEmptyCandleContinue) {
            do {
                TradeCandle nextTradeCandle = new TradeCandle();
                nextTradeCandle.setOpen(lastPrice);
                nextTradeCandle.setClose(lastPrice);
                nextTradeCandle.setHigh(lastPrice);
                nextTradeCandle.setLow(lastPrice);
                nextTradeCandle.setOpenTime(nextStartTime);
                nextTradeCandle.setCloseTime(nextEndTime);
                this.tradeCandles.addCandle(nextTradeCandle);
                nextStartTime = nextEndTime;
                nextEndTime = nextStartTime + timeGap;
            } while (trade.getTime() >= nextEndTime);
            this.tradeCandles.addTradeNewCandle(trade, nextStartTime, nextEndTime);
        } else {
            long startTime = CandleTimeGap.getStartTime(timeGap, trade.getTime());
            this.tradeCandles.addTradeNewCandle(trade, startTime, startTime + timeGap);
        }
    }
}

