/*
 * Decompiled with CFR 0.152.
 */
package io.runon.trading.technical.analysis.candle;

import java.util.Calendar;

public class CandleTimeGap {
    public static final long[] DEFAULT_MINUTES = new long[]{60000L, 120000L, 180000L, 240000L, 300000L, 360000L, 600000L, 720000L, 900000L, 1800000L};
    public static final long[] DEFAULT_HOURS = new long[]{3600000L, 0x6DDD00L, 10800000L, 14400000L, 21600000L, 43200000L};
    public static final long[] DEFAULT_DAYS = new long[]{86400000L, 259200000L, 432000000L};
    public static final long[] DEFAULT_SCALPING = CandleTimeGap.makeScalpingTime();

    private static long[] makeScalpingTime() {
        long[] scalpingTimes = new long[DEFAULT_MINUTES.length + DEFAULT_HOURS.length + DEFAULT_DAYS.length + 1];
        System.arraycopy(DEFAULT_MINUTES, 0, scalpingTimes, 0, DEFAULT_MINUTES.length);
        System.arraycopy(DEFAULT_HOURS, 0, scalpingTimes, DEFAULT_MINUTES.length, DEFAULT_HOURS.length);
        System.arraycopy(DEFAULT_DAYS, 0, scalpingTimes, DEFAULT_MINUTES.length + DEFAULT_HOURS.length, DEFAULT_DAYS.length);
        scalpingTimes[scalpingTimes.length - 1] = 604800000L;
        return scalpingTimes;
    }

    public static boolean valid(long timeGap) {
        if (timeGap < 86400000L) {
            return 86400000L % timeGap == 0L;
        }
        return timeGap % 86400000L == 0L;
    }

    public static long getStartTime(long timeGap, long firstTradeTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(firstTradeTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (timeGap < 86400000L) {
            long gap = firstTradeTime - calendar.getTimeInMillis();
            return calendar.getTimeInMillis() + gap - gap % timeGap;
        }
        return calendar.getTimeInMillis();
    }
}

